/*

    LEON2/3 LIBIO low-level routines 
    Written by Jiri Gaisler.
    Copyright (C) 2004  Gaisler Research AB

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#define LEON3_IO_AREA 0xfff00000
#define LEON3_CONF_AREA 0xff000
#define VENDOR_GAISLER 0x01
#define GAISLER_APBMST 0x006
#define GAISLER_APBUART 0x00C
#define GAISLER_GPTIMER 0x011
   
	.text
	/* ------- */
  	.weak	cpuinit
	.set	cpuinit,_cpuinit
	/* ------- */
	!.global cpuinit
_cpuinit:

        mov %o7,%g6

	mov	%psr, %l3
	srl	%l3, 24, %g5
	and  	%g5, 0xf, %g5
	subcc	%g5, 3, %0
	be	1f

	/* other versions */
	
        ba 2f  	

        ! ####### leon3 #########

1:      set 0x01, %o0              !VENDOR_GAISLER
        set 0x006, %o1             !GAISLER_APBMST  
        call ahbslv_scan
        nop

        cmp %g0,%o0 
        be 2f
         nop

        ld [%o0+16],%g1
        set 0xfff00000,%o0         !LEON3_IO_AREA          
        and %g1,%o0,%g1            !g1: apb base

        set 0xff000,%o0            !LEON3_CONF_AREA    
        or %g1,%o0,%g2             !g2: apb conf base
  
        ! ####### uart #########
        mov %g2,%o0
        set 0x01 , %o1             ! VENDOR_GAISLER   
        set 0x00C,%o2              ! GAISLER_APBUART  
        call apbslv_scan
         nop
        cmp %g0,%o0
        be 2f
         nop
        
        call iobar_getbase
         mov %g1,%o1
        
	set 	console, %g5
        st %o1,[%g5]             !uart base address

        ! ####### timer #########

        mov %g2,%o0
        set 0x01 , %o1           !VENDOR_GAISLER
        set 0x011,%o2            !GAISLER_GPTIMER
        call apbslv_scan
         nop
        cmp %g0,%o0
        be 2f
         nop
        
        call iobar_getbase
         mov %g1,%o1
        
        add %o1,0x10,%o1
	set rtc, %g5
        st %o1,[%g5]

        ! ################
        
        mov %g2,%o0
        set 0x01 , %o1           !VENDOR_GAISLER
        set 0x00D,%o2            !GAISLER_IRQMP
        call apbslv_scan
        nop
        cmp %g0,%o0
        be 2f
        nop
        
        call iobar_getbase
        mov %g1,%o1
        
	set irqmp, %g5
        st %o1,[%g5]
        ld [%o1+0x10], %o2
	srl %o2, 16, %o2
	and %o2, 15, %o2
        st %o2,[%g5+4]

        ! ################

2:	mov %g6,%o7
        retl
	nop

        ! force link of jiffies_64
        .global jiffies_64
3:      set jiffies_64,%g1


	.text
