/*  AMBA Plug & Play Device and Vendor definitions.
 * 
 *  COPYRIGHT (c) 2009.
 *  Aeroflex Gaisler.
 *
 *  The device and vendor definitions are extracted with a script from 
 *  GRLIB.
 *
 *  The license and distribution terms for this file may be
 *  found in the file LICENSE in this distribution or at
 *  http://www.rtems.com/license/LICENSE.
 *
 *  2009-01-27, Daniel Hellstrom <daniel@gaisler.com>
 *    Created from GRLIB 3386.
 */


#include <ambapp_ids.h>

#ifndef NULL
#define NULL 0
#endif

typedef struct {
	int device_id;
	char *name;
} ambapp_device_name;

typedef struct {
	unsigned int vendor_id;
	char *name;
	ambapp_device_name *devices;
} ambapp_vendor_devnames;

/**************** AUTO GENERATED FROM devices.vhd ****************/
static ambapp_device_name GAISLER_devices[] =
{
  {GAISLER_LEON2DSU, "GAISLER_LEON2DSU"},
  {GAISLER_LEON3, "GAISLER_LEON3"},
  {GAISLER_LEON3DSU, "GAISLER_LEON3DSU"},
  {GAISLER_ETHAHB, "GAISLER_ETHAHB"},
  {GAISLER_APBMST, "GAISLER_APBMST"},
  {GAISLER_AHBUART, "GAISLER_AHBUART"},
  {GAISLER_SRCTRL, "GAISLER_SRCTRL"},
  {GAISLER_SDCTRL, "GAISLER_SDCTRL"},
  {GAISLER_SSRCTRL, "GAISLER_SSRCTRL"},
  {GAISLER_APBUART, "GAISLER_APBUART"},
  {GAISLER_IRQMP, "GAISLER_IRQMP"},
  {GAISLER_AHBRAM, "GAISLER_AHBRAM"},
  {GAISLER_AHBDPRAM, "GAISLER_AHBDPRAM"},
  {GAISLER_GPTIMER, "GAISLER_GPTIMER"},
  {GAISLER_PCITRG, "GAISLER_PCITRG"},
  {GAISLER_PCISBRG, "GAISLER_PCISBRG"},
  {GAISLER_PCIFBRG, "GAISLER_PCIFBRG"},
  {GAISLER_PCITRACE, "GAISLER_PCITRACE"},
  {GAISLER_DMACTRL, "GAISLER_DMACTRL"},
  {GAISLER_AHBTRACE, "GAISLER_AHBTRACE"},
  {GAISLER_DSUCTRL, "GAISLER_DSUCTRL"},
  {GAISLER_CANAHB, "GAISLER_CANAHB"},
  {GAISLER_GPIO, "GAISLER_GPIO"},
  {GAISLER_AHBROM, "GAISLER_AHBROM"},
  {GAISLER_AHBJTAG, "GAISLER_AHBJTAG"},
  {GAISLER_ETHMAC, "GAISLER_ETHMAC"},
  {GAISLER_SWNODE, "GAISLER_SWNODE"},
  {GAISLER_SPW, "GAISLER_SPW"},
  {GAISLER_AHB2AHB, "GAISLER_AHB2AHB"},
  {GAISLER_USBDC, "GAISLER_USBDC"},
  {GAISLER_USB_DCL, "GAISLER_USB_DCL"},
  {GAISLER_DDRMP, "GAISLER_DDRMP"},
  {GAISLER_ATACTRL, "GAISLER_ATACTRL"},
  {GAISLER_DDRSP, "GAISLER_DDRSP"},
  {GAISLER_EHCI, "GAISLER_EHCI"},
  {GAISLER_UHCI, "GAISLER_UHCI"},
  {GAISLER_I2CMST, "GAISLER_I2CMST"},
  {GAISLER_SPW2, "GAISLER_SPW2"},
  {GAISLER_AHBDMA, "GAISLER_AHBDMA"},
  {GAISLER_NUHOSP3, "GAISLER_NUHOSP3"},
  {GAISLER_CLKGATE, "GAISLER_CLKGATE"},
  {GAISLER_SPICTRL, "GAISLER_SPICTRL"},
  {GAISLER_DDR2SP, "GAISLER_DDR2SP"},
  {GAISLER_SLINK, "GAISLER_SLINK"},
  {GAISLER_GRTM, "GAISLER_GRTM"},
  {GAISLER_GRTC, "GAISLER_GRTC"},
  {GAISLER_GRPW, "GAISLER_GRPW"},
  {GAISLER_GRCTM, "GAISLER_GRCTM"},
  {GAISLER_GRHCAN, "GAISLER_GRHCAN"},
  {GAISLER_GRFIFO, "GAISLER_GRFIFO"},
  {GAISLER_GRADCDAC, "GAISLER_GRADCDAC"},
  {GAISLER_GRPULSE, "GAISLER_GRPULSE"},
  {GAISLER_GRTIMER, "GAISLER_GRTIMER"},
  {GAISLER_AHB2PP, "GAISLER_AHB2PP"},
  {GAISLER_GRVERSION, "GAISLER_GRVERSION"},
  {GAISLER_APB2PW, "GAISLER_APB2PW"},
  {GAISLER_PW2APB, "GAISLER_PW2APB"},
  {GAISLER_GRCAN, "GAISLER_GRCAN"},
  {GAISLER_I2CSLV, "GAISLER_I2CSLV"},
  {GAISLER_U16550, "GAISLER_U16550"},
  {GAISLER_AHBMST_EM, "GAISLER_AHBMST_EM"},
  {GAISLER_AHBSLV_EM, "GAISLER_AHBSLV_EM"},
  {GAISLER_GRTESTMOD, "GAISLER_GRTESTMOD"},
  {GAISLER_ASCS, "GAISLER_ASCS"},
  {GAISLER_IPMVBCTRL, "GAISLER_IPMVBCTRL"},
  {GAISLER_SPIMCTRL, "GAISLER_SPIMCTRL"},
  {GAISLER_LEON4, "GAISLER_LEON4"},
  {GAISLER_LEON4DSU, "GAISLER_LEON4DSU"},
  {GAISLER_GRPWM, "GAISLER_GRPWM"},
  {GAISLER_FTAHBRAM, "GAISLER_FTAHBRAM"},
  {GAISLER_FTSRCTRL, "GAISLER_FTSRCTRL"},
  {GAISLER_AHBSTAT, "GAISLER_AHBSTAT"},
  {GAISLER_LEON3FT, "GAISLER_LEON3FT"},
  {GAISLER_FTMCTRL, "GAISLER_FTMCTRL"},
  {GAISLER_FTSDCTRL, "GAISLER_FTSDCTRL"},
  {GAISLER_FTSRCTRL8, "GAISLER_FTSRCTRL8"},
  {GAISLER_MEMSCRUB, "GAISLER_MEMSCRUB"},
  {GAISLER_APBPS2, "GAISLER_APBPS2"},
  {GAISLER_VGACTRL, "GAISLER_VGACTRL"},
  {GAISLER_LOGAN, "GAISLER_LOGAN"},
  {GAISLER_SVGACTRL, "GAISLER_SVGACTRL"},
  {GAISLER_T1AHB, "GAISLER_T1AHB"},
  {GAISLER_MP7WRAP, "GAISLER_MP7WRAP"},
  {GAISLER_GRSYSMON, "GAISLER_GRSYSMON"},
  {GAISLER_GRACECTRL, "GAISLER_GRACECTRL"},
  {GAISLER_B1553BC, "GAISLER_B1553BC"},
  {GAISLER_B1553RT, "GAISLER_B1553RT"},
  {GAISLER_B1553BRM, "GAISLER_B1553BRM"},
  {GAISLER_SATCAN, "GAISLER_SATCAN"},
  {GAISLER_CANMUX, "GAISLER_CANMUX"},
  {GAISLER_GRTMRX, "GAISLER_GRTMRX"},
  {GAISLER_GRTCTX, "GAISLER_GRTCTX"},
  {GAISLER_GRTMDESC, "GAISLER_GRTMDESC"},
  {GAISLER_GRTMVC, "GAISLER_GRTMVC"},
  {GAISLER_GEFFE, "GAISLER_GEFFE"},
  {GAISLER_AES, "GAISLER_AES"},
  {GAISLER_GRAESDMA, "GAISLER_GRAESDMA"},
  {GAISLER_ECC, "GAISLER_ECC"},
  {GAISLER_PCIF, "GAISLER_PCIF"},
  {GAISLER_CLKMOD, "GAISLER_CLKMOD"},
  {GAISLER_HAPSTRAK, "GAISLER_HAPSTRAK"},
  {GAISLER_TEST_1X2, "GAISLER_TEST_1X2"},
  {GAISLER_WILD2AHB, "GAISLER_WILD2AHB"},
  {GAISLER_BIO1, "GAISLER_BIO1"},
  {GAISLER_GR1553B, "GAISLER_GR1553B"},
  {GAISLER_L2CACHE, "GAISLER_L2CACHE"},
  {GAISLER_L4STAT, "GAISLER_L4STAT"},
  {GAISLER_GRPCI2, "GAISLER_GRPCI2"},
  {GAISLER_GRPCI2_DMA, "GAISLER_GRPCI2_DMA"},
  {GAISLER_GRIOMMU, "GAISLER_GRIOMMU"},
  {GAISLER_SPW2_DMA, "GAISLER_SPW2_DMA"},
  {GAISLER_SPW_ROUTER, "GAISLER_SPW_ROUTER"},
  {0, NULL}
};

static ambapp_device_name PENDER_devices[] =
{
  {0, NULL}
};

static ambapp_device_name ESA_devices[] =
{
  {ESA_LEON2, "ESA_LEON2"},
  {ESA_LEON2APB, "ESA_LEON2APB"},
  {ESA_IRQ, "ESA_IRQ"},
  {ESA_TIMER, "ESA_TIMER"},
  {ESA_UART, "ESA_UART"},
  {ESA_CFG, "ESA_CFG"},
  {ESA_IO, "ESA_IO"},
  {ESA_MCTRL, "ESA_MCTRL"},
  {ESA_PCIARB, "ESA_PCIARB"},
  {ESA_HURRICANE, "ESA_HURRICANE"},
  {ESA_SPW_RMAP, "ESA_SPW_RMAP"},
  {ESA_AHBUART, "ESA_AHBUART"},
  {ESA_SPWA, "ESA_SPWA"},
  {ESA_BOSCHCAN, "ESA_BOSCHCAN"},
  {ESA_IRQ2, "ESA_IRQ2"},
  {ESA_AHBSTAT, "ESA_AHBSTAT"},
  {ESA_WPROT, "ESA_WPROT"},
  {ESA_WPROT2, "ESA_WPROT2"},
  {ESA_PDEC3AMBA, "ESA_PDEC3AMBA"},
  {ESA_PTME3AMBA, "ESA_PTME3AMBA"},
  {0, NULL}
};

static ambapp_device_name ASTRIUM_devices[] =
{
  {0, NULL}
};

static ambapp_device_name OPENCHIP_devices[] =
{
  {OPENCHIP_APBGPIO, "OPENCHIP_APBGPIO"},
  {OPENCHIP_APBI2C, "OPENCHIP_APBI2C"},
  {OPENCHIP_APBSPI, "OPENCHIP_APBSPI"},
  {OPENCHIP_APBCHARLCD, "OPENCHIP_APBCHARLCD"},
  {OPENCHIP_APBPWM, "OPENCHIP_APBPWM"},
  {OPENCHIP_APBPS2, "OPENCHIP_APBPS2"},
  {OPENCHIP_APBMMCSD, "OPENCHIP_APBMMCSD"},
  {OPENCHIP_APBNAND, "OPENCHIP_APBNAND"},
  {OPENCHIP_APBLPC, "OPENCHIP_APBLPC"},
  {OPENCHIP_APBCF, "OPENCHIP_APBCF"},
  {OPENCHIP_APBSYSACE, "OPENCHIP_APBSYSACE"},
  {OPENCHIP_APB1WIRE, "OPENCHIP_APB1WIRE"},
  {OPENCHIP_APBJTAG, "OPENCHIP_APBJTAG"},
  {OPENCHIP_APBSUI, "OPENCHIP_APBSUI"},
  {0, NULL}
};

static ambapp_device_name OPENCORES_devices[] =
{
  {0, NULL}
};

static ambapp_device_name CONTRIB_devices[] =
{
  {CONTRIB_CORE1, "CONTRIB_CORE1"},
  {CONTRIB_CORE2, "CONTRIB_CORE2"},
  {0, NULL}
};

static ambapp_device_name EONIC_devices[] =
{
  {0, NULL}
};

static ambapp_device_name RADIONOR_devices[] =
{
  {0, NULL}
};

static ambapp_device_name GLEICHMANN_devices[] =
{
  {GLEICHMANN_CUSTOM, "GLEICHMANN_CUSTOM"},
  {GLEICHMANN_GEOLCD01, "GLEICHMANN_GEOLCD01"},
  {GLEICHMANN_DAC, "GLEICHMANN_DAC"},
  {GLEICHMANN_HPI, "GLEICHMANN_HPI"},
  {GLEICHMANN_SPI, "GLEICHMANN_SPI"},
  {GLEICHMANN_HIFC, "GLEICHMANN_HIFC"},
  {GLEICHMANN_ADCDAC, "GLEICHMANN_ADCDAC"},
  {GLEICHMANN_SPIOC, "GLEICHMANN_SPIOC"},
  {GLEICHMANN_AC97, "GLEICHMANN_AC97"},
  {0, NULL}
};

static ambapp_device_name MENTA_devices[] =
{
  {0, NULL}
};

static ambapp_device_name SUN_devices[] =
{
  {SUN_T1, "SUN_T1"},
  {SUN_S1, "SUN_S1"},
  {0, NULL}
};

static ambapp_device_name MOVIDIA_devices[] =
{
  {0, NULL}
};

static ambapp_device_name ORBITA_devices[] =
{
  {ORBITA_1553B, "ORBITA_1553B"},
  {ORBITA_429, "ORBITA_429"},
  {ORBITA_SPI, "ORBITA_SPI"},
  {ORBITA_I2C, "ORBITA_I2C"},
  {ORBITA_SMARTCARD, "ORBITA_SMARTCARD"},
  {ORBITA_SDCARD, "ORBITA_SDCARD"},
  {ORBITA_UART16550, "ORBITA_UART16550"},
  {ORBITA_CRYPTO, "ORBITA_CRYPTO"},
  {ORBITA_SYSIF, "ORBITA_SYSIF"},
  {ORBITA_PIO, "ORBITA_PIO"},
  {ORBITA_RTC, "ORBITA_RTC"},
  {ORBITA_COLORLCD, "ORBITA_COLORLCD"},
  {ORBITA_PCI, "ORBITA_PCI"},
  {ORBITA_DSP, "ORBITA_DSP"},
  {ORBITA_USBHOST, "ORBITA_USBHOST"},
  {ORBITA_USBDEV, "ORBITA_USBDEV"},
  {0, NULL}
};

static ambapp_device_name SYNOPSYS_devices[] =
{
  {0, NULL}
};

static ambapp_device_name NASA_devices[] =
{
  {NASA_EP32, "NASA_EP32"},
  {0, NULL}
};

static ambapp_device_name CAL_devices[] =
{
  {CAL_DDRCTRL, "CAL_DDRCTRL"},
  {0, NULL}
};

static ambapp_device_name EMBEDDIT_devices[] =
{
  {0, NULL}
};

static ambapp_device_name CETON_devices[] =
{
  {0, NULL}
};

static ambapp_device_name ACTEL_devices[] =
{
  {ACTEL_COREMP7, "ACTEL_COREMP7"},
  {0, NULL}
};

static ambapp_vendor_devnames vendors[] = 
{
  {VENDOR_GAISLER, "VENDOR_GAISLER", GAISLER_devices},
  {VENDOR_PENDER, "VENDOR_PENDER", PENDER_devices},
  {VENDOR_ESA, "VENDOR_ESA", ESA_devices},
  {VENDOR_ASTRIUM, "VENDOR_ASTRIUM", ASTRIUM_devices},
  {VENDOR_OPENCHIP, "VENDOR_OPENCHIP", OPENCHIP_devices},
  {VENDOR_OPENCORES, "VENDOR_OPENCORES", OPENCORES_devices},
  {VENDOR_CONTRIB, "VENDOR_CONTRIB", CONTRIB_devices},
  {VENDOR_EONIC, "VENDOR_EONIC", EONIC_devices},
  {VENDOR_RADIONOR, "VENDOR_RADIONOR", RADIONOR_devices},
  {VENDOR_GLEICHMANN, "VENDOR_GLEICHMANN", GLEICHMANN_devices},
  {VENDOR_MENTA, "VENDOR_MENTA", MENTA_devices},
  {VENDOR_SUN, "VENDOR_SUN", SUN_devices},
  {VENDOR_MOVIDIA, "VENDOR_MOVIDIA", MOVIDIA_devices},
  {VENDOR_ORBITA, "VENDOR_ORBITA", ORBITA_devices},
  {VENDOR_SYNOPSYS, "VENDOR_SYNOPSYS", SYNOPSYS_devices},
  {VENDOR_NASA, "VENDOR_NASA", NASA_devices},
  {VENDOR_CAL, "VENDOR_CAL", CAL_devices},
  {VENDOR_EMBEDDIT, "VENDOR_EMBEDDIT", EMBEDDIT_devices},
  {VENDOR_CETON, "VENDOR_CETON", CETON_devices},
  {VENDOR_ACTEL, "VENDOR_ACTEL", ACTEL_devices},
  {0, NULL, NULL}
};

/*****************************************************************/

static char *ambapp_get_devname(ambapp_device_name *devs, int id)
{
	while( devs->device_id > 0 ){
		if ( devs->device_id == id )
			return devs->name;
		devs++;
	}
	return NULL;
}

char *ambapp_device_id2str(int vendor, int id)
{
	ambapp_vendor_devnames *ven = &vendors[0];
	
	while( ven->vendor_id > 0 ){
		if ( ven->vendor_id == vendor ){
			return ambapp_get_devname(ven->devices,id);
		}
		ven++;
	}
	return NULL;
}

char *ambapp_vendor_id2str(int vendor)
{
	ambapp_vendor_devnames *ven = &vendors[0];
	
	while( ven->vendor_id > 0 ){
		if ( ven->vendor_id == vendor ){
			return ven->name;
		}
		ven++;
	}
	return NULL;
}
