/*

    LEON2/3 LIBIO low-level routines 
    Written by Jiri Gaisler.
    Copyright (C) 2004  Gaisler Research AB

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
/*
 * regwin.s for LEON
 */

#include <asm-leon/leon.h>
#include <asm-leon/leonstack.h>
        
        .seg    "data"
	.global sparc_leon23_cache_flush, sparc_leon23_icache_flush, sparc_leon23_dcache_flush
	
	.global _leon_version
	
	.seg    "text"

/* =============================================== */
	
/* use only %o7 */	
sparc_leon3_icache_flush:
	retl
sparc_leon3_cache_flush:
	sta %g0, [%g0] ASI_LEON3_IFLUSH
sparc_leon3_dcache_flush:
	retl
	 sta %g0, [%g0] ASI_LEON3_DFLUSH

/* use only %o7 */	
sparc_leon2_icache_flush:
	retl
sparc_leon2_cache_flush:
	sta %g0, [%g0] ASI_LEON2_IFLUSH
sparc_leon2_dcache_flush:
	retl
	 sta %g0, [%g0] ASI_LEON2_DFLUSH 

/* =============================================== */
	
sparc_leon23_cache_flush:	
         sethi	%hi(_leon_version),%o1
	ld	[%o1+%lo(_leon_version)],%o1
	cmp     %o1,2
	bne     loadleon3
loadleon2:
	 set	sparc_leon2_cache_flush,%o1
	jmp	%o1
	 nop
loadleon3:
	set	sparc_leon3_cache_flush,%o1
	jmp	%o1
	 nop
		
sparc_leon23_icache_flush:	
         sethi	%hi(_leon_version),%o1
	ld	[%o1+%lo(_leon_version)],%o1
	cmp     %o1,2
	bne     iloadleon3
iloadleon2:
	 set	sparc_leon2_icache_flush,%o1
	jmp	%o1
	 nop
iloadleon3:
	set	sparc_leon3_icache_flush,%o1
	jmp	%o1
	 nop
	
sparc_leon23_dcache_flush:	
         sethi	%hi(_leon_version),%o1
	ld	[%o1+%lo(_leon_version)],%o1
	cmp     %o1,2
	bne     dloadleon3
dloadleon2:
	 set	sparc_leon2_dcache_flush,%o1
	jmp	%o1
	 nop
dloadleon3:
	set	sparc_leon3_dcache_flush,%o1
	jmp	%o1
	 nop

	