################################################################################
#
# libxcrypt
#
################################################################################

LIBXCRYPT_VERSION = 4.4.36
LIBXCRYPT_SITE = $(call github,besser82,libxcrypt,v$(LIBXCRYPT_VERSION))
LIBXCRYPT_LICENSE = LGPL-2.1+
LIBXCRYPT_LICENSE_FILES = LICENSING COPYING.LIB
LIBXCRYPT_INSTALL_STAGING = YES
LIBXCRYPT_AUTORECONF = YES

# Some warnings turn into errors with some sensitive compilers
LIBXCRYPT_CONF_OPTS = --disable-werror

# Disable obsolete and unsecure API
LIBXCRYPT_CONF_OPTS += --disable-obsolete_api

ifeq ($(BR2_TOOLCHAIN_HAS_GLIBC_NO_LIBCRYPT)$(BR2_PACKAGE_LIBXCRYPT),yy)
# The toolchain package depends on libxcrypt so the toolchain
# dependency needs to be removed to avoid circular dependency
LIBXCRYPT_ADD_TOOLCHAIN_DEPENDENCY = NO

# Add a dependency on the active toolchain to ensure that it
# is built before libxcrypt is built
ifeq ($(BR2_TOOLCHAIN_BUILDROOT),y)
LIBXCRYPT_DEPENDENCIES += toolchain-buildroot
else ifeq ($(BR2_TOOLCHAIN_EXTERNAL),y)
LIBXCRYPT_DEPENDENCIES += toolchain-external
endif

endif

$(eval $(autotools-package))
