################################################################################
#
# grlib
#
################################################################################
GRLIB_DRVPKG_VERSION = $(call qstrip,$(BR2_TARGET_GRLIB_DRVPKG_VERSION))
GRLIB_DRVPKG_COMPR = bz2
GRLIB_DRVPKG_SOURCE = grlib-linux-drvpkg-$(GRLIB_DRVPKG_VERSION).tar.$(GRLIB_DRVPKG_COMPR)
GRLIB_DRVPKG_LICENSE = GPL-2.0+

ifeq ($(GRLIB_DRVPKG_VERSION),custom)
# Handle custom GRLIB Linux driver package tarballs as specified by the configuration
GRLIB_DRVPKG_TARBALL = $(call qstrip,$(BR2_TARGET_GRLIB_DRVPKG_CUSTOM_TARBALL_LOCATION))
GRLIB_DRVPKG_SITE = $(patsubst %/,%,$(dir $(GRLIB_DRVPKG_TARBALL)))
GRLIB_DRVPKG_SOURCE = $(notdir $(GRLIB_DRVPKG_TARBALL))
else
GRLIB_DRVPKG_SITE = https://download.gaisler.com/anonftp/linux/linux-5/kernel
endif

ifeq ($(BR2_TARGET_GRLIB_DRVPKG)$(BR2_TARGET_GRLIB_DRVPKG_LATEST_VERSION),y)
BR_NO_CHECK_HASH_FOR += $(GRLIB_DRVPKG_SOURCE)
endif

ifeq ($(BR2_TARGET_GRLIB_DRVPKG_LATEST_VERSION),y)
GRLIB_DRVPKG_LICENSE_FILES = doc/gpl-2.0.txt
endif

$(eval $(generic-package))
