/* $Id: systbls.S,v 1.41 1996/04/25 09:11:39 davem Exp $
 * systbls.S: System call entry point tables for OS compatibility.
 *            The native Linux system call table lives here also.
 *
 * Copyright (C) 1995 David S. Miller (davem@caip.rutgers.edu)
 *
 * Based upon preliminary work which is:
 *
 * Copyright (C) 1995 Adrian M. Rodriguez (adrian@remus.rutgers.edu)
 */

#include <asm/cprefix.h>

	/* READ THIS BEFORE DICKING WITH THIS TABLE...
	 *
	 * The format of these entries is kind of peculiar
	 * to optimize non-blocking easy syscalls.  If
	 * it is a difficult call or it will sleep the entry
	 * is just to word aligned address of the function
	 * routine to call.  If the lowest bit of the entry
	 * is set then (entry & ~1) is the address of the low
	 * in-trap-window assembler routine which will handle
	 * the system call at the lowest possible level.  For
	 * these low level optimized routines no state is saved
	 * at all and the usual restrictions reply.  Act as
	 * if you got called directly from the trap table.
	 * Some of these optimized routines try really hard
	 * to get around a state save, if you run into trouble
	 * you can still survive by branching to the label
	 * syscall_is_too_hard which is in entry.S  If you
	 * have to back out like this you _must_ preserve the
	 * value of %l0, %l1, %l2, and %l7 when you were called
	 * so be _careful_.
	 */

#define LOWSYS(func) (CONCAT(func, _low) + 1)

	.data
	.align 4

	.globl C_LABEL(sys_call_table)
C_LABEL(sys_call_table):
/*0*/	.long C_LABEL(sys_setup)
	.long C_LABEL(sys_exit)
	.long C_LABEL(sys_fork)
	.long C_LABEL(sys_read)
	.long C_LABEL(sys_write)
/*5*/	.long C_LABEL(sys_open)
	.long C_LABEL(sys_close)
	.long C_LABEL(sys_waitpid)
	.long C_LABEL(sys_creat)
	.long C_LABEL(sys_link)
/*10*/  .long C_LABEL(sys_unlink)
	.long C_LABEL(sys_execv)
	.long C_LABEL(sys_chdir)
	.long C_LABEL(sys_time)
	.long C_LABEL(sys_mknod)
/*15*/	.long C_LABEL(sys_chmod)
	.long C_LABEL(sys_chown)
	.long C_LABEL(sys_break)
	.long C_LABEL(sys_stat)
	.long C_LABEL(sys_lseek)
/*20*/	.long C_LABEL(sys_getpid)
	.long C_LABEL(sys_mount)
	.long C_LABEL(sys_umount)
	.long C_LABEL(sys_setuid)
	.long C_LABEL(sys_getuid)
/*25*/	.long C_LABEL(sys_stime)
	.long C_LABEL(sys_ptrace)
	.long C_LABEL(sys_alarm)
	.long C_LABEL(sys_fstat)
	.long C_LABEL(sys_pause)
/*30*/	.long C_LABEL(sys_utime)
	.long C_LABEL(sys_stty)
	.long C_LABEL(sys_gtty)
	.long C_LABEL(sys_access)
	.long C_LABEL(sys_nice)
/*35*/	.long C_LABEL(sys_ftime)
	.long C_LABEL(sys_sync)
	.long C_LABEL(sys_kill)
	.long C_LABEL(sys_rename)
	.long C_LABEL(sys_mkdir)
/*40*/	.long C_LABEL(sys_rmdir)
	.long C_LABEL(sys_dup)
	.long C_LABEL(sys_pipe)
	.long C_LABEL(sys_times)
	.long C_LABEL(sys_prof)
/*45*/	.long C_LABEL(sys_brk)
	.long C_LABEL(sys_setgid)
	.long C_LABEL(sys_getgid)
	.long C_LABEL(sys_signal)
	.long C_LABEL(sys_geteuid)
/*50*/	.long C_LABEL(sys_getegid)
	.long C_LABEL(sys_acct)
	.long C_LABEL(sys_phys)
	.long C_LABEL(sys_lock)
	.long C_LABEL(sys_ioctl)
/*55*/	.long C_LABEL(sys_fcntl)
	.long C_LABEL(sys_mpx)
	.long C_LABEL(sys_setpgid)
	.long C_LABEL(sys_ulimit)
	.long C_LABEL(sys_olduname)
/*60*/	.long C_LABEL(sys_umask)
	.long C_LABEL(sys_chroot)
	.long C_LABEL(sys_ustat)
	.long C_LABEL(sys_dup2)
	.long C_LABEL(sys_getppid)
/*65*/	.long C_LABEL(sys_getpgrp)
	.long C_LABEL(sys_setsid)
	.long C_LABEL(sys_sigaction)
	.long C_LABEL(sys_sgetmask)
	.long C_LABEL(sys_ssetmask)
/*70*/	.long C_LABEL(sys_setreuid)
	.long C_LABEL(sys_setregid)
	.long C_LABEL(sys_sigsuspend)
	.long C_LABEL(sys_sigpending)
	.long C_LABEL(sys_sethostname)
/*75*/	.long C_LABEL(sys_setrlimit)
	.long C_LABEL(sys_getrlimit)
	.long C_LABEL(sys_getrusage)
	.long C_LABEL(sys_gettimeofday)
	.long C_LABEL(sys_settimeofday)
/*80*/	.long C_LABEL(sys_getgroups)
	.long C_LABEL(sys_setgroups)
	.long C_LABEL(sys_select)
	.long C_LABEL(sys_symlink)
	.long C_LABEL(sys_lstat)
/*85*/	.long C_LABEL(sys_readlink)
	.long C_LABEL(sys_uselib)
	.long C_LABEL(sys_swapon)
	.long C_LABEL(sys_reboot)
	.long C_LABEL(old_readdir)
/*90*/	.long C_LABEL(old_mmap)
	.long C_LABEL(sys_munmap)
	.long C_LABEL(sys_truncate)
	.long C_LABEL(sys_ftruncate)
	.long C_LABEL(sys_fchmod)
/*95*/	.long C_LABEL(sys_fchown)
	.long C_LABEL(sys_getpriority)
	.long C_LABEL(sys_setpriority)
	.long C_LABEL(sys_profil)
	.long C_LABEL(sys_statfs)
/*100*/	.long C_LABEL(sys_fstatfs)
	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_socketcall)
	.long C_LABEL(sys_syslog)
	.long C_LABEL(sys_setitimer)
/*105*/	.long C_LABEL(sys_getitimer)
	.long C_LABEL(sys_newstat)
	.long C_LABEL(sys_newlstat)
	.long C_LABEL(sys_newfstat)
	.long C_LABEL(sys_uname)
/*110*/	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_vhangup)
	.long C_LABEL(sys_idle)
	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_wait4)
/*115*/	.long C_LABEL(sys_swapoff)
	.long C_LABEL(sys_sysinfo)
	.long C_LABEL(sys_ipc)
	.long C_LABEL(sys_fsync)
	.long C_LABEL(sys_sigreturn)
/*120*/	.long C_LABEL(sys_clone)
	.long C_LABEL(sys_setdomainname)
	.long C_LABEL(sys_newuname)
	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_adjtimex)
/*125*/	.long C_LABEL(sys_mprotect)
	.long C_LABEL(sys_sigprocmask)
	.long C_LABEL(sys_create_module)
	.long C_LABEL(sys_init_module)
	.long C_LABEL(sys_delete_module)
/*130*/	.long C_LABEL(sys_get_kernel_syms)
	.long C_LABEL(sys_quotactl)
	.long C_LABEL(sys_getpgid)
	.long C_LABEL(sys_fchdir)
	.long C_LABEL(sys_bdflush)
/*135*/	.long C_LABEL(sys_sysfs)
	.long C_LABEL(sys_personality)
	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_setfsuid)
	.long C_LABEL(sys_setfsgid)
/*140*/	.long C_LABEL(sys_llseek)
	.long C_LABEL(sys_getdents)
	.long C_LABEL(sys_select)
	.long C_LABEL(sys_flock)
	.long C_LABEL(sys_msync)
/*145*/	.long C_LABEL(sys_readv)
	.long C_LABEL(sys_writev)
	.long C_LABEL(sys_getsid)
	.long C_LABEL(sys_fdatasync)
	.long C_LABEL(sys_sysctl)
/*150*/	.long C_LABEL(sys_mlock)
	.long C_LABEL(sys_munlock)
	.long C_LABEL(sys_mlockall)
	.long C_LABEL(sys_munlockall)
	.long C_LABEL(sys_sched_setparam)
/*155*/	.long C_LABEL(sys_sched_getparam)
	.long C_LABEL(sys_sched_setscheduler)
	.long C_LABEL(sys_sched_getscheduler)
	.long C_LABEL(sys_sched_yield)
	.long C_LABEL(sys_sched_get_priority_max)
/*160*/	.long C_LABEL(sys_sched_get_priority_min)
	.long C_LABEL(sys_sched_rr_get_interval)
	.long C_LABEL(sys_nanosleep)
	.long C_LABEL(sys_mremap)
	.long C_LABEL(sys_printk) /*C_LABEL(sys_ni_syscall)  eiselekd:	 remove*/
/*165*/	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
/*170*/	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
/*175*/	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
/*180*/	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
/*185*/	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
/*190*/	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
/*195*/	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
/*200*/	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
/*205*/	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
/*210*/	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
/*215*/	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
/*220*/	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
/*225*/	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
/*230*/	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
/*235*/	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
/*240*/	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
/*245*/	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
/*250*/	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)
	.long C_LABEL(sys_ni_syscall)

