/*------------------------------------------------------------------------------

    File    :   MPEGTAB.C

    Author  :   Stphane TAVENARD

    $VER:   MPEGTAB.C  0.1  (31/03/1997)

    (C) Copyright 1997-1997 Stphane TAVENARD
        All Rights Reserved

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    #Rev|   Date   |                      Comment
    ----|----------|--------------------------------------------------------
    0   |19/02/1997| Initial revision                                     ST
    1   |31/03/1997| First Aminet release                                 ST

    ------------------------------------------------------------------------

    MPEG Audio tables

------------------------------------------------------------------------------*/

#include "defs.h"
#include "mpegaud.h"
#include "mpegtab.h"

const UINT16 MPT_freq[ 2 ][ 4 ] = {
   { 22050, 24000, 16000, 0 },
   { 44100, 48000, 32000, 0 }
};

//  MPT_bitrate[ ID ][ Layer-1 ][ BitrateIndex ]
//  MPEG1->ID=1 MPEG2->ID=0
const INT16 MPT_bitrate[ 2 ][ 3 ][ 16 ] = {
   { {0,32,48,56,64,80,96,112,128,144,160,176,192,224,256,0},
     {0,8,16,24,32,40,48,56,64,80,96,112,128,144,160,0},
     {0,8,16,24,32,40,48,56,64,80,96,112,128,144,160,0} },

   { {0,32,64,96,128,160,192,224,256,288,320,352,384,416,448,0},
     {0,32,48,56,64,80,96,112,128,160,192,224,256,320,384,0},
     {0,32,40,48,56,64,80,96,112,128,160,192,224,256,320,0} }
};

const INT16 MPT_sblimit[ 5 ] = { 27, 30, 8, 12, 30 };

const INT16 MPT_jsbound[ 3 ][ 4 ] = {
   { 4, 8, 12, 16 }, { 4, 8, 12, 16 }, { 0, 4, 8, 16 }
};

#ifdef MPEGAUD_INT

// 15 bits dec. mult table
const MPEGTAB_MULT_TYPE MPT_multiple[ 64 ] = {
   0x10000,0xCB2F,0xA145,0x8000,0x6597,0x50A2,0x4000,0x32CB,
   0x2851,0x2000,0x1965,0x1428,0x1000,0x0CB2,0x0A14,0x0800,
   0x0659,0x050A,0x0400,0x032C,0x0285,0x0200,0x0196,0x0142,
   0x0100,0x00CB,0x00A1,0x0080,0x0065,0x0050,0x0040,0x0032,
   0x0028,0x0020,0x0019,0x0014,0x0010,0x000C,0x000A,0x0008,
   0x0006,0x0005,0x0004,0x0003,0x0002,0x0002,0x0001,0x0001,
   0x0001,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,
   0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000
};

// Dewindowing table (integer values) (14 bits)
const MPEGTAB_DEW_TYPE MPT_dewindow[ 512 ] = {
       +0,    -7,   +53,  -114,  +509, -1288, +1643, -9372,+18759, +9372, +1643, +1288,  +509,  +114,   +53,    +7,
       +0,    -7,   +54,  -129,  +499, -1379, +1489, -9833,+18747, +8909, +1783, +1196,  +515,  +100,   +51,    +6,
       +0,    -8,   +55,  -145,  +487, -1469, +1321,-10293,+18713, +8447, +1909, +1106,  +519,   +86,   +50,    +6,
       +0,    -9,   +56,  -161,  +473, -1559, +1140,-10751,+18657, +7986, +2022, +1015,  +521,   +73,   +49,    +5,
       +0,   -10,   +56,  -177,  +455, -1647,  +943,-11205,+18578, +7527, +2122,  +926,  +521,   +61,   +47,    +4,
       +0,   -11,   +57,  -194,  +434, -1733,  +733,-11654,+18476, +7072, +2209,  +837,  +518,   +49,   +45,    +4,
       +0,   -12,   +57,  -211,  +410, -1817,  +509,-12097,+18353, +6620, +2284,  +750,  +514,   +38,   +44,    +4,
       +0,   -13,   +56,  -229,  +383, -1899,  +270,-12534,+18208, +6173, +2347,  +665,  +507,   +27,   +42,    +3,
       +0,   -14,   +56,  -247,  +353, -1977,   +17,-12963,+18042, +5732, +2397,  +582,  +500,   +18,   +40,    +3,
       +0,   -15,   +55,  -266,  +320, -2052,  -249,-13383,+17854, +5297, +2437,  +501,  +490,    +8,   +38,    +2,
       +0,   -17,   +53,  -284,  +282, -2122,  -530,-13794,+17647, +4869, +2465,  +422,  +479,    +0,   +36,    +2,
       +0,   -18,   +51,  -302,  +242, -2188,  -824,-14194,+17419, +4449, +2483,  +346,  +467,    -7,   +34,    +2,
       +0,   -19,   +50,  -320,  +198, -2249, -1133,-14583,+17172, +4038, +2491,  +273,  +454,   -14,   +32,    +1,
       +0,   -21,   +47,  -338,  +151, -2304, -1454,-14959,+16907, +3636, +2489,  +203,  +439,   -20,   +31,    +1,
       +0,   -22,   +44,  -356,  +100, -2353, -1788,-15322,+16623, +3244, +2478,  +136,  +424,   -26,   +29,    +1,
       -1,   -24,   +40,  -374,   +46, -2396, -2134,-15670,+16322, +2863, +2459,   +71,  +408,   -31,   +27,    +1,
       -1,   -25,   +36,  -391,   -11, -2431, -2493,-16004,+16004, +2493, +2431,   +11,  +391,   -36,   +25,    +1,
       -1,   -27,   +31,  -408,   -71, -2459, -2863,-16322,+15670, +2134, +2396,   -46,  +374,   -40,   +24,    +1,
       -1,   -29,   +26,  -424,  -136, -2478, -3244,-16623,+15322, +1788, +2353,  -100,  +356,   -44,   +22,    +0,
       -1,   -31,   +20,  -439,  -203, -2489, -3636,-16907,+14959, +1454, +2304,  -151,  +339,   -47,   +21,    +0,
       -1,   -32,   +14,  -454,  -273, -2491, -4038,-17172,+14583, +1133, +2249,  -198,  +320,   -50,   +19,    +0,
       -2,   -34,    +7,  -467,  -346, -2483, -4449,-17419,+14194,  +825, +2188,  -242,  +302,   -51,   +18,    +0,
       -2,   -36,    +0,  -479,  -422, -2465, -4869,-17647,+13794,  +530, +2122,  -282,  +284,   -53,   +17,    +0,
       -2,   -38,    -8,  -490,  -501, -2437, -5297,-17854,+13383,  +249, +2052,  -319,  +266,   -55,   +15,    +0,
       -3,   -40,   -18,  -500,  -582, -2397, -5732,-18042,+12963,   -17, +1977,  -353,  +247,   -55,   +14,    +0,
       -3,   -42,   -27,  -507,  -665, -2347, -6173,-18208,+12534,  -270, +1899,  -383,  +229,   -56,   +13,    +0,
       -4,   -44,   -38,  -514,  -750, -2284, -6620,-18353,+12097,  -509, +1817,  -410,  +211,   -57,   +12,    +0,
       -4,   -45,   -49,  -518,  -837, -2209, -7072,-18476,+11654,  -733, +1733,  -434,  +194,   -57,   +11,    +0,
       -4,   -47,   -61,  -521,  -926, -2122, -7527,-18578,+11205,  -943, +1647,  -455,  +177,   -56,   +10,    +0,
       -5,   -49,   -73,  -521, -1015, -2022, -7986,-18657,+10751, -1140, +1559,  -473,  +161,   -56,    +9,    +0,
       -6,   -50,   -86,  -519, -1106, -1909, -8447,-18713,+10293, -1321, +1469,  -487,  +145,   -55,    +8,    +0,
       -6,   -51,  -100,  -515, -1196, -1783, -8909,-18747, +9833, -1489, +1379,  -499,  +129,   -54,    +7,    +0
};

#else

const MPEGTAB_MULT_TYPE MPT_multiple[ 64 ] = {
2.00000000000000, 1.58740105196820, 1.25992104989487,
1.00000000000000, 0.79370052598410, 0.62996052494744, 0.50000000000000,
0.39685026299205, 0.31498026247372, 0.25000000000000, 0.19842513149602,
0.15749013123686, 0.12500000000000, 0.09921256574801, 0.07874506561843,
0.06250000000000, 0.04960628287401, 0.03937253280921, 0.03125000000000,
0.02480314143700, 0.01968626640461, 0.01562500000000, 0.01240157071850,
0.00984313320230, 0.00781250000000, 0.00620078535925, 0.00492156660115,
0.00390625000000, 0.00310039267963, 0.00246078330058, 0.00195312500000,
0.00155019633981, 0.00123039165029, 0.00097656250000, 0.00077509816991,
0.00061519582514, 0.00048828125000, 0.00038754908495, 0.00030759791257,
0.00024414062500, 0.00019377454248, 0.00015379895629, 0.00012207031250,
0.00009688727124, 0.00007689947814, 0.00006103515625, 0.00004844363562,
0.00003844973907, 0.00003051757813, 0.00002422181781, 0.00001922486954,
0.00001525878906, 0.00001211090890, 0.00000961243477, 0.00000762939453,
0.00000605545445, 0.00000480621738, 0.00000381469727, 0.00000302772723,
0.00000240310869, 0.00000190734863, 0.00000151386361, 0.00000120155435,
1E-20
};

const MPEGTAB_DEW_TYPE MPT_dewindow[ 512 ] = {
   +0.000000000, -0.000442505, +0.003250122, -0.007003784, +0.031082153, -0.078628540, +0.100311279, -0.572036743, +1.144989014, +0.572036743, +0.100311279, +0.078628540, +0.031082153, +0.007003784, +0.003250122, +0.000442505,
   -0.000015259, -0.000473022, +0.003326416, -0.007919312, +0.030517578, -0.084182739, +0.090927124, -0.600219727, +1.144287109, +0.543823242, +0.108856201, +0.073059082, +0.031478882, +0.006118774, +0.003173828, +0.000396729,
   -0.000015259, -0.000534058, +0.003387451, -0.008865356, +0.029785156, -0.089706421, +0.080688477, -0.628295898, +1.142211914, +0.515609741, +0.116577148, +0.067520142, +0.031738281, +0.005294800, +0.003082275, +0.000366211,
   -0.000015259, -0.000579834, +0.003433228, -0.009841919, +0.028884888, -0.095169067, +0.069595337, -0.656219482, +1.138763428, +0.487472534, +0.123474121, +0.061996460, +0.031845093, +0.004486084, +0.002990723, +0.000320435,
   -0.000015259, -0.000625610, +0.003463745, -0.010848999, +0.027801514, -0.100540161, +0.057617188, -0.683914185, +1.133926392, +0.459472656, +0.129577637, +0.056533813, +0.031814575, +0.003723145, +0.002899170, +0.000289917,
   -0.000015259, -0.000686646, +0.003479004, -0.011886597, +0.026535034, -0.105819702, +0.044784546, -0.711318970, +1.127746582, +0.431655884, +0.134887695, +0.051132202, +0.031661987, +0.003005981, +0.002792358, +0.000259399,
   -0.000015259, -0.000747681, +0.003479004, -0.012939453, +0.025085449, -0.110946655, +0.031082153, -0.738372803, +1.120223999, +0.404083252, +0.139450073, +0.045837402, +0.031387329, +0.002334595, +0.002685547, +0.000244141,
   -0.000030518, -0.000808716, +0.003463745, -0.014022827, +0.023422241, -0.115921021, +0.016510010, -0.765029907, +1.111373901, +0.376800537, +0.143264771, +0.040634155, +0.031005859, +0.001693726, +0.002578735, +0.000213623,
   -0.000030518, -0.000885010, +0.003417969, -0.015121460, +0.021575928, -0.120697021, +0.001068115, -0.791213989, +1.101211548, +0.349868774, +0.146362305, +0.035552979, +0.030532837, +0.001098633, +0.002456665, +0.000198364,
   -0.000030518, -0.000961304, +0.003372192, -0.016235352, +0.019531250, -0.125259399, -0.015228271, -0.816864014, +1.089782715, +0.323318481, +0.148773193, +0.030609131, +0.029937744, +0.000549316, +0.002349854, +0.000167847,
   -0.000030518, -0.001037598, +0.003280640, -0.017349243, +0.017257690, -0.129562378, -0.032379150, -0.841949463, +1.077117920, +0.297210693, +0.150497437, +0.025817871, +0.029281616, +0.000030518, +0.002243042, +0.000152588,
   -0.000045776, -0.001113892, +0.003173828, -0.018463135, +0.014801025, -0.133590698, -0.050354004, -0.866363525, +1.063217163, +0.271591187, +0.151596069, +0.021179199, +0.028533936, -0.000442505, +0.002120972, +0.000137329,
   -0.000045776, -0.001205444, +0.003051758, -0.019577026, +0.012115479, -0.137298584, -0.069168091, -0.890090942, +1.048156738, +0.246505737, +0.152069092, +0.016708374, +0.027725220, -0.000869751, +0.002014160, +0.000122070,
   -0.000061035, -0.001296997, +0.002883911, -0.020690918, +0.009231567, -0.140670776, -0.088775635, -0.913055420, +1.031936646, +0.221984863, +0.151962280, +0.012420654, +0.026840210, -0.001266479, +0.001907349, +0.000106812,
   -0.000061035, -0.001388550, +0.002700806, -0.021789551, +0.006134033, -0.143676758, -0.109161377, -0.935195923, +1.014617920, +0.198059082, +0.151306152, +0.008316040, +0.025909424, -0.001617432, +0.001785278, +0.000106812,
   -0.000076294, -0.001480103, +0.002487183, -0.022857666, +0.002822876, -0.146255493, -0.130310059, -0.956481934, +0.996246338, +0.174789429, +0.150115967, +0.004394531, +0.024932861, -0.001937866, +0.001693726, +0.000091553,
   -0.000076294, -0.001586914, +0.002227783, -0.023910522, -0.000686646, -0.148422241, -0.152206421, -0.976852417, +0.976852417, +0.152206421, +0.148422241, +0.000686646, +0.023910522, -0.002227783, +0.001586914, +0.000076294,
   -0.000091553, -0.001693726, +0.001937866, -0.024932861, -0.004394531, -0.150115967, -0.174789429, -0.996246338, +0.956481934, +0.130310059, +0.146255493, -0.002822876, +0.022857666, -0.002487183, +0.001480103, +0.000076294,
   -0.000106812, -0.001785278, +0.001617432, -0.025909424, -0.008316040, -0.151306152, -0.198059082, -1.014617920, +0.935195923, +0.109161377, +0.143676758, -0.006134033, +0.021789551, -0.002700806, +0.001388550, +0.000061035,
   -0.000106812, -0.001907349, +0.001266479, -0.026840210, -0.012420654, -0.151962280, -0.221984863, -1.031936646, +0.913055420, +0.088775635, +0.140670776, -0.009231567, +0.020690918, -0.002883911, +0.001296997, +0.000061035,
   -0.000122070, -0.002014160, +0.000869751, -0.027725220, -0.016708374, -0.152069092, -0.246505737, -1.048156738, +0.890090942, +0.069168091, +0.137298584, -0.012115479, +0.019577026, -0.003051758, +0.001205444, +0.000045776,
   -0.000137329, -0.002120972, +0.000442505, -0.028533936, -0.021179199, -0.151596069, -0.271591187, -1.063217163, +0.866363525, +0.050354004, +0.133590698, -0.014801025, +0.018463135, -0.003173828, +0.001113892, +0.000045776,
   -0.000152588, -0.002243042, -0.000030518, -0.029281616, -0.025817871, -0.150497437, -0.297210693, -1.077117920, +0.841949463, +0.032379150, +0.129562378, -0.017257690, +0.017349243, -0.003280640, +0.001037598, +0.000030518,
   -0.000167847, -0.002349854, -0.000549316, -0.029937744, -0.030609131, -0.148773193, -0.323318481, -1.089782715, +0.816864014, +0.015228271, +0.125259399, -0.019531250, +0.016235352, -0.003372192, +0.000961304, +0.000030518,
   -0.000198364, -0.002456665, -0.001098633, -0.030532837, -0.035552979, -0.146362305, -0.349868774, -1.101211548, +0.791213989, -0.001068115, +0.120697021, -0.021575928, +0.015121460, -0.003417969, +0.000885010, +0.000030518,
   -0.000213623, -0.002578735, -0.001693726, -0.031005859, -0.040634155, -0.143264771, -0.376800537, -1.111373901, +0.765029907, -0.016510010, +0.115921021, -0.023422241, +0.014022827, -0.003463745, +0.000808716, +0.000030518,
   -0.000244141, -0.002685547, -0.002334595, -0.031387329, -0.045837402, -0.139450073, -0.404083252, -1.120223999, +0.738372803, -0.031082153, +0.110946655, -0.025085449, +0.012939453, -0.003479004, +0.000747681, +0.000015259,
   -0.000259399, -0.002792358, -0.003005981, -0.031661987, -0.051132202, -0.134887695, -0.431655884, -1.127746582, +0.711318970, -0.044784546, +0.105819702, -0.026535034, +0.011886597, -0.003479004, +0.000686646, +0.000015259,
   -0.000289917, -0.002899170, -0.003723145, -0.031814575, -0.056533813, -0.129577637, -0.459472656, -1.133926392, +0.683914185, -0.057617188, +0.100540161, -0.027801514, +0.010848999, -0.003463745, +0.000625610, +0.000015259,
   -0.000320435, -0.002990723, -0.004486084, -0.031845093, -0.061996460, -0.123474121, -0.487472534, -1.138763428, +0.656219482, -0.069595337, +0.095169067, -0.028884888, +0.009841919, -0.003433228, +0.000579834, +0.000015259,
   -0.000366211, -0.003082275, -0.005294800, -0.031738281, -0.067520142, -0.116577148, -0.515609741, -1.142211914, +0.628295898, -0.080688477, +0.089706421, -0.029785156, +0.008865356, -0.003387451, +0.000534058, +0.000015259,
   -0.000396729, -0.003173828, -0.006118774, -0.031478882, -0.073059082, -0.108856201, -0.543823242, -1.144287109, +0.600219727, -0.090927124, +0.084182739, -0.030517578, +0.007919312, -0.003326416, +0.000473022, +0.000015259,
   };

#endif

const UINT8 MPT_alloc_0[][ 16 ] = {
   0x04, 0x14, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F,
   0x04, 0x14, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F,
   0x04, 0x14, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F,
   0x04, 0x14, 0x26, 0x02, 0x39, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0F,
   0x04, 0x14, 0x26, 0x02, 0x39, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0F,
   0x04, 0x14, 0x26, 0x02, 0x39, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0F,
   0x04, 0x14, 0x26, 0x02, 0x39, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0F,
   0x04, 0x14, 0x26, 0x02, 0x39, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0F,
   0x04, 0x14, 0x26, 0x02, 0x39, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0F,
   0x04, 0x14, 0x26, 0x02, 0x39, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0F,
   0x04, 0x14, 0x26, 0x02, 0x39, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0F,
   0x03, 0x14, 0x26, 0x02, 0x39, 0x03, 0x04, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x03, 0x14, 0x26, 0x02, 0x39, 0x03, 0x04, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x03, 0x14, 0x26, 0x02, 0x39, 0x03, 0x04, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x03, 0x14, 0x26, 0x02, 0x39, 0x03, 0x04, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x03, 0x14, 0x26, 0x02, 0x39, 0x03, 0x04, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x03, 0x14, 0x26, 0x02, 0x39, 0x03, 0x04, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x03, 0x14, 0x26, 0x02, 0x39, 0x03, 0x04, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x03, 0x14, 0x26, 0x02, 0x39, 0x03, 0x04, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x03, 0x14, 0x26, 0x02, 0x39, 0x03, 0x04, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x03, 0x14, 0x26, 0x02, 0x39, 0x03, 0x04, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x03, 0x14, 0x26, 0x02, 0x39, 0x03, 0x04, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x03, 0x14, 0x26, 0x02, 0x39, 0x03, 0x04, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x02, 0x14, 0x26, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x02, 0x14, 0x26, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x02, 0x14, 0x26, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x02, 0x14, 0x26, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

const UINT8 MPT_alloc_1[][ 16 ] = {
   0x04, 0x14, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F,
   0x04, 0x14, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F,
   0x04, 0x14, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F,
   0x04, 0x14, 0x26, 0x02, 0x39, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0F,
   0x04, 0x14, 0x26, 0x02, 0x39, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0F,
   0x04, 0x14, 0x26, 0x02, 0x39, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0F,
   0x04, 0x14, 0x26, 0x02, 0x39, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0F,
   0x04, 0x14, 0x26, 0x02, 0x39, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0F,
   0x04, 0x14, 0x26, 0x02, 0x39, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0F,
   0x04, 0x14, 0x26, 0x02, 0x39, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0F,
   0x04, 0x14, 0x26, 0x02, 0x39, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0F,
   0x03, 0x14, 0x26, 0x02, 0x39, 0x03, 0x04, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x03, 0x14, 0x26, 0x02, 0x39, 0x03, 0x04, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x03, 0x14, 0x26, 0x02, 0x39, 0x03, 0x04, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x03, 0x14, 0x26, 0x02, 0x39, 0x03, 0x04, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x03, 0x14, 0x26, 0x02, 0x39, 0x03, 0x04, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x03, 0x14, 0x26, 0x02, 0x39, 0x03, 0x04, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x03, 0x14, 0x26, 0x02, 0x39, 0x03, 0x04, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x03, 0x14, 0x26, 0x02, 0x39, 0x03, 0x04, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x03, 0x14, 0x26, 0x02, 0x39, 0x03, 0x04, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x03, 0x14, 0x26, 0x02, 0x39, 0x03, 0x04, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x03, 0x14, 0x26, 0x02, 0x39, 0x03, 0x04, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x03, 0x14, 0x26, 0x02, 0x39, 0x03, 0x04, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x02, 0x14, 0x26, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x02, 0x14, 0x26, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x02, 0x14, 0x26, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x02, 0x14, 0x26, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x02, 0x14, 0x26, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x02, 0x14, 0x26, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x02, 0x14, 0x26, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

const UINT8 MPT_alloc_2[][ 16 ] = {
   0x04, 0x14, 0x26, 0x39, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E,
   0x04, 0x14, 0x26, 0x39, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E,
   0x03, 0x14, 0x26, 0x39, 0x03, 0x04, 0x05, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x03, 0x14, 0x26, 0x39, 0x03, 0x04, 0x05, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x03, 0x14, 0x26, 0x39, 0x03, 0x04, 0x05, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x03, 0x14, 0x26, 0x39, 0x03, 0x04, 0x05, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x03, 0x14, 0x26, 0x39, 0x03, 0x04, 0x05, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x03, 0x14, 0x26, 0x39, 0x03, 0x04, 0x05, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

const UINT8 MPT_alloc_3[][ 16 ] = {
   0x04, 0x14, 0x26, 0x39, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E,
   0x04, 0x14, 0x26, 0x39, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E,
   0x03, 0x14, 0x26, 0x39, 0x03, 0x04, 0x05, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x03, 0x14, 0x26, 0x39, 0x03, 0x04, 0x05, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x03, 0x14, 0x26, 0x39, 0x03, 0x04, 0x05, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x03, 0x14, 0x26, 0x39, 0x03, 0x04, 0x05, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x03, 0x14, 0x26, 0x39, 0x03, 0x04, 0x05, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x03, 0x14, 0x26, 0x39, 0x03, 0x04, 0x05, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x03, 0x14, 0x26, 0x39, 0x03, 0x04, 0x05, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x03, 0x14, 0x26, 0x39, 0x03, 0x04, 0x05, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x03, 0x14, 0x26, 0x39, 0x03, 0x04, 0x05, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x03, 0x14, 0x26, 0x39, 0x03, 0x04, 0x05, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

const UINT8 MPT_alloc_4[][ 16 ] = {
   0x04, 0x14, 0x26, 0x02, 0x39, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D,
   0x04, 0x14, 0x26, 0x02, 0x39, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D,
   0x04, 0x14, 0x26, 0x02, 0x39, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D,
   0x04, 0x14, 0x26, 0x02, 0x39, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D,
   0x03, 0x14, 0x26, 0x39, 0x03, 0x04, 0x05, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x03, 0x14, 0x26, 0x39, 0x03, 0x04, 0x05, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x03, 0x14, 0x26, 0x39, 0x03, 0x04, 0x05, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x03, 0x14, 0x26, 0x39, 0x03, 0x04, 0x05, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x03, 0x14, 0x26, 0x39, 0x03, 0x04, 0x05, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x03, 0x14, 0x26, 0x39, 0x03, 0x04, 0x05, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x03, 0x14, 0x26, 0x39, 0x03, 0x04, 0x05, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x02, 0x14, 0x26, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x02, 0x14, 0x26, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x02, 0x14, 0x26, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x02, 0x14, 0x26, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x02, 0x14, 0x26, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x02, 0x14, 0x26, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x02, 0x14, 0x26, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x02, 0x14, 0x26, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x02, 0x14, 0x26, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x02, 0x14, 0x26, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x02, 0x14, 0x26, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x02, 0x14, 0x26, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x02, 0x14, 0x26, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x02, 0x14, 0x26, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x02, 0x14, 0x26, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x02, 0x14, 0x26, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x02, 0x14, 0x26, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x02, 0x14, 0x26, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x02, 0x14, 0x26, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

#ifdef MPEGAUD_INT

// (4/3)^x table for x=0..8191
// -> <pow mantissa:24><pow exponent:8>
const FAR MPEGTAB_POW_TYPE MPT_pow_4_3[ 8192 ] = {
   0x00000011, 0x01000010, 0x02851410, 0x0229D20F, 0x032CBF0F, 0x0223310E, 0x02B9C60E, 0x0358FE0E,
   0x01FFFF0D, 0x0257100D, 0x02B16B0D, 0x030ED70D, 0x036F230D, 0x03D2270D, 0x021BDF0C, 0x024FE40C,
   0x0285140C, 0x02BB630C, 0x02F2C60C, 0x032B310C, 0x03649D0C, 0x039EFF0C, 0x03DA510C, 0x020B450B,
   0x0229D20B, 0x0248CD0B, 0x0268320B, 0x0287FF0B, 0x02A8320B, 0x02C8C70B, 0x02E9BC0B, 0x030B0F0B,
   0x032CBF0B, 0x034ECA0B, 0x03712C0B, 0x0393E60B, 0x03B6F40B, 0x03DA560B, 0x01FF050A, 0x0211070A,
   0x0223310A, 0x0235810A, 0x0247F80A, 0x025A950A, 0x026D570A, 0x02803D0A, 0x0293470A, 0x02A6750A,
   0x02B9C60A, 0x02CD390A, 0x02E0CE0A, 0x02F4850A, 0x03085C0A, 0x031C550A, 0x03306D0A, 0x0344A60A,
   0x0358FE0A, 0x036D750A, 0x03820B0A, 0x0396BF0A, 0x03AB910A, 0x03C0810A, 0x03D58E0A, 0x03EAB80A,
   0x01FFFF09, 0x020AB109, 0x02157109, 0x02203F09, 0x022B1A09, 0x02360409, 0x0240FA09, 0x024BFF09,
   0x02571009, 0x02622E09, 0x026D5A09, 0x02789309, 0x0283D809, 0x028F2A09, 0x029A8809, 0x02A5F309,
   0x02B16B09, 0x02BCEE09, 0x02C87E09, 0x02D41A09, 0x02DFC209, 0x02EB7609, 0x02F73509, 0x03030009,
   0x030ED709, 0x031AB909, 0x0326A709, 0x0332A009, 0x033EA409, 0x034AB309, 0x0356CE09, 0x0362F309,
   0x036F2309, 0x037B5F09, 0x0387A509, 0x0393F509, 0x03A05109, 0x03ACB709, 0x03B92709, 0x03C5A209,
   0x03D22709, 0x03DEB709, 0x03EB5009, 0x03F7F409, 0x02025108, 0x0208AD08, 0x020F0E08, 0x02157408,
   0x021BDF08, 0x02224E08, 0x0228C308, 0x022F3D08, 0x0235BB08, 0x023C3E08, 0x0242C608, 0x02495208,
   0x024FE408, 0x02567A08, 0x025D1408, 0x0263B308, 0x026A5708, 0x0270FF08, 0x0277AC08, 0x027E5E08,
   0x02851408, 0x028BCE08, 0x02928D08, 0x02995108, 0x02A01808, 0x02A6E408, 0x02ADB508, 0x02B48A08,
   0x02BB6308, 0x02C24008, 0x02C92208, 0x02D00808, 0x02D6F208, 0x02DDE108, 0x02E4D408, 0x02EBCB08,
   0x02F2C608, 0x02F9C508, 0x0300C808, 0x0307CF08, 0x030EDB08, 0x0315EA08, 0x031CFE08, 0x03241608,
   0x032B3108, 0x03325108, 0x03397408, 0x03409C08, 0x0347C708, 0x034EF708, 0x03562A08, 0x035D6108,
   0x03649D08, 0x036BDC08, 0x03731E08, 0x037A6508, 0x0381AF08, 0x0388FE08, 0x03905008, 0x0397A608,
   0x039EFF08, 0x03A65C08, 0x03ADBD08, 0x03B52208, 0x03BC8B08, 0x03C3F708, 0x03CB6608, 0x03D2DA08,
   0x03DA5108, 0x03E1CC08, 0x03E94A08, 0x03F0CC08, 0x03F85108, 0x01FFED07, 0x0203B307, 0x02077B07,
   0x020B4507, 0x020F1107, 0x0212DE07, 0x0216AD07, 0x021A7E07, 0x021E5007, 0x02222507, 0x0225FB07,
   0x0229D207, 0x022DAC07, 0x02318707, 0x02356407, 0x02394207, 0x023D2307, 0x02410407, 0x0244E807,
   0x0248CD07, 0x024CB407, 0x02509D07, 0x02548707, 0x02587307, 0x025C6007, 0x02604F07, 0x02644007,
   0x02683207, 0x026C2607, 0x02701C07, 0x02741307, 0x02780C07, 0x027C0707, 0x02800307, 0x02840007,
   0x0287FF07, 0x028C0007, 0x02900307, 0x02940707, 0x02980C07, 0x029C1307, 0x02A01C07, 0x02A42607,
   0x02A83207, 0x02AC3F07, 0x02B04E07, 0x02B45E07, 0x02B87007, 0x02BC8307, 0x02C09807, 0x02C4AF07,
   0x02C8C707, 0x02CCE007, 0x02D0FB07, 0x02D51707, 0x02D93507, 0x02DD5507, 0x02E17607, 0x02E59807,
   0x02E9BC07, 0x02EDE107, 0x02F20807, 0x02F63007, 0x02FA5A07, 0x02FE8507, 0x0302B207, 0x0306E007,
   0x030B0F07, 0x030F4007, 0x03137307, 0x0317A707, 0x031BDC07, 0x03201307, 0x03244B07, 0x03288407,
   0x032CBF07, 0x0330FC07, 0x03353907, 0x03397907, 0x033DB907, 0x0341FB07, 0x03463F07, 0x034A8307,
   0x034ECA07, 0x03531107, 0x03575A07, 0x035BA407, 0x035FF007, 0x03643D07, 0x03688B07, 0x036CDB07,
   0x03712C07, 0x03757F07, 0x0379D207, 0x037E2807, 0x03827E07, 0x0386D607, 0x038B2F07, 0x038F8A07,
   0x0393E607, 0x03984307, 0x039CA107, 0x03A10107, 0x03A56207, 0x03A9C507, 0x03AE2807, 0x03B28E07,
   0x03B6F407, 0x03BB5C07, 0x03BFC507, 0x03C42F07, 0x03C89B07, 0x03CD0807, 0x03D17607, 0x03D5E507,
   0x03DA5607, 0x03DEC807, 0x03E33B07, 0x03E7B007, 0x03EC2607, 0x03F09D07, 0x03F51507, 0x03F98F07,
   0x03FE0A07, 0x02014306, 0x02038106, 0x0205C106, 0x02080106, 0x020A4106, 0x020C8306, 0x020EC406,
   0x02110706, 0x02134A06, 0x02158E06, 0x0217D206, 0x021A1706, 0x021C5C06, 0x021EA306, 0x0220E906,
   0x02233106, 0x02257906, 0x0227C106, 0x022A0A06, 0x022C5406, 0x022E9F06, 0x0230EA06, 0x02333506,
   0x02358106, 0x0237CE06, 0x023A1C06, 0x023C6A06, 0x023EB806, 0x02410706, 0x02435706, 0x0245A806,
   0x0247F806, 0x024A4A06, 0x024C9C06, 0x024EEF06, 0x02514206, 0x02539606, 0x0255EA06, 0x02583F06,
   0x025A9506, 0x025CEB06, 0x025F4206, 0x02619906, 0x0263F106, 0x02664A06, 0x0268A306, 0x026AFD06,
   0x026D5706, 0x026FB206, 0x02720D06, 0x02746906, 0x0276C506, 0x02792306, 0x027B8006, 0x027DDE06,
   0x02803D06, 0x02829C06, 0x0284FC06, 0x02875D06, 0x0289BE06, 0x028C1F06, 0x028E8106, 0x0290E406,
   0x02934706, 0x0295AB06, 0x02981006, 0x029A7406, 0x029CDA06, 0x029F4006, 0x02A1A606, 0x02A40D06,
   0x02A67506, 0x02A8DD06, 0x02AB4606, 0x02ADAF06, 0x02B01906, 0x02B28306, 0x02B4EE06, 0x02B75A06,
   0x02B9C606, 0x02BC3206, 0x02BE9F06, 0x02C10D06, 0x02C37B06, 0x02C5EA06, 0x02C85906, 0x02CAC906,
   0x02CD3906, 0x02CFAA06, 0x02D21B06, 0x02D48D06, 0x02D6FF06, 0x02D97206, 0x02DBE506, 0x02DE5906,
   0x02E0CE06, 0x02E34306, 0x02E5B806, 0x02E82E06, 0x02EAA506, 0x02ED1C06, 0x02EF9406, 0x02F20C06,
   0x02F48506, 0x02F6FE06, 0x02F97706, 0x02FBF206, 0x02FE6C06, 0x0300E806, 0x03036306, 0x0305DF06,
   0x03085C06, 0x030ADA06, 0x030D5706, 0x030FD606, 0x03125406, 0x0314D406, 0x03175406, 0x0319D406,
   0x031C5506, 0x031ED606, 0x03215806, 0x0323DA06, 0x03265D06, 0x0328E006, 0x032B6406, 0x032DE806,
   0x03306D06, 0x0332F306, 0x03357806, 0x0337FF06, 0x033A8606, 0x033D0D06, 0x033F9506, 0x03421D06,
   0x0344A606, 0x03472F06, 0x0349B906, 0x034C4306, 0x034ECE06, 0x03515906, 0x0353E506, 0x03567106,
   0x0358FE06, 0x035B8B06, 0x035E1906, 0x0360A706, 0x03633506, 0x0365C506, 0x03685406, 0x036AE406,
   0x036D7506, 0x03700606, 0x03729706, 0x03752906, 0x0377BC06, 0x037A4F06, 0x037CE206, 0x037F7606,
   0x03820B06, 0x03849F06, 0x03873506, 0x0389CB06, 0x038C6106, 0x038EF806, 0x03918F06, 0x03942706,
   0x0396BF06, 0x03995706, 0x039BF106, 0x039E8A06, 0x03A12406, 0x03A3BF06, 0x03A65A06, 0x03A8F506,
   0x03AB9106, 0x03AE2D06, 0x03B0CA06, 0x03B36706, 0x03B60506, 0x03B8A306, 0x03BB4206, 0x03BDE106,
   0x03C08106, 0x03C32106, 0x03C5C106, 0x03C86206, 0x03CB0406, 0x03CDA606, 0x03D04806, 0x03D2EB06,
   0x03D58E06, 0x03D83206, 0x03DAD606, 0x03DD7B06, 0x03E02006, 0x03E2C506, 0x03E56B06, 0x03E81206,
   0x03EAB806, 0x03ED6006, 0x03F00806, 0x03F2B006, 0x03F55806, 0x03F80206, 0x03FAAB06, 0x03FD5506,
   0x01FFFF05, 0x02015505, 0x0202AB05, 0x02040005, 0x02055705, 0x0206AD05, 0x02080305, 0x02095A05,
   0x020AB105, 0x020C0805, 0x020D6005, 0x020EB805, 0x02100F05, 0x02116805, 0x0212C005, 0x02141805,
   0x02157105, 0x0216CA05, 0x02182305, 0x02197D05, 0x021AD605, 0x021C3005, 0x021D8A05, 0x021EE405,
   0x02203F05, 0x02219A05, 0x0222F405, 0x02245005, 0x0225AB05, 0x02270605, 0x02286205, 0x0229BE05,
   0x022B1A05, 0x022C7705, 0x022DD305, 0x022F3005, 0x02308D05, 0x0231EB05, 0x02334805, 0x0234A605,
   0x02360405, 0x02376205, 0x0238C005, 0x023A1F05, 0x023B7D05, 0x023CDC05, 0x023E3B05, 0x023F9B05,
   0x0240FA05, 0x02425A05, 0x0243BA05, 0x02451A05, 0x02467B05, 0x0247DB05, 0x02493C05, 0x024A9D05,
   0x024BFF05, 0x024D6005, 0x024EC205, 0x02502305, 0x02518605, 0x0252E805, 0x02544A05, 0x0255AD05,
   0x02571005, 0x02587305, 0x0259D605, 0x025B3A05, 0x025C9E05, 0x025E0105, 0x025F6605, 0x0260CA05,
   0x02622E05, 0x02639305, 0x0264F805, 0x02665D05, 0x0267C305, 0x02692805, 0x026A8E05, 0x026BF405,
   0x026D5A05, 0x026EC005, 0x02702705, 0x02718E05, 0x0272F505, 0x02745C05, 0x0275C305, 0x02772B05,
   0x02789305, 0x0279FB05, 0x027B6305, 0x027CCB05, 0x027E3405, 0x027F9C05, 0x02810505, 0x02826F05,
   0x0283D805, 0x02854105, 0x0286AB05, 0x02881505, 0x02897F05, 0x028AEA05, 0x028C5405, 0x028DBF05,
   0x028F2A05, 0x02909505, 0x02920005, 0x02936C05, 0x0294D805, 0x02964305, 0x0297B005, 0x02991C05,
   0x029A8805, 0x029BF505, 0x029D6205, 0x029ECF05, 0x02A03C05, 0x02A1AA05, 0x02A31705, 0x02A48505,
   0x02A5F305, 0x02A76205, 0x02A8D005, 0x02AA3F05, 0x02ABAE05, 0x02AD1D05, 0x02AE8C05, 0x02AFFB05,
   0x02B16B05, 0x02B2DB05, 0x02B44B05, 0x02B5BB05, 0x02B72B05, 0x02B89C05, 0x02BA0C05, 0x02BB7D05,
   0x02BCEE05, 0x02BE6005, 0x02BFD105, 0x02C14305, 0x02C2B505, 0x02C42705, 0x02C59905, 0x02C70C05,
   0x02C87E05, 0x02C9F105, 0x02CB6405, 0x02CCD705, 0x02CE4B05, 0x02CFBE05, 0x02D13205, 0x02D2A605,
   0x02D41A05, 0x02D58E05, 0x02D70305, 0x02D87805, 0x02D9EC05, 0x02DB6205, 0x02DCD705, 0x02DE4C05,
   0x02DFC205, 0x02E13805, 0x02E2AE05, 0x02E42405, 0x02E59A05, 0x02E71105, 0x02E88805, 0x02E9FE05,
   0x02EB7605, 0x02ECED05, 0x02EE6405, 0x02EFDC05, 0x02F15405, 0x02F2CC05, 0x02F44405, 0x02F5BC05,
   0x02F73505, 0x02F8AE05, 0x02FA2705, 0x02FBA005, 0x02FD1905, 0x02FE9305, 0x03000C05, 0x03018605,
   0x03030005, 0x03047A05, 0x0305F505, 0x03076F05, 0x0308EA05, 0x030A6505, 0x030BE005, 0x030D5B05,
   0x030ED705, 0x03105205, 0x0311CE05, 0x03134A05, 0x0314C605, 0x03164305, 0x0317BF05, 0x03193C05,
   0x031AB905, 0x031C3605, 0x031DB305, 0x031F3105, 0x0320AE05, 0x03222C05, 0x0323AA05, 0x03252805,
   0x0326A705, 0x03282505, 0x0329A405, 0x032B2305, 0x032CA205, 0x032E2105, 0x032FA005, 0x03312005,
   0x0332A005, 0x03341F05, 0x0335A005, 0x03372005, 0x0338A005, 0x033A2105, 0x033BA205, 0x033D2305,
   0x033EA405, 0x03402505, 0x0341A705, 0x03432805, 0x0344AA05, 0x03462C05, 0x0347AE05, 0x03493105,
   0x034AB305, 0x034C3605, 0x034DB905, 0x034F3C05, 0x0350BF05, 0x03524205, 0x0353C605, 0x03554A05,
   0x0356CE05, 0x03585205, 0x0359D605, 0x035B5A05, 0x035CDF05, 0x035E6405, 0x035FE905, 0x03616E05,
   0x0362F305, 0x03647905, 0x0365FE05, 0x03678405, 0x03690A05, 0x036A9005, 0x036C1605, 0x036D9D05,
   0x036F2305, 0x0370AA05, 0x03723105, 0x0373B805, 0x03754005, 0x0376C705, 0x03784F05, 0x0379D705,
   0x037B5F05, 0x037CE705, 0x037E6F05, 0x037FF805, 0x03818005, 0x03830905, 0x03849205, 0x03861B05,
   0x0387A505, 0x03892E05, 0x038AB805, 0x038C4205, 0x038DCC05, 0x038F5605, 0x0390E005, 0x03926B05,
   0x0393F505, 0x03958005, 0x03970B05, 0x03989705, 0x039A2205, 0x039BAD05, 0x039D3905, 0x039EC505,
   0x03A05105, 0x03A1DD05, 0x03A36905, 0x03A4F605, 0x03A68205, 0x03A80F05, 0x03A99C05, 0x03AB2905,
   0x03ACB705, 0x03AE4405, 0x03AFD205, 0x03B16005, 0x03B2EE05, 0x03B47C05, 0x03B60A05, 0x03B79905,
   0x03B92705, 0x03BAB605, 0x03BC4505, 0x03BDD405, 0x03BF6305, 0x03C0F305, 0x03C28205, 0x03C41205,
   0x03C5A205, 0x03C73205, 0x03C8C205, 0x03CA5305, 0x03CBE305, 0x03CD7405, 0x03CF0505, 0x03D09605,
   0x03D22705, 0x03D3B905, 0x03D54A05, 0x03D6DC05, 0x03D86E05, 0x03DA0005, 0x03DB9205, 0x03DD2405,
   0x03DEB705, 0x03E04905, 0x03E1DC05, 0x03E36F05, 0x03E50205, 0x03E69605, 0x03E82905, 0x03E9BD05,
   0x03EB5005, 0x03ECE405, 0x03EE7805, 0x03F00D05, 0x03F1A105, 0x03F33605, 0x03F4CA05, 0x03F65F05,
   0x03F7F405, 0x03F98A05, 0x03FB1F05, 0x03FCB405, 0x03FE4A05, 0x01FFF004, 0x0200BB04, 0x02018604,
   0x02025104, 0x02031C04, 0x0203E704, 0x0204B304, 0x02057E04, 0x02064A04, 0x02071504, 0x0207E104,
   0x0208AD04, 0x02097904, 0x020A4504, 0x020B1104, 0x020BDD04, 0x020CA904, 0x020D7504, 0x020E4104,
   0x020F0E04, 0x020FDA04, 0x0210A704, 0x02117404, 0x02124004, 0x02130D04, 0x0213DA04, 0x0214A704,
   0x02157404, 0x02164104, 0x02170E04, 0x0217DB04, 0x0218A904, 0x02197604, 0x021A4404, 0x021B1104,
   0x021BDF04, 0x021CAC04, 0x021D7A04, 0x021E4804, 0x021F1604, 0x021FE404, 0x0220B204, 0x02218004,
   0x02224E04, 0x02231D04, 0x0223EB04, 0x0224BA04, 0x02258804, 0x02265704, 0x02272504, 0x0227F404,
   0x0228C304, 0x02299204, 0x022A6104, 0x022B3004, 0x022BFF04, 0x022CCE04, 0x022D9E04, 0x022E6D04,
   0x022F3D04, 0x02300C04, 0x0230DC04, 0x0231AB04, 0x02327B04, 0x02334B04, 0x02341B04, 0x0234EB04,
   0x0235BB04, 0x02368B04, 0x02375B04, 0x02382B04, 0x0238FC04, 0x0239CC04, 0x023A9D04, 0x023B6D04,
   0x023C3E04, 0x023D0F04, 0x023DDF04, 0x023EB004, 0x023F8104, 0x02405204, 0x02412304, 0x0241F504,
   0x0242C604, 0x02439704, 0x02446804, 0x02453A04, 0x02460B04, 0x0246DD04, 0x0247AF04, 0x02488004,
   0x02495204, 0x024A2404, 0x024AF604, 0x024BC804, 0x024C9A04, 0x024D6D04, 0x024E3F04, 0x024F1104,
   0x024FE404, 0x0250B604, 0x02518904, 0x02525B04, 0x02532E04, 0x02540104, 0x0254D404, 0x0255A704,
   0x02567A04, 0x02574D04, 0x02582004, 0x0258F304, 0x0259C604, 0x025A9A04, 0x025B6D04, 0x025C4104,
   0x025D1404, 0x025DE804, 0x025EBB04, 0x025F8F04, 0x02606304, 0x02613704, 0x02620B04, 0x0262DF04,
   0x0263B304, 0x02648804, 0x02655C04, 0x02663004, 0x02670504, 0x0267D904, 0x0268AE04, 0x02698204,
   0x026A5704, 0x026B2C04, 0x026C0104, 0x026CD604, 0x026DAB04, 0x026E8004, 0x026F5504, 0x02702A04,
   0x0270FF04, 0x0271D504, 0x0272AA04, 0x02738004, 0x02745504, 0x02752B04, 0x02760104, 0x0276D704,
   0x0277AC04, 0x02788204, 0x02795804, 0x027A2E04, 0x027B0504, 0x027BDB04, 0x027CB104, 0x027D8704,
   0x027E5E04, 0x027F3404, 0x02800B04, 0x0280E204, 0x0281B804, 0x02828F04, 0x02836604, 0x02843D04,
   0x02851404, 0x0285EB04, 0x0286C204, 0x02879904, 0x02887104, 0x02894804, 0x028A1F04, 0x028AF704,
   0x028BCE04, 0x028CA604, 0x028D7E04, 0x028E5504, 0x028F2D04, 0x02900504, 0x0290DD04, 0x0291B504,
   0x02928D04, 0x02936504, 0x02943E04, 0x02951604, 0x0295EE04, 0x0296C704, 0x02979F04, 0x02987804,
   0x02995104, 0x029A2904, 0x029B0204, 0x029BDB04, 0x029CB404, 0x029D8D04, 0x029E6604, 0x029F3F04,
   0x02A01804, 0x02A0F204, 0x02A1CB04, 0x02A2A404, 0x02A37E04, 0x02A45704, 0x02A53104, 0x02A60B04,
   0x02A6E404, 0x02A7BE04, 0x02A89804, 0x02A97204, 0x02AA4C04, 0x02AB2604, 0x02AC0004, 0x02ACDB04,
   0x02ADB504, 0x02AE8F04, 0x02AF6A04, 0x02B04404, 0x02B11F04, 0x02B1F904, 0x02B2D404, 0x02B3AF04,
   0x02B48A04, 0x02B56504, 0x02B64004, 0x02B71B04, 0x02B7F604, 0x02B8D104, 0x02B9AC04, 0x02BA8804,
   0x02BB6304, 0x02BC3E04, 0x02BD1A04, 0x02BDF604, 0x02BED104, 0x02BFAD04, 0x02C08904, 0x02C16504,
   0x02C24004, 0x02C31C04, 0x02C3F804, 0x02C4D504, 0x02C5B104, 0x02C68D04, 0x02C76904, 0x02C84604,
   0x02C92204, 0x02C9FF04, 0x02CADB04, 0x02CBB804, 0x02CC9504, 0x02CD7104, 0x02CE4E04, 0x02CF2B04,
   0x02D00804, 0x02D0E504, 0x02D1C204, 0x02D2A004, 0x02D37D04, 0x02D45A04, 0x02D53804, 0x02D61504,
   0x02D6F204, 0x02D7D004, 0x02D8AE04, 0x02D98B04, 0x02DA6904, 0x02DB4704, 0x02DC2504, 0x02DD0304,
   0x02DDE104, 0x02DEBF04, 0x02DF9D04, 0x02E07B04, 0x02E15A04, 0x02E23804, 0x02E31704, 0x02E3F504,
   0x02E4D404, 0x02E5B204, 0x02E69104, 0x02E77004, 0x02E84F04, 0x02E92D04, 0x02EA0C04, 0x02EAEB04,
   0x02EBCB04, 0x02ECAA04, 0x02ED8904, 0x02EE6804, 0x02EF4704, 0x02F02704, 0x02F10604, 0x02F1E604,
   0x02F2C604, 0x02F3A504, 0x02F48504, 0x02F56504, 0x02F64504, 0x02F72504, 0x02F80504, 0x02F8E504,
   0x02F9C504, 0x02FAA504, 0x02FB8504, 0x02FC6504, 0x02FD4604, 0x02FE2604, 0x02FF0704, 0x02FFE704,
   0x0300C804, 0x0301A904, 0x03028904, 0x03036A04, 0x03044B04, 0x03052C04, 0x03060D04, 0x0306EE04,
   0x0307CF04, 0x0308B104, 0x03099204, 0x030A7304, 0x030B5504, 0x030C3604, 0x030D1804, 0x030DF904,
   0x030EDB04, 0x030FBD04, 0x03109E04, 0x03118004, 0x03126204, 0x03134404, 0x03142604, 0x03150804,
   0x0315EA04, 0x0316CD04, 0x0317AF04, 0x03189104, 0x03197404, 0x031A5604, 0x031B3904, 0x031C1B04,
   0x031CFE04, 0x031DE104, 0x031EC304, 0x031FA604, 0x03208904, 0x03216C04, 0x03224F04, 0x03233204,
   0x03241604, 0x0324F904, 0x0325DC04, 0x0326BF04, 0x0327A304, 0x03288604, 0x03296A04, 0x032A4E04,
   0x032B3104, 0x032C1504, 0x032CF904, 0x032DDD04, 0x032EC104, 0x032FA404, 0x03308904, 0x03316D04,
   0x03325104, 0x03333504, 0x03341904, 0x0334FE04, 0x0335E204, 0x0336C704, 0x0337AB04, 0x03389004,
   0x03397404, 0x033A5904, 0x033B3E04, 0x033C2304, 0x033D0804, 0x033DED04, 0x033ED204, 0x033FB704,
   0x03409C04, 0x03418104, 0x03426604, 0x03434C04, 0x03443104, 0x03451704, 0x0345FC04, 0x0346E204,
   0x0347C704, 0x0348AD04, 0x03499304, 0x034A7904, 0x034B5F04, 0x034C4504, 0x034D2B04, 0x034E1104,
   0x034EF704, 0x034FDD04, 0x0350C304, 0x0351AA04, 0x03529004, 0x03537704, 0x03545D04, 0x03554404,
   0x03562A04, 0x03571104, 0x0357F804, 0x0358DF04, 0x0359C504, 0x035AAC04, 0x035B9304, 0x035C7A04,
   0x035D6104, 0x035E4904, 0x035F3004, 0x03601704, 0x0360FF04, 0x0361E604, 0x0362CD04, 0x0363B504,
   0x03649D04, 0x03658404, 0x03666C04, 0x03675404, 0x03683C04, 0x03692304, 0x036A0B04, 0x036AF304,
   0x036BDC04, 0x036CC404, 0x036DAC04, 0x036E9404, 0x036F7C04, 0x03706504, 0x03714D04, 0x03723604,
   0x03731E04, 0x03740704, 0x0374F004, 0x0375D804, 0x0376C104, 0x0377AA04, 0x03789304, 0x03797C04,
   0x037A6504, 0x037B4E04, 0x037C3704, 0x037D2004, 0x037E0A04, 0x037EF304, 0x037FDD04, 0x0380C604,
   0x0381AF04, 0x03829904, 0x03838304, 0x03846C04, 0x03855604, 0x03864004, 0x03872A04, 0x03881404,
   0x0388FE04, 0x0389E804, 0x038AD204, 0x038BBC04, 0x038CA604, 0x038D9104, 0x038E7B04, 0x038F6504,
   0x03905004, 0x03913A04, 0x03922504, 0x03930F04, 0x0393FA04, 0x0394E504, 0x0395D004, 0x0396BB04,
   0x0397A604, 0x03989104, 0x03997C04, 0x039A6704, 0x039B5204, 0x039C3D04, 0x039D2804, 0x039E1404,
   0x039EFF04, 0x039FEB04, 0x03A0D604, 0x03A1C204, 0x03A2AD04, 0x03A39904, 0x03A48504, 0x03A57104,
   0x03A65C04, 0x03A74804, 0x03A83404, 0x03A92004, 0x03AA0C04, 0x03AAF904, 0x03ABE504, 0x03ACD104,
   0x03ADBD04, 0x03AEAA04, 0x03AF9604, 0x03B08304, 0x03B16F04, 0x03B25C04, 0x03B34904, 0x03B43504,
   0x03B52204, 0x03B60F04, 0x03B6FC04, 0x03B7E904, 0x03B8D604, 0x03B9C304, 0x03BAB004, 0x03BB9D04,
   0x03BC8B04, 0x03BD7804, 0x03BE6504, 0x03BF5304, 0x03C04004, 0x03C12E04, 0x03C21B04, 0x03C30904,
   0x03C3F704, 0x03C4E404, 0x03C5D204, 0x03C6C004, 0x03C7AE04, 0x03C89C04, 0x03C98A04, 0x03CA7804,
   0x03CB6604, 0x03CC5504, 0x03CD4304, 0x03CE3104, 0x03CF2004, 0x03D00E04, 0x03D0FD04, 0x03D1EB04,
   0x03D2DA04, 0x03D3C904, 0x03D4B704, 0x03D5A604, 0x03D69504, 0x03D78404, 0x03D87304, 0x03D96204,
   0x03DA5104, 0x03DB4004, 0x03DC2F04, 0x03DD1E04, 0x03DE0E04, 0x03DEFD04, 0x03DFED04, 0x03E0DC04,
   0x03E1CC04, 0x03E2BB04, 0x03E3AB04, 0x03E49A04, 0x03E58A04, 0x03E67A04, 0x03E76A04, 0x03E85A04,
   0x03E94A04, 0x03EA3A04, 0x03EB2A04, 0x03EC1A04, 0x03ED0A04, 0x03EDFB04, 0x03EEEB04, 0x03EFDB04,
   0x03F0CC04, 0x03F1BC04, 0x03F2AD04, 0x03F39D04, 0x03F48E04, 0x03F57F04, 0x03F66F04, 0x03F76004,
   0x03F85104, 0x03F94204, 0x03FA3304, 0x03FB2404, 0x03FC1504, 0x03FD0604, 0x03FDF804, 0x03FEE904,
   0x03FFDA04, 0x02006603, 0x0200DE03, 0x02015703, 0x0201D003, 0x02024903, 0x0202C103, 0x02033A03,
   0x0203B303, 0x02042C03, 0x0204A503, 0x02051E03, 0x02059703, 0x02061003, 0x02068903, 0x02070203,
   0x02077B03, 0x0207F403, 0x02086D03, 0x0208E703, 0x02096003, 0x0209D903, 0x020A5203, 0x020ACC03,
   0x020B4503, 0x020BBE03, 0x020C3803, 0x020CB103, 0x020D2B03, 0x020DA403, 0x020E1E03, 0x020E9703,
   0x020F1103, 0x020F8A03, 0x02100403, 0x02107D03, 0x0210F703, 0x02117103, 0x0211EA03, 0x02126403,
   0x0212DE03, 0x02135803, 0x0213D203, 0x02144B03, 0x0214C503, 0x02153F03, 0x0215B903, 0x02163303,
   0x0216AD03, 0x02172703, 0x0217A103, 0x02181B03, 0x02189503, 0x02190F03, 0x02198903, 0x021A0403,
   0x021A7E03, 0x021AF803, 0x021B7203, 0x021BED03, 0x021C6703, 0x021CE103, 0x021D5C03, 0x021DD603,
   0x021E5003, 0x021ECB03, 0x021F4503, 0x021FC003, 0x02203A03, 0x0220B503, 0x02212F03, 0x0221AA03,
   0x02222503, 0x02229F03, 0x02231A03, 0x02239503, 0x02240F03, 0x02248A03, 0x02250503, 0x02258003,
   0x0225FB03, 0x02267603, 0x0226F003, 0x02276B03, 0x0227E603, 0x02286103, 0x0228DC03, 0x02295703,
   0x0229D203, 0x022A4D03, 0x022AC903, 0x022B4403, 0x022BBF03, 0x022C3A03, 0x022CB503, 0x022D3103,
   0x022DAC03, 0x022E2703, 0x022EA203, 0x022F1E03, 0x022F9903, 0x02301503, 0x02309003, 0x02310B03,
   0x02318703, 0x02320203, 0x02327E03, 0x0232FA03, 0x02337503, 0x0233F103, 0x02346C03, 0x0234E803,
   0x02356403, 0x0235E003, 0x02365B03, 0x0236D703, 0x02375303, 0x0237CF03, 0x02384B03, 0x0238C603,
   0x02394203, 0x0239BE03, 0x023A3A03, 0x023AB603, 0x023B3203, 0x023BAE03, 0x023C2A03, 0x023CA603,
   0x023D2303, 0x023D9F03, 0x023E1B03, 0x023E9703, 0x023F1303, 0x023F9003, 0x02400C03, 0x02408803,
   0x02410403, 0x02418103, 0x0241FD03, 0x02427A03, 0x0242F603, 0x02437203, 0x0243EF03, 0x02446B03,
   0x0244E803, 0x02456503, 0x0245E103, 0x02465E03, 0x0246DA03, 0x02475703, 0x0247D403, 0x02485003,
   0x0248CD03, 0x02494A03, 0x0249C703, 0x024A4403, 0x024AC003, 0x024B3D03, 0x024BBA03, 0x024C3703,
   0x024CB403, 0x024D3103, 0x024DAE03, 0x024E2B03, 0x024EA803, 0x024F2503, 0x024FA203, 0x02501F03,
   0x02509D03, 0x02511A03, 0x02519703, 0x02521403, 0x02529203, 0x02530F03, 0x02538C03, 0x02540903,
   0x02548703, 0x02550403, 0x02558203, 0x0255FF03, 0x02567D03, 0x0256FA03, 0x02577803, 0x0257F503,
   0x02587303, 0x0258F003, 0x02596E03, 0x0259EC03, 0x025A6903, 0x025AE703, 0x025B6503, 0x025BE203,
   0x025C6003, 0x025CDE03, 0x025D5C03, 0x025DDA03, 0x025E5803, 0x025ED503, 0x025F5303, 0x025FD103,
   0x02604F03, 0x0260CD03, 0x02614B03, 0x0261C903, 0x02624803, 0x0262C603, 0x02634403, 0x0263C203,
   0x02644003, 0x0264BE03, 0x02653D03, 0x0265BB03, 0x02663903, 0x0266B703, 0x02673603, 0x0267B403,
   0x02683203, 0x0268B103, 0x02692F03, 0x0269AE03, 0x026A2C03, 0x026AAB03, 0x026B2903, 0x026BA803,
   0x026C2603, 0x026CA503, 0x026D2403, 0x026DA203, 0x026E2103, 0x026EA003, 0x026F1F03, 0x026F9D03,
   0x02701C03, 0x02709B03, 0x02711A03, 0x02719903, 0x02721803, 0x02729603, 0x02731503, 0x02739403,
   0x02741303, 0x02749203, 0x02751103, 0x02759003, 0x02761003, 0x02768F03, 0x02770E03, 0x02778D03,
   0x02780C03, 0x02788B03, 0x02790B03, 0x02798A03, 0x027A0903, 0x027A8903, 0x027B0803, 0x027B8703,
   0x027C0703, 0x027C8603, 0x027D0503, 0x027D8503, 0x027E0403, 0x027E8403, 0x027F0403, 0x027F8303,
   0x02800303, 0x02808203, 0x02810203, 0x02818203, 0x02820103, 0x02828103, 0x02830103, 0x02838103,
   0x02840003, 0x02848003, 0x02850003, 0x02858003, 0x02860003, 0x02868003, 0x02870003, 0x02878003,
   0x0287FF03, 0x02888003, 0x02890003, 0x02898003, 0x028A0003, 0x028A8003, 0x028B0003, 0x028B8003,
   0x028C0003, 0x028C8003, 0x028D0103, 0x028D8103, 0x028E0103, 0x028E8203, 0x028F0203, 0x028F8203,
   0x02900303, 0x02908303, 0x02910303, 0x02918403, 0x02920403, 0x02928503, 0x02930503, 0x02938603,
   0x02940703, 0x02948703, 0x02950803, 0x02958803, 0x02960903, 0x02968A03, 0x02970B03, 0x02978B03,
   0x02980C03, 0x02988D03, 0x02990E03, 0x02998F03, 0x029A0F03, 0x029A9003, 0x029B1103, 0x029B9203,
   0x029C1303, 0x029C9403, 0x029D1503, 0x029D9603, 0x029E1703, 0x029E9803, 0x029F1903, 0x029F9B03,
   0x02A01C03, 0x02A09D03, 0x02A11E03, 0x02A19F03, 0x02A22103, 0x02A2A203, 0x02A32303, 0x02A3A503,
   0x02A42603, 0x02A4A703, 0x02A52903, 0x02A5AA03, 0x02A62C03, 0x02A6AD03, 0x02A72F03, 0x02A7B003,
   0x02A83203, 0x02A8B303, 0x02A93503, 0x02A9B603, 0x02AA3803, 0x02AABA03, 0x02AB3B03, 0x02ABBD03,
   0x02AC3F03, 0x02ACC103, 0x02AD4203, 0x02ADC403, 0x02AE4603, 0x02AEC803, 0x02AF4A03, 0x02AFCC03,
   0x02B04E03, 0x02B0D003, 0x02B15203, 0x02B1D403, 0x02B25603, 0x02B2D803, 0x02B35A03, 0x02B3DC03,
   0x02B45E03, 0x02B4E003, 0x02B56203, 0x02B5E503, 0x02B66703, 0x02B6E903, 0x02B76B03, 0x02B7EE03,
   0x02B87003, 0x02B8F203, 0x02B97503, 0x02B9F703, 0x02BA7903, 0x02BAFC03, 0x02BB7E03, 0x02BC0103,
   0x02BC8303, 0x02BD0603, 0x02BD8803, 0x02BE0B03, 0x02BE8E03, 0x02BF1003, 0x02BF9303, 0x02C01503,
   0x02C09803, 0x02C11B03, 0x02C19E03, 0x02C22003, 0x02C2A303, 0x02C32603, 0x02C3A903, 0x02C42C03,
   0x02C4AF03, 0x02C53203, 0x02C5B403, 0x02C63703, 0x02C6BA03, 0x02C73D03, 0x02C7C003, 0x02C84303,
   0x02C8C703, 0x02C94A03, 0x02C9CD03, 0x02CA5003, 0x02CAD303, 0x02CB5603, 0x02CBD903, 0x02CC5D03,
   0x02CCE003, 0x02CD6303, 0x02CDE703, 0x02CE6A03, 0x02CEED03, 0x02CF7103, 0x02CFF403, 0x02D07703,
   0x02D0FB03, 0x02D17E03, 0x02D20203, 0x02D28503, 0x02D30903, 0x02D38D03, 0x02D41003, 0x02D49403,
   0x02D51703, 0x02D59B03, 0x02D61F03, 0x02D6A203, 0x02D72603, 0x02D7AA03, 0x02D82E03, 0x02D8B103,
   0x02D93503, 0x02D9B903, 0x02DA3D03, 0x02DAC103, 0x02DB4503, 0x02DBC903, 0x02DC4D03, 0x02DCD103,
   0x02DD5503, 0x02DDD903, 0x02DE5D03, 0x02DEE103, 0x02DF6503, 0x02DFE903, 0x02E06D03, 0x02E0F103,
   0x02E17603, 0x02E1FA03, 0x02E27E03, 0x02E30203, 0x02E38703, 0x02E40B03, 0x02E48F03, 0x02E51403,
   0x02E59803, 0x02E61C03, 0x02E6A103, 0x02E72503, 0x02E7AA03, 0x02E82E03, 0x02E8B303, 0x02E93703,
   0x02E9BC03, 0x02EA4003, 0x02EAC503, 0x02EB4A03, 0x02EBCE03, 0x02EC5303, 0x02ECD803, 0x02ED5C03,
   0x02EDE103, 0x02EE6603, 0x02EEEB03, 0x02EF7003, 0x02EFF403, 0x02F07903, 0x02F0FE03, 0x02F18303,
   0x02F20803, 0x02F28D03, 0x02F31203, 0x02F39703, 0x02F41C03, 0x02F4A103, 0x02F52603, 0x02F5AB03,
   0x02F63003, 0x02F6B503, 0x02F73B03, 0x02F7C003, 0x02F84503, 0x02F8CA03, 0x02F94F03, 0x02F9D503,
   0x02FA5A03, 0x02FADF03, 0x02FB6503, 0x02FBEA03, 0x02FC6F03, 0x02FCF503, 0x02FD7A03, 0x02FE0003,
   0x02FE8503, 0x02FF0B03, 0x02FF9003, 0x03001603, 0x03009B03, 0x03012103, 0x0301A703, 0x03022C03,
   0x0302B203, 0x03033803, 0x0303BD03, 0x03044303, 0x0304C903, 0x03054E03, 0x0305D403, 0x03065A03,
   0x0306E003, 0x03076603, 0x0307EC03, 0x03087203, 0x0308F803, 0x03097D03, 0x030A0303, 0x030A8903,
   0x030B0F03, 0x030B9603, 0x030C1C03, 0x030CA203, 0x030D2803, 0x030DAE03, 0x030E3403, 0x030EBA03,
   0x030F4003, 0x030FC703, 0x03104D03, 0x0310D303, 0x03115903, 0x0311E003, 0x03126603, 0x0312EC03,
   0x03137303, 0x0313F903, 0x03148003, 0x03150603, 0x03158D03, 0x03161303, 0x03169A03, 0x03172003,
   0x0317A703, 0x03182D03, 0x0318B403, 0x03193B03, 0x0319C103, 0x031A4803, 0x031ACF03, 0x031B5503,
   0x031BDC03, 0x031C6303, 0x031CEA03, 0x031D7003, 0x031DF703, 0x031E7E03, 0x031F0503, 0x031F8C03,
   0x03201303, 0x03209A03, 0x03212103, 0x0321A803, 0x03222F03, 0x0322B603, 0x03233D03, 0x0323C403,
   0x03244B03, 0x0324D203, 0x03255903, 0x0325E003, 0x03266703, 0x0326EF03, 0x03277603, 0x0327FD03,
   0x03288403, 0x03290C03, 0x03299303, 0x032A1A03, 0x032AA203, 0x032B2903, 0x032BB003, 0x032C3803,
   0x032CBF03, 0x032D4703, 0x032DCE03, 0x032E5603, 0x032EDD03, 0x032F6503, 0x032FEC03, 0x03307403,
   0x0330FC03, 0x03318303, 0x03320B03, 0x03329303, 0x03331A03, 0x0333A203, 0x03342A03, 0x0334B203,
   0x03353903, 0x0335C103, 0x03364903, 0x0336D103, 0x03375903, 0x0337E103, 0x03386903, 0x0338F103,
   0x03397903, 0x033A0103, 0x033A8903, 0x033B1103, 0x033B9903, 0x033C2103, 0x033CA903, 0x033D3103,
   0x033DB903, 0x033E4103, 0x033ECA03, 0x033F5203, 0x033FDA03, 0x03406203, 0x0340EB03, 0x03417303,
   0x0341FB03, 0x03428403, 0x03430C03, 0x03439403, 0x03441D03, 0x0344A503, 0x03452E03, 0x0345B603,
   0x03463F03, 0x0346C703, 0x03475003, 0x0347D803, 0x03486103, 0x0348E903, 0x03497203, 0x0349FB03,
   0x034A8303, 0x034B0C03, 0x034B9503, 0x034C1D03, 0x034CA603, 0x034D2F03, 0x034DB803, 0x034E4103,
   0x034ECA03, 0x034F5203, 0x034FDB03, 0x03506403, 0x0350ED03, 0x03517603, 0x0351FF03, 0x03528803,
   0x03531103, 0x03539A03, 0x03542303, 0x0354AC03, 0x03553503, 0x0355BE03, 0x03564803, 0x0356D103,
   0x03575A03, 0x0357E303, 0x03586C03, 0x0358F603, 0x03597F03, 0x035A0803, 0x035A9203, 0x035B1B03,
   0x035BA403, 0x035C2E03, 0x035CB703, 0x035D4003, 0x035DCA03, 0x035E5303, 0x035EDD03, 0x035F6603,
   0x035FF003, 0x03607903, 0x03610303, 0x03618D03, 0x03621603, 0x0362A003, 0x03632A03, 0x0363B303,
   0x03643D03, 0x0364C703, 0x03655003, 0x0365DA03, 0x03666403, 0x0366EE03, 0x03677803, 0x03680103,
   0x03688B03, 0x03691503, 0x03699F03, 0x036A2903, 0x036AB303, 0x036B3D03, 0x036BC703, 0x036C5103,
   0x036CDB03, 0x036D6503, 0x036DEF03, 0x036E7903, 0x036F0303, 0x036F8E03, 0x03701803, 0x0370A203,
   0x03712C03, 0x0371B603, 0x03724103, 0x0372CB03, 0x03735503, 0x0373E003, 0x03746A03, 0x0374F403,
   0x03757F03, 0x03760903, 0x03769303, 0x03771E03, 0x0377A803, 0x03783303, 0x0378BD03, 0x03794803,
   0x0379D203, 0x037A5D03, 0x037AE803, 0x037B7203, 0x037BFD03, 0x037C8703, 0x037D1203, 0x037D9D03,
   0x037E2803, 0x037EB203, 0x037F3D03, 0x037FC803, 0x03805303, 0x0380DE03, 0x03816803, 0x0381F303,
   0x03827E03, 0x03830903, 0x03839403, 0x03841F03, 0x0384AA03, 0x03853503, 0x0385C003, 0x03864B03,
   0x0386D603, 0x03876103, 0x0387EC03, 0x03887703, 0x03890203, 0x03898E03, 0x038A1903, 0x038AA403,
   0x038B2F03, 0x038BBA03, 0x038C4603, 0x038CD103, 0x038D5C03, 0x038DE803, 0x038E7303, 0x038EFE03,
   0x038F8A03, 0x03901503, 0x0390A103, 0x03912C03, 0x0391B703, 0x03924303, 0x0392CE03, 0x03935A03,
   0x0393E603, 0x03947103, 0x0394FD03, 0x03958803, 0x03961403, 0x0396A003, 0x03972B03, 0x0397B703,
   0x03984303, 0x0398CE03, 0x03995A03, 0x0399E603, 0x039A7203, 0x039AFE03, 0x039B8903, 0x039C1503,
   0x039CA103, 0x039D2D03, 0x039DB903, 0x039E4503, 0x039ED103, 0x039F5D03, 0x039FE903, 0x03A07503,
   0x03A10103, 0x03A18D03, 0x03A21903, 0x03A2A503, 0x03A33103, 0x03A3BE03, 0x03A44A03, 0x03A4D603,
   0x03A56203, 0x03A5EE03, 0x03A67B03, 0x03A70703, 0x03A79303, 0x03A82003, 0x03A8AC03, 0x03A93803,
   0x03A9C503, 0x03AA5103, 0x03AADE03, 0x03AB6A03, 0x03ABF603, 0x03AC8303, 0x03AD0F03, 0x03AD9C03,
   0x03AE2803, 0x03AEB503, 0x03AF4203, 0x03AFCE03, 0x03B05B03, 0x03B0E803, 0x03B17403, 0x03B20103,
   0x03B28E03, 0x03B31A03, 0x03B3A703, 0x03B43403, 0x03B4C103, 0x03B54D03, 0x03B5DA03, 0x03B66703,
   0x03B6F403, 0x03B78103, 0x03B80E03, 0x03B89B03, 0x03B92803, 0x03B9B503, 0x03BA4203, 0x03BACF03,
   0x03BB5C03, 0x03BBE903, 0x03BC7603, 0x03BD0303, 0x03BD9003, 0x03BE1D03, 0x03BEAA03, 0x03BF3803,
   0x03BFC503, 0x03C05203, 0x03C0DF03, 0x03C16C03, 0x03C1FA03, 0x03C28703, 0x03C31403, 0x03C3A203,
   0x03C42F03, 0x03C4BC03, 0x03C54A03, 0x03C5D703, 0x03C66503, 0x03C6F203, 0x03C78003, 0x03C80D03,
   0x03C89B03, 0x03C92803, 0x03C9B603, 0x03CA4303, 0x03CAD103, 0x03CB5F03, 0x03CBEC03, 0x03CC7A03,
   0x03CD0803, 0x03CD9503, 0x03CE2303, 0x03CEB103, 0x03CF3E03, 0x03CFCC03, 0x03D05A03, 0x03D0E803,
   0x03D17603, 0x03D20403, 0x03D29103, 0x03D31F03, 0x03D3AD03, 0x03D43B03, 0x03D4C903, 0x03D55703,
   0x03D5E503, 0x03D67303, 0x03D70103, 0x03D78F03, 0x03D81D03, 0x03D8AC03, 0x03D93A03, 0x03D9C803,
   0x03DA5603, 0x03DAE403, 0x03DB7203, 0x03DC0103, 0x03DC8F03, 0x03DD1D03, 0x03DDAB03, 0x03DE3A03,
   0x03DEC803, 0x03DF5603, 0x03DFE503, 0x03E07303, 0x03E10103, 0x03E19003, 0x03E21E03, 0x03E2AD03,
   0x03E33B03, 0x03E3CA03, 0x03E45803, 0x03E4E703, 0x03E57503, 0x03E60403, 0x03E69303, 0x03E72103,
   0x03E7B003, 0x03E83F03, 0x03E8CD03, 0x03E95C03, 0x03E9EB03, 0x03EA7903, 0x03EB0803, 0x03EB9703,
   0x03EC2603, 0x03ECB503, 0x03ED4303, 0x03EDD203, 0x03EE6103, 0x03EEF003, 0x03EF7F03, 0x03F00E03,
   0x03F09D03, 0x03F12C03, 0x03F1BB03, 0x03F24A03, 0x03F2D903, 0x03F36803, 0x03F3F703, 0x03F48603,
   0x03F51503, 0x03F5A403, 0x03F63403, 0x03F6C303, 0x03F75203, 0x03F7E103, 0x03F87003, 0x03F90003,
   0x03F98F03, 0x03FA1E03, 0x03FAAE03, 0x03FB3D03, 0x03FBCC03, 0x03FC5C03, 0x03FCEB03, 0x03FD7A03,
   0x03FE0A03, 0x03FE9903, 0x03FF2903, 0x03FFB803, 0x02002402, 0x02006B02, 0x0200B302, 0x0200FB02,
   0x02014302, 0x02018B02, 0x0201D202, 0x02021A02, 0x02026202, 0x0202AA02, 0x0202F202, 0x02033A02,
   0x02038102, 0x0203C902, 0x02041102, 0x02045902, 0x0204A102, 0x0204E902, 0x02053102, 0x02057902,
   0x0205C102, 0x02060902, 0x02065102, 0x02069902, 0x0206E102, 0x02072902, 0x02077102, 0x0207B902,
   0x02080102, 0x02084902, 0x02089102, 0x0208D902, 0x02092102, 0x02096902, 0x0209B102, 0x0209F902,
   0x020A4102, 0x020A8A02, 0x020AD202, 0x020B1A02, 0x020B6202, 0x020BAA02, 0x020BF202, 0x020C3A02,
   0x020C8302, 0x020CCB02, 0x020D1302, 0x020D5B02, 0x020DA302, 0x020DEC02, 0x020E3402, 0x020E7C02,
   0x020EC402, 0x020F0D02, 0x020F5502, 0x020F9D02, 0x020FE602, 0x02102E02, 0x02107602, 0x0210BF02,
   0x02110702, 0x02114F02, 0x02119802, 0x0211E002, 0x02122802, 0x02127102, 0x0212B902, 0x02130202,
   0x02134A02, 0x02139202, 0x0213DB02, 0x02142302, 0x02146C02, 0x0214B402, 0x0214FD02, 0x02154502,
   0x02158E02, 0x0215D602, 0x02161F02, 0x02166702, 0x0216B002, 0x0216F802, 0x02174102, 0x02178902,
   0x0217D202, 0x02181B02, 0x02186302, 0x0218AC02, 0x0218F402, 0x02193D02, 0x02198602, 0x0219CE02,
   0x021A1702, 0x021A6002, 0x021AA802, 0x021AF102, 0x021B3A02, 0x021B8202, 0x021BCB02, 0x021C1402,
   0x021C5C02, 0x021CA502, 0x021CEE02, 0x021D3702, 0x021D7F02, 0x021DC802, 0x021E1102, 0x021E5A02,
   0x021EA302, 0x021EEB02, 0x021F3402, 0x021F7D02, 0x021FC602, 0x02200F02, 0x02205802, 0x0220A002,
   0x0220E902, 0x02213202, 0x02217B02, 0x0221C402, 0x02220D02, 0x02225602, 0x02229F02, 0x0222E802,
   0x02233102, 0x02237A02, 0x0223C302, 0x02240C02, 0x02245502, 0x02249E02, 0x0224E702, 0x02253002,
   0x02257902, 0x0225C202, 0x02260B02, 0x02265402, 0x02269D02, 0x0226E602, 0x02272F02, 0x02277802,
   0x0227C102, 0x02280A02, 0x02285402, 0x02289D02, 0x0228E602, 0x02292F02, 0x02297802, 0x0229C102,
   0x022A0A02, 0x022A5402, 0x022A9D02, 0x022AE602, 0x022B2F02, 0x022B7902, 0x022BC202, 0x022C0B02,
   0x022C5402, 0x022C9E02, 0x022CE702, 0x022D3002, 0x022D7902, 0x022DC302, 0x022E0C02, 0x022E5502,
   0x022E9F02, 0x022EE802, 0x022F3102, 0x022F7B02, 0x022FC402, 0x02300D02, 0x02305702, 0x0230A002,
   0x0230EA02, 0x02313302, 0x02317D02, 0x0231C602, 0x02320F02, 0x02325902, 0x0232A202, 0x0232EC02,
   0x02333502, 0x02337F02, 0x0233C802, 0x02341202, 0x02345B02, 0x0234A502, 0x0234EE02, 0x02353802,
   0x02358102, 0x0235CB02, 0x02361502, 0x02365E02, 0x0236A802, 0x0236F102, 0x02373B02, 0x02378502,
   0x0237CE02, 0x02381802, 0x02386202, 0x0238AB02, 0x0238F502, 0x02393F02, 0x02398802, 0x0239D202,
   0x023A1C02, 0x023A6502, 0x023AAF02, 0x023AF902, 0x023B4302, 0x023B8C02, 0x023BD602, 0x023C2002,
   0x023C6A02, 0x023CB302, 0x023CFD02, 0x023D4702, 0x023D9102, 0x023DDB02, 0x023E2502, 0x023E6E02,
   0x023EB802, 0x023F0202, 0x023F4C02, 0x023F9602, 0x023FE002, 0x02402A02, 0x02407402, 0x0240BD02,
   0x02410702, 0x02415102, 0x02419B02, 0x0241E502, 0x02422F02, 0x02427902, 0x0242C302, 0x02430D02,
   0x02435702, 0x0243A102, 0x0243EB02, 0x02443502, 0x02447F02, 0x0244C902, 0x02451302, 0x02455D02,
   0x0245A802, 0x0245F202, 0x02463C02, 0x02468602, 0x0246D002, 0x02471A02, 0x02476402, 0x0247AE02,
   0x0247F802, 0x02484302, 0x02488D02, 0x0248D702, 0x02492102, 0x02496B02, 0x0249B602, 0x024A0002,
   0x024A4A02, 0x024A9402, 0x024ADE02, 0x024B2902, 0x024B7302, 0x024BBD02, 0x024C0802, 0x024C5202,
   0x024C9C02, 0x024CE602, 0x024D3102, 0x024D7B02, 0x024DC502, 0x024E1002, 0x024E5A02, 0x024EA402,
   0x024EEF02, 0x024F3902, 0x024F8402, 0x024FCE02, 0x02501802, 0x02506302, 0x0250AD02, 0x0250F802,
   0x02514202, 0x02518D02, 0x0251D702, 0x02522202, 0x02526C02, 0x0252B602, 0x02530102, 0x02534B02,
   0x02539602, 0x0253E102, 0x02542B02, 0x02547602, 0x0254C002, 0x02550B02, 0x02555502, 0x0255A002,
   0x0255EA02, 0x02563502, 0x02568002, 0x0256CA02, 0x02571502, 0x02576002, 0x0257AA02, 0x0257F502,
   0x02583F02, 0x02588A02, 0x0258D502, 0x02592002, 0x02596A02, 0x0259B502, 0x025A0002, 0x025A4A02,
   0x025A9502, 0x025AE002, 0x025B2B02, 0x025B7502, 0x025BC002, 0x025C0B02, 0x025C5602, 0x025CA102,
   0x025CEB02, 0x025D3602, 0x025D8102, 0x025DCC02, 0x025E1702, 0x025E6102, 0x025EAC02, 0x025EF702,
   0x025F4202, 0x025F8D02, 0x025FD802, 0x02602302, 0x02606E02, 0x0260B902, 0x02610402, 0x02614F02,
   0x02619902, 0x0261E402, 0x02622F02, 0x02627A02, 0x0262C502, 0x02631002, 0x02635B02, 0x0263A602,
   0x0263F102, 0x02643C02, 0x02648702, 0x0264D302, 0x02651E02, 0x02656902, 0x0265B402, 0x0265FF02,
   0x02664A02, 0x02669502, 0x0266E002, 0x02672B02, 0x02677602, 0x0267C202, 0x02680D02, 0x02685802,
   0x0268A302, 0x0268EE02, 0x02693902, 0x02698502, 0x0269D002, 0x026A1B02, 0x026A6602, 0x026AB102,
   0x026AFD02, 0x026B4802, 0x026B9302, 0x026BDE02, 0x026C2A02, 0x026C7502, 0x026CC002, 0x026D0C02,
   0x026D5702, 0x026DA202, 0x026DEE02, 0x026E3902, 0x026E8402, 0x026ED002, 0x026F1B02, 0x026F6602,
   0x026FB202, 0x026FFD02, 0x02704802, 0x02709402, 0x0270DF02, 0x02712B02, 0x02717602, 0x0271C202,
   0x02720D02, 0x02725902, 0x0272A402, 0x0272EF02, 0x02733B02, 0x02738602, 0x0273D202, 0x02741D02,
   0x02746902, 0x0274B502, 0x02750002, 0x02754C02, 0x02759702, 0x0275E302, 0x02762E02, 0x02767A02,
   0x0276C502, 0x02771102, 0x02775D02, 0x0277A802, 0x0277F402, 0x02784002, 0x02788B02, 0x0278D702,
   0x02792302, 0x02796E02, 0x0279BA02, 0x027A0602, 0x027A5102, 0x027A9D02, 0x027AE902, 0x027B3402,
   0x027B8002, 0x027BCC02, 0x027C1802, 0x027C6302, 0x027CAF02, 0x027CFB02, 0x027D4702, 0x027D9302,
   0x027DDE02, 0x027E2A02, 0x027E7602, 0x027EC202, 0x027F0E02, 0x027F5A02, 0x027FA502, 0x027FF102,
   0x02803D02, 0x02808902, 0x0280D502, 0x02812102, 0x02816D02, 0x0281B902, 0x02820502, 0x02825102,
   0x02829C02, 0x0282E802, 0x02833402, 0x02838002, 0x0283CC02, 0x02841802, 0x02846402, 0x0284B002,
   0x0284FC02, 0x02854802, 0x02859402, 0x0285E002, 0x02862D02, 0x02867902, 0x0286C502, 0x02871102,
   0x02875D02, 0x0287A902, 0x0287F502, 0x02884102, 0x02888D02, 0x0288D902, 0x02892502, 0x02897202,
   0x0289BE02, 0x028A0A02, 0x028A5602, 0x028AA202, 0x028AEF02, 0x028B3B02, 0x028B8702, 0x028BD302,
   0x028C1F02, 0x028C6C02, 0x028CB802, 0x028D0402, 0x028D5002, 0x028D9D02, 0x028DE902, 0x028E3502,
   0x028E8102, 0x028ECE02, 0x028F1A02, 0x028F6602, 0x028FB302, 0x028FFF02, 0x02904B02, 0x02909802,
   0x0290E402, 0x02913102, 0x02917D02, 0x0291C902, 0x02921602, 0x02926202, 0x0292AF02, 0x0292FB02,
   0x02934702, 0x02939402, 0x0293E002, 0x02942D02, 0x02947902, 0x0294C602, 0x02951202, 0x02955F02,
   0x0295AB02, 0x0295F802, 0x02964402, 0x02969102, 0x0296DD02, 0x02972A02, 0x02977602, 0x0297C302,
   0x02981002, 0x02985C02, 0x0298A902, 0x0298F502, 0x02994202, 0x02998E02, 0x0299DB02, 0x029A2802,
   0x029A7402, 0x029AC102, 0x029B0E02, 0x029B5A02, 0x029BA702, 0x029BF402, 0x029C4002, 0x029C8D02,
   0x029CDA02, 0x029D2702, 0x029D7302, 0x029DC002, 0x029E0D02, 0x029E5A02, 0x029EA602, 0x029EF302,
   0x029F4002, 0x029F8D02, 0x029FD902, 0x02A02602, 0x02A07302, 0x02A0C002, 0x02A10D02, 0x02A15A02,
   0x02A1A602, 0x02A1F302, 0x02A24002, 0x02A28D02, 0x02A2DA02, 0x02A32702, 0x02A37402, 0x02A3C102,
   0x02A40D02, 0x02A45A02, 0x02A4A702, 0x02A4F402, 0x02A54102, 0x02A58E02, 0x02A5DB02, 0x02A62802,
   0x02A67502, 0x02A6C202, 0x02A70F02, 0x02A75C02, 0x02A7A902, 0x02A7F602, 0x02A84302, 0x02A89002,
   0x02A8DD02, 0x02A92A02, 0x02A97702, 0x02A9C402, 0x02AA1202, 0x02AA5F02, 0x02AAAC02, 0x02AAF902,
   0x02AB4602, 0x02AB9302, 0x02ABE002, 0x02AC2D02, 0x02AC7B02, 0x02ACC802, 0x02AD1502, 0x02AD6202,
   0x02ADAF02, 0x02ADFC02, 0x02AE4A02, 0x02AE9702, 0x02AEE402, 0x02AF3102, 0x02AF7F02, 0x02AFCC02,
   0x02B01902, 0x02B06602, 0x02B0B402, 0x02B10102, 0x02B14E02, 0x02B19B02, 0x02B1E902, 0x02B23602,
   0x02B28302, 0x02B2D102, 0x02B31E02, 0x02B36B02, 0x02B3B902, 0x02B40602, 0x02B45402, 0x02B4A102,
   0x02B4EE02, 0x02B53C02, 0x02B58902, 0x02B5D702, 0x02B62402, 0x02B67102, 0x02B6BF02, 0x02B70C02,
   0x02B75A02, 0x02B7A702, 0x02B7F502, 0x02B84202, 0x02B89002, 0x02B8DD02, 0x02B92B02, 0x02B97802,
   0x02B9C602, 0x02BA1302, 0x02BA6102, 0x02BAAE02, 0x02BAFC02, 0x02BB4902, 0x02BB9702, 0x02BBE502,
   0x02BC3202, 0x02BC8002, 0x02BCCD02, 0x02BD1B02, 0x02BD6902, 0x02BDB602, 0x02BE0402, 0x02BE5202,
   0x02BE9F02, 0x02BEED02, 0x02BF3B02, 0x02BF8802, 0x02BFD602, 0x02C02402, 0x02C07102, 0x02C0BF02,
   0x02C10D02, 0x02C15B02, 0x02C1A802, 0x02C1F602, 0x02C24402, 0x02C29202, 0x02C2DF02, 0x02C32D02,
   0x02C37B02, 0x02C3C902, 0x02C41702, 0x02C46402, 0x02C4B202, 0x02C50002, 0x02C54E02, 0x02C59C02,
   0x02C5EA02, 0x02C63802, 0x02C68502, 0x02C6D302, 0x02C72102, 0x02C76F02, 0x02C7BD02, 0x02C80B02,
   0x02C85902, 0x02C8A702, 0x02C8F502, 0x02C94302, 0x02C99102, 0x02C9DF02, 0x02CA2D02, 0x02CA7B02,
   0x02CAC902, 0x02CB1702, 0x02CB6502, 0x02CBB302, 0x02CC0102, 0x02CC4F02, 0x02CC9D02, 0x02CCEB02,
   0x02CD3902, 0x02CD8702, 0x02CDD502, 0x02CE2302, 0x02CE7102, 0x02CEBF02, 0x02CF0D02, 0x02CF5B02,
   0x02CFAA02, 0x02CFF802, 0x02D04602, 0x02D09402, 0x02D0E202, 0x02D13002, 0x02D17F02, 0x02D1CD02,
   0x02D21B02, 0x02D26902, 0x02D2B702, 0x02D30602, 0x02D35402, 0x02D3A202, 0x02D3F002, 0x02D43F02,
   0x02D48D02, 0x02D4DB02, 0x02D52902, 0x02D57802, 0x02D5C602, 0x02D61402, 0x02D66302, 0x02D6B102,
   0x02D6FF02, 0x02D74D02, 0x02D79C02, 0x02D7EA02, 0x02D83902, 0x02D88702, 0x02D8D502, 0x02D92402,
   0x02D97202, 0x02D9C002, 0x02DA0F02, 0x02DA5D02, 0x02DAAC02, 0x02DAFA02, 0x02DB4902, 0x02DB9702,
   0x02DBE502, 0x02DC3402, 0x02DC8202, 0x02DCD102, 0x02DD1F02, 0x02DD6E02, 0x02DDBC02, 0x02DE0B02,
   0x02DE5902, 0x02DEA802, 0x02DEF702, 0x02DF4502, 0x02DF9402, 0x02DFE202, 0x02E03102, 0x02E07F02,
   0x02E0CE02, 0x02E11D02, 0x02E16B02, 0x02E1BA02, 0x02E20802, 0x02E25702, 0x02E2A602, 0x02E2F402,
   0x02E34302, 0x02E39202, 0x02E3E002, 0x02E42F02, 0x02E47E02, 0x02E4CC02, 0x02E51B02, 0x02E56A02,
   0x02E5B802, 0x02E60702, 0x02E65602, 0x02E6A502, 0x02E6F302, 0x02E74202, 0x02E79102, 0x02E7E002,
   0x02E82E02, 0x02E87D02, 0x02E8CC02, 0x02E91B02, 0x02E96A02, 0x02E9B902, 0x02EA0702, 0x02EA5602,
   0x02EAA502, 0x02EAF402, 0x02EB4302, 0x02EB9202, 0x02EBE102, 0x02EC2F02, 0x02EC7E02, 0x02ECCD02,
   0x02ED1C02, 0x02ED6B02, 0x02EDBA02, 0x02EE0902, 0x02EE5802, 0x02EEA702, 0x02EEF602, 0x02EF4502,
   0x02EF9402, 0x02EFE302, 0x02F03202, 0x02F08102, 0x02F0D002, 0x02F11F02, 0x02F16E02, 0x02F1BD02,
   0x02F20C02, 0x02F25B02, 0x02F2AA02, 0x02F2F902, 0x02F34802, 0x02F39702, 0x02F3E602, 0x02F43502,
   0x02F48502, 0x02F4D402, 0x02F52302, 0x02F57202, 0x02F5C102, 0x02F61002, 0x02F65F02, 0x02F6AF02,
   0x02F6FE02, 0x02F74D02, 0x02F79C02, 0x02F7EB02, 0x02F83A02, 0x02F88A02, 0x02F8D902, 0x02F92802,
   0x02F97702, 0x02F9C702, 0x02FA1602, 0x02FA6502, 0x02FAB402, 0x02FB0402, 0x02FB5302, 0x02FBA202,
   0x02FBF202, 0x02FC4102, 0x02FC9002, 0x02FCE002, 0x02FD2F02, 0x02FD7E02, 0x02FDCE02, 0x02FE1D02,
   0x02FE6C02, 0x02FEBC02, 0x02FF0B02, 0x02FF5A02, 0x02FFAA02, 0x02FFF902, 0x03004902, 0x03009802,
   0x0300E802, 0x03013702, 0x03018602, 0x0301D602, 0x03022502, 0x03027502, 0x0302C402, 0x03031402,
   0x03036302, 0x0303B302, 0x03040202, 0x03045202, 0x0304A102, 0x0304F102, 0x03054002, 0x03059002,
   0x0305DF02, 0x03062F02, 0x03067F02, 0x0306CE02, 0x03071E02, 0x03076D02, 0x0307BD02, 0x03080D02,
   0x03085C02, 0x0308AC02, 0x0308FC02, 0x03094B02, 0x03099B02, 0x0309EA02, 0x030A3A02, 0x030A8A02,
   0x030ADA02, 0x030B2902, 0x030B7902, 0x030BC902, 0x030C1802, 0x030C6802, 0x030CB802, 0x030D0802,
   0x030D5702, 0x030DA702, 0x030DF702, 0x030E4702, 0x030E9602, 0x030EE602, 0x030F3602, 0x030F8602,
   0x030FD602, 0x03102502, 0x03107502, 0x0310C502, 0x03111502, 0x03116502, 0x0311B502, 0x03120502,
   0x03125402, 0x0312A402, 0x0312F402, 0x03134402, 0x03139402, 0x0313E402, 0x03143402, 0x03148402,
   0x0314D402, 0x03152402, 0x03157402, 0x0315C402, 0x03161402, 0x03166402, 0x0316B402, 0x03170302,
   0x03175402, 0x0317A402, 0x0317F402, 0x03184402, 0x03189402, 0x0318E402, 0x03193402, 0x03198402,
   0x0319D402, 0x031A2402, 0x031A7402, 0x031AC402, 0x031B1402, 0x031B6402, 0x031BB402, 0x031C0502,
   0x031C5502, 0x031CA502, 0x031CF502, 0x031D4502, 0x031D9502, 0x031DE502, 0x031E3602, 0x031E8602,
   0x031ED602, 0x031F2602, 0x031F7602, 0x031FC702, 0x03201702, 0x03206702, 0x0320B702, 0x03210802,
   0x03215802, 0x0321A802, 0x0321F802, 0x03224902, 0x03229902, 0x0322E902, 0x03233902, 0x03238A02,
   0x0323DA02, 0x03242A02, 0x03247B02, 0x0324CB02, 0x03251B02, 0x03256C02, 0x0325BC02, 0x03260D02,
   0x03265D02, 0x0326AD02, 0x0326FE02, 0x03274E02, 0x03279F02, 0x0327EF02, 0x03283F02, 0x03289002,
   0x0328E002, 0x03293102, 0x03298102, 0x0329D202, 0x032A2202, 0x032A7302, 0x032AC302, 0x032B1402,
   0x032B6402, 0x032BB502, 0x032C0502, 0x032C5602, 0x032CA602, 0x032CF702, 0x032D4702, 0x032D9802,
   0x032DE802, 0x032E3902, 0x032E8A02, 0x032EDA02, 0x032F2B02, 0x032F7B02, 0x032FCC02, 0x03301D02,
   0x03306D02, 0x0330BE02, 0x03310F02, 0x03315F02, 0x0331B002, 0x03320102, 0x03325102, 0x0332A202,
   0x0332F302, 0x03334302, 0x03339402, 0x0333E502, 0x03343502, 0x03348602, 0x0334D702, 0x03352802,
   0x03357802, 0x0335C902, 0x03361A02, 0x03366B02, 0x0336BC02, 0x03370C02, 0x03375D02, 0x0337AE02,
   0x0337FF02, 0x03385002, 0x0338A002, 0x0338F102, 0x03394202, 0x03399302, 0x0339E402, 0x033A3502,
   0x033A8602, 0x033AD602, 0x033B2702, 0x033B7802, 0x033BC902, 0x033C1A02, 0x033C6B02, 0x033CBC02,
   0x033D0D02, 0x033D5E02, 0x033DAF02, 0x033E0002, 0x033E5102, 0x033EA202, 0x033EF302, 0x033F4402,
   0x033F9502, 0x033FE602, 0x03403702, 0x03408802, 0x0340D902, 0x03412A02, 0x03417B02, 0x0341CC02,
   0x03421D02, 0x03426E02, 0x0342BF02, 0x03431002, 0x03436102, 0x0343B202, 0x03440402, 0x03445502,
   0x0344A602, 0x0344F702, 0x03454802, 0x03459902, 0x0345EA02, 0x03463C02, 0x03468D02, 0x0346DE02,
   0x03472F02, 0x03478002, 0x0347D102, 0x03482302, 0x03487402, 0x0348C502, 0x03491602, 0x03496802,
   0x0349B902, 0x034A0A02, 0x034A5B02, 0x034AAD02, 0x034AFE02, 0x034B4F02, 0x034BA002, 0x034BF202,
   0x034C4302, 0x034C9402, 0x034CE602, 0x034D3702, 0x034D8802, 0x034DDA02, 0x034E2B02, 0x034E7C02,
   0x034ECE02, 0x034F1F02, 0x034F7102, 0x034FC202, 0x03501302, 0x03506502, 0x0350B602, 0x03510802,
   0x03515902, 0x0351AB02, 0x0351FC02, 0x03524D02, 0x03529F02, 0x0352F002, 0x03534202, 0x03539302,
   0x0353E502, 0x03543602, 0x03548802, 0x0354D902, 0x03552B02, 0x03557C02, 0x0355CE02, 0x03561F02,
   0x03567102, 0x0356C302, 0x03571402, 0x03576602, 0x0357B702, 0x03580902, 0x03585B02, 0x0358AC02,
   0x0358FE02, 0x03594F02, 0x0359A102, 0x0359F302, 0x035A4402, 0x035A9602, 0x035AE802, 0x035B3902,
   0x035B8B02, 0x035BDD02, 0x035C2E02, 0x035C8002, 0x035CD202, 0x035D2302, 0x035D7502, 0x035DC702,
   0x035E1902, 0x035E6A02, 0x035EBC02, 0x035F0E02, 0x035F6002, 0x035FB102, 0x03600302, 0x03605502,
   0x0360A702, 0x0360F902, 0x03614A02, 0x03619C02, 0x0361EE02, 0x03624002, 0x03629202, 0x0362E402,
   0x03633502, 0x03638702, 0x0363D902, 0x03642B02, 0x03647D02, 0x0364CF02, 0x03652102, 0x03657302,
   0x0365C502, 0x03661602, 0x03666802, 0x0366BA02, 0x03670C02, 0x03675E02, 0x0367B002, 0x03680202,
   0x03685402, 0x0368A602, 0x0368F802, 0x03694A02, 0x03699C02, 0x0369EE02, 0x036A4002, 0x036A9202,
   0x036AE402, 0x036B3602, 0x036B8802, 0x036BDA02, 0x036C2C02, 0x036C7F02, 0x036CD102, 0x036D2302,
   0x036D7502, 0x036DC702, 0x036E1902, 0x036E6B02, 0x036EBD02, 0x036F0F02, 0x036F6202, 0x036FB402,
   0x03700602, 0x03705802, 0x0370AA02, 0x0370FC02, 0x03714F02, 0x0371A102, 0x0371F302, 0x03724502,
   0x03729702, 0x0372EA02, 0x03733C02, 0x03738E02, 0x0373E002, 0x03743302, 0x03748502, 0x0374D702,
   0x03752902, 0x03757C02, 0x0375CE02, 0x03762002, 0x03767302, 0x0376C502, 0x03771702, 0x03776A02,
   0x0377BC02, 0x03780E02, 0x03786102, 0x0378B302, 0x03790502, 0x03795802, 0x0379AA02, 0x0379FC02,
   0x037A4F02, 0x037AA102, 0x037AF402, 0x037B4602, 0x037B9902, 0x037BEB02, 0x037C3D02, 0x037C9002,
   0x037CE202, 0x037D3502, 0x037D8702, 0x037DDA02, 0x037E2C02, 0x037E7F02, 0x037ED102, 0x037F2402,
   0x037F7602, 0x037FC902, 0x03801B02, 0x03806E02, 0x0380C002, 0x03811302, 0x03816502, 0x0381B802,
   0x03820B02, 0x03825D02, 0x0382B002, 0x03830202, 0x03835502, 0x0383A802, 0x0383FA02, 0x03844D02,
   0x03849F02, 0x0384F202, 0x03854502, 0x03859702, 0x0385EA02, 0x03863D02, 0x03868F02, 0x0386E202,
   0x03873502, 0x03878802, 0x0387DA02, 0x03882D02, 0x03888002, 0x0388D202, 0x03892502, 0x03897802,
   0x0389CB02, 0x038A1D02, 0x038A7002, 0x038AC302, 0x038B1602, 0x038B6902, 0x038BBB02, 0x038C0E02,
   0x038C6102, 0x038CB402, 0x038D0702, 0x038D5902, 0x038DAC02, 0x038DFF02, 0x038E5202, 0x038EA502,
   0x038EF802, 0x038F4B02, 0x038F9D02, 0x038FF002, 0x03904302, 0x03909602, 0x0390E902, 0x03913C02,
   0x03918F02, 0x0391E202, 0x03923502, 0x03928802, 0x0392DB02, 0x03932E02, 0x03938102, 0x0393D402,
   0x03942702, 0x03947A02, 0x0394CD02, 0x03952002, 0x03957302, 0x0395C602, 0x03961902, 0x03966C02,
   0x0396BF02, 0x03971202, 0x03976502, 0x0397B802, 0x03980B02, 0x03985E02, 0x0398B102, 0x03990402,
   0x03995702, 0x0399AB02, 0x0399FE02, 0x039A5102, 0x039AA402, 0x039AF702, 0x039B4A02, 0x039B9D02,
   0x039BF102, 0x039C4402, 0x039C9702, 0x039CEA02, 0x039D3D02, 0x039D9002, 0x039DE402, 0x039E3702,
   0x039E8A02, 0x039EDD02, 0x039F3102, 0x039F8402, 0x039FD702, 0x03A02A02, 0x03A07E02, 0x03A0D102,
   0x03A12402, 0x03A17702, 0x03A1CB02, 0x03A21E02, 0x03A27102, 0x03A2C502, 0x03A31802, 0x03A36B02,
   0x03A3BF02, 0x03A41202, 0x03A46502, 0x03A4B902, 0x03A50C02, 0x03A55F02, 0x03A5B302, 0x03A60602,
   0x03A65A02, 0x03A6AD02, 0x03A70002, 0x03A75402, 0x03A7A702, 0x03A7FB02, 0x03A84E02, 0x03A8A202,
   0x03A8F502, 0x03A94902, 0x03A99C02, 0x03A9EF02, 0x03AA4302, 0x03AA9602, 0x03AAEA02, 0x03AB3D02,
   0x03AB9102, 0x03ABE402, 0x03AC3802, 0x03AC8C02, 0x03ACDF02, 0x03AD3302, 0x03AD8602, 0x03ADDA02,
   0x03AE2D02, 0x03AE8102, 0x03AED502, 0x03AF2802, 0x03AF7C02, 0x03AFCF02, 0x03B02302, 0x03B07702,
   0x03B0CA02, 0x03B11E02, 0x03B17102, 0x03B1C502, 0x03B21902, 0x03B26C02, 0x03B2C002, 0x03B31402,
   0x03B36702, 0x03B3BB02, 0x03B40F02, 0x03B46302, 0x03B4B602, 0x03B50A02, 0x03B55E02, 0x03B5B102,
   0x03B60502, 0x03B65902, 0x03B6AD02, 0x03B70102, 0x03B75402, 0x03B7A802, 0x03B7FC02, 0x03B85002,
   0x03B8A302, 0x03B8F702, 0x03B94B02, 0x03B99F02, 0x03B9F302, 0x03BA4702, 0x03BA9A02, 0x03BAEE02,
   0x03BB4202, 0x03BB9602, 0x03BBEA02, 0x03BC3E02, 0x03BC9202, 0x03BCE602, 0x03BD3902, 0x03BD8D02,
   0x03BDE102, 0x03BE3502, 0x03BE8902, 0x03BEDD02, 0x03BF3102, 0x03BF8502, 0x03BFD902, 0x03C02D02,
   0x03C08102, 0x03C0D502, 0x03C12902, 0x03C17D02, 0x03C1D102, 0x03C22502, 0x03C27902, 0x03C2CD02,
   0x03C32102, 0x03C37502, 0x03C3C902, 0x03C41D02, 0x03C47102, 0x03C4C502, 0x03C51902, 0x03C56D02,
   0x03C5C102, 0x03C61602, 0x03C66A02, 0x03C6BE02, 0x03C71202, 0x03C76602, 0x03C7BA02, 0x03C80E02,
   0x03C86202, 0x03C8B702, 0x03C90B02, 0x03C95F02, 0x03C9B302, 0x03CA0702, 0x03CA5B02, 0x03CAB002,
   0x03CB0402, 0x03CB5802, 0x03CBAC02, 0x03CC0002, 0x03CC5502, 0x03CCA902, 0x03CCFD02, 0x03CD5102,
   0x03CDA602, 0x03CDFA02, 0x03CE4E02, 0x03CEA302, 0x03CEF702, 0x03CF4B02, 0x03CF9F02, 0x03CFF402,
   0x03D04802, 0x03D09C02, 0x03D0F102, 0x03D14502, 0x03D19902, 0x03D1EE02, 0x03D24202, 0x03D29602,
   0x03D2EB02, 0x03D33F02, 0x03D39402, 0x03D3E802, 0x03D43C02, 0x03D49102, 0x03D4E502, 0x03D53A02,
   0x03D58E02, 0x03D5E302, 0x03D63702, 0x03D68B02, 0x03D6E002, 0x03D73402, 0x03D78902, 0x03D7DD02,
   0x03D83202, 0x03D88602, 0x03D8DB02, 0x03D92F02, 0x03D98402, 0x03D9D802, 0x03DA2D02, 0x03DA8102,
   0x03DAD602, 0x03DB2B02, 0x03DB7F02, 0x03DBD402, 0x03DC2802, 0x03DC7D02, 0x03DCD102, 0x03DD2602,
   0x03DD7B02, 0x03DDCF02, 0x03DE2402, 0x03DE7802, 0x03DECD02, 0x03DF2202, 0x03DF7602, 0x03DFCB02,
   0x03E02002, 0x03E07402, 0x03E0C902, 0x03E11E02, 0x03E17202, 0x03E1C702, 0x03E21C02, 0x03E27002,
   0x03E2C502, 0x03E31A02, 0x03E36F02, 0x03E3C302, 0x03E41802, 0x03E46D02, 0x03E4C202, 0x03E51602,
   0x03E56B02, 0x03E5C002, 0x03E61502, 0x03E66A02, 0x03E6BE02, 0x03E71302, 0x03E76802, 0x03E7BD02,
   0x03E81202, 0x03E86602, 0x03E8BB02, 0x03E91002, 0x03E96502, 0x03E9BA02, 0x03EA0F02, 0x03EA6402,
   0x03EAB802, 0x03EB0D02, 0x03EB6202, 0x03EBB702, 0x03EC0C02, 0x03EC6102, 0x03ECB602, 0x03ED0B02,
   0x03ED6002, 0x03EDB502, 0x03EE0A02, 0x03EE5F02, 0x03EEB402, 0x03EF0902, 0x03EF5E02, 0x03EFB302,
   0x03F00802, 0x03F05D02, 0x03F0B202, 0x03F10702, 0x03F15C02, 0x03F1B102, 0x03F20602, 0x03F25B02,
   0x03F2B002, 0x03F30502, 0x03F35A02, 0x03F3AF02, 0x03F40402, 0x03F45902, 0x03F4AE02, 0x03F50302,
   0x03F55802, 0x03F5AE02, 0x03F60302, 0x03F65802, 0x03F6AD02, 0x03F70202, 0x03F75702, 0x03F7AC02,
   0x03F80202, 0x03F85702, 0x03F8AC02, 0x03F90102, 0x03F95602, 0x03F9AB02, 0x03FA0102, 0x03FA5602,
   0x03FAAB02, 0x03FB0002, 0x03FB5602, 0x03FBAB02, 0x03FC0002, 0x03FC5502, 0x03FCAB02, 0x03FD0002,
   0x03FD5502, 0x03FDAA02, 0x03FE0002, 0x03FE5502, 0x03FEAA02, 0x03FF0002, 0x03FF5502, 0x03FFAA02,
   0x01FFFF01, 0x02002A01, 0x02005501, 0x02008001, 0x0200AA01, 0x0200D501, 0x02010001, 0x02012A01,
   0x02015501, 0x02018001, 0x0201AA01, 0x0201D501, 0x02020001, 0x02022A01, 0x02025501, 0x02028001,
   0x0202AB01, 0x0202D501, 0x02030001, 0x02032B01, 0x02035601, 0x02038001, 0x0203AB01, 0x0203D601,
   0x02040001, 0x02042B01, 0x02045601, 0x02048101, 0x0204AC01, 0x0204D601, 0x02050101, 0x02052C01,
   0x02055701, 0x02058101, 0x0205AC01, 0x0205D701, 0x02060201, 0x02062D01, 0x02065701, 0x02068201,
   0x0206AD01, 0x0206D801, 0x02070301, 0x02072D01, 0x02075801, 0x02078301, 0x0207AE01, 0x0207D901,
   0x02080301, 0x02082E01, 0x02085901, 0x02088401, 0x0208AF01, 0x0208DA01, 0x02090501, 0x02092F01,
   0x02095A01, 0x02098501, 0x0209B001, 0x0209DB01, 0x020A0601, 0x020A3101, 0x020A5B01, 0x020A8601,
   0x020AB101, 0x020ADC01, 0x020B0701, 0x020B3201, 0x020B5D01, 0x020B8801, 0x020BB301, 0x020BDE01,
   0x020C0801, 0x020C3301, 0x020C5E01, 0x020C8901, 0x020CB401, 0x020CDF01, 0x020D0A01, 0x020D3501,
   0x020D6001, 0x020D8B01, 0x020DB601, 0x020DE101, 0x020E0C01, 0x020E3701, 0x020E6201, 0x020E8D01,
   0x020EB801, 0x020EE301, 0x020F0D01, 0x020F3801, 0x020F6301, 0x020F8E01, 0x020FB901, 0x020FE401,
   0x02100F01, 0x02103A01, 0x02106501, 0x02109001, 0x0210BB01, 0x0210E601, 0x02111101, 0x02113C01,
   0x02116801, 0x02119301, 0x0211BE01, 0x0211E901, 0x02121401, 0x02123F01, 0x02126A01, 0x02129501,
   0x0212C001, 0x0212EB01, 0x02131601, 0x02134101, 0x02136C01, 0x02139701, 0x0213C201, 0x0213ED01,
   0x02141801, 0x02144301, 0x02146F01, 0x02149A01, 0x0214C501, 0x0214F001, 0x02151B01, 0x02154601,
   0x02157101, 0x02159C01, 0x0215C701, 0x0215F201, 0x02161E01, 0x02164901, 0x02167401, 0x02169F01,
   0x0216CA01, 0x0216F501, 0x02172001, 0x02174B01, 0x02177701, 0x0217A201, 0x0217CD01, 0x0217F801,
   0x02182301, 0x02184E01, 0x02187A01, 0x0218A501, 0x0218D001, 0x0218FB01, 0x02192601, 0x02195101,
   0x02197D01, 0x0219A801, 0x0219D301, 0x0219FE01, 0x021A2901, 0x021A5501, 0x021A8001, 0x021AAB01,
   0x021AD601, 0x021B0101, 0x021B2D01, 0x021B5801, 0x021B8301, 0x021BAE01, 0x021BDA01, 0x021C0501,
   0x021C3001, 0x021C5B01, 0x021C8701, 0x021CB201, 0x021CDD01, 0x021D0801, 0x021D3401, 0x021D5F01,
   0x021D8A01, 0x021DB501, 0x021DE101, 0x021E0C01, 0x021E3701, 0x021E6201, 0x021E8E01, 0x021EB901,
   0x021EE401, 0x021F1001, 0x021F3B01, 0x021F6601, 0x021F9201, 0x021FBD01, 0x021FE801, 0x02201401,
   0x02203F01, 0x02206A01, 0x02209501, 0x0220C101, 0x0220EC01, 0x02211801, 0x02214301, 0x02216E01,
   0x02219A01, 0x0221C501, 0x0221F001, 0x02221C01, 0x02224701, 0x02227201, 0x02229E01, 0x0222C901,
   0x0222F401, 0x02232001, 0x02234B01, 0x02237701, 0x0223A201, 0x0223CD01, 0x0223F901, 0x02242401,
   0x02245001, 0x02247B01, 0x0224A601, 0x0224D201, 0x0224FD01, 0x02252901, 0x02255401, 0x02257F01,
   0x0225AB01, 0x0225D601, 0x02260201, 0x02262D01, 0x02265901, 0x02268401, 0x0226B001, 0x0226DB01,
   0x02270601, 0x02273201, 0x02275D01, 0x02278901, 0x0227B401, 0x0227E001, 0x02280B01, 0x02283701,
   0x02286201, 0x02288E01, 0x0228B901, 0x0228E501, 0x02291001, 0x02293C01, 0x02296701, 0x02299301,
   0x0229BE01, 0x0229EA01, 0x022A1501, 0x022A4101, 0x022A6C01, 0x022A9801, 0x022AC301, 0x022AEF01,
   0x022B1A01, 0x022B4601, 0x022B7101, 0x022B9D01, 0x022BC901, 0x022BF401, 0x022C2001, 0x022C4B01,
   0x022C7701, 0x022CA201, 0x022CCE01, 0x022CFA01, 0x022D2501, 0x022D5101, 0x022D7C01, 0x022DA801,
   0x022DD301, 0x022DFF01, 0x022E2B01, 0x022E5601, 0x022E8201, 0x022EAD01, 0x022ED901, 0x022F0501,
   0x022F3001, 0x022F5C01, 0x022F8801, 0x022FB301, 0x022FDF01, 0x02300A01, 0x02303601, 0x02306201,
   0x02308D01, 0x0230B901, 0x0230E501, 0x02311001, 0x02313C01, 0x02316801, 0x02319301, 0x0231BF01,
   0x0231EB01, 0x02321601, 0x02324201, 0x02326E01, 0x02329901, 0x0232C501, 0x0232F101, 0x02331C01,
   0x02334801, 0x02337401, 0x02339F01, 0x0233CB01, 0x0233F701, 0x02342301, 0x02344E01, 0x02347A01,
   0x0234A601, 0x0234D101, 0x0234FD01, 0x02352901, 0x02355501, 0x02358001, 0x0235AC01, 0x0235D801,
   0x02360401, 0x02362F01, 0x02365B01, 0x02368701, 0x0236B301, 0x0236DE01, 0x02370A01, 0x02373601,
   0x02376201, 0x02378E01, 0x0237B901, 0x0237E501, 0x02381101, 0x02383D01, 0x02386801, 0x02389401,
   0x0238C001, 0x0238EC01, 0x02391801, 0x02394301, 0x02396F01, 0x02399B01, 0x0239C701, 0x0239F301,
   0x023A1F01, 0x023A4A01, 0x023A7601, 0x023AA201, 0x023ACE01, 0x023AFA01, 0x023B2601, 0x023B5101,
   0x023B7D01, 0x023BA901, 0x023BD501, 0x023C0101, 0x023C2D01, 0x023C5901, 0x023C8501, 0x023CB001,
   0x023CDC01, 0x023D0801, 0x023D3401, 0x023D6001, 0x023D8C01, 0x023DB801, 0x023DE401, 0x023E1001,
   0x023E3B01, 0x023E6701, 0x023E9301, 0x023EBF01, 0x023EEB01, 0x023F1701, 0x023F4301, 0x023F6F01,
   0x023F9B01, 0x023FC701, 0x023FF301, 0x02401F01, 0x02404B01, 0x02407601, 0x0240A201, 0x0240CE01,
   0x0240FA01, 0x02412601, 0x02415201, 0x02417E01, 0x0241AA01, 0x0241D601, 0x02420201, 0x02422E01,
   0x02425A01, 0x02428601, 0x0242B201, 0x0242DE01, 0x02430A01, 0x02433601, 0x02436201, 0x02438E01,
   0x0243BA01, 0x0243E601, 0x02441201, 0x02443E01, 0x02446A01, 0x02449601, 0x0244C201, 0x0244EE01,
   0x02451A01, 0x02454601, 0x02457201, 0x02459E01, 0x0245CB01, 0x0245F701, 0x02462301, 0x02464F01,
   0x02467B01, 0x0246A701, 0x0246D301, 0x0246FF01, 0x02472B01, 0x02475701, 0x02478301, 0x0247AF01,
   0x0247DB01, 0x02480701, 0x02483401, 0x02486001, 0x02488C01, 0x0248B801, 0x0248E401, 0x02491001,
   0x02493C01, 0x02496801, 0x02499401, 0x0249C101, 0x0249ED01, 0x024A1901, 0x024A4501, 0x024A7101,
   0x024A9D01, 0x024AC901, 0x024AF601, 0x024B2201, 0x024B4E01, 0x024B7A01, 0x024BA601, 0x024BD201,
   0x024BFF01, 0x024C2B01, 0x024C5701, 0x024C8301, 0x024CAF01, 0x024CDB01, 0x024D0801, 0x024D3401,
   0x024D6001, 0x024D8C01, 0x024DB801, 0x024DE501, 0x024E1101, 0x024E3D01, 0x024E6901, 0x024E9501,
   0x024EC201, 0x024EEE01, 0x024F1A01, 0x024F4601, 0x024F7301, 0x024F9F01, 0x024FCB01, 0x024FF701,
   0x02502301, 0x02505001, 0x02507C01, 0x0250A801, 0x0250D401, 0x02510101, 0x02512D01, 0x02515901,
   0x02518601, 0x0251B201, 0x0251DE01, 0x02520A01, 0x02523701, 0x02526301, 0x02528F01, 0x0252BC01,
   0x0252E801, 0x02531401, 0x02534001, 0x02536D01, 0x02539901, 0x0253C501, 0x0253F201, 0x02541E01,
   0x02544A01, 0x02547701, 0x0254A301, 0x0254CF01, 0x0254FC01, 0x02552801, 0x02555401, 0x02558101,
   0x0255AD01, 0x0255D901, 0x02560601, 0x02563201, 0x02565E01, 0x02568B01, 0x0256B701, 0x0256E401,
   0x02571001, 0x02573C01, 0x02576901, 0x02579501, 0x0257C101, 0x0257EE01, 0x02581A01, 0x02584701,
   0x02587301, 0x02589F01, 0x0258CC01, 0x0258F801, 0x02592501, 0x02595101, 0x02597D01, 0x0259AA01,
   0x0259D601, 0x025A0301, 0x025A2F01, 0x025A5C01, 0x025A8801, 0x025AB501, 0x025AE101, 0x025B0D01,
   0x025B3A01, 0x025B6601, 0x025B9301, 0x025BBF01, 0x025BEC01, 0x025C1801, 0x025C4501, 0x025C7101,
   0x025C9E01, 0x025CCA01, 0x025CF701, 0x025D2301, 0x025D5001, 0x025D7C01, 0x025DA801, 0x025DD501,
   0x025E0101, 0x025E2E01, 0x025E5B01, 0x025E8701, 0x025EB401, 0x025EE001, 0x025F0D01, 0x025F3901,
   0x025F6601, 0x025F9201, 0x025FBF01, 0x025FEB01, 0x02601801, 0x02604401, 0x02607101, 0x02609D01,
   0x0260CA01, 0x0260F701, 0x02612301, 0x02615001, 0x02617C01, 0x0261A901, 0x0261D501, 0x02620201,
   0x02622E01, 0x02625B01, 0x02628801, 0x0262B401, 0x0262E101, 0x02630D01, 0x02633A01, 0x02636701,
   0x02639301, 0x0263C001, 0x0263EC01, 0x02641901, 0x02644601, 0x02647201, 0x02649F01, 0x0264CC01,
   0x0264F801, 0x02652501, 0x02655101, 0x02657E01, 0x0265AB01, 0x0265D701, 0x02660401, 0x02663101,
   0x02665D01, 0x02668A01, 0x0266B701, 0x0266E301, 0x02671001, 0x02673D01, 0x02676901, 0x02679601,
   0x0267C301, 0x0267EF01, 0x02681C01, 0x02684901, 0x02687501, 0x0268A201, 0x0268CF01, 0x0268FC01,
   0x02692801, 0x02695501, 0x02698201, 0x0269AE01, 0x0269DB01, 0x026A0801, 0x026A3501, 0x026A6101,
   0x026A8E01, 0x026ABB01, 0x026AE701, 0x026B1401, 0x026B4101, 0x026B6E01, 0x026B9A01, 0x026BC701,
   0x026BF401, 0x026C2101, 0x026C4D01, 0x026C7A01, 0x026CA701, 0x026CD401, 0x026D0101, 0x026D2D01,
   0x026D5A01, 0x026D8701, 0x026DB401, 0x026DE001, 0x026E0D01, 0x026E3A01, 0x026E6701, 0x026E9401,
   0x026EC001, 0x026EED01, 0x026F1A01, 0x026F4701, 0x026F7401, 0x026FA101, 0x026FCD01, 0x026FFA01,
   0x02702701, 0x02705401, 0x02708101, 0x0270AE01, 0x0270DA01, 0x02710701, 0x02713401, 0x02716101,
   0x02718E01, 0x0271BB01, 0x0271E701, 0x02721401, 0x02724101, 0x02726E01, 0x02729B01, 0x0272C801,
   0x0272F501, 0x02732201, 0x02734E01, 0x02737B01, 0x0273A801, 0x0273D501, 0x02740201, 0x02742F01,
   0x02745C01, 0x02748901, 0x0274B601, 0x0274E301, 0x02751001, 0x02753C01, 0x02756901, 0x02759601,
   0x0275C301, 0x0275F001, 0x02761D01, 0x02764A01, 0x02767701, 0x0276A401, 0x0276D101, 0x0276FE01,
   0x02772B01, 0x02775801, 0x02778501, 0x0277B201, 0x0277DF01, 0x02780C01, 0x02783901, 0x02786601,
   0x02789301, 0x0278C001, 0x0278ED01, 0x02791A01, 0x02794701, 0x02797401, 0x0279A101, 0x0279CE01,
   0x0279FB01, 0x027A2801, 0x027A5501, 0x027A8201, 0x027AAF01, 0x027ADC01, 0x027B0901, 0x027B3601,
   0x027B6301, 0x027B9001, 0x027BBD01, 0x027BEA01, 0x027C1701, 0x027C4401, 0x027C7101, 0x027C9E01,
   0x027CCB01, 0x027CF801, 0x027D2501, 0x027D5201, 0x027D7F01, 0x027DAC01, 0x027DD901, 0x027E0701,
   0x027E3401, 0x027E6101, 0x027E8E01, 0x027EBB01, 0x027EE801, 0x027F1501, 0x027F4201, 0x027F6F01,
   0x027F9C01, 0x027FC901, 0x027FF701, 0x02802401, 0x02805101, 0x02807E01, 0x0280AB01, 0x0280D801,
   0x02810501, 0x02813201, 0x02816001, 0x02818D01, 0x0281BA01, 0x0281E701, 0x02821401, 0x02824101,
   0x02826F01, 0x02829C01, 0x0282C901, 0x0282F601, 0x02832301, 0x02835001, 0x02837E01, 0x0283AB01,
   0x0283D801, 0x02840501, 0x02843201, 0x02845F01, 0x02848D01, 0x0284BA01, 0x0284E701, 0x02851401,
   0x02854101, 0x02856F01, 0x02859C01, 0x0285C901, 0x0285F601, 0x02862301, 0x02865101, 0x02867E01,
   0x0286AB01, 0x0286D801, 0x02870601, 0x02873301, 0x02876001, 0x02878D01, 0x0287BB01, 0x0287E801,
   0x02881501, 0x02884201, 0x02887001, 0x02889D01, 0x0288CA01, 0x0288F701, 0x02892501, 0x02895201,
   0x02897F01, 0x0289AD01, 0x0289DA01, 0x028A0701, 0x028A3401, 0x028A6201, 0x028A8F01, 0x028ABC01,
   0x028AEA01, 0x028B1701, 0x028B4401, 0x028B7201, 0x028B9F01, 0x028BCC01, 0x028BFA01, 0x028C2701,
   0x028C5401, 0x028C8101, 0x028CAF01, 0x028CDC01, 0x028D0A01, 0x028D3701, 0x028D6401, 0x028D9201,
   0x028DBF01, 0x028DEC01, 0x028E1A01, 0x028E4701, 0x028E7401, 0x028EA201, 0x028ECF01, 0x028EFC01,
   0x028F2A01, 0x028F5701, 0x028F8501, 0x028FB201, 0x028FDF01, 0x02900D01, 0x02903A01, 0x02906801,
   0x02909501, 0x0290C201, 0x0290F001, 0x02911D01, 0x02914B01, 0x02917801, 0x0291A501, 0x0291D301,
   0x02920001, 0x02922E01, 0x02925B01, 0x02928901, 0x0292B601, 0x0292E301, 0x02931101, 0x02933E01,
   0x02936C01, 0x02939901, 0x0293C701, 0x0293F401, 0x02942201, 0x02944F01, 0x02947D01, 0x0294AA01,
   0x0294D801, 0x02950501, 0x02953301, 0x02956001, 0x02958D01, 0x0295BB01, 0x0295E801, 0x02961601,
   0x02964301, 0x02967101, 0x02969E01, 0x0296CC01, 0x0296FA01, 0x02972701, 0x02975501, 0x02978201,
   0x0297B001, 0x0297DD01, 0x02980B01, 0x02983801, 0x02986601, 0x02989301, 0x0298C101, 0x0298EE01,
   0x02991C01, 0x02994901, 0x02997701, 0x0299A501, 0x0299D201, 0x029A0001, 0x029A2D01, 0x029A5B01,
   0x029A8801, 0x029AB601, 0x029AE401, 0x029B1101, 0x029B3F01, 0x029B6C01, 0x029B9A01, 0x029BC701,
   0x029BF501, 0x029C2301, 0x029C5001, 0x029C7E01, 0x029CAC01, 0x029CD901, 0x029D0701, 0x029D3401,
   0x029D6201, 0x029D9001, 0x029DBD01, 0x029DEB01, 0x029E1901, 0x029E4601, 0x029E7401, 0x029EA101,
   0x029ECF01, 0x029EFD01, 0x029F2A01, 0x029F5801, 0x029F8601, 0x029FB301, 0x029FE101, 0x02A00F01,
   0x02A03C01, 0x02A06A01, 0x02A09801, 0x02A0C501, 0x02A0F301, 0x02A12101, 0x02A14E01, 0x02A17C01,
   0x02A1AA01, 0x02A1D801, 0x02A20501, 0x02A23301, 0x02A26101, 0x02A28E01, 0x02A2BC01, 0x02A2EA01,
   0x02A31701, 0x02A34501, 0x02A37301, 0x02A3A101, 0x02A3CE01, 0x02A3FC01, 0x02A42A01, 0x02A45801,
   0x02A48501, 0x02A4B301, 0x02A4E101, 0x02A50F01, 0x02A53C01, 0x02A56A01, 0x02A59801, 0x02A5C601,
   0x02A5F301, 0x02A62101, 0x02A64F01, 0x02A67D01, 0x02A6AB01, 0x02A6D801, 0x02A70601, 0x02A73401,
   0x02A76201, 0x02A78F01, 0x02A7BD01, 0x02A7EB01, 0x02A81901, 0x02A84701, 0x02A87401, 0x02A8A201,
   0x02A8D001, 0x02A8FE01, 0x02A92C01, 0x02A95A01, 0x02A98701, 0x02A9B501, 0x02A9E301, 0x02AA1101,
   0x02AA3F01, 0x02AA6D01, 0x02AA9A01, 0x02AAC801, 0x02AAF601, 0x02AB2401, 0x02AB5201, 0x02AB8001,
   0x02ABAE01, 0x02ABDB01, 0x02AC0901, 0x02AC3701, 0x02AC6501, 0x02AC9301, 0x02ACC101, 0x02ACEF01,
   0x02AD1D01, 0x02AD4A01, 0x02AD7801, 0x02ADA601, 0x02ADD401, 0x02AE0201, 0x02AE3001, 0x02AE5E01,
   0x02AE8C01, 0x02AEBA01, 0x02AEE801, 0x02AF1601, 0x02AF4301, 0x02AF7101, 0x02AF9F01, 0x02AFCD01,
   0x02AFFB01, 0x02B02901, 0x02B05701, 0x02B08501, 0x02B0B301, 0x02B0E101, 0x02B10F01, 0x02B13D01,
   0x02B16B01, 0x02B19901, 0x02B1C701, 0x02B1F501, 0x02B22301, 0x02B25101, 0x02B27F01, 0x02B2AD01,
   0x02B2DB01, 0x02B30901, 0x02B33701, 0x02B36501, 0x02B39301, 0x02B3C101, 0x02B3EF01, 0x02B41D01,
   0x02B44B01, 0x02B47901, 0x02B4A701, 0x02B4D501, 0x02B50301, 0x02B53101, 0x02B55F01, 0x02B58D01,
   0x02B5BB01, 0x02B5E901, 0x02B61701, 0x02B64501, 0x02B67301, 0x02B6A101, 0x02B6CF01, 0x02B6FD01,
   0x02B72B01, 0x02B75901, 0x02B78701, 0x02B7B501, 0x02B7E301, 0x02B81101, 0x02B83F01, 0x02B86E01,
   0x02B89C01, 0x02B8CA01, 0x02B8F801, 0x02B92601, 0x02B95401, 0x02B98201, 0x02B9B001, 0x02B9DE01,
   0x02BA0C01, 0x02BA3A01, 0x02BA6901, 0x02BA9701, 0x02BAC501, 0x02BAF301, 0x02BB2101, 0x02BB4F01,
   0x02BB7D01, 0x02BBAB01, 0x02BBDA01, 0x02BC0801, 0x02BC3601, 0x02BC6401, 0x02BC9201, 0x02BCC001,
   0x02BCEE01, 0x02BD1D01, 0x02BD4B01, 0x02BD7901, 0x02BDA701, 0x02BDD501, 0x02BE0301, 0x02BE3201,
   0x02BE6001, 0x02BE8E01, 0x02BEBC01, 0x02BEEA01, 0x02BF1801, 0x02BF4701, 0x02BF7501, 0x02BFA301,
   0x02BFD101, 0x02BFFF01, 0x02C02E01, 0x02C05C01, 0x02C08A01, 0x02C0B801, 0x02C0E601, 0x02C11501,
   0x02C14301, 0x02C17101, 0x02C19F01, 0x02C1CE01, 0x02C1FC01, 0x02C22A01, 0x02C25801, 0x02C28701,
   0x02C2B501, 0x02C2E301, 0x02C31101, 0x02C34001, 0x02C36E01, 0x02C39C01, 0x02C3CA01, 0x02C3F901,
   0x02C42701, 0x02C45501, 0x02C48301, 0x02C4B201, 0x02C4E001, 0x02C50E01, 0x02C53D01, 0x02C56B01,
   0x02C59901, 0x02C5C701, 0x02C5F601, 0x02C62401, 0x02C65201, 0x02C68101, 0x02C6AF01, 0x02C6DD01,
   0x02C70C01, 0x02C73A01, 0x02C76801, 0x02C79701, 0x02C7C501, 0x02C7F301, 0x02C82201, 0x02C85001,
   0x02C87E01, 0x02C8AD01, 0x02C8DB01, 0x02C90901, 0x02C93801, 0x02C96601, 0x02C99401, 0x02C9C301,
   0x02C9F101, 0x02CA1F01, 0x02CA4E01, 0x02CA7C01, 0x02CAAB01, 0x02CAD901, 0x02CB0701, 0x02CB3601,
   0x02CB6401, 0x02CB9201, 0x02CBC101, 0x02CBEF01, 0x02CC1E01, 0x02CC4C01, 0x02CC7A01, 0x02CCA901,
   0x02CCD701, 0x02CD0601, 0x02CD3401, 0x02CD6201, 0x02CD9101, 0x02CDBF01, 0x02CDEE01, 0x02CE1C01,
   0x02CE4B01, 0x02CE7901, 0x02CEA801, 0x02CED601, 0x02CF0401, 0x02CF3301, 0x02CF6101, 0x02CF9001,
   0x02CFBE01, 0x02CFED01, 0x02D01B01, 0x02D04A01, 0x02D07801, 0x02D0A701, 0x02D0D501, 0x02D10301,
   0x02D13201, 0x02D16001, 0x02D18F01, 0x02D1BD01, 0x02D1EC01, 0x02D21A01, 0x02D24901, 0x02D27701,
   0x02D2A601, 0x02D2D401, 0x02D30301, 0x02D33101, 0x02D36001, 0x02D38E01, 0x02D3BD01, 0x02D3EC01,
   0x02D41A01, 0x02D44901, 0x02D47701, 0x02D4A601, 0x02D4D401, 0x02D50301, 0x02D53101, 0x02D56001,
   0x02D58E01, 0x02D5BD01, 0x02D5EB01, 0x02D61A01, 0x02D64901, 0x02D67701, 0x02D6A601, 0x02D6D401,
   0x02D70301, 0x02D73101, 0x02D76001, 0x02D78F01, 0x02D7BD01, 0x02D7EC01, 0x02D81A01, 0x02D84901,
   0x02D87801, 0x02D8A601, 0x02D8D501, 0x02D90301, 0x02D93201, 0x02D96101, 0x02D98F01, 0x02D9BE01,
   0x02D9EC01, 0x02DA1B01, 0x02DA4A01, 0x02DA7801, 0x02DAA701, 0x02DAD601, 0x02DB0401, 0x02DB3301,
   0x02DB6201, 0x02DB9001, 0x02DBBF01, 0x02DBED01, 0x02DC1C01, 0x02DC4B01, 0x02DC7901, 0x02DCA801,
   0x02DCD701, 0x02DD0501, 0x02DD3401, 0x02DD6301, 0x02DD9101, 0x02DDC001, 0x02DDEF01, 0x02DE1E01,
   0x02DE4C01, 0x02DE7B01, 0x02DEAA01, 0x02DED801, 0x02DF0701, 0x02DF3601, 0x02DF6401, 0x02DF9301,
   0x02DFC201, 0x02DFF101, 0x02E01F01, 0x02E04E01, 0x02E07D01, 0x02E0AB01, 0x02E0DA01, 0x02E10901,
   0x02E13801, 0x02E16601, 0x02E19501, 0x02E1C401, 0x02E1F301, 0x02E22101, 0x02E25001, 0x02E27F01,
   0x02E2AE01, 0x02E2DC01, 0x02E30B01, 0x02E33A01, 0x02E36901, 0x02E39801, 0x02E3C601, 0x02E3F501,
   0x02E42401, 0x02E45301, 0x02E48101, 0x02E4B001, 0x02E4DF01, 0x02E50E01, 0x02E53D01, 0x02E56B01,
   0x02E59A01, 0x02E5C901, 0x02E5F801, 0x02E62701, 0x02E65501, 0x02E68401, 0x02E6B301, 0x02E6E201,
   0x02E71101, 0x02E74001, 0x02E76E01, 0x02E79D01, 0x02E7CC01, 0x02E7FB01, 0x02E82A01, 0x02E85901,
   0x02E88801, 0x02E8B601, 0x02E8E501, 0x02E91401, 0x02E94301, 0x02E97201, 0x02E9A101, 0x02E9D001,
   0x02E9FE01, 0x02EA2D01, 0x02EA5C01, 0x02EA8B01, 0x02EABA01, 0x02EAE901, 0x02EB1801, 0x02EB4701,
   0x02EB7601, 0x02EBA401, 0x02EBD301, 0x02EC0201, 0x02EC3101, 0x02EC6001, 0x02EC8F01, 0x02ECBE01,
   0x02ECED01, 0x02ED1C01, 0x02ED4B01, 0x02ED7A01, 0x02EDA901, 0x02EDD701, 0x02EE0601, 0x02EE3501,
   0x02EE6401, 0x02EE9301, 0x02EEC201, 0x02EEF101, 0x02EF2001, 0x02EF4F01, 0x02EF7E01, 0x02EFAD01,
   0x02EFDC01, 0x02F00B01, 0x02F03A01, 0x02F06901, 0x02F09801, 0x02F0C701, 0x02F0F601, 0x02F12501,
   0x02F15401, 0x02F18301, 0x02F1B201, 0x02F1E101, 0x02F21001, 0x02F23F01, 0x02F26E01, 0x02F29D01,
   0x02F2CC01, 0x02F2FB01, 0x02F32A01, 0x02F35901, 0x02F38801, 0x02F3B701, 0x02F3E601, 0x02F41501,
   0x02F44401, 0x02F47301, 0x02F4A201, 0x02F4D101, 0x02F50001, 0x02F52F01, 0x02F55E01, 0x02F58D01,
   0x02F5BC01, 0x02F5EB01, 0x02F61B01, 0x02F64A01, 0x02F67901, 0x02F6A801, 0x02F6D701, 0x02F70601,
   0x02F73501, 0x02F76401, 0x02F79301, 0x02F7C201, 0x02F7F101, 0x02F82001, 0x02F85001, 0x02F87F01,
   0x02F8AE01, 0x02F8DD01, 0x02F90C01, 0x02F93B01, 0x02F96A01, 0x02F99901, 0x02F9C801, 0x02F9F801,
   0x02FA2701, 0x02FA5601, 0x02FA8501, 0x02FAB401, 0x02FAE301, 0x02FB1201, 0x02FB4101, 0x02FB7101,
   0x02FBA001, 0x02FBCF01, 0x02FBFE01, 0x02FC2D01, 0x02FC5C01, 0x02FC8C01, 0x02FCBB01, 0x02FCEA01,
   0x02FD1901, 0x02FD4801, 0x02FD7701, 0x02FDA701, 0x02FDD601, 0x02FE0501, 0x02FE3401, 0x02FE6301,
   0x02FE9301, 0x02FEC201, 0x02FEF101, 0x02FF2001, 0x02FF4F01, 0x02FF7F01, 0x02FFAE01, 0x02FFDD01,
   0x03000C01, 0x03003B01, 0x03006B01, 0x03009A01, 0x0300C901, 0x0300F801, 0x03012801, 0x03015701,
   0x03018601, 0x0301B501, 0x0301E501, 0x03021401, 0x03024301, 0x03027201, 0x0302A201, 0x0302D101,
   0x03030001, 0x03032F01, 0x03035F01, 0x03038E01, 0x0303BD01, 0x0303EC01, 0x03041C01, 0x03044B01,
   0x03047A01, 0x0304AA01, 0x0304D901, 0x03050801, 0x03053701, 0x03056701, 0x03059601, 0x0305C501,
   0x0305F501, 0x03062401, 0x03065301, 0x03068301, 0x0306B201, 0x0306E101, 0x03071101, 0x03074001,
   0x03076F01, 0x03079F01, 0x0307CE01, 0x0307FD01, 0x03082D01, 0x03085C01, 0x03088B01, 0x0308BB01,
   0x0308EA01, 0x03091901, 0x03094901, 0x03097801, 0x0309A701, 0x0309D701, 0x030A0601, 0x030A3601,
   0x030A6501, 0x030A9401, 0x030AC401, 0x030AF301, 0x030B2201, 0x030B5201, 0x030B8101, 0x030BB101,
   0x030BE001, 0x030C0F01, 0x030C3F01, 0x030C6E01, 0x030C9E01, 0x030CCD01, 0x030CFC01, 0x030D2C01,
   0x030D5B01, 0x030D8B01, 0x030DBA01, 0x030DEA01, 0x030E1901, 0x030E4801, 0x030E7801, 0x030EA701,
   0x030ED701, 0x030F0601, 0x030F3601, 0x030F6501, 0x030F9501, 0x030FC401, 0x030FF401, 0x03102301,
   0x03105201, 0x03108201, 0x0310B101, 0x0310E101, 0x03111001, 0x03114001, 0x03116F01, 0x03119F01,
   0x0311CE01, 0x0311FE01, 0x03122D01, 0x03125D01, 0x03128C01, 0x0312BC01, 0x0312EB01, 0x03131B01,
   0x03134A01, 0x03137A01, 0x0313A901, 0x0313D901, 0x03140801, 0x03143801, 0x03146701, 0x03149701,
   0x0314C601, 0x0314F601, 0x03152601, 0x03155501, 0x03158501, 0x0315B401, 0x0315E401, 0x03161301,
   0x03164301, 0x03167201, 0x0316A201, 0x0316D201, 0x03170101, 0x03173101, 0x03176001, 0x03179001,
   0x0317BF01, 0x0317EF01, 0x03181F01, 0x03184E01, 0x03187E01, 0x0318AD01, 0x0318DD01, 0x03190D01,
   0x03193C01, 0x03196C01, 0x03199B01, 0x0319CB01, 0x0319FB01, 0x031A2A01, 0x031A5A01, 0x031A8901,
   0x031AB901, 0x031AE901, 0x031B1801, 0x031B4801, 0x031B7801, 0x031BA701, 0x031BD701, 0x031C0601,
   0x031C3601, 0x031C6601, 0x031C9501, 0x031CC501, 0x031CF501, 0x031D2401, 0x031D5401, 0x031D8401,
   0x031DB301, 0x031DE301, 0x031E1301, 0x031E4201, 0x031E7201, 0x031EA201, 0x031ED101, 0x031F0101,
   0x031F3101, 0x031F6001, 0x031F9001, 0x031FC001, 0x031FF001, 0x03201F01, 0x03204F01, 0x03207F01,
   0x0320AE01, 0x0320DE01, 0x03210E01, 0x03213E01, 0x03216D01, 0x03219D01, 0x0321CD01, 0x0321FC01,
   0x03222C01, 0x03225C01, 0x03228C01, 0x0322BB01, 0x0322EB01, 0x03231B01, 0x03234B01, 0x03237A01,
   0x0323AA01, 0x0323DA01, 0x03240A01, 0x03243901, 0x03246901, 0x03249901, 0x0324C901, 0x0324F901,
   0x03252801, 0x03255801, 0x03258801, 0x0325B801, 0x0325E701, 0x03261701, 0x03264701, 0x03267701,
   0x0326A701, 0x0326D601, 0x03270601, 0x03273601, 0x03276601, 0x03279601, 0x0327C501, 0x0327F501,
   0x03282501, 0x03285501, 0x03288501, 0x0328B501, 0x0328E401, 0x03291401, 0x03294401, 0x03297401,
   0x0329A401, 0x0329D401, 0x032A0401, 0x032A3301, 0x032A6301, 0x032A9301, 0x032AC301, 0x032AF301,
   0x032B2301, 0x032B5301, 0x032B8201, 0x032BB201, 0x032BE201, 0x032C1201, 0x032C4201, 0x032C7201,
   0x032CA201, 0x032CD201, 0x032D0101, 0x032D3101, 0x032D6101, 0x032D9101, 0x032DC101, 0x032DF101,
   0x032E2101, 0x032E5101, 0x032E8101, 0x032EB101, 0x032EE101, 0x032F1101, 0x032F4001, 0x032F7001,
   0x032FA001, 0x032FD001, 0x03300001, 0x03303001, 0x03306001, 0x03309001, 0x0330C001, 0x0330F001,
   0x03312001, 0x03315001, 0x03318001, 0x0331B001, 0x0331E001, 0x03321001, 0x03324001, 0x03327001,
   0x0332A001, 0x0332D001, 0x03330001, 0x03333001, 0x03336001, 0x03339001, 0x0333C001, 0x0333F001,
   0x03341F01, 0x03345001, 0x03348001, 0x0334B001, 0x0334E001, 0x03351001, 0x03354001, 0x03357001,
   0x0335A001, 0x0335D001, 0x03360001, 0x03363001, 0x03366001, 0x03369001, 0x0336C001, 0x0336F001,
   0x03372001, 0x03375001, 0x03378001, 0x0337B001, 0x0337E001, 0x03381001, 0x03384001, 0x03387001,
   0x0338A001, 0x0338D001, 0x03390001, 0x03393001, 0x03396101, 0x03399101, 0x0339C101, 0x0339F101,
   0x033A2101, 0x033A5101, 0x033A8101, 0x033AB101, 0x033AE101, 0x033B1101, 0x033B4101, 0x033B7201,
   0x033BA201, 0x033BD201, 0x033C0201, 0x033C3201, 0x033C6201, 0x033C9201, 0x033CC201, 0x033CF301,
   0x033D2301, 0x033D5301, 0x033D8301, 0x033DB301, 0x033DE301, 0x033E1301, 0x033E4301, 0x033E7401,
   0x033EA401, 0x033ED401, 0x033F0401, 0x033F3401, 0x033F6401, 0x033F9501, 0x033FC501, 0x033FF501,
   0x03402501, 0x03405501, 0x03408501, 0x0340B601, 0x0340E601, 0x03411601, 0x03414601, 0x03417601,
   0x0341A701, 0x0341D701, 0x03420701, 0x03423701, 0x03426701, 0x03429801, 0x0342C801, 0x0342F801,
   0x03432801, 0x03435801, 0x03438901, 0x0343B901, 0x0343E901, 0x03441901, 0x03444A01, 0x03447A01,
   0x0344AA01, 0x0344DA01, 0x03450B01, 0x03453B01, 0x03456B01, 0x03459B01, 0x0345CC01, 0x0345FC01,
   0x03462C01, 0x03465C01, 0x03468D01, 0x0346BD01, 0x0346ED01, 0x03471D01, 0x03474E01, 0x03477E01,
   0x0347AE01, 0x0347DF01, 0x03480F01, 0x03483F01, 0x03486F01, 0x0348A001, 0x0348D001, 0x03490001,
   0x03493101, 0x03496101, 0x03499101, 0x0349C201, 0x0349F201, 0x034A2201, 0x034A5301, 0x034A8301,
   0x034AB301, 0x034AE301, 0x034B1401, 0x034B4401, 0x034B7401, 0x034BA501, 0x034BD501, 0x034C0601,
   0x034C3601, 0x034C6601, 0x034C9701, 0x034CC701, 0x034CF701, 0x034D2801, 0x034D5801, 0x034D8801,
   0x034DB901, 0x034DE901, 0x034E1901, 0x034E4A01, 0x034E7A01, 0x034EAB01, 0x034EDB01, 0x034F0B01,
   0x034F3C01, 0x034F6C01, 0x034F9D01, 0x034FCD01, 0x034FFD01, 0x03502E01, 0x03505E01, 0x03508F01,
   0x0350BF01, 0x0350EF01, 0x03512001, 0x03515001, 0x03518101, 0x0351B101, 0x0351E201, 0x03521201,
   0x03524201, 0x03527301, 0x0352A301, 0x0352D401, 0x03530401, 0x03533501, 0x03536501, 0x03539601,
   0x0353C601, 0x0353F601, 0x03542701, 0x03545701, 0x03548801, 0x0354B801, 0x0354E901, 0x03551901,
   0x03554A01, 0x03557A01, 0x0355AB01, 0x0355DB01, 0x03560C01, 0x03563C01, 0x03566D01, 0x03569D01,
   0x0356CE01, 0x0356FE01, 0x03572F01, 0x03575F01, 0x03579001, 0x0357C001, 0x0357F101, 0x03582101,
   0x03585201, 0x03588201, 0x0358B301, 0x0358E301, 0x03591401, 0x03594401, 0x03597501, 0x0359A501,
   0x0359D601, 0x035A0701, 0x035A3701, 0x035A6801, 0x035A9801, 0x035AC901, 0x035AF901, 0x035B2A01,
   0x035B5A01, 0x035B8B01, 0x035BBC01, 0x035BEC01, 0x035C1D01, 0x035C4D01, 0x035C7E01, 0x035CAE01,
   0x035CDF01, 0x035D1001, 0x035D4001, 0x035D7101, 0x035DA101, 0x035DD201, 0x035E0301, 0x035E3301,
   0x035E6401, 0x035E9401, 0x035EC501, 0x035EF601, 0x035F2601, 0x035F5701, 0x035F8701, 0x035FB801,
   0x035FE901, 0x03601901, 0x03604A01, 0x03607B01, 0x0360AB01, 0x0360DC01, 0x03610D01, 0x03613D01,
   0x03616E01, 0x03619E01, 0x0361CF01, 0x03620001, 0x03623001, 0x03626101, 0x03629201, 0x0362C201,
   0x0362F301, 0x03632401, 0x03635401, 0x03638501, 0x0363B601, 0x0363E601, 0x03641701, 0x03644801,
   0x03647901, 0x0364A901, 0x0364DA01, 0x03650B01, 0x03653B01, 0x03656C01, 0x03659D01, 0x0365CD01,
   0x0365FE01, 0x03662F01, 0x03666001, 0x03669001, 0x0366C101, 0x0366F201, 0x03672201, 0x03675301,
   0x03678401, 0x0367B501, 0x0367E501, 0x03681601, 0x03684701, 0x03687801, 0x0368A801, 0x0368D901,
   0x03690A01, 0x03693B01, 0x03696B01, 0x03699C01, 0x0369CD01, 0x0369FE01, 0x036A2F01, 0x036A5F01,
   0x036A9001, 0x036AC101, 0x036AF201, 0x036B2201, 0x036B5301, 0x036B8401, 0x036BB501, 0x036BE601,
   0x036C1601, 0x036C4701, 0x036C7801, 0x036CA901, 0x036CDA01, 0x036D0A01, 0x036D3B01, 0x036D6C01,
   0x036D9D01, 0x036DCE01, 0x036DFE01, 0x036E2F01, 0x036E6001, 0x036E9101, 0x036EC201, 0x036EF301,
   0x036F2301, 0x036F5401, 0x036F8501, 0x036FB601, 0x036FE701, 0x03701801, 0x03704901, 0x03707901,
   0x0370AA01, 0x0370DB01, 0x03710C01, 0x03713D01, 0x03716E01, 0x03719F01, 0x0371D001, 0x03720001,
   0x03723101, 0x03726201, 0x03729301, 0x0372C401, 0x0372F501, 0x03732601, 0x03735701, 0x03738801,
   0x0373B801, 0x0373E901, 0x03741A01, 0x03744B01, 0x03747C01, 0x0374AD01, 0x0374DE01, 0x03750F01,
   0x03754001, 0x03757101, 0x0375A201, 0x0375D301, 0x03760301, 0x03763401, 0x03766501, 0x03769601,
   0x0376C701, 0x0376F801, 0x03772901, 0x03775A01, 0x03778B01, 0x0377BC01, 0x0377ED01, 0x03781E01,
   0x03784F01, 0x03788001, 0x0378B101, 0x0378E201, 0x03791301, 0x03794401, 0x03797501, 0x0379A601,
   0x0379D701, 0x037A0801, 0x037A3901, 0x037A6A01, 0x037A9B01, 0x037ACC01, 0x037AFD01, 0x037B2E01,
   0x037B5F01, 0x037B9001, 0x037BC101, 0x037BF201, 0x037C2301, 0x037C5401, 0x037C8501, 0x037CB601,
   0x037CE701, 0x037D1801, 0x037D4901, 0x037D7A01, 0x037DAB01, 0x037DDC01, 0x037E0D01, 0x037E3E01,
   0x037E6F01, 0x037EA001, 0x037ED101, 0x037F0201, 0x037F3301, 0x037F6501, 0x037F9601, 0x037FC701,
   0x037FF801, 0x03802901, 0x03805A01, 0x03808B01, 0x0380BC01, 0x0380ED01, 0x03811E01, 0x03814F01,
   0x03818001, 0x0381B101, 0x0381E301, 0x03821401, 0x03824501, 0x03827601, 0x0382A701, 0x0382D801,
   0x03830901, 0x03833A01, 0x03836B01, 0x03839D01, 0x0383CE01, 0x0383FF01, 0x03843001, 0x03846101,
   0x03849201, 0x0384C301, 0x0384F501, 0x03852601, 0x03855701, 0x03858801, 0x0385B901, 0x0385EA01,
   0x03861B01, 0x03864D01, 0x03867E01, 0x0386AF01, 0x0386E001, 0x03871101, 0x03874201, 0x03877401,
   0x0387A501, 0x0387D601, 0x03880701, 0x03883801, 0x03886901, 0x03889B01, 0x0388CC01, 0x0388FD01,
   0x03892E01, 0x03895F01, 0x03899101, 0x0389C201, 0x0389F301, 0x038A2401, 0x038A5501, 0x038A8701,
   0x038AB801, 0x038AE901, 0x038B1A01, 0x038B4C01, 0x038B7D01, 0x038BAE01, 0x038BDF01, 0x038C1101,
   0x038C4201, 0x038C7301, 0x038CA401, 0x038CD601, 0x038D0701, 0x038D3801, 0x038D6901, 0x038D9B01,
   0x038DCC01, 0x038DFD01, 0x038E2E01, 0x038E6001, 0x038E9101, 0x038EC201, 0x038EF301, 0x038F2501,
   0x038F5601, 0x038F8701, 0x038FB901, 0x038FEA01, 0x03901B01, 0x03904C01, 0x03907E01, 0x0390AF01,
   0x0390E001, 0x03911201, 0x03914301, 0x03917401, 0x0391A601, 0x0391D701, 0x03920801, 0x03923901,
   0x03926B01, 0x03929C01, 0x0392CD01, 0x0392FF01, 0x03933001, 0x03936101, 0x03939301, 0x0393C401,
   0x0393F501, 0x03942701, 0x03945801, 0x03948A01, 0x0394BB01, 0x0394EC01, 0x03951E01, 0x03954F01,
   0x03958001, 0x0395B201, 0x0395E301, 0x03961401, 0x03964601, 0x03967701, 0x0396A901, 0x0396DA01,
   0x03970B01, 0x03973D01, 0x03976E01, 0x0397A001, 0x0397D101, 0x03980201, 0x03983401, 0x03986501,
   0x03989701, 0x0398C801, 0x0398F901, 0x03992B01, 0x03995C01, 0x03998E01, 0x0399BF01, 0x0399F001,
   0x039A2201, 0x039A5301, 0x039A8501, 0x039AB601, 0x039AE801, 0x039B1901, 0x039B4A01, 0x039B7C01,
   0x039BAD01, 0x039BDF01, 0x039C1001, 0x039C4201, 0x039C7301, 0x039CA501, 0x039CD601, 0x039D0801,
   0x039D3901, 0x039D6A01, 0x039D9C01, 0x039DCD01, 0x039DFF01, 0x039E3001, 0x039E6201, 0x039E9301,
   0x039EC501, 0x039EF601, 0x039F2801, 0x039F5901, 0x039F8B01, 0x039FBC01, 0x039FEE01, 0x03A01F01,
   0x03A05101, 0x03A08201, 0x03A0B401, 0x03A0E501, 0x03A11701, 0x03A14801, 0x03A17A01, 0x03A1AB01,
   0x03A1DD01, 0x03A20F01, 0x03A24001, 0x03A27201, 0x03A2A301, 0x03A2D501, 0x03A30601, 0x03A33801,
   0x03A36901, 0x03A39B01, 0x03A3CC01, 0x03A3FE01, 0x03A43001, 0x03A46101, 0x03A49301, 0x03A4C401,
   0x03A4F601, 0x03A52701, 0x03A55901, 0x03A58B01, 0x03A5BC01, 0x03A5EE01, 0x03A61F01, 0x03A65101,
   0x03A68201, 0x03A6B401, 0x03A6E601, 0x03A71701, 0x03A74901, 0x03A77A01, 0x03A7AC01, 0x03A7DE01,
   0x03A80F01, 0x03A84101, 0x03A87301, 0x03A8A401, 0x03A8D601, 0x03A90701, 0x03A93901, 0x03A96B01,
   0x03A99C01, 0x03A9CE01, 0x03AA0001, 0x03AA3101, 0x03AA6301, 0x03AA9501, 0x03AAC601, 0x03AAF801,
   0x03AB2901, 0x03AB5B01, 0x03AB8D01, 0x03ABBE01, 0x03ABF001, 0x03AC2201, 0x03AC5301, 0x03AC8501,
   0x03ACB701, 0x03ACE801, 0x03AD1A01, 0x03AD4C01, 0x03AD7D01, 0x03ADAF01, 0x03ADE101, 0x03AE1301,
   0x03AE4401, 0x03AE7601, 0x03AEA801, 0x03AED901, 0x03AF0B01, 0x03AF3D01, 0x03AF6E01, 0x03AFA001,
   0x03AFD201, 0x03B00401, 0x03B03501, 0x03B06701, 0x03B09901, 0x03B0CB01, 0x03B0FC01, 0x03B12E01,
   0x03B16001, 0x03B19101, 0x03B1C301, 0x03B1F501, 0x03B22701, 0x03B25801, 0x03B28A01, 0x03B2BC01,
   0x03B2EE01, 0x03B31F01, 0x03B35101, 0x03B38301, 0x03B3B501, 0x03B3E601, 0x03B41801, 0x03B44A01,
   0x03B47C01, 0x03B4AE01, 0x03B4DF01, 0x03B51101, 0x03B54301, 0x03B57501, 0x03B5A701, 0x03B5D801,
   0x03B60A01, 0x03B63C01, 0x03B66E01, 0x03B6A001, 0x03B6D101, 0x03B70301, 0x03B73501, 0x03B76701,
   0x03B79901, 0x03B7CA01, 0x03B7FC01, 0x03B82E01, 0x03B86001, 0x03B89201, 0x03B8C401, 0x03B8F501,
   0x03B92701, 0x03B95901, 0x03B98B01, 0x03B9BD01, 0x03B9EF01, 0x03BA2001, 0x03BA5201, 0x03BA8401,
   0x03BAB601, 0x03BAE801, 0x03BB1A01, 0x03BB4C01, 0x03BB7D01, 0x03BBAF01, 0x03BBE101, 0x03BC1301,
   0x03BC4501, 0x03BC7701, 0x03BCA901, 0x03BCDB01, 0x03BD0C01, 0x03BD3E01, 0x03BD7001, 0x03BDA201,
   0x03BDD401, 0x03BE0601, 0x03BE3801, 0x03BE6A01, 0x03BE9C01, 0x03BECE01, 0x03BEFF01, 0x03BF3101,
   0x03BF6301, 0x03BF9501, 0x03BFC701, 0x03BFF901, 0x03C02B01, 0x03C05D01, 0x03C08F01, 0x03C0C101,
   0x03C0F301, 0x03C12501, 0x03C15701, 0x03C18901, 0x03C1BB01, 0x03C1EC01, 0x03C21E01, 0x03C25001,
   0x03C28201, 0x03C2B401, 0x03C2E601, 0x03C31801, 0x03C34A01, 0x03C37C01, 0x03C3AE01, 0x03C3E001,
   0x03C41201, 0x03C44401, 0x03C47601, 0x03C4A801, 0x03C4DA01, 0x03C50C01, 0x03C53E01, 0x03C57001,
   0x03C5A201, 0x03C5D401, 0x03C60601, 0x03C63801, 0x03C66A01, 0x03C69C01, 0x03C6CE01, 0x03C70001,
   0x03C73201, 0x03C76401, 0x03C79601, 0x03C7C801, 0x03C7FA01, 0x03C82C01, 0x03C85E01, 0x03C89001,
   0x03C8C201, 0x03C8F401, 0x03C92601, 0x03C95901, 0x03C98B01, 0x03C9BD01, 0x03C9EF01, 0x03CA2101,
   0x03CA5301, 0x03CA8501, 0x03CAB701, 0x03CAE901, 0x03CB1B01, 0x03CB4D01, 0x03CB7F01, 0x03CBB101,
   0x03CBE301, 0x03CC1501, 0x03CC4801, 0x03CC7A01, 0x03CCAC01, 0x03CCDE01, 0x03CD1001, 0x03CD4201,
   0x03CD7401, 0x03CDA601, 0x03CDD801, 0x03CE0A01, 0x03CE3D01, 0x03CE6F01, 0x03CEA101, 0x03CED301,
   0x03CF0501, 0x03CF3701, 0x03CF6901, 0x03CF9B01, 0x03CFCD01, 0x03D00001, 0x03D03201, 0x03D06401,
   0x03D09601, 0x03D0C801, 0x03D0FA01, 0x03D12C01, 0x03D15F01, 0x03D19101, 0x03D1C301, 0x03D1F501,
   0x03D22701, 0x03D25901, 0x03D28C01, 0x03D2BE01, 0x03D2F001, 0x03D32201, 0x03D35401, 0x03D38601,
   0x03D3B901, 0x03D3EB01, 0x03D41D01, 0x03D44F01, 0x03D48101, 0x03D4B401, 0x03D4E601, 0x03D51801,
   0x03D54A01, 0x03D57C01, 0x03D5AF01, 0x03D5E101, 0x03D61301, 0x03D64501, 0x03D67701, 0x03D6AA01,
   0x03D6DC01, 0x03D70E01, 0x03D74001, 0x03D77301, 0x03D7A501, 0x03D7D701, 0x03D80901, 0x03D83B01,
   0x03D86E01, 0x03D8A001, 0x03D8D201, 0x03D90401, 0x03D93701, 0x03D96901, 0x03D99B01, 0x03D9CD01,
   0x03DA0001, 0x03DA3201, 0x03DA6401, 0x03DA9701, 0x03DAC901, 0x03DAFB01, 0x03DB2D01, 0x03DB6001,
   0x03DB9201, 0x03DBC401, 0x03DBF601, 0x03DC2901, 0x03DC5B01, 0x03DC8D01, 0x03DCC001, 0x03DCF201,
   0x03DD2401, 0x03DD5701, 0x03DD8901, 0x03DDBB01, 0x03DDED01, 0x03DE2001, 0x03DE5201, 0x03DE8401,
   0x03DEB701, 0x03DEE901, 0x03DF1B01, 0x03DF4E01, 0x03DF8001, 0x03DFB201, 0x03DFE501, 0x03E01701,
   0x03E04901, 0x03E07C01, 0x03E0AE01, 0x03E0E001, 0x03E11301, 0x03E14501, 0x03E17701, 0x03E1AA01,
   0x03E1DC01, 0x03E20F01, 0x03E24101, 0x03E27301, 0x03E2A601, 0x03E2D801, 0x03E30A01, 0x03E33D01,
   0x03E36F01, 0x03E3A201, 0x03E3D401, 0x03E40601, 0x03E43901, 0x03E46B01, 0x03E49E01, 0x03E4D001,
   0x03E50201, 0x03E53501, 0x03E56701, 0x03E59A01, 0x03E5CC01, 0x03E5FE01, 0x03E63101, 0x03E66301,
   0x03E69601, 0x03E6C801, 0x03E6FA01, 0x03E72D01, 0x03E75F01, 0x03E79201, 0x03E7C401, 0x03E7F701,
   0x03E82901, 0x03E85C01, 0x03E88E01, 0x03E8C001, 0x03E8F301, 0x03E92501, 0x03E95801, 0x03E98A01,
   0x03E9BD01, 0x03E9EF01, 0x03EA2201, 0x03EA5401, 0x03EA8701, 0x03EAB901, 0x03EAEB01, 0x03EB1E01,
   0x03EB5001, 0x03EB8301, 0x03EBB501, 0x03EBE801, 0x03EC1A01, 0x03EC4D01, 0x03EC7F01, 0x03ECB201,
   0x03ECE401, 0x03ED1701, 0x03ED4901, 0x03ED7C01, 0x03EDAE01, 0x03EDE101, 0x03EE1301, 0x03EE4601,
   0x03EE7801, 0x03EEAB01, 0x03EEDE01, 0x03EF1001, 0x03EF4301, 0x03EF7501, 0x03EFA801, 0x03EFDA01,
   0x03F00D01, 0x03F03F01, 0x03F07201, 0x03F0A401, 0x03F0D701, 0x03F10901, 0x03F13C01, 0x03F16F01,
   0x03F1A101, 0x03F1D401, 0x03F20601, 0x03F23901, 0x03F26B01, 0x03F29E01, 0x03F2D101, 0x03F30301,
   0x03F33601, 0x03F36801, 0x03F39B01, 0x03F3CD01, 0x03F40001, 0x03F43301, 0x03F46501, 0x03F49801,
   0x03F4CA01, 0x03F4FD01, 0x03F53001, 0x03F56201, 0x03F59501, 0x03F5C701, 0x03F5FA01, 0x03F62D01,
   0x03F65F01, 0x03F69201, 0x03F6C501, 0x03F6F701, 0x03F72A01, 0x03F75C01, 0x03F78F01, 0x03F7C201,
   0x03F7F401, 0x03F82701, 0x03F85A01, 0x03F88C01, 0x03F8BF01, 0x03F8F201, 0x03F92401, 0x03F95701,
   0x03F98A01, 0x03F9BC01, 0x03F9EF01, 0x03FA2101, 0x03FA5401, 0x03FA8701, 0x03FABA01, 0x03FAEC01,
   0x03FB1F01, 0x03FB5201, 0x03FB8401, 0x03FBB701, 0x03FBEA01, 0x03FC1C01, 0x03FC4F01, 0x03FC8201,
   0x03FCB401, 0x03FCE701, 0x03FD1A01, 0x03FD4C01, 0x03FD7F01, 0x03FDB201, 0x03FDE501, 0x03FE1701,
   0x03FE4A01, 0x03FE7D01, 0x03FEAF01, 0x03FEE201, 0x03FF1501, 0x03FF4801, 0x03FF7A01, 0x03FFAD01,
   0x03FFE001, 0x02000900, 0x02002200, 0x02003C00, 0x02005500, 0x02006F00, 0x02008800, 0x0200A100,
   0x0200BB00, 0x0200D400, 0x0200ED00, 0x02010700, 0x02012000, 0x02013A00, 0x02015300, 0x02016C00,
   0x02018600, 0x02019F00, 0x0201B900, 0x0201D200, 0x0201EB00, 0x02020500, 0x02021E00, 0x02023700,
   0x02025100, 0x02026A00, 0x02028400, 0x02029D00, 0x0202B600, 0x0202D000, 0x0202E900, 0x02030300,
   0x02031C00, 0x02033600, 0x02034F00, 0x02036800, 0x02038200, 0x02039B00, 0x0203B500, 0x0203CE00,
   0x0203E700, 0x02040100, 0x02041A00, 0x02043400, 0x02044D00, 0x02046700, 0x02048000, 0x02049900,
   0x0204B300, 0x0204CC00, 0x0204E600, 0x0204FF00, 0x02051900, 0x02053200, 0x02054B00, 0x02056500,
   0x02057E00, 0x02059800, 0x0205B100, 0x0205CB00, 0x0205E400, 0x0205FD00, 0x02061700, 0x02063000,
   0x02064A00, 0x02066300, 0x02067D00, 0x02069600, 0x0206B000, 0x0206C900, 0x0206E300, 0x0206FC00,
   0x02071500, 0x02072F00, 0x02074800, 0x02076200, 0x02077B00, 0x02079500, 0x0207AE00, 0x0207C800,
   0x0207E100, 0x0207FB00, 0x02081400, 0x02082E00, 0x02084700, 0x02086000, 0x02087A00, 0x02089300,
   0x0208AD00, 0x0208C600, 0x0208E000, 0x0208F900, 0x02091300, 0x02092C00, 0x02094600, 0x02095F00,
   0x02097900, 0x02099200, 0x0209AC00, 0x0209C500, 0x0209DF00, 0x0209F800, 0x020A1200, 0x020A2B00,
   0x020A4500, 0x020A5E00, 0x020A7800, 0x020A9100, 0x020AAB00, 0x020AC400, 0x020ADE00, 0x020AF700,
   0x020B1100, 0x020B2A00, 0x020B4400, 0x020B5D00, 0x020B7700, 0x020B9000, 0x020BAA00, 0x020BC300,
   0x020BDD00, 0x020BF600, 0x020C1000, 0x020C2900, 0x020C4300, 0x020C5C00, 0x020C7600, 0x020C8F00,
   0x020CA900, 0x020CC200, 0x020CDC00, 0x020CF600, 0x020D0F00, 0x020D2900, 0x020D4200, 0x020D5C00,
   0x020D7500, 0x020D8F00, 0x020DA800, 0x020DC200, 0x020DDB00, 0x020DF500, 0x020E0E00, 0x020E2800,
   0x020E4100, 0x020E5B00, 0x020E7500, 0x020E8E00, 0x020EA800, 0x020EC100, 0x020EDB00, 0x020EF400,
   0x020F0E00, 0x020F2700, 0x020F4100, 0x020F5B00, 0x020F7400, 0x020F8E00, 0x020FA700, 0x020FC100,
   0x020FDA00, 0x020FF400, 0x02100D00, 0x02102700, 0x02104100, 0x02105A00, 0x02107400, 0x02108D00,
   0x0210A700, 0x0210C000, 0x0210DA00, 0x0210F400, 0x02110D00, 0x02112700, 0x02114000, 0x02115A00,
   0x02117400, 0x02118D00, 0x0211A700, 0x0211C000, 0x0211DA00, 0x0211F300, 0x02120D00, 0x02122700,
   0x02124000, 0x02125A00, 0x02127300, 0x02128D00, 0x0212A700, 0x0212C000, 0x0212DA00, 0x0212F300,
   0x02130D00, 0x02132700, 0x02134000, 0x02135A00, 0x02137300, 0x02138D00, 0x0213A700, 0x0213C000,
   0x0213DA00, 0x0213F300, 0x02140D00, 0x02142700, 0x02144000, 0x02145A00, 0x02147400, 0x02148D00,
   0x0214A700, 0x0214C000, 0x0214DA00, 0x0214F400, 0x02150D00, 0x02152700, 0x02154100, 0x02155A00,
   0x02157400, 0x02158D00, 0x0215A700, 0x0215C100, 0x0215DA00, 0x0215F400, 0x02160E00, 0x02162700,
   0x02164100, 0x02165B00, 0x02167400, 0x02168E00, 0x0216A700, 0x0216C100, 0x0216DB00, 0x0216F400,
   0x02170E00, 0x02172800, 0x02174100, 0x02175B00, 0x02177500, 0x02178E00, 0x0217A800, 0x0217C200,
   0x0217DB00, 0x0217F500, 0x02180F00, 0x02182800, 0x02184200, 0x02185C00, 0x02187500, 0x02188F00,
   0x0218A900, 0x0218C200, 0x0218DC00, 0x0218F600, 0x02190F00, 0x02192900, 0x02194300, 0x02195C00,
   0x02197600, 0x02199000, 0x0219A900, 0x0219C300, 0x0219DD00, 0x0219F600, 0x021A1000, 0x021A2A00,
   0x021A4400, 0x021A5D00, 0x021A7700, 0x021A9100, 0x021AAA00, 0x021AC400, 0x021ADE00, 0x021AF700,
   0x021B1100, 0x021B2B00, 0x021B4400, 0x021B5E00, 0x021B7800, 0x021B9200, 0x021BAB00, 0x021BC500,
   0x021BDF00, 0x021BF800, 0x021C1200, 0x021C2C00, 0x021C4600, 0x021C5F00, 0x021C7900, 0x021C9300,
   0x021CAC00, 0x021CC600, 0x021CE000, 0x021CFA00, 0x021D1300, 0x021D2D00, 0x021D4700, 0x021D6000,
   0x021D7A00, 0x021D9400, 0x021DAE00, 0x021DC700, 0x021DE100, 0x021DFB00, 0x021E1500, 0x021E2E00,
   0x021E4800, 0x021E6200, 0x021E7C00, 0x021E9500, 0x021EAF00, 0x021EC900, 0x021EE200, 0x021EFC00,
   0x021F1600, 0x021F3000, 0x021F4900, 0x021F6300, 0x021F7D00, 0x021F9700, 0x021FB000, 0x021FCA00,
   0x021FE400, 0x021FFE00, 0x02201700, 0x02203100, 0x02204B00, 0x02206500, 0x02207F00, 0x02209800,
   0x0220B200, 0x0220CC00, 0x0220E600, 0x0220FF00, 0x02211900, 0x02213300, 0x02214D00, 0x02216600,
   0x02218000, 0x02219A00, 0x0221B400, 0x0221CE00, 0x0221E700, 0x02220100, 0x02221B00, 0x02223500,
   0x02224E00, 0x02226800, 0x02228200, 0x02229C00, 0x0222B600, 0x0222CF00, 0x0222E900, 0x02230300,
   0x02231D00, 0x02233700, 0x02235000, 0x02236A00, 0x02238400, 0x02239E00, 0x0223B800, 0x0223D100,
   0x0223EB00, 0x02240500, 0x02241F00, 0x02243900, 0x02245200, 0x02246C00, 0x02248600, 0x0224A000,
   0x0224BA00, 0x0224D300, 0x0224ED00, 0x02250700, 0x02252100, 0x02253B00, 0x02255500, 0x02256E00,
   0x02258800, 0x0225A200, 0x0225BC00, 0x0225D600, 0x0225EF00, 0x02260900, 0x02262300, 0x02263D00,
   0x02265700, 0x02267100, 0x02268A00, 0x0226A400, 0x0226BE00, 0x0226D800, 0x0226F200, 0x02270C00,
   0x02272500, 0x02273F00, 0x02275900, 0x02277300, 0x02278D00, 0x0227A700, 0x0227C100, 0x0227DA00,
   0x0227F400, 0x02280E00, 0x02282800, 0x02284200, 0x02285C00, 0x02287600, 0x02288F00, 0x0228A900,
   0x0228C300, 0x0228DD00, 0x0228F700, 0x02291100, 0x02292B00, 0x02294400, 0x02295E00, 0x02297800,
   0x02299200, 0x0229AC00, 0x0229C600, 0x0229E000, 0x0229FA00, 0x022A1300, 0x022A2D00, 0x022A4700,
   0x022A6100, 0x022A7B00, 0x022A9500, 0x022AAF00, 0x022AC900, 0x022AE200, 0x022AFC00, 0x022B1600,
   0x022B3000, 0x022B4A00, 0x022B6400, 0x022B7E00, 0x022B9800, 0x022BB200, 0x022BCB00, 0x022BE500,
   0x022BFF00, 0x022C1900, 0x022C3300, 0x022C4D00, 0x022C6700, 0x022C8100, 0x022C9B00, 0x022CB500,
   0x022CCE00, 0x022CE800, 0x022D0200, 0x022D1C00, 0x022D3600, 0x022D5000, 0x022D6A00, 0x022D8400,
   0x022D9E00, 0x022DB800, 0x022DD200, 0x022DEC00, 0x022E0500, 0x022E1F00, 0x022E3900, 0x022E5300,
   0x022E6D00, 0x022E8700, 0x022EA100, 0x022EBB00, 0x022ED500, 0x022EEF00, 0x022F0900, 0x022F2300,
   0x022F3D00, 0x022F5700, 0x022F7000, 0x022F8A00, 0x022FA400, 0x022FBE00, 0x022FD800, 0x022FF200,
   0x02300C00, 0x02302600, 0x02304000, 0x02305A00, 0x02307400, 0x02308E00, 0x0230A800, 0x0230C200,
   0x0230DC00, 0x0230F600, 0x02311000, 0x02312A00, 0x02314400, 0x02315D00, 0x02317700, 0x02319100,
   0x0231AB00, 0x0231C500, 0x0231DF00, 0x0231F900, 0x02321300, 0x02322D00, 0x02324700, 0x02326100,
   0x02327B00, 0x02329500, 0x0232AF00, 0x0232C900, 0x0232E300, 0x0232FD00, 0x02331700, 0x02333100,
   0x02334B00, 0x02336500, 0x02337F00, 0x02339900, 0x0233B300, 0x0233CD00, 0x0233E700, 0x02340100,
   0x02341B00, 0x02343500, 0x02344F00, 0x02346900, 0x02348300, 0x02349D00, 0x0234B700, 0x0234D100,
   0x0234EB00, 0x02350500, 0x02351F00, 0x02353900, 0x02355300, 0x02356D00, 0x02358700, 0x0235A100,
   0x0235BB00, 0x0235D500, 0x0235EF00, 0x02360900, 0x02362300, 0x02363D00, 0x02365700, 0x02367100,
   0x02368B00, 0x0236A500, 0x0236BF00, 0x0236D900, 0x0236F300, 0x02370D00, 0x02372700, 0x02374100,
   0x02375B00, 0x02377500, 0x02378F00, 0x0237A900, 0x0237C300, 0x0237DD00, 0x0237F700, 0x02381100,
   0x02382B00, 0x02384500, 0x02386000, 0x02387A00, 0x02389400, 0x0238AE00, 0x0238C800, 0x0238E200,
   0x0238FC00, 0x02391600, 0x02393000, 0x02394A00, 0x02396400, 0x02397E00, 0x02399800, 0x0239B200,
   0x0239CC00, 0x0239E600, 0x023A0000, 0x023A1A00, 0x023A3400, 0x023A4F00, 0x023A6900, 0x023A8300,
   0x023A9D00, 0x023AB700, 0x023AD100, 0x023AEB00, 0x023B0500, 0x023B1F00, 0x023B3900, 0x023B5300,
   0x023B6D00, 0x023B8700, 0x023BA100, 0x023BBC00, 0x023BD600, 0x023BF000, 0x023C0A00, 0x023C2400,
   0x023C3E00, 0x023C5800, 0x023C7200, 0x023C8C00, 0x023CA600, 0x023CC000, 0x023CDA00, 0x023CF500,
   0x023D0F00, 0x023D2900, 0x023D4300, 0x023D5D00, 0x023D7700, 0x023D9100, 0x023DAB00, 0x023DC500,
   0x023DDF00, 0x023DFA00, 0x023E1400, 0x023E2E00, 0x023E4800, 0x023E6200, 0x023E7C00, 0x023E9600,
   0x023EB000, 0x023ECA00, 0x023EE500, 0x023EFF00, 0x023F1900, 0x023F3300, 0x023F4D00, 0x023F6700,
   0x023F8100, 0x023F9B00, 0x023FB500, 0x023FD000, 0x023FEA00, 0x02400400, 0x02401E00, 0x02403800,
   0x02405200, 0x02406C00, 0x02408700, 0x0240A100, 0x0240BB00, 0x0240D500, 0x0240EF00, 0x02410900,
   0x02412300, 0x02413D00, 0x02415800, 0x02417200, 0x02418C00, 0x0241A600, 0x0241C000, 0x0241DA00,
   0x0241F500, 0x02420F00, 0x02422900, 0x02424300, 0x02425D00, 0x02427700, 0x02429100, 0x0242AC00,
   0x0242C600, 0x0242E000, 0x0242FA00, 0x02431400, 0x02432E00, 0x02434900, 0x02436300, 0x02437D00,
   0x02439700, 0x0243B100, 0x0243CB00, 0x0243E600, 0x02440000, 0x02441A00, 0x02443400, 0x02444E00,
   0x02446800, 0x02448300, 0x02449D00, 0x0244B700, 0x0244D100, 0x0244EB00, 0x02450600, 0x02452000,
   0x02453A00, 0x02455400, 0x02456E00, 0x02458800, 0x0245A300, 0x0245BD00, 0x0245D700, 0x0245F100,
   0x02460B00, 0x02462600, 0x02464000, 0x02465A00, 0x02467400, 0x02468E00, 0x0246A900, 0x0246C300,
   0x0246DD00, 0x0246F700, 0x02471100, 0x02472C00, 0x02474600, 0x02476000, 0x02477A00, 0x02479500,
   0x0247AF00, 0x0247C900, 0x0247E300, 0x0247FD00, 0x02481800, 0x02483200, 0x02484C00, 0x02486600,
   0x02488000, 0x02489B00, 0x0248B500, 0x0248CF00, 0x0248E900, 0x02490400, 0x02491E00, 0x02493800,
   0x02495200, 0x02496D00, 0x02498700, 0x0249A100, 0x0249BB00, 0x0249D500, 0x0249F000, 0x024A0A00,
   0x024A2400, 0x024A3E00, 0x024A5900, 0x024A7300, 0x024A8D00, 0x024AA700, 0x024AC200, 0x024ADC00,
   0x024AF600, 0x024B1000, 0x024B2B00, 0x024B4500, 0x024B5F00, 0x024B7900, 0x024B9400, 0x024BAE00,
   0x024BC800, 0x024BE200, 0x024BFD00, 0x024C1700, 0x024C3100, 0x024C4C00, 0x024C6600, 0x024C8000,
   0x024C9A00, 0x024CB500, 0x024CCF00, 0x024CE900, 0x024D0300, 0x024D1E00, 0x024D3800, 0x024D5200,
   0x024D6D00, 0x024D8700, 0x024DA100, 0x024DBB00, 0x024DD600, 0x024DF000, 0x024E0A00, 0x024E2500,
   0x024E3F00, 0x024E5900, 0x024E7300, 0x024E8E00, 0x024EA800, 0x024EC200, 0x024EDD00, 0x024EF700,
   0x024F1100, 0x024F2B00, 0x024F4600, 0x024F6000, 0x024F7A00, 0x024F9500, 0x024FAF00, 0x024FC900,
   0x024FE400, 0x024FFE00, 0x02501800, 0x02503200, 0x02504D00, 0x02506700, 0x02508100, 0x02509C00,
   0x0250B600, 0x0250D000, 0x0250EB00, 0x02510500, 0x02511F00, 0x02513A00, 0x02515400, 0x02516E00,
   0x02518900, 0x0251A300, 0x0251BD00, 0x0251D800, 0x0251F200, 0x02520C00, 0x02522700, 0x02524100,
   0x02525B00, 0x02527600, 0x02529000, 0x0252AA00, 0x0252C500, 0x0252DF00, 0x0252F900, 0x02531400,
   0x02532E00, 0x02534800, 0x02536300, 0x02537D00, 0x02539700, 0x0253B200, 0x0253CC00, 0x0253E600,
   0x02540100, 0x02541B00, 0x02543500, 0x02545000, 0x02546A00, 0x02548500, 0x02549F00, 0x0254B900,
   0x0254D400, 0x0254EE00, 0x02550800, 0x02552300, 0x02553D00, 0x02555700, 0x02557200, 0x02558C00,
   0x0255A700, 0x0255C100, 0x0255DB00, 0x0255F600, 0x02561000, 0x02562A00, 0x02564500, 0x02565F00,
   0x02567A00, 0x02569400, 0x0256AE00, 0x0256C900, 0x0256E300, 0x0256FD00, 0x02571800, 0x02573200,
   0x02574D00, 0x02576700, 0x02578100, 0x02579C00, 0x0257B600, 0x0257D100, 0x0257EB00, 0x02580500,
   0x02582000, 0x02583A00, 0x02585500, 0x02586F00, 0x02588900, 0x0258A400, 0x0258BE00, 0x0258D900,
   0x0258F300, 0x02590D00, 0x02592800, 0x02594200, 0x02595D00, 0x02597700, 0x02599100, 0x0259AC00,
   0x0259C600, 0x0259E100, 0x0259FB00, 0x025A1500, 0x025A3000, 0x025A4A00, 0x025A6500, 0x025A7F00,
   0x025A9A00, 0x025AB400, 0x025ACE00, 0x025AE900, 0x025B0300, 0x025B1E00, 0x025B3800, 0x025B5300,
   0x025B6D00, 0x025B8700, 0x025BA200, 0x025BBC00, 0x025BD700, 0x025BF100, 0x025C0C00, 0x025C2600,
   0x025C4100, 0x025C5B00, 0x025C7500, 0x025C9000, 0x025CAA00, 0x025CC500, 0x025CDF00, 0x025CFA00,
   0x025D1400, 0x025D2F00, 0x025D4900, 0x025D6300, 0x025D7E00, 0x025D9800, 0x025DB300, 0x025DCD00,
   0x025DE800, 0x025E0200, 0x025E1D00, 0x025E3700, 0x025E5200, 0x025E6C00, 0x025E8700, 0x025EA100,
   0x025EBB00, 0x025ED600, 0x025EF000, 0x025F0B00, 0x025F2500, 0x025F4000, 0x025F5A00, 0x025F7500,
   0x025F8F00, 0x025FAA00, 0x025FC400, 0x025FDF00, 0x025FF900, 0x02601400, 0x02602E00, 0x02604900,
   0x02606300, 0x02607E00, 0x02609800, 0x0260B300, 0x0260CD00, 0x0260E800, 0x02610200, 0x02611D00,
   0x02613700, 0x02615200, 0x02616C00, 0x02618700, 0x0261A100, 0x0261BC00, 0x0261D600, 0x0261F100,
   0x02620B00, 0x02622600, 0x02624000, 0x02625B00, 0x02627500, 0x02629000, 0x0262AA00, 0x0262C500,
   0x0262DF00, 0x0262FA00, 0x02631400, 0x02632F00, 0x02634900, 0x02636400, 0x02637E00, 0x02639900,
   0x0263B300, 0x0263CE00, 0x0263E800, 0x02640300, 0x02641D00, 0x02643800, 0x02645200, 0x02646D00,
   0x02648800, 0x0264A200, 0x0264BD00, 0x0264D700, 0x0264F200, 0x02650C00, 0x02652700, 0x02654100,
   0x02655C00, 0x02657600, 0x02659100, 0x0265AB00, 0x0265C600, 0x0265E100, 0x0265FB00, 0x02661600,
   0x02663000, 0x02664B00, 0x02666500, 0x02668000, 0x02669A00, 0x0266B500, 0x0266D000, 0x0266EA00,
   0x02670500, 0x02671F00, 0x02673A00, 0x02675400, 0x02676F00, 0x02678900, 0x0267A400, 0x0267BF00,
   0x0267D900, 0x0267F400, 0x02680E00, 0x02682900, 0x02684300, 0x02685E00, 0x02687900, 0x02689300,
   0x0268AE00, 0x0268C800, 0x0268E300, 0x0268FD00, 0x02691800, 0x02693300, 0x02694D00, 0x02696800,
   0x02698200, 0x02699D00, 0x0269B800, 0x0269D200, 0x0269ED00, 0x026A0700, 0x026A2200, 0x026A3D00,
   0x026A5700, 0x026A7200, 0x026A8C00, 0x026AA700, 0x026AC200, 0x026ADC00, 0x026AF700, 0x026B1100,
   0x026B2C00, 0x026B4700, 0x026B6100, 0x026B7C00, 0x026B9600, 0x026BB100, 0x026BCC00, 0x026BE600,
   0x026C0100, 0x026C1B00, 0x026C3600, 0x026C5100, 0x026C6B00, 0x026C8600, 0x026CA000, 0x026CBB00,
   0x026CD600, 0x026CF000, 0x026D0B00, 0x026D2600, 0x026D4000, 0x026D5B00, 0x026D7500, 0x026D9000,
   0x026DAB00, 0x026DC500, 0x026DE000, 0x026DFB00, 0x026E1500, 0x026E3000, 0x026E4B00, 0x026E6500,
   0x026E8000, 0x026E9A00, 0x026EB500, 0x026ED000, 0x026EEA00, 0x026F0500, 0x026F2000, 0x026F3A00,
   0x026F5500, 0x026F7000, 0x026F8A00, 0x026FA500, 0x026FC000, 0x026FDA00, 0x026FF500, 0x02701000,
   0x02702A00, 0x02704500, 0x02706000, 0x02707A00, 0x02709500, 0x0270B000, 0x0270CA00, 0x0270E500,
   0x0270FF00, 0x02711A00, 0x02713500, 0x02715000, 0x02716A00, 0x02718500, 0x0271A000, 0x0271BA00,
   0x0271D500, 0x0271F000, 0x02720A00, 0x02722500, 0x02724000, 0x02725A00, 0x02727500, 0x02729000,
   0x0272AA00, 0x0272C500, 0x0272E000, 0x0272FA00, 0x02731500, 0x02733000, 0x02734A00, 0x02736500,
   0x02738000, 0x02739B00, 0x0273B500, 0x0273D000, 0x0273EB00, 0x02740500, 0x02742000, 0x02743B00,
   0x02745500, 0x02747000, 0x02748B00, 0x0274A600, 0x0274C000, 0x0274DB00, 0x0274F600, 0x02751000,
   0x02752B00, 0x02754600, 0x02756000, 0x02757B00, 0x02759600, 0x0275B100, 0x0275CB00, 0x0275E600,
   0x02760100, 0x02761B00, 0x02763600, 0x02765100, 0x02766C00, 0x02768600, 0x0276A100, 0x0276BC00,
   0x0276D700, 0x0276F100, 0x02770C00, 0x02772700, 0x02774100, 0x02775C00, 0x02777700, 0x02779200,
   0x0277AC00, 0x0277C700, 0x0277E200, 0x0277FD00, 0x02781700, 0x02783200, 0x02784D00, 0x02786800,
   0x02788200, 0x02789D00, 0x0278B800, 0x0278D300, 0x0278ED00, 0x02790800, 0x02792300, 0x02793E00,
   0x02795800, 0x02797300, 0x02798E00, 0x0279A900, 0x0279C300, 0x0279DE00, 0x0279F900, 0x027A1400,
   0x027A2E00, 0x027A4900, 0x027A6400, 0x027A7F00, 0x027A9A00, 0x027AB400, 0x027ACF00, 0x027AEA00,
   0x027B0500, 0x027B1F00, 0x027B3A00, 0x027B5500, 0x027B7000, 0x027B8A00, 0x027BA500, 0x027BC000,
   0x027BDB00, 0x027BF600, 0x027C1000, 0x027C2B00, 0x027C4600, 0x027C6100, 0x027C7C00, 0x027C9600,
   0x027CB100, 0x027CCC00, 0x027CE700, 0x027D0100, 0x027D1C00, 0x027D3700, 0x027D5200, 0x027D6D00,
   0x027D8700, 0x027DA200, 0x027DBD00, 0x027DD800, 0x027DF300, 0x027E0D00, 0x027E2800, 0x027E4300,
   0x027E5E00, 0x027E7900, 0x027E9400, 0x027EAE00, 0x027EC900, 0x027EE400, 0x027EFF00, 0x027F1A00,
   0x027F3400, 0x027F4F00, 0x027F6A00, 0x027F8500, 0x027FA000, 0x027FBB00, 0x027FD500, 0x027FF000,
   0x02800B00, 0x02802600, 0x02804100, 0x02805B00, 0x02807600, 0x02809100, 0x0280AC00, 0x0280C700,
   0x0280E200, 0x0280FC00, 0x02811700, 0x02813200, 0x02814D00, 0x02816800, 0x02818300, 0x02819D00,
   0x0281B800, 0x0281D300, 0x0281EE00, 0x02820900, 0x02822400, 0x02823F00, 0x02825900, 0x02827400,
   0x02828F00, 0x0282AA00, 0x0282C500, 0x0282E000, 0x0282FB00, 0x02831500, 0x02833000, 0x02834B00,
   0x02836600, 0x02838100, 0x02839C00, 0x0283B700, 0x0283D100, 0x0283EC00, 0x02840700, 0x02842200,
   0x02843D00, 0x02845800, 0x02847300, 0x02848D00, 0x0284A800, 0x0284C300, 0x0284DE00, 0x0284F900
};

#endif

