/*
 * GRLIB Driver package Major/Minor device numbering
 *
 * Copyright (c) 2010 Aeroflex Gaisler AB
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
 * MA 02110-1301 USA
 */

#ifndef __GRLIB_DEVNO_H__
#define __GRLIB_DEVNO_H__

/* Device Node Major and Minor Definitions for GRLIB Drivers */

#define GRLIB_MAJOR_BASE 60

#define MAPLIB_MAJOR		GRLIB_MAJOR_BASE
#define GRSPWU_MAJOR		(MAPLIB_MAJOR+1)
#define SPWROUTER_MAJOR		GRSPWU_MAJOR

/* Number of device nodes per driver */
#define MAPLIB_DEVCNT		32
#define GRSPWU_DEVCNT		32
#define SPWROUTER_DEVCNT	4

/* Minor Devices */
#define MAPLIB_MINOR		0
#define GRSPWU_MINOR		0
#define SPWROUTER_MINOR		(GRSPWU_MINOR+GRSPWU_DEVCNT)

#endif
