function next_gvar() {
    return ("v" gvarn++);
}

function scan_space(a, r) {
    r = "";
	while (length(a)) {
		if (!match(a,"^[\n[:space:] \t,]")) {
			break;
		}
		r = substr(a, 1, 1);
		a = substr(a, 1+1);
	}
	scan_space_r = r;
	return a;
}

function scan_string(a, sd, ed, id, r, l, last) {

	a = scan_space(a);
	if (!match(a,("^" sd))) {
		print "No " sd "-string at \"" a "\"";
		exit 1;
	}
	r = substr(a, 1, 1);
	a = substr(a, 1+1);
	last = 0;
	while (length(a) && !last) {
		#print "Next " a;
		if (match(a,("^" ed))) {
			last = 1;
		}
		l = 1;
		if (match(a,("^\\\\" ed))) {
			l = 2;
		}
		r = r substr(a, 1, l);
		a = substr(a, 1+l);
	}
	scan_string_a = a;
        scanstr_r[id] = r;
        scanstr_rs[id] = substr(r,1+length(sd),length(r)-length(sd)-length(ed));
	
	return a;
}

function scan_bracket(a, sd, ed, gvb, gvb2, r, l, last, deep, comment) {

	a = scan_space(a);
	
	if (!match(a,("^" sd))) {
		print "No " sd "-string at \"" a "\"";
		exit 1;
	}
        l = RLENGTH;
	r = ""; #substr(a, 1, l);
	a = substr(a, 1+l);
	last = 0; deep = 1;
	while (length(a) && !last) {
		#print "Next " a;
		if (match(a,("^" ed))) {
			if (--deep == 0) {
				last = RLENGTH;
			}
		} else if (match(a,("^" sd))) {
			deep++;
		}
		l = 1;
                if (last) {
                    l = last;
                }
		if (match(a,("^\\\\" ed))) {
			l = 2;
		}
		if (match(a,"^\"")) {
		    a = scan_string(a, "\"", "\"", gvb2 = next_gvar());
		    r = (r scanstr_r[gvb2]);
		} else if (match(a,"^/\\*")) {
                    comment = scan_comment_o(a, gvb2 = next_gvar());
                    a = gvar[gvb2]
		    r = (r "/*" comment "*/");
                    
		} else {
                        if (!last)
 			    r = r substr(a, 1, l);
			a = substr(a, 1+l);
		}
	}
	gvar[gvb] = a;
	scan_bracket_a = a;
	
	return r;
}

function scan_comment_o(a, gvb,      gvb2, r, l, last, deep) {
	r = ""; scan_comment = "";
	if (match(a,"^[[:blank:]]*\\/\\*[^\\*]+\\*\\/")) {
		r = remove_space(substr(a,RSTART,RLENGTH));
		a = substr(a,RSTART+RLENGTH);
		sub("^\\/\\*","",r);
		sub("\\*\\/$","",r);
		r = remove_space(r);
	}
	gvar[gvb] = remove_space(a);
	scan_comment = remove_space(a);
	
	return r;
}

function resolve_vendor(v, v0) {
    v0 = v;
    v = remove_str(v);
    if (match(v,"^VENDOR_"))
        v = substr(v,RSTART+RLENGTH);
    if (v == "GAISLER") return "0x1";
    if (v == "PENDER") return "0x02";
    if (v == "ESA") return "0x04";
    if (v == "ASTRIUM") return        "0x06";
    if (v == "OPENCHIP") return       "0x07";
    if (v == "OPENCORES") return      "0x08";
    if (v == "CONTRIB") return        "0x09";
    if (v == "EONIC") return          "0x0b";
    if (v == "RADIONOR") return       "0x0f";
    if (v == "GLEICHMANN") return     "0x10";
    if (v == "MENTA") return          "0x11";
    if (v == "SUN") return            "0x13";
    if (v == "MOVIDIA") return        "0x14";
    if (v == "ORBITA") return         "0x17";
    if (v == "SYNOPSYS") return       "0x21";
    if (v == "NASA") return           "0x22";
    if (v == "S3") return             "0x31";
    if (v == "ACTEL") return          "0xac";
    if (v == "APPLECORE") return      "0xae";
    if (v == "CAL") return            "0xca";
    if (v == "CETON") return          "0xcb";
    if (v == "EMBEDDIT") return       "0xea";
    return v0;
}

# use this prog to extract device-ids:
#
#!/usr/bin/perl
#
#sub readfile {
#    my ($in) = @_;
#    usage(\*STDOUT) if (length($in) == 0) ;
#    open IN, "$in" or die "Reading \"$in\":".$!;
#    local $/ = undef;
#    $m = <IN>;
#    close IN;
#    return $m;
#}
#
#%vendors = ();
#%devs = ();
#$idx = 0;
#%i = ();
#foreach my $l (split("\n",readfile($ARGV[0]))) {
#    $idx ++;
#    if ($l =~ /VENDOR_([A-Za-z0-9_]*)\s+([0xa-f0-9]+)/) {
#	$vendors{"$1"} = {'id'=>"$2",'e'=>{}};
#    } elsif ($l =~ /#define ([A-Za-z0-9]+)_([A-Za-z0-9_]+)\s+([0xa-f0-9]+)/) {
#	my ($v,$n,$i) = ($1,$2,$3);
#	if (!exists($vendors{$v})) {
#	    die("Cannot find vendor $l\n");
#	}
#	if (exists($vendors{"$v"}{'e'}{$n})) {
#	    die("$l already exists\n");
#	}
#	$vendors{"$v"}{'e'}{$n} = $i;
#	if (!exists($devs{$n})) {
#	    $devs{$n} = $v;
#	}
#	$i{"${v}_${n}"} = $idx;
#    }
#}
#
#@p = ();
#foreach my $v (keys (%vendors)) {
#    foreach my $n (keys (%{$vendors{$v}{'e'}})) {
#	push(@p, [$v,$n]);
#    }
#}
#
#foreach my $x (sort {  $i{$a->[0]."_".$a->[1]} <=> $i{$b->[0]."_".$b->[1]} } @p) {
#    my $v = $x->[0];
#    my $n = $x->[1];
#    print ("if (v == \"${v}_${n}\") return \"".$vendors{$v}{'e'}{$n}."\";\n");
#    if ($devs{$n} eq $v) {
#	print ("if (v == \"${n}\") return \"".$vendors{$v}{'e'}{$n}."\";\n");
#    }
#}
#

function resolve_device(v) {
    v0 = v;
    v = remove_str(v);
    if (v == "GAISLER_LEON2DSU") return "0x002";
if (v == "LEON2DSU") return "0x002";
if (v == "GAISLER_LEON3") return "0x003";
if (v == "LEON3") return "0x003";
if (v == "GAISLER_LEON3DSU") return "0x004";
if (v == "LEON3DSU") return "0x004";
if (v == "GAISLER_ETHAHB") return "0x005";
if (v == "ETHAHB") return "0x005";
if (v == "GAISLER_APBMST") return "0x006";
if (v == "APBMST") return "0x006";
if (v == "GAISLER_AHBUART") return "0x007";
if (v == "AHBUART") return "0x007";
if (v == "GAISLER_SRCTRL") return "0x008";
if (v == "SRCTRL") return "0x008";
if (v == "GAISLER_SDCTRL") return "0x009";
if (v == "SDCTRL") return "0x009";
if (v == "GAISLER_SSRCTRL") return "0x00a";
if (v == "SSRCTRL") return "0x00a";
if (v == "GAISLER_APBUART") return "0x00c";
if (v == "APBUART") return "0x00c";
if (v == "GAISLER_IRQMP") return "0x00d";
if (v == "IRQMP") return "0x00d";
if (v == "GAISLER_AHBRAM") return "0x00e";
if (v == "AHBRAM") return "0x00e";
if (v == "GAISLER_AHBDPRAM") return "0x00f";
if (v == "AHBDPRAM") return "0x00f";
if (v == "GAISLER_GPTIMER") return "0x011";
if (v == "GPTIMER") return "0x011";
if (v == "GAISLER_PCITRG") return "0x012";
if (v == "PCITRG") return "0x012";
if (v == "GAISLER_PCISBRG") return "0x013";
if (v == "PCISBRG") return "0x013";
if (v == "GAISLER_PCIFBRG") return "0x014";
if (v == "PCIFBRG") return "0x014";
if (v == "GAISLER_PCITRACE") return "0x015";
if (v == "PCITRACE") return "0x015";
if (v == "GAISLER_DMACTRL") return "0x016";
if (v == "DMACTRL") return "0x016";
if (v == "GAISLER_AHBTRACE") return "0x017";
if (v == "AHBTRACE") return "0x017";
if (v == "GAISLER_DSUCTRL") return "0x018";
if (v == "DSUCTRL") return "0x018";
if (v == "GAISLER_CANAHB") return "0x019";
if (v == "CANAHB") return "0x019";
if (v == "GAISLER_GPIO") return "0x01a";
if (v == "GPIO") return "0x01a";
if (v == "GAISLER_AHBROM") return "0x01b";
if (v == "AHBROM") return "0x01b";
if (v == "GAISLER_AHBJTAG") return "0x01c";
if (v == "AHBJTAG") return "0x01c";
if (v == "GAISLER_ETHMAC") return "0x01d";
if (v == "ETHMAC") return "0x01d";
if (v == "GAISLER_SWNODE") return "0x01e";
if (v == "SWNODE") return "0x01e";
if (v == "GAISLER_SPW") return "0x01f";
if (v == "SPW") return "0x01f";
if (v == "GAISLER_AHB2AHB") return "0x020";
if (v == "AHB2AHB") return "0x020";
if (v == "GAISLER_USBDC") return "0x021";
if (v == "USBDC") return "0x021";
if (v == "GAISLER_USB_DCL") return "0x022";
if (v == "USB_DCL") return "0x022";
if (v == "GAISLER_DDRMP") return "0x023";
if (v == "DDRMP") return "0x023";
if (v == "GAISLER_ATACTRL") return "0x024";
if (v == "ATACTRL") return "0x024";
if (v == "GAISLER_DDRSP") return "0x025";
if (v == "DDRSP") return "0x025";
if (v == "GAISLER_EHCI") return "0x026";
if (v == "EHCI") return "0x026";
if (v == "GAISLER_UHCI") return "0x027";
if (v == "UHCI") return "0x027";
if (v == "GAISLER_I2CMST") return "0x028";
if (v == "I2CMST") return "0x028";
if (v == "GAISLER_SPW2") return "0x029";
if (v == "SPW2") return "0x029";
if (v == "GAISLER_AHBDMA") return "0x02a";
if (v == "AHBDMA") return "0x02a";
if (v == "GAISLER_NUHOSP3") return "0x02b";
if (v == "NUHOSP3") return "0x02b";
if (v == "GAISLER_CLKGATE") return "0x02c";
if (v == "CLKGATE") return "0x02c";
if (v == "GAISLER_SPICTRL") return "0x02d";
if (v == "SPICTRL") return "0x02d";
if (v == "GAISLER_DDR2SP") return "0x02e";
if (v == "DDR2SP") return "0x02e";
if (v == "GAISLER_SLINK") return "0x02f";
if (v == "SLINK") return "0x02f";
if (v == "GAISLER_GRTM") return "0x030";
if (v == "GRTM") return "0x030";
if (v == "GAISLER_GRTC") return "0x031";
if (v == "GRTC") return "0x031";
if (v == "GAISLER_GRPW") return "0x032";
if (v == "GRPW") return "0x032";
if (v == "GAISLER_GRCTM") return "0x033";
if (v == "GRCTM") return "0x033";
if (v == "GAISLER_GRHCAN") return "0x034";
if (v == "GRHCAN") return "0x034";
if (v == "GAISLER_GRFIFO") return "0x035";
if (v == "GRFIFO") return "0x035";
if (v == "GAISLER_GRADCDAC") return "0x036";
if (v == "GRADCDAC") return "0x036";
if (v == "GAISLER_GRPULSE") return "0x037";
if (v == "GRPULSE") return "0x037";
if (v == "GAISLER_GRTIMER") return "0x038";
if (v == "GRTIMER") return "0x038";
if (v == "GAISLER_AHB2PP") return "0x039";
if (v == "AHB2PP") return "0x039";
if (v == "GAISLER_GRVERSION") return "0x03a";
if (v == "GRVERSION") return "0x03a";
if (v == "GAISLER_APB2PW") return "0x03b";
if (v == "APB2PW") return "0x03b";
if (v == "GAISLER_PW2APB") return "0x03c";
if (v == "PW2APB") return "0x03c";
if (v == "GAISLER_GRCAN") return "0x03d";
if (v == "GRCAN") return "0x03d";
if (v == "GAISLER_I2CSLV") return "0x03e";
if (v == "I2CSLV") return "0x03e";
if (v == "GAISLER_U16550") return "0x03f";
if (v == "U16550") return "0x03f";
if (v == "GAISLER_AHBMST_EM") return "0x040";
if (v == "AHBMST_EM") return "0x040";
if (v == "GAISLER_AHBSLV_EM") return "0x041";
if (v == "AHBSLV_EM") return "0x041";
if (v == "GAISLER_GRTESTMOD") return "0x042";
if (v == "GRTESTMOD") return "0x042";
if (v == "GAISLER_ASCS") return "0x043";
if (v == "ASCS") return "0x043";
if (v == "GAISLER_IPMVBCTRL") return "0x044";
if (v == "IPMVBCTRL") return "0x044";
if (v == "GAISLER_SPIMCTRL") return "0x045";
if (v == "SPIMCTRL") return "0x045";
if (v == "GAISLER_L4STAT") return "0x047";
if (v == "L4STAT") return "0x047";
if (v == "GAISLER_LEON4") return "0x048";
if (v == "LEON4") return "0x048";
if (v == "GAISLER_LEON4DSU") return "0x049";
if (v == "LEON4DSU") return "0x049";
if (v == "GAISLER_PWM") return "0x04a";
if (v == "PWM") return "0x04a";
if (v == "GAISLER_L2CACHE") return "0x04b";
if (v == "L2CACHE") return "0x04b";
if (v == "GAISLER_SDCTRL64") return "0x04c";
if (v == "SDCTRL64") return "0x04c";
if (v == "GAISLER_GR1553B") return "0x04d";
if (v == "GR1553B") return "0x04d";
if (v == "GAISLER_1553TST") return "0x04e";
if (v == "1553TST") return "0x04e";
if (v == "GAISLER_GRIOMMU") return "0x04f";
if (v == "GRIOMMU") return "0x04f";
if (v == "GAISLER_FTAHBRAM") return "0x050";
if (v == "FTAHBRAM") return "0x050";
if (v == "GAISLER_FTSRCTRL") return "0x051";
if (v == "FTSRCTRL") return "0x051";
if (v == "GAISLER_AHBSTAT") return "0x052";
if (v == "AHBSTAT") return "0x052";
if (v == "GAISLER_LEON3FT") return "0x053";
if (v == "LEON3FT") return "0x053";
if (v == "GAISLER_FTMCTRL") return "0x054";
if (v == "FTMCTRL") return "0x054";
if (v == "GAISLER_FTSDCTRL") return "0x055";
if (v == "FTSDCTRL") return "0x055";
if (v == "GAISLER_FTSRCTRL8") return "0x056";
if (v == "FTSRCTRL8") return "0x056";
if (v == "GAISLER_MEMSCRUB") return "0x057";
if (v == "MEMSCRUB") return "0x057";
if (v == "GAISLER_FTSDCTRL64") return "0x058";
if (v == "FTSDCTRL64") return "0x058";
if (v == "GAISLER_APBPS2") return "0x060";
if (v == "APBPS2") return "0x060";
if (v == "GAISLER_VGACTRL") return "0x061";
if (v == "VGACTRL") return "0x061";
if (v == "GAISLER_LOGAN") return "0x062";
if (v == "LOGAN") return "0x062";
if (v == "GAISLER_SVGACTRL") return "0x063";
if (v == "SVGACTRL") return "0x063";
if (v == "GAISLER_T1AHB") return "0x064";
if (v == "T1AHB") return "0x064";
if (v == "GAISLER_MP7WRAP") return "0x065";
if (v == "MP7WRAP") return "0x065";
if (v == "GAISLER_GRSYSMON") return "0x066";
if (v == "GRSYSMON") return "0x066";
if (v == "GAISLER_GRACECTRL") return "0x067";
if (v == "GRACECTRL") return "0x067";
if (v == "GAISLER_ATAHBSLV") return "0x068";
if (v == "ATAHBSLV") return "0x068";
if (v == "GAISLER_ATAHBMST") return "0x069";
if (v == "ATAHBMST") return "0x069";
if (v == "GAISLER_ATAPBSLV") return "0x06a";
if (v == "ATAPBSLV") return "0x06a";
if (v == "GAISLER_B1553BC") return "0x070";
if (v == "B1553BC") return "0x070";
if (v == "GAISLER_B1553RT") return "0x071";
if (v == "B1553RT") return "0x071";
if (v == "GAISLER_B1553BRM") return "0x072";
if (v == "B1553BRM") return "0x072";
if (v == "GAISLER_AES") return "0x073";
if (v == "AES") return "0x073";
if (v == "GAISLER_ECC") return "0x074";
if (v == "ECC") return "0x074";
if (v == "GAISLER_PCIF") return "0x075";
if (v == "PCIF") return "0x075";
if (v == "GAISLER_CLKMOD") return "0x076";
if (v == "CLKMOD") return "0x076";
if (v == "GAISLER_HAPSTRAK") return "0x077";
if (v == "HAPSTRAK") return "0x077";
if (v == "GAISLER_TEST_1X2") return "0x078";
if (v == "TEST_1X2") return "0x078";
if (v == "GAISLER_WILD2AHB") return "0x079";
if (v == "WILD2AHB") return "0x079";
if (v == "GAISLER_BIO1") return "0x07a";
if (v == "BIO1") return "0x07a";
if (v == "GAISLER_AESDMA") return "0x07b";
if (v == "AESDMA") return "0x07b";
if (v == "GAISLER_GRPCI2") return "0x07c";
if (v == "GRPCI2") return "0x07c";
if (v == "GAISLER_GRPCI2_DMA") return "0x07d";
if (v == "GRPCI2_DMA") return "0x07d";
if (v == "GAISLER_SATCAN") return "0x080";
if (v == "SATCAN") return "0x080";
if (v == "GAISLER_CANMUX") return "0x081";
if (v == "CANMUX") return "0x081";
if (v == "GAISLER_GRTMRX") return "0x082";
if (v == "GRTMRX") return "0x082";
if (v == "GAISLER_GRTCTX") return "0x083";
if (v == "GRTCTX") return "0x083";
if (v == "GAISLER_GRTMDESC") return "0x084";
if (v == "GRTMDESC") return "0x084";
if (v == "GAISLER_GRTMVC") return "0x085";
if (v == "GRTMVC") return "0x085";
if (v == "GAISLER_GEFFE") return "0x086";
if (v == "GEFFE") return "0x086";
if (v == "GAISLER_GPREG") return "0x087";
if (v == "GPREG") return "0x087";
if (v == "GAISLER_GRTMPAHB") return "0x088";
if (v == "GRTMPAHB") return "0x088";
if (v == "GAISLER_SPWCUC") return "0x089";
if (v == "SPWCUC") return "0x089";
if (v == "GAISLER_SPW2_DMA") return "0x08a";
if (v == "SPW2_DMA") return "0x08a";
if (v == "GAISLER_SPWROUTER") return "0x08b";
if (v == "SPWROUTER") return "0x08b";
if (v == "GAISLER_EDCLMST") return "0x08c";
if (v == "EDCLMST") return "0x08c";
if (v == "ESA_LEON2") return "0x002";
if (v == "LEON2") return "0x002";
if (v == "ESA_LEON2APB") return "0x003";
if (v == "LEON2APB") return "0x003";
if (v == "ESA_IRQ") return "0x005";
if (v == "IRQ") return "0x005";
if (v == "ESA_TIMER") return "0x006";
if (v == "TIMER") return "0x006";
if (v == "ESA_UART") return "0x007";
if (v == "UART") return "0x007";
if (v == "ESA_CFG") return "0x008";
if (v == "CFG") return "0x008";
if (v == "ESA_IO") return "0x009";
if (v == "IO") return "0x009";
if (v == "ESA_MCTRL") return "0x00f";
if (v == "MCTRL") return "0x00f";
if (v == "ESA_PCIARB") return "0x010";
if (v == "PCIARB") return "0x010";
if (v == "ESA_HURRICANE") return "0x011";
if (v == "HURRICANE") return "0x011";
if (v == "ESA_SPW_RMAP") return "0x012";
if (v == "SPW_RMAP") return "0x012";
if (v == "ESA_AHBUART") return "0x013";
if (v == "ESA_SPWA") return "0x014";
if (v == "SPWA") return "0x014";
if (v == "ESA_BOSCHCAN") return "0x015";
if (v == "BOSCHCAN") return "0x015";
if (v == "ESA_IRQ2") return "0x016";
if (v == "IRQ2") return "0x016";
if (v == "ESA_AHBSTAT") return "0x017";
if (v == "ESA_WPROT") return "0x018";
if (v == "WPROT") return "0x018";
if (v == "ESA_WPROT2") return "0x019";
if (v == "WPROT2") return "0x019";
if (v == "ESA_PDEC3AMBA") return "0x020";
if (v == "PDEC3AMBA") return "0x020";
if (v == "ESA_PTME3AMBA") return "0x021";
if (v == "PTME3AMBA") return "0x021";
if (v == "OPENCHIP_APBGPIO") return "0x001";
if (v == "APBGPIO") return "0x001";
if (v == "OPENCHIP_APBI2C") return "0x002";
if (v == "APBI2C") return "0x002";
if (v == "OPENCHIP_APBSPI") return "0x003";
if (v == "APBSPI") return "0x003";
if (v == "OPENCHIP_APBCHARLCD") return "0x004";
if (v == "APBCHARLCD") return "0x004";
if (v == "OPENCHIP_APBPWM") return "0x005";
if (v == "APBPWM") return "0x005";
if (v == "OPENCHIP_APBPS2") return "0x006";
if (v == "OPENCHIP_APBMMCSD") return "0x007";
if (v == "APBMMCSD") return "0x007";
if (v == "OPENCHIP_APBNAND") return "0x008";
if (v == "APBNAND") return "0x008";
if (v == "OPENCHIP_APBLPC") return "0x009";
if (v == "APBLPC") return "0x009";
if (v == "OPENCHIP_APBCF") return "0x00a";
if (v == "APBCF") return "0x00a";
if (v == "OPENCHIP_APBSYSACE") return "0x00b";
if (v == "APBSYSACE") return "0x00b";
if (v == "OPENCHIP_APB1WIRE") return "0x00c";
if (v == "APB1WIRE") return "0x00c";
if (v == "OPENCHIP_APBJTAG") return "0x00d";
if (v == "APBJTAG") return "0x00d";
if (v == "OPENCHIP_APBSUI") return "0x00e";
if (v == "APBSUI") return "0x00e";
if (v == "CONTRIB_CORE1") return "0x001";
if (v == "CORE1") return "0x001";
if (v == "CONTRIB_CORE2") return "0x002";
if (v == "CORE2") return "0x002";
if (v == "GLEICHMANN_CUSTOM") return "0x001";
if (v == "CUSTOM") return "0x001";
if (v == "GLEICHMANN_GEOLCD01") return "0x002";
if (v == "GEOLCD01") return "0x002";
if (v == "GLEICHMANN_DAC") return "0x003";
if (v == "DAC") return "0x003";
if (v == "GLEICHMANN_HPI") return "0x004";
if (v == "HPI") return "0x004";
if (v == "GLEICHMANN_SPI") return "0x005";
if (v == "SPI") return "0x005";
if (v == "GLEICHMANN_HIFC") return "0x006";
if (v == "HIFC") return "0x006";
if (v == "GLEICHMANN_ADCDAC") return "0x007";
if (v == "ADCDAC") return "0x007";
if (v == "GLEICHMANN_SPIOC") return "0x008";
if (v == "SPIOC") return "0x008";
if (v == "GLEICHMANN_AC97") return "0x009";
if (v == "AC97") return "0x009";
if (v == "SUN_T1") return "0x001";
if (v == "T1") return "0x001";
if (v == "SUN_S1") return "0x011";
if (v == "S1") return "0x011";
if (v == "ORBITA_1553B") return "0x001";
if (v == "1553B") return "0x001";
if (v == "ORBITA_429") return "0x002";
if (v == "429") return "0x002";
if (v == "ORBITA_SPI") return "0x003";
if (v == "ORBITA_I2C") return "0x004";
if (v == "I2C") return "0x004";
if (v == "ORBITA_SMARTCARD") return "0x064";
if (v == "SMARTCARD") return "0x064";
if (v == "ORBITA_SDCARD") return "0x065";
if (v == "SDCARD") return "0x065";
if (v == "ORBITA_UART16550") return "0x066";
if (v == "UART16550") return "0x066";
if (v == "ORBITA_CRYPTO") return "0x067";
if (v == "CRYPTO") return "0x067";
if (v == "ORBITA_SYSIF") return "0x068";
if (v == "SYSIF") return "0x068";
if (v == "ORBITA_PIO") return "0x069";
if (v == "PIO") return "0x069";
if (v == "ORBITA_RTC") return "0x0c8";
if (v == "RTC") return "0x0c8";
if (v == "ORBITA_COLORLCD") return "0x12c";
if (v == "COLORLCD") return "0x12c";
if (v == "ORBITA_PCI") return "0x190";
if (v == "PCI") return "0x190";
if (v == "ORBITA_DSP") return "0x1f4";
if (v == "DSP") return "0x1f4";
if (v == "ORBITA_USBHOST") return "0x258";
if (v == "USBHOST") return "0x258";
if (v == "ORBITA_USBDEV") return "0x2bc";
if (v == "USBDEV") return "0x2bc";
if (v == "NASA_EP32") return "0x001";
if (v == "EP32") return "0x001";
if (v == "ACTEL_COREMP7") return "0x001";
if (v == "COREMP7") return "0x001";
if (v == "APPLECORE_UTLEON3") return "0x001";
if (v == "UTLEON3") return "0x001";
if (v == "APPLECORE_UTLEON3DSU") return "0x002";
if (v == "UTLEON3DSU") return "0x002";
if (v == "APPLECORE_APBPERFCNT") return "0x003";
if (v == "APBPERFCNT") return "0x003";
if (v == "CAL_DDRCTRL") return "0x188";
if (v == "DDRCTRL") return "0x188";
    return v0;
}


function get_values(l,a,gvba,v,v0,v1,r,val,gvb) {
    r = 0;
    while (match(l,"[a-zA-Z0-9]+=[[:space:]]*[\"a-zA-Z0-9_]")) {
        v = substr(l,RSTART,RLENGTH);
        l = substr(l,RSTART+RLENGTH-1);
        if (match(l,"^\"")) {
            l = scan_string(l, "\"", "\"", gvb = next_gvar());
            val = scanstr_r[gvb];
        } else if (match(l,"^[a-zA-Z0-9_]+")) {
            val = substr(l,RSTART,RLENGTH);
            l = substr(l,RSTART+RLENGTH);
        } else {
            print("Unable to scan: " l); exit(1);
        }
        match(v,"=");
        v0 = substr(v,1,RSTART-1);
        v0 = remove_space(v0);
        if (v0 == "vendor") {
            val = resolve_vendor(val);
        } else if (v0 == "device") {
            val = resolve_device(val);
        }
        a[gvba,v0] = val;
        r++;
        if (dbgscan) {
            print(indent(gl) " + Values:" v0 "=" val);
        }
    }
    return r;
}

function remove_space(f) {
    sub("^[[:blank:]]*","",f);
    sub("[[:blank:]]*$","",f);
    return f;
}

function remove_str(f) {
    sub("^[[:blank:]]*\"","",f);
    sub("[[:blank:]]*\"$","",f);
    return f;
}

function remove_str_n(f,r) {
    r = remove_str(f);
    if (!length(r))
        r = 0;
    return r;
}

function subst_conpact(f) {
    while(sub("\\\\\n", "\n", f));
    while(sub("^[\n\t [:blank:]]+", "", f));
    while(sub("[\t[:blank:]]+\n", "", f));
    while(sub("[\n]", "", f));
    while(sub("[\t]", " ", f));
    while(sub("  ", " ", f));
    while(sub(" \\{", "{", f));
    while(sub("\\{ ", "{", f));
    while(sub(" \\(", "(", f));
    while(sub("\\( ", "(", f));
    while(sub(" \\}", "}", f));
    while(sub("\\} ", "}", f));
    while(sub(" \\)", ")", f));
    while(sub("\\) ", ")", f));
    while(sub("$ ", "", f));
    while(sub("/\\*[^\\*]*\\*/", "", f));
    return f;
}

function dbg_str(f,l,  post) {
    post = "";
    f = subst_conpact(f);
    while(sub("\n", "\\n", f));
    if (length(f) > l) post = "...";
    return ("\"" substr(f,1,l) post "\"");
}

function indent(i,  r) {
    r = "";
    while(i-- > 0) {
	r = " " r;
    }
    return r;
}

BEGIN {
    gl = 0; cset=1; spos = 0; selid = 1;
    dbg=0; if (!length(of)) of = "o.txt";
}

function pushent(isaddnode) {
    if (gl == 0) {
        selc = selid++;
        spos = 0;
        setid[selc] = 1;
        get_values($0,addprop,gvb= next_gvar());

        selv[selc,"vendor"] = remove_str_n(addprop[gvb,"vendor"]) 
        selv[selc,"device"] = remove_str_n(addprop[gvb,"device"])
        selv[selc,"idx"] = remove_str_n(addprop[gvb,"idx"])
        selv[selc,"parent"] = remove_str_n(addprop[gvb,"parent"])
        selv[selc,"isaddnode"] = isaddnode;

    }
    gl++;
    cset = setid[selc]++
    stk[++spos] = cset;
    par[selc,cset] = stk[spos-1]
    plv[selc,cset] = gl;
    proppos[selc,cset] = 1;

    if (isaddnode) {
        prop[selc,cset,proppos[selc,cset],"name"] = "\"name\"";
        prop[selc,cset,proppos[selc,cset],"value"] = addprop[gvb,"name"]
        prop[selc,cset,proppos[selc,cset],"type"] = "str";
        proppos[selc,cset]++;
    }
        
}

function popent() {
    gl--;
    spos--;
    cset = stk[spos];
}

/<add-property/ {
    if (dbgscan) {
        print (indent(gl) "Found add-property: " dbg_str($0,64))
    }
    pushent(0);
}

/<\/add-property/ {
    if (dbgscan) {
        print (indent(gl) "Found /add-property ")
    }
    popent();
}

/<property/ {
    if (dbgscan) {
        print (indent(gl)  "Found property: " dbg_str($0,64))
    }
    get_values($0,addprop,gvb= next_gvar());
    prop[selc,cset,proppos[selc,cset],"name"] = addprop[gvb,"name"]
    prop[selc,cset,proppos[selc,cset],"type"] = remove_str(addprop[gvb,"type"])
    if (!(prop[selc,cset,proppos[selc,cset],"value"] = addprop[gvb,"value"])) {
        l = $0;
        if (match(l,">")) {
            l=substr(l,RSTART+1);
        }
        while(!match(l,"</property")) {
            if (getline <= 0) {
                print("Searching for </property> failed\n"); exit(1);
            }
            l = l $0;
        }
        l=substr(l,1,RSTART-1);
        prop[selc,cset,proppos[selc,cset],"value"] = "\"" l "\""
    }
    if (!(prop[selc,cset,proppos[selc,cset],"type"] == "int" ||
          prop[selc,cset,proppos[selc,cset],"type"] == "str")) {
        print("Property must be of type int or str:" dbg_str($0,64) " is " prop[selc,cset,proppos[cset],"type"]); exit(1);
    }
    proppos[selc,cset]++;
}

/<add-node/  {
    if (dbgscan) {
        print (indent(gl)  "Found add-node: " dbg_str($0,64))
    }
    pushent(1);
}

/<\/add-node/  {
    if (dbgscan) {
        print (indent(gl) "Found /add-node ")
    }
    popent();
}

END {
    if (dbg) {
        for (selc = 1; selc < selid; selc++) {
            for (i = 1; i < setid[selc]; i++) {
                print(i ":" (par[selc,i] ? ("->" par[selc,i]) : "")  )
                for (j = 1; j < proppos[selc,i]; j++) {
                    print(" (" prop[selc,i,j,"type"] ")" prop[selc,i,j,"name"] "=" prop[selc,i,j,"value"]);
                }
            }
        }
        
    }
    nidx = 0; pidx = 0;
    sel = "";
    nodes = ""; p = ""; vals = ""; vp = 0;
    nidx = 0;
    for (selc = 1; selc < selid; selc++) {
        for (i = 1; i < setid[selc]; i++) {
            if (i > 1) {
                if (plv[selc,i-1]+1 == plv[selc,i])
                    nc[selc,i-1] = nidx;
                else if (plv[selc,i-1] == plv[selc,i])
                    ns[selc,i-1] = nidx;
            }
            nidx++;
        }
    }
    nidx = 0; ni = 0;
    for (selc = 1; selc < selid; selc++) {
        sels = nidx;
        nodes = nodes "/* ---------- entry-" (selc-1) "*/\n";
        for (i = 1; i < setid[selc]; i++) {
            p = p "/* " selc ":" i " */\n"; spidx = pidx;
            for (j = 1; j < proppos[selc,i]; j++) {
                propg = (j+1) < proppos[selc,i] ? "PROPA_PTR" : "PROPA_PTR_END";
                if (prop[selc,i,j,"type"] == "int") {
                    ilen = 4;
                    if (length(vals)) vals = vals ","
                    vals = vals remove_str(prop[selc,i,j,"value"]);
                    p = p "\t" propg "( /*"pidx"*/" prop[selc,i,j,"name"]  ", (char *)(&vals[" vp "]), " ilen "),\n";
                    vp += ilen/4;
                } else if (prop[selc,i,j,"type"] == "str") {
                    str = prop[selc,i,j,"value"];
                    p = p "\t" propg "( /*"pidx"*/ " prop[selc,i,j,"name"]  ", " str ", " (length(str)-2+1) "),\n";
                }
                pidx++;
            }
            
            nodes = nodes "/* " ni " */  {{(struct node *)" (nc[selc,i]?("&nod[" nc[selc,i] "]"):"NULL") ",(struct node *)" (ns[selc,i]?("&nod[" ns[selc,i] "]"):"NULL") ",(struct prop *)&prp[" spidx  "] }, " plv[selc,i] ", " (proppos[selc,i]-1) ", &prp[" spidx  "]}, /* " selc ":" i " */ \n"; nidx++;
            ni++;
        }
        sele = nidx;
        sel = sel "/* ---------- entry-" selc "*/" "{ " selv[selc,"vendor"] "," selv[selc,"device"] "," selv[selc,"idx"] "," selv[selc,"parent"] ", \t/* isaddnode */ "  selv[selc,"isaddnode"] ", /* from */ "  sels ", /* to */ " sele "},\n";
        
    }
    
    print "struct mksel_def sel[] = {\n" sel "};\n" >> of;
    print "int vals[] = { " vals "};\n" >> of;
    print "struct propa_ptr prp[] = {\n" p "};\n" >> of;
    print "struct mknod_def nod[] = {\n" nodes "};\n" >> of;
    print "#define SELCNT " (selid-1) >> of;
    print "#define PRPCNT " (pidx-1) >> of;
    print "int selcnt=SELCNT;" >> of;
    
}

#Local Variables:
#c-basic-offset:4
#indent-tabs-mode:nil
#End:

