/* Exported functionality from PROM sections
 *
 * (C) Copyright 2011 Aeroflex Gaisler
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 *
 */

#ifndef __PROM_H__
#define __PROM_H__

#include <common.h>
#include <linux.h>

extern struct common_data common;
extern struct linux_romvec romvector;
extern unsigned long cpu_freq_khz;

/* AMBA Property Names */
extern char *prop_str_name;
extern char *prop_str_vendor;
extern char *prop_str_device;
extern char *prop_str_version;
extern char *prop_str_devmsk;
extern char *prop_str_interrupts;
extern char *prop_str_reg;
extern char *prop_str_userdef;
extern char *prop_str_freq;
extern char *prop_str_index;
extern char *prop_str_ampopts;
extern char *prop_str_description;

extern void opprom_init(void);
extern void *prom_malloc(int size);
extern void *prom_calloc(int size);
struct node *opprom_get_ambapp0(void);

/* send one character to UART, blocking until done. For debugging.
 * Works only after AMBA has been scanned or if CONFIG_DEBUG_UART has been
 * set correcty.
 */
extern void outbyte(char c);
extern void outstr(char *str);

/* avoid UMUL/DIV reference (all hardware does not have those instructions) */
extern unsigned int int_div(unsigned int v, unsigned int d);
extern unsigned int int_mul(unsigned int v, unsigned int m);

/* String operations */
extern void _memcpy(char *d, char *s, int len);
extern void _strcpy(char *d, char *s);
extern void _memset(void *d, int v, int len);
extern int _strcmp(char *d, char *s);
extern int _strnlen(const char *s, int count);

#ifdef CONFIG_DEBUG

#define DBG_PRINTF(fmt, a0, a1, a2, a3, a4, a5, a6) \
	_printf(fmt, (int)(a0), (int)(a1), (int)(a2), (int)(a3), (int)(a4), \
		(int)(a5), (int)(a6))

extern int _printf(const char *fmt, int a0, int a1, int a2, int a3, int a4,
		   int a5, int a6);

#else /* !CONFIG_DEBUG */

#define DBG_PRINTF(fmt, a0, a1, a2, a3, a4, a5, a6)

#endif /* CONFIG_DEBUG */

#endif
