# Common Makefile definitions

# Top Level Directory defined by the Makefile including this directory
#TOP:=

CONFIG=$(TOP)/.config

# Include Current Configuration if created, LB_HAVE_DOT_CONFIG is set if .config
# exists.
-include $(CONFIG)
include $(TOP)/VERSION

# Download Directory
DLDIR:=$(TOP)/gaisler/dl

SCRIPTS:=$(TOP)/gaisler/scripts

FTP_BASE=ftp://ftp.gaisler.com/gaisler.com

# SPARC/LEON Linux Toolchain from config
#TOOLCHAIN=sparc-linux-
ifeq ($(LB_TOOLCHAIN_CUSTOM),y)
 PATH:=$(subst ",,$(LB_TOOLCHAIN_CUSTOM_PATH)/bin):$(PATH)
 export PATH
endif
ifeq ($(LB_TOOLCHAIN_BUILDROOT),y)
 ifneq ($(wildcard $(TOP)/dist/.toolchain_path),)
  PATH:=$(shell cat $(TOP)/dist/.toolchain_path):$(PATH)
  export PATH
 endif
endif

# Build target options
ifeq ($(LB_BUILDOPTS_V8),y)
 TGT_CFLAGS+= -mv8
endif
ifneq ($(LB_BUILDOPTS_FPU),y)
 TGT_CFLAGS+= -msoft-float
endif
