#!/bin/sh
#
# Usage: get.sh <url> [destination]
#
# cp is used for file:// scheme
# wget is used for everything else

URL=$1
if [ -z "$URL" ] ; then
    echo >&2 "Usage: `basename $0` <url> [destination]"
    exit 1
elif [ $# -ge 2 ] ; then
    DEST="$2"
else
    DEST="."
fi

FILENAME=`basename $URL`
STRIPPEDFILEURL=`echo $URL | sed 's_^file://__'`

if [ -d $DEST ] ; then
    DEST=$DEST/$FILENAME
fi


if [ $URL != $STRIPPEDFILEURL ] ; then
    cp "$STRIPPEDFILEURL" "$DEST"
else
    wget "$URL" -O "$DEST"
fi
