/*
 * GRSPW DMA SpaceWire packet demonstration software
 *
 * Copyright (c) 2016 Cobham Gaisler AB
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
 * MA 02110-1301 USA
 */

#undef DEBUG_TEST

#define DMACHAN 1
#define DMACHAN_MASK (1<<DMACHAN)

/******** SpaceWire  ********/
#define TXPKTS 5461 /* Max packet structures for 128Kb */
#define RXPKTS 5461 /* Max packet structures for 128Kb */
#define SPW_PROT_ID 155

/* Number of seconds to run Test */
/*#define TEST_LENGTH_SEC (60*60*12)*/
#define TEST_LENGTH_SEC (30)

/* Number of micro seconds to wait for all packets to be received */
#define TEST_END_WAIT_MSEC 10000

/* Skip RX check to save CPU and thereby get higher throughput figures
 * all packets are checked in the end any way...
 */
#define SKIP_CHECK_FOR_EVERY_RECEIVED_PACKET

/* Skip TX check to save CPU and thereby get higher throughput figures
 * all packets are checked in the end any way...
 */
#define SKIP_CHECK_FOR_EVERY_TRANSMITTED_PACKET

/* SpaceWire Packet first sender (INITIATOR) device Index */
#define SPW_INITIATOR 0

/* SpW links on SpaceWire Router determine which PATH addess the AMBA
 * targets has. This define can be overridden by command line parameter.
 */
#define ROUTER_SPWLINK_NO 8

/* Number of SpaceWire Links to share the packet buffers with, each
 * SpaceWire Link have 2 Packet Queues per DMA Unit.
 */
#ifndef SPW_LINKS_USED
 #define SPW_LINKS_USED 4
#endif
#define SPW_DMA_CHANS_PER_LINK_USED 1 /* only 1 supported at this time */
#define SPW_DIRECTIONS_USED (SPW_LINKS_USED*SPW_DMA_CHANS_PER_LINK_USED*2)

#define SPW_BUF_MB_BLOCKS 8
#define SPW_BUF_SIZE (SPW_BUF_MB_BLOCKS*1024*1024)
#ifndef PKT_SIZE
  #define PKT_SIZE 1024
#endif
#define PKT_DATA_SIZE (PKT_SIZE-1-1-1-1-4) /* - sizeof(pkt_hdr)... */
#define PKT_CNT  SPW_BUF_SIZE/PKT_SIZE/SPW_DIRECTIONS_USED
#define PKT_CNT_TOT PKT_CNT*SPW_DIRECTIONS_USED

/* Define header buffers */
#define HDR_SIZE 16
#define HDR_BUF_SIZE ((PKT_CNT_TOT) * HDR_SIZE)
#define HDR_BUF_128K_BLOCKS ((HDR_BUF_SIZE + (128*1024-1)) / (128*1024))
