/*
 * Custom hardcoded configuration of test. Use this to describe your SpaceWire
 * network set up - cabeling and node address configuration.
 *
 * Two examples below to demonstrate usage of four or two AMBA ports which are
 * configured to route SpW packets internally within a GR740 or LEON4-N2X
 * SpW router. If the external SpaceWire connectors is to be used then one need
 * to add one additional path address.
 */

#if (SPW_LINKS_USED == 2)	/* Two AMBA ports */
struct route_entry initial_route = 
{
	.dstadr_next = 0x1,
	.dstadr = {1+ROUTER_SPWLINK_NO+1, 0x2, 0},
};

#define ROUTE_MAX 256
struct route_entry routetab[ROUTE_MAX] = 
{
	{0, {0, 0}},
	{0x2, {1+ROUTER_SPWLINK_NO, 0x1, 0}},
	{0x1, {1+ROUTER_SPWLINK_NO+1, 0x2, 0}},
};

#elif (SPW_LINKS_USED == 4)	/* Four AMBA ports */
struct route_entry initial_route = 
{
	.dstadr_next = 0x3,
	.dstadr = {1+ROUTER_SPWLINK_NO+1, 0x2, 0},
};

#define ROUTE_MAX 256
struct route_entry routetab[ROUTE_MAX] = 
{
	/* DST */  /* NEXT-ADR, {PATH/LOGICAL ADDRESS} */
	/* 0x00 */ {0, {0, 0}},
	/* 0x01 */ {0x2, {1+ROUTER_SPWLINK_NO, 0x1, 0}},
	/* 0x02 */ {0x3, {1+ROUTER_SPWLINK_NO+1, 0x2, 0}},
	/* 0x03 */ {0x4, {1+ROUTER_SPWLINK_NO+2, 0x3, 0}},
	/* 0x04 */ {0x1, {1+ROUTER_SPWLINK_NO+3, 0x4, 0}},
};
#endif

static void init_routetab(int nlinks)
{
	/* do nothing, configuration is hardcoded... */
}
