################################################################################
#
# openal
#
################################################################################

OPENAL_VERSION = 1.20.1
OPENAL_SITE = $(call github,kcat,openal-soft,openal-soft-$(OPENAL_VERSION))
OPENAL_LICENSE = LGPL-2.0+
OPENAL_LICENSE_FILES = COPYING
OPENAL_INSTALL_STAGING = YES

# We don't need examples, tests and utilities, Distros don't ship them either
OPENAL_CONF_OPTS += -DALSOFT_UTILS=OFF -DALSOFT_EXAMPLES=OFF -DALSOFT_TESTS=OFF

ifeq ($(BR2_TOOLCHAIN_GCC_AT_LEAST_4_8),y)
OPENAL_CONF_OPTS += -DEXTRA_LIBS=atomic
endif

ifeq ($(BR2_PACKAGE_ALSA_LIB),y)
OPENAL_DEPENDENCIES += alsa-lib
OPENAL_CONF_OPTS += -DALSOFT_REQUIRE_ALSA=ON
else
OPENAL_CONF_OPTS += -DALSOFT_REQUIRE_ALSA=OFF
endif

ifeq ($(BR2_PACKAGE_JACK2),y)
OPENAL_DEPENDENCIES += jack2
OPENAL_CONF_OPTS += -DALSOFT_REQUIRE_JACK=ON
else
OPENAL_CONF_OPTS += -DALSOFT_REQUIRE_JACK=OFF
endif

ifeq ($(BR2_PACKAGE_PORTAUDIO),y)
OPENAL_DEPENDENCIES += portaudio
OPENAL_CONF_OPTS += -DALSOFT_REQUIRE_PORTAUDIO=ON
else
OPENAL_CONF_OPTS += -DALSOFT_REQUIRE_PORTAUDIO=OFF
endif

ifeq ($(BR2_PACKAGE_PULSEAUDIO),y)
OPENAL_DEPENDENCIES += pulseaudio
OPENAL_CONF_OPTS += -DALSOFT_REQUIRE_PULSEAUDIO=ON
else
OPENAL_CONF_OPTS += -DALSOFT_REQUIRE_PULSEAUDIO=OFF
endif

ifeq ($(BR2_STATIC_LIBS),y)
OPENAL_CONF_OPTS += -DLIBTYPE=STATIC
endif

$(eval $(cmake-package))
