#!/bin/bash

# Download latest version in the directory specified by arguments. The
# latest version is found by reading the LATEST.basename file in that directory.
# The LATEST.basename file will be saved in the LOCAL_PATH/LATEST.basename file.
#
#
# Usage:
#   download.sh FTP_BASE LOCAL_PATH BASE_NAME
#
# unimplemented: [-p PKG_NAME] [-v VERSION]

FTP_BASE=$1
LOCAL_PATH=$2
BASENAME=$3
WGET=wget

if [ -z "$FTP_BASE" -o -z "$LOCAL_PATH" -o -z "$BASENAME" ]; then
	echo "usage: $0 FTP_BASE LOCAL_PATH BASE_NAME"
	exit 2
fi

rm -f $LOCAL_PATH/.LATEST.$BASENAME
if ! $WGET $FTP_BASE/CURRENT.$BASENAME -O $LOCAL_PATH/.LATEST.$BASENAME ; then
	echo "Failed to access FTP server 1"
	exit 2
fi

#cp ${FTP_BASE}/LATEST $LOCAL_PATH/LATEST

# Check if this version works with the current version of LINUXBUILD,
# sometimes an upgrade of LINUXBUILD most be performed before upgrading
# a packet.
top=`dirname $0`/../..
lb_ver=`sed -n -e 's/^LB_VER=//gp' $top/VERSION`
lb_major=`echo $lb_ver | cut -d'.' -f1`
lb_minor=`echo $lb_ver | cut -d'.' -f2`
lb_rev=`echo $lb_ver | cut -d'.' -f3`

# LB_REQ in CURRENT is required version
req_ver=`sed -n -e 's/^REQ_LB=//gp' $LOCAL_PATH/.LATEST.$BASENAME`
req_major=`echo $req_ver | cut -d'.' -f1`
req_minor=`echo $req_ver | cut -d'.' -f2`
req_rev=`echo $req_ver | cut -d'.' -f3`

echo "Current LINUXBUILD version $lb_major.$lb_minor.$lb_rev, package requires $req_major.$req_minor.$req_rev"

if [ $req_major -ne $lb_major   -o   $req_minor -ne $lb_minor   -o   $req_rev -gt $lb_rev ]; then
	rm -f $LOCAL_PATH/.LATEST.$BASENAME
	echo
	echo  "!!! latest versions on server requires a newer LINUXBUILD version"
	echo  "    please upgrade LINUXBUILD first"
	echo
	exit 0
fi

filename=`sed -n -e 's/^FILENAME=//gp' $LOCAL_PATH/.LATEST.$BASENAME`
if [ -f $LOCAL_PATH/$filename ]; then
	rm -f $LOCAL_PATH/LATEST.$BASENAME
	mv $LOCAL_PATH/{.LATEST.$BASENAME,LATEST.$BASENAME}
	echo
	echo "!!! latest version already downloaded.."
	echo
	exit 0
fi

if ! $WGET $FTP_BASE/$filename -O $LOCAL_PATH/.$filename ; then
	rm -f $LOCAL_PATH/.$filename $LOCAL_PATH/.LATEST.$BASENAME
	echo "Failed to access FTP server 2"
	exit 2
fi

rm -f $LOCAL_PATH/LATEST.$BASENAME $LOCAL_PATH/$filename
mv $LOCAL_PATH/.LATEST.$BASENAME $LOCAL_PATH/LATEST.$BASENAME
mv $LOCAL_PATH/.$filename $LOCAL_PATH/$filename

echo
echo DOWNLOADED $filename
echo

exit 0
