#!/bin/bash

# usage:
#   unpack.sh REFERENCE DESTINATION BASENAME

REF=$1
DST=$2
BASENAME=$3

if [ -z "$BASENAME" -o -z "$REF" -o -z "$DST" -o ! -d "$REF" -o ! -d "$DST" ]; then
	echo "usage: $0 REFERENCE DESTINATION"
	exit 2
fi

if [ ! -f $REF/LATEST.$BASENAME ]; then
	echo "$0: REFERENCE directory corrupt (LATEST.$BASENAME missing)."
	exit 2
fi

# Read LATEST file to determine which file to unpack
filename=`sed -n -e 's/^FILENAME=//gp' $REF/LATEST.$BASENAME`
if [ ! -f $REF/$filename ]; then
	echo "$0: REFERENCE directory corrupt ($filename missing)."
	exit 2
fi

name=`sed -n -e 's/^NAME=//gp' $REF/LATEST.$BASENAME`

dirname=$BASENAME-$name
rm -rf $DST/$dirname
tar -C $DST -xjf $REF/$filename

exit 0
