usage() {
    echo "Usage:"
    echo "$0 <linux-image> <out-file> [-freq <frequency>] [-base <baseaddr>] [-cmdline <string>] [-amp <string>] [-ethmac <string>]"
    echo "  <linux-image> linux image, normally <linux-dir>/arch/sparc/boot/image."
    echo "  <out-file>    output image that can be uploaded using GRMON or run in TSIM."
    echo ""
    echo " optional parameters:"
    echo "  -base <baseaddr>  optional baseaddress. The default is 0x40000000."
    echo "  -cmdline <string> kernel parameter string. Default is \"console=ttyS0,38400\"."
    echo "  -freq <frequency> optional frequency parameter in case if it cannot be retrived from the Timer scalar."
    echo "  -amp <string>     optional strng of format <idx0>=<val0>:<idx1>=<val1>:... that sets for core index"
    echo "                    n property ampopts to value n. Example 0=1:1:0 will set core index 0's ampopts to 1"
    echo "		      and core index 1's ampopts to 0."
    echo "  -ethmac <string>  set the ethernet mac address as 12 dgt hex. Default: 00007ccc0145"
    
    
    exit 1;
}

isdbg=0;istest=0; ofile=""; ldir=""; baddr="0x40000000"; freq="0x2625A00"; cmdline="console=ttyS0,38400"; amp="";
ethmac="00007ccc0145";
while [ $# -ne 0 ]
do
    case "$1" in
	#-o) shift; ofile="$1";
	-d) isdbg=1;;
	-t) istest=1;;
	-freq) shift; freq="$1";;
	-cmdline) shift; cmdline="$1";;
	-base) shift; baddr="$1";;
	-ethmac) shift; ethmac="$1";;
	-amp) shift; amp="$1";;
	*) a[${#a[*]}]="$1";;
    esac
    shift
done

ldir=${a[0]}
limg=${a[0]}
o=${a[1]}
prefix=`dirname $(readlink -f $0)`/

if [ "${#a[*]}" != "2" ]; then usage; fi

bss_addr=0x`sparc-linux-objdump -h $limg | grep \\\\.bss\\[\\[:space:\\]\\] | awk '{ print $4 }' `;
bss_size=0x`sparc-linux-objdump -h $limg | grep \\\\.bss\\[\\[:space:\\]\\] | awk '{ print $3 }' `;
macrostr=-DETHMACDEF=0x${ethmac}ull
#" -DLEONSETUP_MEM_BASEADDR=${baddr} -DBOOTLOADER_freq=${freq} -DCONFIG_KERNEL_COMMAND_LINE=\"\\\"${cmdline}\\\"\" "
#echo "Linux-dir     :" $ldir
echo "Linux-img     :" $limg "(bss:" $bss_addr ")"
echo "Linux-wrap    :" $o
echo "prefix        :" $prefix
echo "base          :" $baddr
echo "macrodef      :" $macrostr
echo "amp           :" $amp
echo "ethmac        :" $ethmac
bss_clear_start=$((($bss_addr-0xf0000000+0x40000000)))   
bss_clear_end=$((($bss_clear_start+$bss_size)))   

# 1. create a static MMU page table pgt.S using pgt_gen.c
# 2. compile prom_stage2.c and pgt.S
# 3. convert Linux-img into a binary elf section
# 4. create a linkerscript linuxwrap.ld that merges Linux-img, pgt.S and prom_stage2.c
# 5. create the output image

echo "" > amp_opts.c
if [ "x$amp" != "x" ]; then
    echo $amp | awk '{split($0,a,":"); for (v in a) { print a[v]; }; }' | awk '{split($0,a,"="); print "{" a[1] "," a[2] "},"; }; ' >> amp_opts.c
fi

# -I$ldir/include -I. -I$ldir/arch/sparc/include 
echo -e "########### \n" \
     "gcc -DLEONSETUP_MEM_BASEADDR=${baddr} -DBOOTLOADER_freq=${freq} -DCONFIG_KERNEL_COMMAND_LINE=\"\\\"${cmdline}\\\"\" -D__KERNEL__ -o pgt_gen ${prefix}pgt_gen.c && \
	./pgt_gen >pgt.S && rm pgt_gen"
      gcc -DLEONSETUP_MEM_BASEADDR=${baddr} -DBOOTLOADER_freq=${freq} -DCONFIG_KERNEL_COMMAND_LINE="\"${cmdline}\"" -D__KERNEL__ -o pgt_gen ${prefix}pgt_gen.c && \
	./pgt_gen >pgt.S && rm pgt_gen 

echo -e "########### \n" \
     "sparc-linux-gcc ${macrostr} -DLEONSETUP_MEM_BASEADDR=${baddr} -DBOOTLOADER_freq=${freq} -DCONFIG_KERNEL_COMMAND_LINE=\"\\\"${cmdline}\\\"\" -c pgt.S -o pgt.o"
      sparc-linux-gcc ${macrostr} -DLEONSETUP_MEM_BASEADDR=${baddr} -DBOOTLOADER_freq=${freq} -DCONFIG_KERNEL_COMMAND_LINE="\"${cmdline}\"" -c pgt.S -o pgt.o
      
echo -e "########### \n" \
     "sparc-linux-gcc ${macrostr} -DLEONSETUP_MEM_BASEADDR=${baddr} -DBOOTLOADER_freq=${freq} -DCONFIG_KERNEL_COMMAND_LINE=\"\\\"${cmdline}\\\"\" -I. ${prefix}prom_stage2.c -c -o prom_stage2.o -fno-builtin  -D__KERNEL__ -mno-fpu -nostdinc -iwithprefix include -g -Os "
      sparc-linux-gcc ${macrostr} -DLEONSETUP_MEM_BASEADDR=${baddr} -DBOOTLOADER_freq=${freq} -DCONFIG_KERNEL_COMMAND_LINE="\"${cmdline}\"" -I. ${prefix}prom_stage2.c -c -o prom_stage2.o -fno-builtin  -D__KERNEL__ -mno-fpu -nostdinc -iwithprefix include -g -Os || exit

echo -e "########### \n" \
     "sparc-linux-objcopy -O binary -R .note -R .comment -S $limg $limg.piggy"
      sparc-linux-objcopy -O binary -R .note -R .comment -S $limg $limg.piggy || exit
		    
echo -e "########### \n" \
     "sparc-linux-ld -r -b binary $limg.piggy -o $limg.o -g "
      sparc-linux-ld -r -b binary $limg.piggy -o $limg.o -g  || exit

echo "" > remove_predefs.h
sparc-linux-gcc -I. -dM -C -E -P ${prefix}linuxwrap.S | cut -d' ' -f -2 | sed 's/#define/#undef/g' > remove_predefs.h.2 || exit
mv remove_predefs.h.2 remove_predefs.h

sparc-linux-nm $limg | awk '{ if (toupper($2) == "T" && !match($3,"\\.") ) { print $3 " = 0x" $1 ";"; } }' >> remove_predefs.h

echo -e "########### \n" \
     "sparc-linux-gcc -DLEONSETUP_MEM_BASEADDR=${baddr} -DBOOTLOADER_freq=${freq} -DCONFIG_KERNEL_COMMAND_LINE=\"\\\"${cmdline}\\\"\" -E -C -P -I. -DIMAGE=\"$limg.o\" ${prefix}linuxwrap.S -o linuxwrap.ld " 
      sparc-linux-gcc -DLEONSETUP_MEM_BASEADDR=${baddr} -DBOOTLOADER_freq=${freq} -DCONFIG_KERNEL_COMMAND_LINE="\"${cmdline}\"" -E -C -P -I. -DIMAGE="$limg.o"   ${prefix}linuxwrap.S -o linuxwrap.ld || exit

echo -e "########### \n" \
     "sparc-linux-ld -X -T linuxwrap.ld -o $o --defsym bss_start=$bss_clear_start --defsym bss_end=$bss_clear_end -g "
      sparc-linux-ld -X -T linuxwrap.ld -o $o --defsym bss_start=$bss_clear_start --defsym bss_end=$bss_clear_end -g || exit

echo -e "########### \n" \
     "sparc-linux-objdump -d $o > $o.dis"
      sparc-linux-objdump -d $o > $o.dis 

