/*
 * GRSPW Router APB Register char driver
 *
 * Copyright (c) 2016-2022 Cobham Gaisler AB
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
 * MA 02110-1301 USA
 */

#ifndef __GRSPW_ROUTER_H__
#define __GRSPW_ROUTER_H__

/* Hardware Information */
struct router_hw_info {
	unsigned char nports_spw;
	unsigned char nports_amba;
	unsigned char nports_fifo;
	char timers_avail;
	char pnp_avail;
	unsigned char ver_major;
	unsigned char ver_minor;
	unsigned char ver_patch;
	unsigned char iid;
};

#define ROUTER_FLG_CFG		0x01
#define ROUTER_FLG_IID		0x02
#define ROUTER_FLG_IDIV		0x04
#define ROUTER_FLG_TPRES	0x08
#define ROUTER_FLG_TRLD		0x10
#define ROUTER_FLG_ALL		0x1f	/* All Above Flags */

struct router_config {
	unsigned int flags; /* Determine what configuration should be updated */

	/* Router Configuration Register */
	unsigned int config;

	/* Set Instance ID */
	unsigned char iid;

	/* SpaceWire Link Initialization Clock Divisor */
	unsigned char idiv;

	/* Timer Prescaler and Reload */
	unsigned int timer_prescaler;
	unsigned int timer_reload[31];
};

/* Logical routing table */
struct router_routes {
	unsigned int route[224];
};

/* Port Setup, see register definitions for "Port setup register" */
struct router_ps {
	unsigned int ps[31]; /* Port Setup for ports 1-31 */
	unsigned int ps_logical[224]; /* Port setup for locgical addresses 32-255 */
};

/* Set/Get Port Control/Status */
#define ROUTER_PORTFLG_SET_CTRL	0x01
#define ROUTER_PORTFLG_GET_CTRL	0x02
#define ROUTER_PORTFLG_SET_STS	0x04
#define ROUTER_PORTFLG_GET_STS	0x08
struct router_port {
	unsigned int flag;
	int port;
	unsigned int ctrl;
	unsigned int sts;
};

/* Get Hardware support/information available */
#define GRSPWR_IOCTL_HWINFO	_IOW('a', 0x01, struct router_hw_info)

/* Router Configuration */
#define GRSPWR_IOCTL_CFG_SET	_IOR('a', 0x02, struct router_config)
#define GRSPWR_IOCTL_CFG_GET	_IOW('a', 0x03, struct router_config)

/* Routes */
#define GRSPWR_IOCTL_ROUTES_SET	_IOR('a', 0x04, struct router_routes)
#define GRSPWR_IOCTL_ROUTES_GET	_IOW('a', 0x05, struct router_routes)

/* Port Setup */
#define GRSPWR_IOCTL_PS_SET	_IOR('a', 0x06, struct router_ps)
#define GRSPWR_IOCTL_PS_GET	_IOW('a', 0x07, struct router_ps)

/* Set configuration write enable */
#define GRSPWR_IOCTL_WE_SET	_IO('a', 0x08)

/* Set/Get Port Control/Status */
#define GRSPWR_IOCTL_PORT	_IOWR('a', 0x09, struct router_port)

/* Set Router Configuration/Status Register */
#define GRSPWR_IOCTL_CFGSTS_SET	_IO('a', 0x0a)
/* Get Router Configuration/Status Register */
#define GRSPWR_IOCTL_CFGSTS_GET	_IOWR('a', 0x0b, unsigned int *)

/* Get Current Time-Code Register */
#define GRSPWR_IOCTL_TC_GET	_IOWR('a', 0x0c, unsigned int *)

#endif
