/*
 * Dual SpW configuration of test. Use this to describe your SpaceWire
 * network set up - cabeling and node address configuration.
 *
 * Communicates between SpW0 and SpW1. For systems without a SPWROUTER.
 * A cable between SpW0 and SpW1 is required.
 * Setup can be extended by additional path addresses if the SpW0 and SpW1
 * are connected via a router.
 *
 * Tested on a GR712RC.
 */

#if (SPW_LINKS_USED == 2)	/* Two AMBA ports */
struct route_entry initial_route = 
{
	.dstadr_next = 0x1,
	.dstadr = {0x2, 0},
};

#define ROUTE_MAX 256
struct route_entry routetab[ROUTE_MAX] = 
{
	{0, {0, 0}},
	{0x2, {0x1, 0}},
	{0x1, {0x2, 0}},
};

#else
 #error SETUP IS DESIGNED FOR TWO AMBA/SPACEWIRE PORTS.
#endif

static void init_routetab(int nlinks)
{
	/* do nothing, configuration is hardcoded... */
}
