/*
 * Command line option configures the routes of this test. Use this to describe
 * your SpaceWire network set up - cabeling and node address configuration.
 *
 * This configuration demonstrate usage of N (two of more) AMBA ports which are
 * configured to route SpW packets internally within a GR740 or LEON4-N2X
 * SpW router. If the external SpaceWire connectors is to be used then one need
 * to add one additional path address.
 */

#define ROUTE_MAX 256

static struct route_entry initial_route;
static struct route_entry routetab[ROUTE_MAX];

/* Optionally to above hard-coded one can use this function to init
 * route table. This example is designed for use with the GRSPWROUTER
 * and takes the number of SpW links as input determine the AMBA ports
 * addresses needed to generate a correct path address sequence.
 */
static void init_routetab(int nlinks)
{
	initial_route.dstadr_next = SPW_LINKS_USED - 1;
	initial_route.dstadr[0] = 1+nlinks+1;
	initial_route.dstadr[1] = 0x2;
	initial_route.dstadr[2] = 0;

	routetab[0].dstadr_next = 0;
	routetab[0].dstadr[0] = 0;
	routetab[0].dstadr[1] = 0;

	int i;
	for(i = 1; i <= SPW_LINKS_USED; i++) {
		routetab[i].dstadr_next = (i % SPW_LINKS_USED) + 1;
		routetab[i].dstadr[0] = nlinks+i;
		routetab[i].dstadr[1] = i;
		routetab[i].dstadr[2] = 0;
	}
}
