/* Memory MAP Lib Driver Access Help Library 
 *
 * This interface is used to Memory Map device Buffers in Kernel Virtual
 * Address space (and Phycial Memory) to Userpace Virtual Address space.
 * The Physical address space is linear in blocks of 128Kb and can thus
 * be used for device memory (DMA capable).
 *
 * At the moment of writing only the GRSPW SpaceWire driver uses the MMAP
 * library.
 *
 * Copyright (c) 2016-2023 Frontgrade Gaisler AB
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
 * MA 02110-1301 USA
 */

#ifndef __MAPLIB_USER__
#define __MAPLIB_USER__

/******** MAP LIBRARY ********/
struct map {
	void *start;	/* User-Space Start Address of linear block */
	size_t length;	/* Length of Block */
	int ofs;	/* Offset in device memory (typically not used) */
};

extern struct maplib_mmap_info mmapinfo;

/* Memory MAPS, the last map has start|length set to 0 */
extern struct map maps[512];

/* Memory MAP memory blk_size*blk_cnt bytes of device memory to userpace
 * after the memory is mapped and setup, the map is stored i maps[] array
 * for the user to access.
 *
 * Note that device memory may not cross a linear 128KB boudary.
 */
int mmaplib_init(int idx, int blk_size, int blk_cnt);

/* Unmap memory */
void mmaplib_cleanup(void);

#endif
