/* Configuration
 *
 * (C) Copyright 2011 Frontgrade Gaisler
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
 * MA 02110-1301 USA
 */

#ifndef __CONFIG_H__
#define __CONFIG_H__

#define PAGE_SHIFT 12
#define PAGE_SIZE (1UL << PAGE_SHIFT)
#define PAGE_MASK (PAGE_SIZE-1)

#define KERNBASE 0xf0000000
#define LOAD_ADDR 0x4000
#define KERNBASE_ENTRY_VA (KERNBASE + LOAD_ADDR)
#define SRMMU_PGDIR_MASK (~(SRMMU_PGDIR_SIZE-1))
#define SRMMU_PGDIR_SIZE (1UL << SRMMU_PGDIR_SHIFT)
#define SRMMU_PGDIR_SHIFT 24
#define SRMMU_PRIV 0x1c
#define SRMMU_VALID 0x02
#define SRMMU_CACHE 0x80
#define SRMMU_INVALID 0x0
#define SRMMU_ET_PTD 0x1
#define SRMMU_ET_PTE 0x2
#define SRMMU_ET_MASK 0x3
#define SRMMU_ACC_S_ALL	(0x7 << 2)
#define SRMMU_ACC_U_ALL	(0x3 << 2)

#define ASI_LEON_DFLUSH 0x11
#define ASI_LEON_MMUFLUSH 0x18
#define ASI_LEON_BYPASS 0x1c

#define M_LEON 0x30
#define M_LEON3_SOC 0x02

/* MKLINUX Startup sections (overwritten by Linux) [64KBytes]
 *
 * 0xFFD00000-0xFFD3FFFF: Mapped to STARTUP/PROM code (End of RAM)
 *
 *  ----/--------------------------------------------\ 0xffd00000
 *  A   |   STARTUP HEAP/MALLOC                      |
 *  R   |                                            |
 *  E   |                                            |
 *  A   |                                            |
 *      |    (CONFIG_STARTUP_HEAP_SIZE)              |
 *  C   |                                            | <- Heap Grows downwards
 *  L   |--------------------------------------------|
 *  R   |   STARTUP .BSS                             |
 *  ----|--------------------------------------------|
 *  A   |   STARTUP .TEXT                            |
 *  R   |                                            |
 *  E   |                                            |
 *  A   |--------------------------------------------|
 *      |   STARTUP .DATA                            |
 *  M   |--------------------------------------------|<- Linux EOM,
 *  O   |   PROM .TEXT                               |   All above over-
 *  V   |                                            |   written after
 *  E   |                                            |   boot by Linux
 *      |--------------------------------------------|
 *      |   PROM .DATA                               |
 *  ----|--------------------------------------------|
 *  A   |   PROM .BSS                                |
 *  R   |--------------------------------------------|
 *  E   |   PROM HEAP/MALLOC                         |
 *  A   |    (CONFIG_PROM_HEAP_SIZE)                 | <- Heap Grows downwards
 *      |--------------------------------------------|
 *  C   |   STARTUP/PROM STACK                       |
 *  L   |    (CONFIG_PROMSTART_STACK_SIZE)           |
 *  R   |                                            |
 *  --- \--------------------------------------------/<- EOM
 *
 */

/* Size according to maximum needed by Startup/PROM */
#define CONFIG_STARTUP_HEAP_SIZE 0x3000
#define CONFIG_PROM_HEAP_SIZE 0x3000
#define CONFIG_PROMSTART_STACK_SIZE 0x800

/* Constants set by SUN SPARC / Linux implementation. The mappings in this
 * area is inherited by Linux to Linux final MMU tables on startup
 */
#define CONFIG_LINUX_OPPROM_BEGVM 0xffd00000
#define CONFIG_LINUX_OPPROM_ENDVM 0xfff00000
/* Use 0xFFD00000-0xFFD3FFFF Segment to map PROM into addresses */
#define CONFIG_LINUX_OPPROM_SEGMENT ((0xffd00000 - 0xff000000) / 0x40000)

/* Include autogenerated Configuration */
#include <config_auto.h>

/* AMBA Plug and Play Base address for first bus (scanning starting here) */
#ifndef CONFIG_AMBA_IO_AREA
#define CONFIG_AMBA_IO_AREA 0xfff00000
#endif

#ifndef CONFIG_IPI_NUM
#define CONFIG_IPI_NUM 0 /* Use Default Linux IRQ number */
#elif ((CONFIG_IPI_NUM > 14) || (CONFIG_IPI_NUM < 0))
#error IPI must be a vector IRQ (1..14) and can not be shared with other IRQs
#endif

#ifndef CONFIG_MAX_CPUS
 #define CONFIG_MAX_CPUS 8
#endif

#ifndef CONFIG_LINUX_VERSION_CODE
#define CONFIG_LINUX_VERSION_CODE 0x00020624 /* Default to Linux 2.6.36 */
#endif

#define CONFIG_LINVER_MAJOR ((CONFIG_LINUX_VERSION_CODE >> 16) & 0xff)
#define CONFIG_LINVER_MINOR ((CONFIG_LINUX_VERSION_CODE >> 8) & 0xff)
#define CONFIG_LINVER_REV (CONFIG_LINUX_VERSION_CODE & 0xff)

#define CONFIG_LINUX_BSS_END (CONFIG_LINUX_BSS_START + CONFIG_LINUX_BSS_SIZE)

/* Default PROM console to first UART */
#ifndef CONFIG_UART_INDEX
 #define CONFIG_UART_INDEX 0
#endif

/* Standard values, overridden by AMBA Plug&Play routines */
#ifndef CONFIG_DEBUG_APBUART
#define CONFIG_DEBUG_APBUART 0x80000100
#endif

#ifndef CONFIG_DEBUG_IRQMP
#define CONFIG_DEBUG_IRQMP 0x80000200
#endif

#ifndef CONFIG_DEBUG_GPTIMER
#define CONFIG_DEBUG_GPTIMER 0x80000300
#endif

#undef CONFIG_DEBUG_APBUART
#define CONFIG_DEBUG_APBUART 0xff900000
/*#define CONFIG_NO_LINUX*/

#endif
