# Common Makefile definitions

# Top Level Directory defined by the Makefile including this directory
#TOP:=

CONFIG=$(TOP)/.config

# Include Current Configuration if created, LB_HAVE_DOT_CONFIG is set if .config
# exists.
-include $(CONFIG)
include $(TOP)/VERSION

LINUX_SRC=linux-src
LINUX_BUILDDIR=build-linux
LINUX_LEONLINK=leon-linux

BUILDROOT_SRC=buildroot-src
BUILDROOT_BUILDDIR=build-br
BUILDROOT_LEONLINK=leon-br

SCRIPTS:=$(TOP)/gaisler/scripts

FTP_BASE=http://gaisler.com/anonftp

# SPARC/LEON Linux Toolchain from config
#TOOLCHAIN=sparc-linux-
ifeq ($(LB_TOOLCHAIN_CUSTOM),y)
 PATH:=$(subst ",,$(LB_TOOLCHAIN_CUSTOM_PATH)/bin):$(PATH)
 export PATH
endif
ifeq ($(LB_TOOLCHAIN_BUILDROOT),y)
 ifneq ($(wildcard $(TOP)/dist/.toolchain_path),)
  PATH:=$(shell cat $(TOP)/dist/.toolchain_path):$(PATH)
  export PATH
 endif
endif
