/* Copyright (C) 1997, 1999 Free Software Foundation, Inc.
   This file is part of the GNU C Library.
   Contributed by Miguel de Icaza <miguel@gnu.ai.mit.edu>, 1997.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.  */

/* Code taken from glibc2.2.2/sysdeps/unix/sysv/linux/sparc/sparc32/syscall.S */

#include <sys/syscall.h>

.text
.global __syscall
.type   __syscall,%function
.align 4

__syscall:
  mov	%o0, %g1
	mov	%o1, %o0
	mov	%o2, %o1
	mov	%o3, %o2
	mov	%o4, %o3
	mov	%o5, %o4
	ta	0x10
	bcc	1f
  nop

__syscall_error:
  save    %sp,-96,%sp
	call __errno_location
	nop
	st	%i0,[%o0]
	ret
	restore	%g0,-1,%o0

1:	retl
	 nop

.size __syscall,.-__syscall

.weak syscall
	syscall = __syscall
