        .section        .text
        .global         bdinit0
        .global         bdinit1
        .global         bdinit2

/* NOTE: Memory is NOT available when bdinit0 is called. */
bdinit0:
        /* Remember return address */
        mov     %o7, %g5

#if MDDR_APB
        set     MDDR_APB, %o0
        set     mddr_init_table, %o1
        call    init_reg32
         nop
#endif

#if SERDES_APB
        set     SERDES_APB, %o0

        /* Clear bit 5 at offset 0x2008 */
        set     0x2008, %o2
        ld      [%o0 + %g2], %o3
        andn    %o3, 0x20, %o3
        st      %o3, [%o0 + %o2]

        set     serdes_init_table, %o1
        call    init_reg32
         nop

        /* Set bit 5 at offset 0x2008 */
        set     0x2008, %o2
        ld      [%o0 + %g2], %o3
        or      %o3, 0x20, %o3
        st      %o3, [%o0 + %o2]
#endif

        mov     %g5, %o7
        retl
         nop

/*
 * This routine generates bus writes given a table of offset/value pairs. See
 * the file init_reg32.c for the interface.
 */
#include "../shared/init_reg32.S"

/* Bring in the configuration table for DDR controller */
#if MDDR_APB
        .section        .rodata
        .global         mddr_init_table
mddr_init_table:
#include "mddr_init.inc"
#endif

/* Bring in the configuration table for SERDES controller */
#if SERDES_APB
        .section        .rodata
        .global         serdes_init_table
serdes_init_table:
#include "serdes_init.inc"
#endif


        .section        .text
bdinit1:
        retl
         nop

bdinit2:
        retl
         nop

