#!/bin/sh
#
# This script takes a .reg file as generated by Microsemi Libero as input and
# outputs a corresponding table of offset-value pairs. The output can be
# included in a GNU assembler source file.
#
# Input is read on stdin. Output is written on stdout.
#
# Usage:
#   $ ./genregtable.tcl < some.reg > some.inc
#
# The output file can be included in an assembly source file with the assembler
# directive .include or using the preprocessor #include directive.
#
# \
if type tclsh > /dev/null 2>&1 ; then exec tclsh "$0" ${1+"$@"} ; fi
# \
if type tclsh8.6 > /dev/null 2>&1 ; then exec tclsh8.6 "$0" ${1+"$@"} ; fi
# \
if type tclsh8.5 > /dev/null 2>&1 ; then exec tclsh8.5 "$0" ${1+"$@"} ; fi
# \
echo "$0: tclsh required" ; \
exit 1

set usage "Usage: $argv0"

set MSG_INFO    1; #
set MSG_NOTE    2; #
set MSG_DEBUG   4; #
set msglevel [expr {$MSG_INFO | $MSG_NOTE}]
#set msglevel [expr {$MSG_INFO | $MSG_NOTE | $MSG_DEBUG}]

proc DEBUG {str} {
    global msglevel MSG_DEBUG
    if {$msglevel & $MSG_DEBUG} { puts "DEBUG: $str" }
}

proc tohex32 {n} {
    set n [expr {$n & 0xffffffff}]
    format "0x%08x" $n
}

DEBUG "begin"
while {! [eof stdin]} {
    set l [gets stdin]
    if {[llength $l] != 3} {
        continue
    }
    set name   [lindex $l 0]
    set offset [lindex $l 1]
    set value  [lindex $l 2]
    if {[string first "#" "$l"] != -1} {
        continue
    }
    DEBUG "name=$name, offset=$offset, value=$value"
    puts "/* $name */"
    puts "        .word   $offset"
    puts "        .word   $value"
    puts ""
}
puts "/* TERMINATION */"
puts "        .word   0xffffffff"
puts "        .word   0xffffffff"
puts ""
DEBUG "end"

