
#ifndef _GNSS_H_
#define _GNSS_H_

#include <rtems.h>

#define AGGA4_GNSS_DEVNAME "/dev/gnss"

rtems_device_driver gnss_io_initialize(
    rtems_device_major_number major,
    rtems_device_major_number minor,
    void *arg
    );
rtems_device_driver gnss_io_open(
    rtems_device_major_number major,
    rtems_device_major_number minor,
    void *arg
    );
rtems_device_driver gnss_io_close(
    rtems_device_major_number major,
    rtems_device_major_number minor,
    void *arg
    );
rtems_device_driver gnss_io_control(
    rtems_device_major_number major,
    rtems_device_major_number minor,
    void *arg
    );

#define AGGA4_GNSS_DRIVER_TABLE_ENTRY \
  { gnss_io_initialize, gnss_io_open, gnss_io_close, \
	NULL, NULL, gnss_io_control }

enum {
    /* Get register pointer.
     * arg: struct gnss_regs **
     */
    GNSS_IOCTL_GET_REGS,
    /* Set clock source
     * arg: int
     */
    GNSS_IOCTL_SET_CLK,
    /* Register an ISR
     * arg: struct gnss_isr *
     */
    GNSS_IOCTL_SET_ISR,
    /* Reset core
     * arg: NULL
     */
    GNSS_IOCTL_RESET,
};

typedef void (*gnss_isr_func)(void*);

struct gnss_isr {
    int irq;
    gnss_isr_func isr;
    void *arg;
};

/* struct gnss_isr member irq values*/
#define GNSS_INTERRUPT_GIC_CH00        0
#define GNSS_INTERRUPT_GIC_CH01        1
#define GNSS_INTERRUPT_GIC_CH02        2
#define GNSS_INTERRUPT_GIC_CH03        3
#define GNSS_INTERRUPT_GIC_CH04        4
#define GNSS_INTERRUPT_GIC_CH05        5
#define GNSS_INTERRUPT_GIC_CH06        6
#define GNSS_INTERRUPT_GIC_CH07        7
#define GNSS_INTERRUPT_GIC_CH08        8
#define GNSS_INTERRUPT_GIC_CH09        9
#define GNSS_INTERRUPT_GIC_CH10        10
#define GNSS_INTERRUPT_GIC_CH11        11
#define GNSS_INTERRUPT_GIC_CH12        12
#define GNSS_INTERRUPT_GIC_CH13        13
#define GNSS_INTERRUPT_GIC_CH14        14
#define GNSS_INTERRUPT_GIC_CH15        15
#define GNSS_INTERRUPT_GIC_CH16        16
#define GNSS_INTERRUPT_GIC_CH17        17
#define GNSS_INTERRUPT_GIC_CH18        18
#define GNSS_INTERRUPT_GIC_CH19        19
#define GNSS_INTERRUPT_GIC_CH20        20
#define GNSS_INTERRUPT_GIC_CH21        21
#define GNSS_INTERRUPT_GIC_CH22        22
#define GNSS_INTERRUPT_GIC_CH23        23
#define GNSS_INTERRUPT_GIC_CH24        24
#define GNSS_INTERRUPT_GIC_CH25        25
#define GNSS_INTERRUPT_GIC_CH26        26
#define GNSS_INTERRUPT_GIC_CH27        27
#define GNSS_INTERRUPT_GIC_CH28        28
#define GNSS_INTERRUPT_GIC_CH29        29
#define GNSS_INTERRUPT_GIC_CH30        30
#define GNSS_INTERRUPT_GIC_CH31        31
#define GNSS_INTERRUPT_GIC_CH32        32
#define GNSS_INTERRUPT_GIC_CH33        33
#define GNSS_INTERRUPT_GIC_CH34        34
#define GNSS_INTERRUPT_GIC_CH35        35
#define GNSS_INTERRUPT_GIC_PPS         36
#define GNSS_INTERRUPT_GIC_ASE         37
#define GNSS_INTERRUPT_GIC_ME          38
#define GNSS_INTERRUPT_GIC_PLD_5I      39
#define GNSS_INTERRUPT_GIC_PLD_IQ      40
#define GNSS_INTERRUPT_GIC_DMA_ERR     41

/* GNSS_IOCTL_SET_CLK argument values */
#define GNSS_CLK_EXTERNAL 0 /* From input pin "EXT_CORE_CLK" */
#define GNSS_CLK_INTERNAL 1 /* From 2.5 division of HalfSampleClk */

/* GNSS register map */
struct gnss_regs {
        volatile uint8_t ch[36][0x10000];
        struct {
                volatile uint32_t cha0;
                volatile uint32_t cha1;
                volatile uint32_t dbfis;
                volatile uint32_t ecd;
                volatile uint32_t mes;
                volatile uint32_t ppss;
                volatile uint32_t asc;
                volatile uint32_t ecs;
                volatile uint32_t ecc;
                volatile uint32_t eccl;
                volatile uint32_t imtlsw;
                volatile uint32_t imtmsw;
                volatile uint32_t meimtlsw;
                volatile uint32_t meimtmsw;
                volatile uint32_t ppsimtlsw;
                volatile uint32_t ppsimtmsw;
                volatile uint32_t aseimtlsw;
                volatile uint32_t aseimtmsw;
                volatile uint32_t pld5iimtlsw;
                volatile uint32_t pld5iimtmsw;
                volatile uint32_t pldiqimtlsw;
                volatile uint32_t pldiqimtmsw;
                volatile uint32_t autimtlsw;
                volatile uint32_t autimtmsw;
                volatile uint32_t test;
                volatile uint8_t _pad0[0x10000-0x64];
        } mtx;
        struct {
               volatile uint32_t ctrl;
               volatile uint32_t ddcmpi;
               volatile uint32_t ddcmfqt;
               volatile uint32_t ddcapi;
               volatile uint32_t ddcafqt;
               volatile uint32_t dac;
               volatile uint8_t _pad1[0x10000-0x18];
        } im[4];
        volatile uint8_t _pad2[0x20000];
        struct {
                volatile uint32_t pld5iis;
                volatile uint32_t pld5ic;
                volatile uint32_t pldiqis;
                volatile uint32_t pldiqpac;
                volatile uint32_t pldiqc;
                volatile uint32_t acc5ip7;
                volatile uint32_t acc5ip5;
                volatile uint32_t acc5ip3;
                volatile uint32_t acc5ip1;
                volatile uint32_t acc5im1;
                volatile uint32_t acc5im3;
                volatile uint32_t acc5im5;
                volatile uint32_t acc5im7;
                volatile uint32_t accip7;
                volatile uint32_t accip5;
                volatile uint32_t accip3;
                volatile uint32_t accip1;
                volatile uint32_t accim1;
                volatile uint32_t accim3;
                volatile uint32_t accim5;
                volatile uint32_t accim7;
                volatile uint32_t accqp7;
                volatile uint32_t accqp5;
                volatile uint32_t accqp3;
                volatile uint32_t accqp1;
                volatile uint32_t accqm1;
                volatile uint32_t accqm3;
                volatile uint32_t accqm5;
                volatile uint32_t accqm7;
                volatile uint8_t _pad3[0x10000-0x74];
        } pld;
        struct {
                volatile uint32_t mask[2];
                volatile uint32_t prio[2];
                volatile uint32_t pend[2];
                volatile uint32_t clear[2];
                volatile uint32_t qlow;
                volatile uint32_t qhigh;
                volatile uint32_t qstatus;
                volatile uint8_t _pad4[0x10000-0x2C];
        } gic;
        volatile uint8_t _pad5[0x1000000-0x2D0000];
        volatile uint8_t ram[36][0x10000];
};

/* Input Module Control */
#define GNSS_INPUT_CTRL_DDC_AUX_BIT    5
#define GNSS_INPUT_CTRL_DDC_MAIN_BIT   4
#define GNSS_INPUT_CTRL_IFC_FORMAT_BIT 2
#define GNSS_INPUT_CTRL_MODE_BIT       0

#define GNSS_INPUT_CTRL_DDC_AUX        (0x0x1 << NSS_INPUT_CTRL_DDC_AUX_BIT)
#define GNSS_INPUT_CTRL_DDC_MAIN       (0x0x1 << NSS_INPUT_CTRL_DDC_MAIN_BIT)
#define GNSS_INPUT_CTRL_IFC_FORMAT     (0x3   << NSS_INPUT_CTRL_IFC_FORMAT_BIT)
#define GNSS_INPUT_CTRL_MODE           (0x3   << NSS_INPUT_CTRL_MODE_BIT)

/* Input Module DDC Main Phase Increment */
#define GNSS_INPUT_MPI_INC_BIT         0

#define GNSS_INPUT_MPI_INC             (0x7F << GNSS_INPUT_MPI_INC_BIT)

/* Input Module DDC Main FIR Quantization Threshold */
#define GNSS_INPUT_MQT_T2_BIT          20
#define GNSS_INPUT_MQT_T1_BIT          10
#define GNSS_INPUT_MQT_T0_BIT          0

#define GNSS_INPUT_MQT_T2              (0x3FF << GNSS_INPUT_MQT_T2_BIT)
#define GNSS_INPUT_MQT_T1              (0x3FF << GNSS_INPUT_MQT_T1_BIT)
#define GNSS_INPUT_MQT_T0              (0x3FF << GNSS_INPUT_MQT_T0_BIT)

/* Input Module DDC Auxillary Phase Increment */
#define GNSS_INPUT_API_INC_BIT         0

#define GNSS_INPUT_API_INC             (0x7F << GNSS_INPUT_API_INC_BIT)

/* Input Module DDC Auxillary FIR Quantization Threshold */
#define GNSS_INPUT_AQT_T2_BIT          20
#define GNSS_INPUT_AQT_T1_BIT          10
#define GNSS_INPUT_AQT_T0_BIT          0

#define GNSS_INPUT_AQT_T2              (0x3FF << GNSS_INPUT_AQT_T2_BIT)
#define GNSS_INPUT_AQT_T1              (0x3FF << GNSS_INPUT_AQT_T1_BIT)
#define GNSS_INPUT_AQT_T0              (0x3FF << GNSS_INPUT_AQT_T0_BIT)

/* Input Module DA Control */
#define GNSS_INPUT_DA_VALUE_BIT        0
#define GNSS_INPUT_DA_VALUE            (0xFFF << GNSS_INPUT_DA_VALUE_BIT)

/* Power Level Detector 5I Input select */
#define GNSS_PLD_5IS_INPUT_BIT         0

#define GNSS_PLD_5IS_INPUT             (0x3 << GNSS_PLD_5IS_INPUT_BIT)

/* Power Level Detector 5I Control */
#define GNSS_PLD_5IC_TRIG_BIT          24
#define GNSS_PLD_5IC_TIME_BIT          0

#define GNSS_PLD_5IC_TRIG              (0x1      << GNSS_PLD_5IC_TRIG_BIT)
#define GNSS_PLD_5IC_TIME              (0xFFFFFF << GNSS_PLD_5IC_TIME_BIT)

/* Power Level Detector IQ Input Select */
#define GNSS_PLD_IQS_INPUT_BIT         6
#define GNSS_PLD_IQS_SIGNAL_BIT        0

#define GNSS_PLD_IQS_INPUT             (0x3  << GNSS_PLD_IQS_INPUT_BIT)
#define GNSS_PLD_IQS_SIGNAL            (0x3F << GNSS_PLD_IQS_SIGNAL_BIT)

/* Power Level Detector IQ Pre Accumulator Control */
#define GNSS_PLD_IQP_PAUSE_BIT         4
#define GNSS_PLD_IQP_RQ_FAC_BIT        3
#define GNSS_PLD_IQP_EXP_FAC_BIT       0

#define GNSS_PLD_IQP_PAUSE             (0x3FF << GNSS_PLD_IQP_PAUSE_BIT)
#define GNSS_PLD_IQP_RQ_FAC            (0x1   << GNSS_PLD_IQP_RQ_FAC_BIT)
#define GNSS_PLD_IQP_EXP_FAC           (0x7   << GNSS_PLD_IQP_EXP_FAC_BIT)

/* Power Level Detector IQ Control */
#define GNSS_PLD_IQC_TRIG_BIT          24
#define GNSS_PLD_IQC_TIME_BIT          0

#define GNSS_PLD_IQC_TRIG              (0x1      << GNSS_PLD_IQC_TRIG_BIT)
#define GNSS_PLD_IQC_TIME              (0xFFFFFF << GNSS_PLD_IQC_TIME_BIT)

/* Power Level Detector Accumulation Registers */
#define GNSS_PLD_ACC_VALUE_BIT         0
#define GNSS_PLD_ACC_VALUE             (0xFFFFFF << GNSS_PLD_ACC_VALUE)

/* Channel Matrix DBF Input Select */
#define GNSS_MATRIX_DBF_1_BIT          1
#define GNSS_MATRIX_DBF_0_BIT          0

#define GNSS_MATRIX_DBF_1              (0x1 << GNSS_MATRIX_DBF_1_BIT)
#define GNSS_MATRIX_DBF_0              (0x1 << GNSS_MATRIX_DBF_0_BIT)

/* Channel Matrix Epoch Clock Divider */
#define GNSS_MATRIX_EPOCH_INT_BIT      10
#define GNSS_MATRIX_EPOCH_FRAC_BIT     0

#define GNSS_MATRIX_EPOCH_INT          (0x1FFFF << GNSS_MATRIX_EPOCH_INT_BIT)
#define GNSS_MATRIX_EPOCH_FRAC         (0x3FF   << GNSS_MATRIX_EPOCH_FRAC_BIT)

/* Channel Matrix ME settings */
#define GNSS_MATRIX_ME_EIN_BIT         15
#define GNSS_MATRIX_ME_OUT_BIT         14
#define GNSS_MATRIX_ME_DIV_BIT         0

#define GNSS_MATRIX_ME_EIN             (0x1    << GNSS_MATRIX_ME_EIN_BIT)
#define GNSS_MATRIX_ME_OUT             (0x1    << GNSS_MATRIX_ME_OUT_BIT)
#define GNSS_MATRIX_ME_DIV             (0x3FFF << GNSS_MATRIX_ME_DIV_BIT)

/* Channel Matrix PPS settings */
#define GNSS_MATRIX_PPS_SYNC_BIT       16
#define GNSS_MATRIX_PPS_EIN_BIT        15
#define GNSS_MATRIX_PPS_OUT_BIT        14
#define GNSS_MATRIX_PPS_DIV_BIT        0

#define GNSS_MATRIX_PPS_SYNC           (0x1    << GNSS_MATRIX_PPS_SYNC_BIT)
#define GNSS_MATRIX_PPS_EIN            (0x1    << GNSS_MATRIX_PPS_EIN_BIT)
#define GNSS_MATRIX_PPS_OUT            (0x1    << GNSS_MATRIX_PPS_OUT_BIT)
#define GNSS_MATRIX_PPS_DIV            (0x3FFF << GNSS_MATRIX_PPS_DIV_BIT)

/* Channel Matrix Antenna switch control */
#define GNSS_MATRIX_ASC_ID_BIT         15
#define GNSS_MATRIX_ASC_SEQ_BIT        11
#define GNSS_MATRIX_ASC_OUT_BIT        10
#define GNSS_MATRIX_ASC_DVI_BIT        0

#define GNSS_MATRIX_ASC_ID             (0x3   << GNSS_MATRIX_ASC_ID_BIT)
#define GNSS_MATRIX_ASC_SEQ            (0xF   << GNSS_MATRIX_ASC_SEQ_BIT)
#define GNSS_MATRIX_ASC_OUT            (0x1   << GNSS_MATRIX_ASC_OUT_BIT)
#define GNSS_MATRIX_ASC_DVI            (0x3FF << GNSS_MATRIX_ASC_DVI_BIT)

/* Channel Matrix External clock settings */
#define GNSS_MATRIX_ECS_LATCH_PPS_BIT  4
#define GNSS_MATRIX_ECS_LATCH_ME_BIT   3
#define GNSS_MATRIX_ECS_LATCH_EXT_BIT  2
#define GNSS_MATRIX_ECS_SIGNAL_BIT     0

#define GNSS_MATRIX_ECS_LATCH_PPS      (0x1 << GNSS_MATRIX_ECS_LATCH_PPS_BIT)
#define GNSS_MATRIX_ECS_LATCH_ME       (0x1 << GNSS_MATRIX_ECS_LATCH_ME_BIT)
#define GNSS_MATRIX_ECS_LATCH_EXT      (0x1 << GNSS_MATRIX_ECS_LATCH_EXT_BIT)
#define GNSS_MATRIX_ECS_SIGNAL         (0x1 << GNSS_MATRIX_ECS_SIGNAL_BIT)

/* Channel Matrix Test settings */
#define GNSS_MATRIX_TEST_CODE2_BIT     13
#define GNSS_MATRIX_TEST_CODE1_BIT     7
#define GNSS_MATRIX_TEST_OPOS_BIT      6
#define GNSS_MATRIX_TEST_OCHAN_BIT     0

#define GNSS_MATRIX_TEST_CODE2         (0x3F << GNSS_MATRIX_TEST_CODE2_BIT)
#define GNSS_MATRIX_TEST_CODE1         (0x3F << GNSS_MATRIX_TEST_CODE1_BIT)
#define GNSS_MATRIX_TEST_OPOS          (0x1  << GNSS_MATRIX_TEST_OPOS_BIT)
#define GNSS_MATRIX_TEST_OCHAN         (0x3F << GNSS_MATRIX_TEST_OCHAN_BIT)

#endif /* _GNSS_H_ */
