
#ifndef _IP1553B_H_
#define _IP1553B_H_

#include <rtems.h>

#define AGGA4_IP1553B_DEVNAME "/dev/ip1553b"

rtems_device_driver ip1553b_io_initialize(
    rtems_device_major_number major,
    rtems_device_major_number minor,
    void *arg
    );
rtems_device_driver ip1553b_io_open(
    rtems_device_major_number major,
    rtems_device_major_number minor,
    void *arg
    );
rtems_device_driver ip1553b_io_close(
    rtems_device_major_number major,
    rtems_device_major_number minor,
    void *arg
    );
rtems_device_driver ip1553b_io_control(
    rtems_device_major_number major,
    rtems_device_major_number minor,
    void *arg
    );

#define AGGA4_IP1553B_DRIVER_TABLE_ENTRY \
  { ip1553b_io_initialize, ip1553b_io_open, ip1553b_io_close, \
	NULL, NULL, ip1553b_io_control }

enum {
    /* Activate the core
     * arg: NULL
     */
    IP1553B_IOCTL_START,
    /* Setup memory area for the MilBus-1553 controller.
     * The value should be an absolute address pointing at 512kB
     * and aligned to 512kB, within the memory region.
     * arg: void *
     */
    IP1553B_IOCTL_SET_MEM,
    /* Enable extended memory area. The argument should be a sa address,
     * negative value will disable it.
     * arg: struct ip1553b_ext *
     */
    IP1553B_IOCTL_SET_EXT,
     /* Set timeout
     * arg: uint32_t
     */
    IP1553B_IOCTL_SET_TIMEOUT,
    /* Set clock source
     * arg: uint32_t
     */
    IP1553B_IOCTL_SET_CLK,
    /* Set RT address
     * arg: uint32_t
     */
    IP1553B_IOCTL_SET_RTAD,
    /* Set parity
     * arg: uint32_t
     */
    IP1553B_IOCTL_SET_PARITY,
    /* Register an ISR
     * arg: struct ip1553b_isr *
     */
    IP1553B_IOCTL_SET_ISR,
    /* Set a characterization word
     * arg: struct ip1553b_char *
     */
    IP1553B_IOCTL_SET_CHAR,
    /* Set an indirection entry
     * arg: struct ip1553b_indirection *
     */
    IP1553B_IOCTL_SET_INDIRECTION,
    /* Read received one block of data from the memory area
     * arg: struct ip1553b_data *
     */
    IP1553B_IOCTL_RXDATA,
    /* Read received data from the memory area
     * arg: struct ip1553b_block *
     */
    IP1553B_IOCTL_RXBLOCK,
    /* Write data to the memory area
     * arg: struct ip1553b_data *
     */
    IP1553B_IOCTL_TXDATA,
    /* Write one block of data to the memory area
     * arg: struct ip1553b_block *
     */
    IP1553B_IOCTL_TXBLOCK,
    /* Get next command, control and info words
     * arg: struct ip1553b_cmd *
     */
    IP1553B_IOCTL_GET_NEXT,
    /* Get last command, control and info words
     * arg: struct ip1553b_cmd *
     */
    IP1553B_IOCTL_GET_LAST,
};

typedef void (*ip1553b_isr_func)(void*);

struct ip1553b_isr {
    int irq;       /* See IP1553B_INTERRUPT... defines */
    ip1553b_isr_func isr;
    void *arg;
};

struct ip1553b_data {
    int table;     /* Indirection table index */
    uint32_t sa;   /* Sub-address */
    int ofs;       /* Byte offset */
    int cnt;       /* Number of bytes */
    uint8_t *buf;  /* Pointer to data buffer */
};

struct ip1553b_block {
    int table;     /* Indirection table index */
    uint32_t sa;   /* Sub-address */
    int blk;       /* Block offset */
    int ofs;       /* Word offset */
    int cnt;       /* Number of words */
    uint16_t *buf; /* Pointer to data buffer */
};

struct ip1553b_indirection {
    int table;     /* Indirection table index */
    uint32_t sa;   /* Sub-address */
    int adupd;
    int maxbs;
    int brblk;
};

struct ip1553b_char {
    uint32_t idx;    /* Sub-address / mode-code */
    uint32_t word;  /* Combination of IP1553B_CHAR_... defines */
};

struct ip1553b_cmd {
    uint16_t cmd;   /* Combination of IP1553B_CMD_... defines */
    uint16_t ctrl;  /* Combination of IP1553B_CTRL... defines */
    uint32_t info;  /* Combination of IP1553B_INFO_... defines */
};


#define IP1553B_MEMAREA_SIZE         (512*1024)

/* IP1553B_IOCTL_SET_TIMEOUT argument values */
#define IP1553B_TIMEOUT_14US         0
#define IP1553B_TIMEOUT_31US         1

/* IP1553B_IOCTL_SET_CLK argument values */
#define IP1553B_CLK_EXTERNAL         0
#define IP1553B_CLK_PLL              1

/* IP1553B_IOCTL_SET_PARITY argument values */
#define IP1553B_PARITY_ODD           0
#define IP1553B_PARITY_EVEN          1

/* struct ip1553b_isr member irq values*/
#define IP1553B_INTERRUPT_NOM_TROK   0
#define IP1553B_INTERRUPT_NOM_SYNC   1
#define IP1553B_INTERRUPT_NOM_DBC    2
#define IP1553B_INTERRUPT_NOM_SWITCH 3
#define IP1553B_INTERRUPT_RST        4
#define IP1553B_INTERRUPT_ERR_MEM    5
#define IP1553B_INTERRUPT_ERR_1553   6
#define IP1553B_INTERRUPT_ERR_RTAD   7

/* struct ip1553b_char member char bit-values*/
#define IP1553B_CHAR_NOM_TX_TROK     0x8000
#define IP1553B_CHAR_NOM_TX_LEG      0x4000
#define IP1553B_CHAR_NOM_TX_SSF      0x2000
#define IP1553B_CHAR_NOM_TX_SREQ     0x1000
#define IP1553B_CHAR_NOM_RX_TROK     0x0800
#define IP1553B_CHAR_NOM_RX_LEG      0x0400
#define IP1553B_CHAR_NOM_RX_SSF      0x0200
#define IP1553B_CHAR_NOM_RX_SREQ     0x0100
#define IP1553B_CHAR_MODE_TX_TROK    0x0080
#define IP1553B_CHAR_MODE_TX_LEG     0x0040
#define IP1553B_CHAR_MODE_TX_SSF     0x0020
#define IP1553B_CHAR_MODE_TX_SREQ    0x0010
#define IP1553B_CHAR_MODE_RX_TROK    0x0008
#define IP1553B_CHAR_MODE_RX_LEG     0x0004
#define IP1553B_CHAR_MODE_RX_SSF     0x0002
#define IP1553B_CHAR_MODE_RX_SREQ    0x0001

/* struct ip1553b_indirection, ip1553b_data, ip1553b_block member table values*/
#define IP1553B_INDIRECTION_RX0      0
#define IP1553B_INDIRECTION_RX1      1
#define IP1553B_INDIRECTION_TX0      2
#define IP1553B_INDIRECTION_TX1      3

/* struct ip1553b_cmd member cmd bit values */
#define IP1553B_CMD_RTAD             0xF800
#define IP1553B_CMD_TR               0x0400
#define IP1553B_CMD_SA               0x03E0
#define IP1553B_CMD_WC               0x001F

#define IP1553B_CMD_RTAD_BIT         11
#define IP1553B_CMD_TR_BIT           10
#define IP1553B_CMD_SA_BIT           5
#define IP1553B_CMD_WC_BIT           0

/* struct ip1553b_cmd member ctrl bit values */
#define IP1553B_CTRL_DV              0x8000
#define IP1553B_CTRL_T               0x4000
#define IP1553B_CTRL_RTRT            0x2000
#define IP1553B_CTRL_BUSID           0x1000
#define IP1553B_CTRL_MEMERR          0x0400
#define IP1553B_CTRL_TTO0            0x0200
#define IP1553B_CTRL_TTO1            0x0100
#define IP1553B_CTRL_TFINH           0x0080
#define IP1553B_CTRL_HIWRD           0x0040
#define IP1553B_CTRL_LOWRD           0x0020
#define IP1553B_CTRL_UNDCMD          0x0010
#define IP1553B_CTRL_TRILL           0x0008
#define IP1553B_CTRL_LP              0x0004
#define IP1553B_CTRL_BUSYAP          0x0002
#define IP1553B_CTRL_TTOFLG          0x0001

/* struct ip1553b_cmd member info bit values */
#define IP1553B_INFO_BLOCKNUMBER     0xFFE00000
#define IP1553B_INFO_DATING          0x001FFFFF

#define IP1553B_INFO_BLOCKNUMBER_BIT 21
#define IP1553B_INFO_DATING_BIT      0

#endif /* _IP1553B_H_ */
