#ifndef _UART_H_
#define _UART_H_

#include <rtems.h>

#define AGGA4_UART0_DEVNAME "/dev/uart0"
#define AGGA4_UART1_DEVNAME "/dev/uart1"

rtems_device_driver uart_io_initialize(
    rtems_device_major_number major,
    rtems_device_major_number minor,
    void *arg
    );
rtems_device_driver uart_io_open(
    rtems_device_major_number major,
    rtems_device_major_number minor,
    void *arg
    );
rtems_device_driver uart_io_close(
    rtems_device_major_number major,
    rtems_device_major_number minor,
    void *arg
    );
rtems_device_driver uart_io_control(
    rtems_device_major_number major,
    rtems_device_major_number minor,
    void *arg
    );

#define AGGA4_UART_DRIVER_TABLE_ENTRY \
  { uart_io_initialize, uart_io_open, uart_io_close, \
	NULL, NULL, uart_io_control }


/* DMA IOCTL commands */
enum {
    /* Start reciever and transmitter
     * arg: NULL
     */
    UART_IOCTL_START,
    /* Stop reciever and transmitter
     * arg: NULL
     */
    UART_IOCTL_STOP,
    /* Register an ISR
     * arg: struct uart_isr *
     */
    UART_IOCTL_SET_ISR,
    /* Receive one packet
     * arg: struct uart_desc *
     */
    UART_IOCTL_RX,
    /* Transmit one packet
     * arg: struct uart_desc *
     */
    UART_IOCTL_TX,
    /* Check receive status, returns -1 with errno set to ETIMEOUT if area is not full. Optional
     * argument can be provided to retrieve the current number of available characters.
     * arg: int *
     */
    UART_IOCTL_RX_POLL,
    /* Check transmit status, returns -1 with errno set to ETIMEOUT if it's not finished.
     * arg: NULL
     */
    UART_IOCTL_TX_POLL,
    /* Get status flags
     * arg: uint32_t *
     */
    UART_IOCTL_GET_STATUS,
    /* Clear status flags, argument is a mask of status flags that should be cleared
     * arg: uint32_t
     */
    UART_IOCTL_CLR_STATUS,
    /* Set buadrate
     * arg: uint32_t
     */
    UART_IOCTL_SET_RATE,
    /* Get buadrate
     * arg: uint32_t *
     */
    UART_IOCTL_GET_RATE,
    /* Set little or big endian
     * arg: int
     */
    UART_IOCTL_SET_ENDIAN,
    /* Set parity
     * arg: int
     */
    UART_IOCTL_SET_PARITY,
    /* Get parity
     * arg: int *
     */
    UART_IOCTL_GET_PARITY,
    /* Set flow control
     * arg: int
     */
    UART_IOCTL_SET_FLOW,
    /* Get flow control
     * arg: int *
     */
    UART_IOCTL_GET_FLOW,
};

/* UART_IOCTL_SET_ENDIAN argument values */
#define UART_ENDIAN_BIG     0x0
#define UART_ENDIAN_LITTLE  0x1

/* UART_IOCTL_SET_FLOW argument values */
#define UART_FLOW_NO    0x0
#define UART_FLOW_YES   0x1

/* UART_IOCTL_SET_PARITY argument values */
#define UART_PARITY_NONE    0x0
#define UART_PARITY_EVEN    0x2
#define UART_PARITY_ODD     0x3

/* struct uart_isr member irq values */
#define UART_ISR_ERROR  2
#define UART_ISR_TXDONE 1
#define UART_ISR_RXDONE 0

/* UART_IOCTL_GET_STATUS output bit values */
#define UART_STATUS_DR   0x00000001 /* Data Ready */
#define UART_STATUS_TSE  0x00000002 /* TX Send Register Empty */
#define UART_STATUS_THE  0x00000004 /* TX Hold Register Empty */
#define UART_STATUS_BR   0x00000008 /* Break Error */
#define UART_STATUS_OVR  0x00000010 /* RX Overrun Error */
#define UART_STATUS_PER  0x00000020 /* RX Parity Error */
#define UART_STATUS_FER  0x00000040 /* RX Framing Error */
#define UART_STATUS_RTO  0x00000080 /* RX Timeout */
#define UART_STATUS_CLEAR -1		/* Clear all status bits */

typedef void (*uart_isr_func)(void*);

struct uart_isr {
    int irq;
    uart_isr_func isr;
    void *arg;
};

struct uart_desc {
    uint8_t *addr;
    size_t bytes;
};

struct uart_timecode {
    char  code;
    char  flag;
};

#endif /* _UART_H_ */
