/*
 *  LEON2 Cache Snooping Support
 *
 *
 *  COPYRIGHT (c) 1989-2009.
 *  On-Line Applications Research Corporation (OAR).
 *
 *  The license and distribution terms for this file may be
 *  found in the file LICENSE in this distribution or at
 *  http://www.rtems.com/license/LICENSE.
 *
 *  Ported to ERC32 implementation of the SPARC by On-Line Applications
 *  Research Corporation (OAR) under contract to the European Space
 *  Agency (ESA).
 *
 *  ERC32 modifications of respective RTEMS file: COPYRIGHT (c) 1995.
 *  European Space Agency.
 *
 *  $Id$
 */

#include <bsp.h>
#include <bsp/bootcard.h>

/*
 * Tells us if data cache snooping is available
 */
int CPU_SPARC_HAS_SNOOPING;

void console_printk_init(void);

/*
 * set_snooping
 *
 * Read the data cache configuration register to determine if
 * bus snooping is available. This is needed for some drivers so
 * that they can select the most efficient copy routines.
 */
static inline int set_snooping(void)
{
    unsigned int tmp = *(unsigned int *)0x80000014; /* Cache control register */
    return ((tmp>>23) & 1); /* Data cache snooping enabled */
}

void bsp_start( void )
{
    CPU_SPARC_HAS_SNOOPING = set_snooping();

    LEON_REG->Interrupt_Mask = 0;
    LEON_REG->Interrupt_Force = 0;
    LEON_REG->Interrupt_Clear = 0xFFFF;

    LEON_REG->CIC_Mask = 0;
    LEON_REG->CIC_Clear = 0xFF;

    console_printk_init();
}
