
#ifndef _FFT_H_
#define _FFT_H_

#include <rtems.h>

#define AGGA4_FFT_DEVNAME "/dev/fft"

rtems_device_driver fft_io_initialize(
    rtems_device_major_number major,
    rtems_device_major_number minor,
    void *arg
    );
rtems_device_driver fft_io_open(
    rtems_device_major_number major,
    rtems_device_major_number minor,
    void *arg
    );
rtems_device_driver fft_io_read(
    rtems_device_major_number major,
    rtems_device_major_number minor,
    void *arg
    );
rtems_device_driver fft_io_write(
    rtems_device_major_number major,
    rtems_device_major_number minor,
    void *arg
    );
rtems_device_driver fft_io_close(
    rtems_device_major_number major,
    rtems_device_major_number minor,
    void *arg
    );
rtems_device_driver fft_io_control(
    rtems_device_major_number major,
    rtems_device_major_number minor,
    void *arg
    );

#define AGGA4_FFT_DRIVER_TABLE_ENTRY \
  { fft_io_initialize, fft_io_open, fft_io_close, \
	fft_io_read, fft_io_write, fft_io_control }
typedef void (*fft_isr_func)(void*);


enum {
    /* Set blocking or non-blocking for read/write
     * arg: uint32_t
     */
    FFT_IOCTL_BLOCKING,
    /* Get control register.
     * arg: uint32_t *
     */
    FFT_IOCTL_GET_CTRL,
    /* Set control register.
     * arg: uint32_t
     */
    FFT_IOCTL_SET_CTRL,
    /* Get a value register
     * arg: struct fft_value *
     */
    FFT_IOCTL_GET_VALUE,
    /* Set a value register
     * arg: struct fft_value *
     */
    FFT_IOCTL_SET_VALUE,
    /* Register an ISR
     * arg: struct fft_isr *
     */
    FFT_IOCTL_SET_ISR,
};

struct fft_isr {
    fft_isr_func isr;
    void *arg;
};

struct fft_value
{
    int index;
    uint32_t real;
    uint32_t imag;
};

/* FFT_IOCTL_GET_CTRL argument values */
#define FFT_CTRL_START 0x1

/* FFT_IOCTL_BLOCKING argument values */
#define FFT_NONBLOCKING    0x0
#define FFT_BLOCKING_READ  0x1
#define FFT_BLOCKING_WRITE 0x2
#define FFT_BLOCKING       0x3
#define FFT_POLLING_READ   0x4
#define FFT_POLLING_WRITE  0x8
#define FFT_POLLING        0xC

#endif /* _FFT_H_ */
