#ifndef _SPW_H_
#define _SPW_H_

#include <rtems.h>

#define AGGA4_SPW0_DEVNAME "/dev/spw0"
#define AGGA4_SPW1_DEVNAME "/dev/spw1"
#define AGGA4_SPW2_DEVNAME "/dev/spw2"
#define AGGA4_SPW3_DEVNAME "/dev/spw3"

rtems_device_driver spw_io_initialize(
    rtems_device_major_number major,
    rtems_device_major_number minor,
    void *arg
    );
rtems_device_driver spw_io_open(
    rtems_device_major_number major,
    rtems_device_major_number minor,
    void *arg
    );
rtems_device_driver spw_io_close(
    rtems_device_major_number major,
    rtems_device_major_number minor,
    void *arg
    );
rtems_device_driver spw_io_control(
    rtems_device_major_number major,
    rtems_device_major_number minor,
    void *arg
    );

#define AGGA4_SPW_DRIVER_TABLE_ENTRY \
  { spw_io_initialize, spw_io_open, spw_io_close, \
	NULL, NULL, spw_io_control }

/* DMA IOCTL commands */
enum {
    /* Put link in start state
     * arg: NULL
     */
    SPW_IOCTL_START,
    /* Put link in stopped state
     * arg: NULL
     */
    SPW_IOCTL_STOP,
    /* Put link in autostart state
     * arg: NULL
     */
    SPW_IOCTL_AUTOSTART,
    /* Register an ISR
     * arg: struct spw_isr *
     */
    SPW_IOCTL_SET_ISR,
    /* Receive one packet
     * arg: struct spw_desc *
     */
    SPW_IOCTL_RX,
    /* Transmit one packet
     * arg: struct spw_desc *
     */
    SPW_IOCTL_TX,
    /* Check receive status, returns -1 with errno  set to ETIMEDOUT if area is not full.
     * It has an undefuned behavior if called before SPW_IOCTL_RX has been issued.
     * arg: NULL
     */
    SPW_IOCTL_RX_POLL,
    /* Check transmit status, returns -1 with errno set to ETIMEDOUT if it's not finished.
     * It has an undefuned behavior if called before SPW_IOCTL_TX has been issued.
     * arg: NULL
     */
    SPW_IOCTL_TX_POLL,
    /* Get status flags
     * arg: uint32_t *
     */
    SPW_IOCTL_GET_STATUS,
    /* Set link bitrate
     * arg: int
     */
    SPW_IOCTL_SET_RATE,
    /* Set Rx stop on EOP/EEP
     * arg: int
     */
    SPW_IOCTL_SET_STOP_EOP,
    /* Set little or big endian
     * arg: int
     */
    SPW_IOCTL_SET_ENDIAN,

};

/* SPW_IOCTL_SET_RATE argument values */
#define SPW_RATE_10MBIT    0x0000
#define SPW_RATE_FULL      0x0004
#define SPW_RATE_HALF      0x000C
#define SPW_RATE_QUART     0x0014
#define SPW_RATE_EIGTH     0x001C

/* SPW_IOCTL_GET_STATUS output bit values */
#define SPW_STATUS_FCT     0x1000    /* FCT error */
#define SPW_STATUS_ESC     0x0800    /* ESC error */
#define SPW_STATUS_PAR     0x0400    /* Parity error */
#define SPW_STATUS_DIS     0x0200    /* Disconnect error */
#define SPW_STATUS_OK      0x0100    /* Link OK */

/* SPW_IOCTL_SET_ENDIAN argument values */
#define SPW_ENDIAN_BIG     0x0
#define SPW_ENDIAN_LITTLE  0x1

/* SPW_IOCTL_SET_STOP_EOP argument values */
#define SPW_STOP_EOP_NO    0x0
#define SPW_STOP_EOP_YES   0x1

/* struct spw_isr member irq values */
#define SPW_ISR_RXAREA     4
#define SPW_ISR_EOP        3
#define SPW_ISR_TXDONE     2
#define SPW_ISR_LINK_CON   1
#define SPW_ISR_LINK_ERR   0

typedef void (*spw_isr_func)(void*);

struct spw_isr {
    int irq;
    spw_isr_func isr;
    void *arg;
};

struct spw_desc {
    uint8_t *addr;
    size_t bytes;
};

#endif /* _SPW_H_ */

