#ifndef _TC_H_
#define _TC_H_

#include <rtems.h>

#define AGGA4_TC_DEVNAME "/dev/tc"

rtems_device_driver tc_io_initialize(
    rtems_device_major_number major,
    rtems_device_major_number minor,
    void *arg
    );
rtems_device_driver tc_io_open(
    rtems_device_major_number major,
    rtems_device_major_number minor,
    void *arg
    );
rtems_device_driver tc_io_close(
    rtems_device_major_number major,
    rtems_device_major_number minor,
    void *arg
    );
rtems_device_driver tc_io_control(
    rtems_device_major_number major,
    rtems_device_major_number minor,
    void *arg
    );

#define AGGA4_TC_DRIVER_TABLE_ENTRY \
  { tc_io_initialize, tc_io_open, tc_io_close, \
	NULL, NULL, tc_io_control }

/* TimeCode IOCTL commands */
enum {
    /* Register an ISR for TICK_IN
     * arg: struct tc_isr *
     */
    TC_IOCTL_SET_ISR,
    /* Set time code control bits
     * arg: struct int
     */
    TC_IOCTL_SET_TIMECTRL,
    /* Set time code
     * arg: struct tc_timecode *
     */
    TC_IOCTL_SET_TIMECODE,
    /* Get time code
     * arg: struct tc_timecode *
     */
    TC_IOCTL_GET_TIMECODE,
};

/* TC_IOCTL_SET_TIMECTRL argument values */
#define TC_TIMECTRL_ALL   2
#define TC_TIMECTRL_VALID 1
#define TC_TIMECTRL_NONE  0

typedef void (*tc_isr_func)(void*);

struct tc_isr {
    spw_isr_func isr;
    void *arg;
};

struct tc_timecode {
    char  code;
    char  flag;
};

#endif /* _TC_H_ */
