
#ifndef _CRC_H_
#define _CRC_H_

#include <rtems.h>

#define AGGA4_CRC_DEVNAME "/dev/crc"

rtems_device_driver crc_io_initialize(
    rtems_device_major_number major,
    rtems_device_major_number minor,
    void *arg
    );
rtems_device_driver crc_io_open(
    rtems_device_major_number major,
    rtems_device_major_number minor,
    void *arg
    );
rtems_device_driver crc_io_close(
    rtems_device_major_number major,
    rtems_device_major_number minor,
    void *arg
    );
rtems_device_driver crc_io_control(
    rtems_device_major_number major,
    rtems_device_major_number minor,
    void *arg
    );

#define AGGA4_CRC_DRIVER_TABLE_ENTRY \
  { crc_io_initialize, crc_io_open, crc_io_close, \
	NULL, NULL, crc_io_control }

enum {
    /* Start CRC calculation
     * arg: struct crc_desc *
     */
    CRC_IOCTL_START,
    /* Continue CRC calculation (start without resetting LFSR)
     * arg: struct crc_desc *
     */
    CRC_IOCTL_CONTINUE,
    /* Get CRC result.
     * arg: uint32_t *
     */
    CRC_IOCTL_GET_CRC,
    /* POLL until finished. Cannot be used if an ISR has been set.
     * arg: uint32_t
     */
    CRC_IOCTL_POLL,
    /* Set initial lfsr.
     * arg: NULL
     */
    CRC_IOCTL_SET_LFSR,
    /* Get polynom.
     * arg: uint32_t *
     */
    CRC_IOCTL_GET_POLYNOM,
    /* Set polynom.
     * arg: uint32_t
     */
    CRC_IOCTL_SET_POLYNOM,
    /* Get final XOR value.
     * arg: uint32_t *
     */
    CRC_IOCTL_GET_FINAL_XOR,
    /* Set final XOR value.
     * arg: uint32_t
     */
    CRC_IOCTL_SET_FINAL_XOR,
    /* Get control value.
     * arg: uint32_t *
     */
    CRC_IOCTL_GET_CTRL,
    /* Set control value.
     * arg: uint32_t
     */
    CRC_IOCTL_SET_CTRL,
    /* Register an ISR
     * arg: struct crc_isr *
     */
    CRC_IOCTL_SET_ISR,

};

typedef void (*crc_isr_func)(void*);

struct crc_isr {
    crc_isr_func isr;
    void *arg;
};

struct crc_desc {
    uint8_t *addr;
    size_t bytes;
};

/* CRC_IOCTL_SET_CTRL argument bit values */
#define CRC_CTRL_OUT_LITTLE_ENDIAN 0x2
#define CRC_CTRL_OUT_BIG_ENDIAN    0x0
#define CRC_CTRL_IN_LITTLE_ENDIAN  0x1
#define CRC_CTRL_IN_BIG_ENDIAN     0x0

#define CRC_CTRL_REVERSE_RESULT    CRC_CTRL_OUT_LITTLE_ENDIAN
#define CRC_CTRL_REVERSE_IN_DATA   CRC_CTRL_IN_LITTLE_ENDIAN

/* Pre-defined configuration values */
#define CRC_CCITT_POLY 0x8408
#define CRC_CCITT_LFSR 0xFFFF
#define CRC_CCITT_FXOR 0
#define CRC_CCITT_CTRL 0

#define CRC_CRC16_POLY 0x0000A001
#define CRC_CRC16_LFSR 0
#define CRC_CRC16_FXOR 0
#define CRC_CRC16_CTRL (CRC_CTRL_REVERSE_RESULT|CRC_CTRL_REVERSE_IN_DATA)

#define CRC_CRC32_POLY 0xEDB88320
#define CRC_CRC32_LFSR 0xFFFFFFFF
#define CRC_CRC32_FXOR 0xFFFFFFFF
#define CRC_CRC32_CTRL (CRC_CTRL_REVERSE_RESULT|CRC_CTRL_REVERSE_IN_DATA)

#endif /* _CRC_H_ */
