#ifndef _SPI_H_
#define _SPI_H_

#include <rtems.h>

#define AGGA4_SPI_DEVNAME "/dev/spi"

rtems_device_driver spi_io_initialize(
    rtems_device_major_number major,
    rtems_device_major_number minor,
    void *arg
    );
rtems_device_driver spi_io_open(
    rtems_device_major_number major,
    rtems_device_major_number minor,
    void *arg
    );
rtems_device_driver spi_io_read(
    rtems_device_major_number major,
    rtems_device_major_number minor,
    void *arg
    );
rtems_device_driver spi_io_write(
    rtems_device_major_number major,
    rtems_device_major_number minor,
    void *arg
    );
rtems_device_driver spi_io_close(
    rtems_device_major_number major,
    rtems_device_major_number minor,
    void *arg
    );
rtems_device_driver spi_io_control(
    rtems_device_major_number major,
    rtems_device_major_number minor,
    void *arg
    );

#define AGGA4_SPI_DRIVER_TABLE_ENTRY \
  { spi_io_initialize, spi_io_open, spi_io_close, \
	spi_io_read, spi_io_write, spi_io_control }

enum {
    /* Enable transmitter
     * arg: NULL
     */
    SPI_IOCTL_START,
    /* Disable transmitter
     * arg: NULL
     */
    SPI_IOCTL_STOP,
    /* Set blocking or non-blocking for read/write
     * arg: uint32_t
     */
    SPI_IOCTL_BLOCKING,
    /* Get status flags
     * arg: uint32_t *
     */
    SPI_IOCTL_GET_STATUS,
    /* Register an ISR
     * arg: struct spi_isr *
     */
    SPI_IOCTL_SET_ISR,
    /* Set configuration (device must be stopped)
     * arg: struct spi_config *
     */
    SPI_IOCTL_SET_CONFIG,
    /* Get configuration
     * arg: struct spi_config *
     */
    SPI_IOCTL_GET_CONFIG,
};

typedef void (*spi_isr_func)(void*);

struct spi_isr {
    spi_isr_func isr;
    void *arg;
};

/* SPI_IOCTL_GET_STATUS output bit values */
#define SPI_STATUS_XMT_DONE  0x400    /* Tx done */
#define SPI_STATUS_XMT_EMPTY 0x200    /* Tx empty */
#define SPI_STATUS_RX_AVAIL  0x100    /* Rx available */

/* struct spi_config member values */
#define SPI_CONFIG_SLAVE5           0x10
#define SPI_CONFIG_SLAVE4           0x08
#define SPI_CONFIG_SLAVE3           0x04
#define SPI_CONFIG_SLAVE1           0x02
#define SPI_CONFIG_SLAVE0           0x01
#define SPI_CONFIG_MSB_FIRST        0
#define SPI_CONFIG_LSB_FIRST        1
#define SPI_CONFIG_CLK_SEL_GENERATE 0
#define SPI_CONFIG_CLK_SEL_RECEIVE  1
#define SPI_CONFIG_CLK_PHS_FIRST    0
#define SPI_CONFIG_CLK_PHS_SECOND   1
#define SPI_CONFIG_CLK_POL_LOW      0
#define SPI_CONFIG_CLK_POL_HIGH     1
#define SPI_CONFIG_RCLK_POL_FALLING 0
#define SPI_CONFIG_RCLK_POL_RISING  1

/* SPI_IOCTL_BLOCKING argument values */
#define SPI_NONBLOCKING    0x0
#define SPI_BLOCKING_READ  0x1
#define SPI_BLOCKING_WRITE 0x2
#define SPI_BLOCKING       0x3
#define SPI_POLLING_READ   0x4
#define SPI_POLLING_WRITE  0x8
#define SPI_POLLING        0xC

struct spi_config {
    uint32_t length; /* Value between 8 and 16 */
    uint32_t slave;  /* Bit mask */
    int started;     /* Ignored when calling SPI_IOCTL_SET_CONFIG */
    int continous;   /* Boolean */
    int msb_first;   /* Boolean */
    int clk_sel;     /* Boolean */
    int clk_phase;   /* Boolean */
    int clk_pol;     /* Boolean */
    int rcv_clk_pol; /* Boolean */
    uint32_t clk_div;/* Value between 0 255*/
};

#endif /* _SPI_H_ */
