/*
 *  Secondary interrupt controller interface
 *
 *  COPYRIGHT (c) 2007.
 *  Gaisler Research
 *
 *  The license and distribution terms for this file may be
 *  found in the file LICENSE in this distribution or at
 *  http://www.rtems.com/license/LICENSE.
 */

#ifndef __SIRQ_H__
#define __SIRQ_H__

struct leon2_sirq_regs {
	unsigned int imask;
	unsigned int ipend;
	unsigned int status_iclear;
};

#define SIRQ_STATUS_IP 0x20
#define SIRQ_STATUS_IRL 0x1f

#define LEON2_SIRQ_DEFAULT_ADDRESS  0x800000b0
#define LEON2_SIRQ_DEFAULT_IRQ      10

/* Initialize the secondary interrupt controller */
void leon2_sirq_init(unsigned int address, int irq);

/* Register a secondary IRQ handler (isr)*/
int leon2_sirq_register_handler(int irq, void (*sisr)(int irq, void *arg), void *arg);

/* Mask an IRQ (disable) */
void leon2_sirq_mask(int irq);

/* Unmask an IRQ (enable) */
void leon2_sirq_unmask(int irq);

/* Clear Pending interrupts */
void leon2_sirq_clrpend(int irq);

void leon2_sirq_setpend(int irq);

#if 0 
/* unmask (enable) secondary irq controller */
void leon2_sirq_global_unmask(void);

/* mask (disable) secondary irq controller */
void leon2_sirq_global_mask(void);
#endif

#endif
