/*
 *  LEON2-FT based SpaceWire Remote Terminal (SPWRTC) 
 *  definitions.
 * 
 *  COPYRIGHT (c) 2007.
 *  Gaisler Research
 *
 *  The license and distribution terms for this file may be
 *  found in the file LICENSE in this distribution or at
 *  http://www.rtems.com/license/LICENSE.
 */


#ifndef __SPWRTC_H__
#define __SPWRTC_H__


/* The On-chip RAM memory map:
 * What                      Offset       Size   Alignment
 * |----------------------|  0xa0000000   64k
 * | GRFIFO TX BUFFERS    |  0            1k     1k
 * |----------------------|
 * | GRFIFO RX BUFFERS    |  1k           1k     1k
 * |----------------------|
 * |
 * |
 * |
 *
 * Note: The memory have alignment needs to be
 *       fulfilled.
 */


#define ONCHIP_MEM_GRFIFO_TXBUF_SIZE 1024
#define ONCHIP_MEM_GRFIFO_RXBUF_SIZE 1024
#define ONCHIP_MEM_GRCAN_TXBUF_SIZE  1024
#define ONCHIP_MEM_GRCAN_RXBUF_SIZE  1024

#define ONCHIP_MEM_BASE 0xA0000000

/* 1k alignment need for GRFIFO TX address */
#define ONCHIP_MEM_GRFIFO_TXBUF ONCHIP_MEM_BASE

/* 1k alignment need for GRFIFO RX address */
#define ONCHIP_MEM_GRFIFO_RXBUF (ONCHIP_MEM_GRFIFO_TXBUF+ONCHIP_MEM_GRFIFO_TXBUF_SIZE)

#define ONCHIP_MEM_GRCAN_TXBUF
#define ONCHIP_MEM_GRCAN_RXBUF

#endif __SPWRTC_H__
