/*
 *  AMBA Plag & Play Bus Core definitions
 *
 *  COPYRIGHT (c) 2007.
 *  Gaisler Research
 *
 *  The license and distribution terms for this file may be
 *  found in the file LICENSE in this distribution or at
 *  http://www.rtems.com/license/LICENSE.
 *
 */

#ifndef __AMBAPPDEVS_H__
#define __AMBAPPDEVS_H__

/* Vendor codes */ 
#define VENDOR_GAISLER   1
#define VENDOR_PENDER    2
#define VENDOR_ESA       4 
#define VENDOR_OPENCORES 8 

/* Gaisler Research device id's */
#define GAISLER_LEON3     0x03 
#define GAISLER_LEON3DSU  0x04 
#define GAISLER_ETHAHB    0x05 
#define	GAISLER_APBMST    0x06 
#define	GAISLER_AHBUART   0x07 
#define	GAISLER_SRCTRL    0x08 
#define GAISLER_SDCTRL    0x09 
#define	GAISLER_APBUART   0x0C 
#define	GAISLER_IRQMP     0x0D 
#define	GAISLER_AHBRAM    0x0E 
#define	GAISLER_GPTIMER   0x11
#define	GAISLER_PCITRG    0x12
#define	GAISLER_PCISBRG   0x13
#define	GAISLER_PCIFBRG   0x14
#define	GAISLER_PCITRACE  0x15
#define	GAISLER_DMACTRL   0x16
#define GAISLER_OCCAN     0x19
#define GAISLER_PIOPORT   0x1A
#define GAISLER_ETHMAC    0x1D
#define GAISLER_SPACEWIRE 0x1f
#define GAISLER_AHB2AHB   0x20
#define GAISLER_GRHCAN    0x34
#define GAISLER_GRFIFO    0x35
#define GAISLER_GRPULSE   0x37
#define GAISLER_GRTIMER   0x38
#define GAISLER_FTMCTRL   0x54
#define GAISLER_BRM       0x72
 
/* European Space Agency device id's */
#define ESA_LEON2        0x2
#define ESA_MCTRL        0xF
#define ESA_SPW2         0x12

/* Opencores device id's */
#define OPENCORES_PCIBR  0x4
#define OPENCORES_ETHMAC 0x5


/* Core register definitions */




#endif /* __AMBAPPDEVS_H__ */

