/* threadsup.h
 *
 *  threadsup.h,v 1.17 2000/10/31 16:33:48 joel Exp
 */

#ifndef __RTEMS_POSIX_THREAD_SUPPORT_h
#define __RTEMS_POSIX_THREAD_SUPPORT_h

#include <sys/signal.h>
#include <rtems/score/coresem.h>
#include <rtems/score/tqdata.h>

typedef struct {
  pthread_attr_t          Attributes;
  int                     detachstate;
  Thread_queue_Control    Join_List;
  int                     schedpolicy;
  struct sched_param      schedparam;
  int                     ss_high_priority;
  Watchdog_Control        Sporadic_timer;

  sigset_t                signals_blocked;
  sigset_t                signals_pending;

#if 0
  /*
   *  POSIX Interrupts 
   */
  unsigned32              interrupts_installed;
  CORE_semaphore_Control  Interrupt_Semaphore;
#endif

  /*
   *  POSIX Cancelability 
   */
  int                     cancelability_state;
  int                     cancelability_type;
  int                     cancelation_requested;
  Chain_Control           Cancellation_Handlers;

} POSIX_API_Control;

#endif
/* end of include file */

