/* Simple GRCAN interface test.
 * 
 * Gaisler Research 2007,
 * Daniel Hellstrm
 *
 */

#include <rtems.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sched.h>
#include <ctype.h>
#include <string.h>

#undef CANRX_ONLY
#define STATUS_PRINT

/*
#undef UART_TEST
#undef SPW_TEST
#undef CAN_TEST
#define BRM_TEST
*/
#define CONFIGURE_INIT
#include <bsp.h> /* for device driver prototypes */

rtems_task Init( rtems_task_argument argument);	/* forward declaration needed */

/* configuration information */
#define CONFIGURE_APPLICATION_NEEDS_CONSOLE_DRIVER
#define CONFIGURE_APPLICATION_NEEDS_CLOCK_DRIVER
#define CONFIGURE_MAXIMUM_TASKS             16
#define CONFIGURE_RTEMS_INIT_TASKS_TABLE
#define CONFIGURE_EXTRA_TASK_STACKS         (20 * RTEMS_MINIMUM_STACK_SIZE)
#define CONFIGURE_LIBIO_MAXIMUM_FILE_DESCRIPTORS 32
#define CONFIGURE_INIT_TASK_PRIORITY	100
#define CONFIGURE_MAXIMUM_DRIVERS 16

#include <confdefs.h>
#include <stdio.h>
#include <stdlib.h>

#include <pci.h>
#include <rasta.h>

rtems_task status_task1(rtems_task_argument argument);

extern int can_init(amba_confarea_type *amba_bus);
extern void can_start(void);
extern void can_print_stats(void);

extern int b1553_init(amba_confarea_type *amba_bus);
extern void b1553_start(void);
extern void b1553_print_stats(void);

extern int spw_init(amba_confarea_type *amba_bus);
extern void spw_start(void);
extern void spw_print_stats(void);

extern int uart_init(void);
extern void uart_start(void);
extern void uart_print_stats(void);


#ifdef STATUS_PRINT
int status_init(void);
void status_start(void);

static rtems_id   tds[1];        /* array of task ids */
static rtems_name tnames[1];     /* array of task names */
#endif

amba_confarea_type amba_bus;

/* ========================================================= 
   initialisation */

rtems_task Init(
  rtems_task_argument ignored
)
{
  rtems_status_code status;
  
  printf("******** Starting RASTA test ********\n");
  
  
  printf("Initializing PCI\n");
  /* Init AT697 PCI Controller */
	init_pci();
  
  printf("Registering RASTA drivers: ");
  fflush(NULL);
  if  ( rasta_register() ){
    printf("Error\n");
    /*exit(1);*/
  }
  printf("OK\n");

#ifdef UART_TEST
  if ( uart_init() ){
    printf("UART INITIALIZATION FAILED, aborting\n");
    exit(1);
  }
#endif  
  
#ifdef CAN_TEST
  if ( can_init(&amba_bus) ){
    printf("CAN INITIALIZATION FAILED, aborting\n");
    exit(1);
  }
#endif

#ifdef BRM_TEST
  if ( b1553_init(&amba_bus) ){
    printf("BRM INITIALIZATION FAILED, aborting\n");
    exit(2);
  }
#endif

#ifdef SPW_TEST
  if ( spw_init(&amba_bus) ){
    printf("SPW INITIALIZATION FAILED, aborting\n");
    exit(3);
  }
#endif

#ifdef STATUS_PRINT
  if ( status_init() ){
    printf("STATUS INITIALIZATION FAILED, aborting\n");
    exit(4);
  }
#endif
  

#ifdef UART_TEST
  uart_start();
#endif

#ifdef CAN_TEST
  can_start();
#endif

#ifdef BRM_TEST
  b1553_start();
#endif

#ifdef SPW_TEST
  spw_start();
#endif

#ifdef STATUS_PRINT
  status_start();
#endif

  status = rtems_task_delete(RTEMS_SELF);
}

#ifdef STATUS_PRINT

int status_init(void)
{
  int i;
  rtems_status_code status;
  
  for ( i=0; i<1; i++){
    tnames[i] = rtems_build_name( 'T', 'D', 'C', '0'+i );
  }
  
  status = rtems_task_create(
    tnames[0], 1, RTEMS_MINIMUM_STACK_SIZE * 4,
    RTEMS_DEFAULT_MODES | RTEMS_PREEMPT,
    RTEMS_DEFAULT_ATTRIBUTES, &tds[0]
    );
  if ( status != RTEMS_SUCCESSFUL )
    return -1;
  
  return 0;
}

void status_start(void)
{
  rtems_status_code status;
  
  printf("Starting status task1\n");
  
  /* Starting receiver first */
	status = rtems_task_start(tds[0], status_task1, 1);
}

/* TX Task */
rtems_task status_task1(
        rtems_task_argument unused
) 
{
  while(1){
    /* print stats */

#ifdef UART_TEST
    uart_print_stats();
    sched_yield();
#endif

#ifdef CAN_TEST
    can_print_stats();
    sched_yield();
#endif

#ifdef BRM_TEST
    b1553_print_stats();
    sched_yield();
#endif

#ifdef SPW_TEST
    spw_print_stats();
    sched_yield();
#endif

    sleep(2);
  }

}
#endif
