/************************************************************************/
/*   This file is a part of the mkprom3 boot-prom utility               */
/*   Copyright (C) 2004 Gaisler Research                                */
/*                                                                      */
/*   This library is free software; you can redistribute it and/or      */
/*   modify it under the terms of the GNU General Public                */
/*   License as published by the Free Software Foundation; either       */
/*   version 2 of the License, or (at your option) any later version.   */
/*                                                                      */
/*   See the file COPYING.GPL for the full details of the license.      */
/************************************************************************/

	
/*
 * locore.s for LEON3
 *
 */
 
/* The traptable has to be the first code in a boot PROM. */

/* Entry for traps which jump to a programmer-specified trap handler.  */
#define TRAPR(H)  wr %g0, 0xfe0, %psr; mov %g0, %tbr; ba (H); mov %g0, %wim;
#define TRAP(H)  mov %psr, %l0; sethi %hi(H), %l4; jmp %l4+%lo(H); nop;

/* Unexcpected trap will halt the processor by forcing it to error state */
#define BAD_TRAP ta 0; nop; nop; nop;

#define WIM_INIT   2

  .seg    "text"
  .global _trap_table, start, _memcfg1, _memcfg2, _stack, _ftreg 
  .global bdinit1, bdinit2, main, getpsr

start:
_trap_table:
  TRAPR(_hardreset);		! 00 reset trap 
  BAD_TRAP;      		! 01 instruction_access_exception
  BAD_TRAP;      		! 02 illegal_instruction
  BAD_TRAP;      		! 03 priveleged_instruction
  TRAP(_fpu_dis);		! 04 fp_disabled
  TRAP(_window_overflow);	! 05 window_overflow
  TRAP(_window_underflow);	! 06 window_underflow

_hardreset:

	flush
	clr	%g1
	clr	%g2
	clr	%g3
	clr	%g4
	clr	%g5
	clr	%g6
	clr	%g7

	set	noinit, %g2		! Load memory config register 1
	ld	[%g2], %g2
	subcc   %g2, %g0, %g0
	bne	sysini0

	set	0x81000f, %g2
	mov	%psr, %g1
	srl	%g1, 24, %g1
	and  	%g1, 0x0f, %g1
	subcc	%g1, 3, %g1
	be	1f
	set     0x80000000, %g1
  	st	%g2, [%g1+0x14]
	set	0xAA00, %g3
	ba 2f
  	st	%g3, [%g1+0xA4]
1:
	set	_memcaddr, %g1
	ld	[%g1], %g1		
  	sta	%g2, [%g0] 2	        ! enable LEON3 cache
        st      %g0, [%g1 + 0x08]     
2:
	set	_memcfg1, %g2		! Load memory config register 1
	ld	[%g2], %g2
  	ld	[%g1], %g3		! 
	and	%g3, 0x300, %g3
	or	%g2, %g3, %g2
  	st	%g2, [%g1 + 0x00]
	set	_memcfg3, %g2		! Load memory config register 3
	ld	[%g2], %g2
  	st	%g2, [%g1 + 0x08]
	set	_memcfg2, %g2		! Load memory config register 2
	ld	[%g2], %g2
  	st	%g2, [%g1 + 0x04]

	set	freq, %g2		! Load timer scaler register
	ld	[%g2], %g2
	be	1f
	sub	%g2, 1, %g2

	st	%g2, [%g1 + 0x64]
	st	%g2, [%g1 + 0x60]
	set	-1, %g3
	st	%g3, [%g1 + 0x40]
	st	%g3, [%g1 + 0x44]
	set	7, %g3
	st	%g3, [%g1 + 0x48]
	set	0x80000070, %g1
	ba	2f
	nop
1:
	set	_gptaddr, %g1
	ld	[%g1], %g1	
  	st	%g2, [%g1 + 0x4]
  	st	%g2, [%g1 + 0x0]

	set	_uaddr, %g1
	ld	[%g1], %g1	
2:
	set	_uart, %g2		! Load UART scaler register
	ld	[%g2], %g2
  	st	%g2, [%g1 + 0xc]
	set	3, %g2			! Enable UART
  	st	%g2, [%g1 + 0x8]
	st	%g0, [%g1 + 0x4]

sysini0:
	set	WIM_INIT, %g3
	mov	%g3, %wim
	set	0x1000, %g3
	mov	%psr, %g2
	wr	%g2, %g3, %psr
	nop; nop; nop
	set	fsrinit, %g4
	ld	[%g4], %fsr		! Check if FPU is present

	ba	fixfpu
	nop

fsrinit:
	.word 0

! FPU disabled trap address

_fpu_dis:
	mov	%g2, %psr
	nop; nop; nop
	ba    sysini
	nop
	

! Wash FPU register file

fixfpu:

	subcc	%g6, 0, %g0
	be	sysini		

	ldd	[%g0], %f0
	ldd	[%g0], %f2
	ldd	[%g0], %f4
	ldd	[%g0], %f6
	ldd	[%g0], %f8
	ldd	[%g0], %f10
	ldd	[%g0], %f12
	ldd	[%g0], %f14
	ldd	[%g0], %f16
	ldd	[%g0], %f18
	ldd	[%g0], %f20
	ldd	[%g0], %f22
	ldd	[%g0], %f24
	ldd	[%g0], %f26
	ldd	[%g0], %f28
	ldd	[%g0], %f30

! System init

sysini:

	call	bdinit1
	nop

	set	_stack, %g2
	ld	[%g2], %fp
	andn	%fp, 0x0f, %fp
	sub	%fp, 64, %sp

	set	noinit, %g2		! 
	ld	[%g2], %g2
	subcc   %g2, %g0, %g0
	bne	_init

	set	0x20000, %o0
	sub	%fp, %o0, %o1
memclr:					! Scrub top 64K of RAM
	subcc	%o0, 8, %o0
	bg	memclr
	std	%g4, [%o0 + %o1]
	
 
_init:

	call	bdinit2
	nop
	call	main
        nop

	ta 	0			! Halt if _main would return ...
	nop



/* Number of register windows */
#define NWINDOWS 	8

  	 		!Window overflow trap handler.
  	.global _window_overflow

_window_overflow:

  	mov  %wim, %l3       		! Calculate next WIM
  	mov  %g1, %l7           
  	srl  %l3, 1, %g1        
  	sll  %l3, NWINDOWS-1 , %l4
  	or   %l4, %g1, %g1

  	save                              ! Get into window to be saved.
  	mov  %g1, %wim
  	nop; nop; nop
        st   %l0, [%sp + 0];
        st   %l1, [%sp + 4];
        st   %l2, [%sp + 8];
        st   %l3, [%sp + 12];
        st   %l4, [%sp + 16]; 
        st   %l5, [%sp + 20];
        st   %l6, [%sp + 24]; 
        st   %l7, [%sp + 28]; 
        st   %i0, [%sp + 32]; 
        st   %i1, [%sp + 36]; 
        st   %i2, [%sp + 40]; 
        st   %i3, [%sp + 44]; 
        st   %i4, [%sp + 48]; 
        st   %i5, [%sp + 52]; 
        st   %i6, [%sp + 56]; 
        st   %i7, [%sp + 60];
  	restore				! Go back to trap window.
  	mov  %l7, %g1
  	jmp  %l1			! Re-execute save.
  	rett %l2

  /* Window underflow trap handler.  */

  	.global  _window_underflow

_window_underflow:

	mov  %wim, %l3			! Calculate next WIM
	sll  %l3, 1, %l4
  	srl  %l3, NWINDOWS-1, %l5
  	or   %l5, %l4, %l5
  	mov  %l5, %wim
  	nop; nop; nop
  	restore				! Two restores to get into the
  	restore				! window to restore
        ld   [%sp + 0], %l0; 		! Restore window from the stack
        ld   [%sp + 4], %l1; 
        ld   [%sp + 8], %l2; 
        ld   [%sp + 12], %l3; 
        ld   [%sp + 16], %l4; 
        ld   [%sp + 20], %l5; 
        ld   [%sp + 24], %l6; 
        ld   [%sp + 28], %l7; 
        ld   [%sp + 32], %i0; 
        ld   [%sp + 36], %i1; 
        ld   [%sp + 40], %i2; 
        ld   [%sp + 44], %i3; 
        ld   [%sp + 48], %i4; 
        ld   [%sp + 52], %i5; 
        ld   [%sp + 56], %i6; 
        ld   [%sp + 60], %i7;
  	save				! Get back to the trap window.
  	save
  	jmp  %l1			! Re-execute restore.
  	rett  %l2

getpsr:
	retl
	mov %psr, %o0
