/************************************************************************/
/*   This file is a part of the mkprom3 boot-prom utility               */
/*   Copyright (C) 2004 Gaisler Research                                */
/*                                                                      */
/*   This library is free software; you can redistribute it and/or      */
/*   modify it under the terms of the GNU General Public                */
/*   License as published by the Free Software Foundation; either       */
/*   version 2 of the License, or (at your option) any later version.   */
/*                                                                      */
/*   See the file COPYING.GPL for the full details of the license.      */
/************************************************************************/

#define	USR	4/4
#define TXA	0/4

#define	SECNAME	16

typedef struct sectype
{
    unsigned int paddr;
    unsigned int raddr;
    unsigned int len;
    unsigned int comp;
    unsigned char name[SECNAME];
} tt;


extern char filename[];
extern struct sectype sections[];
extern int prot;
extern volatile unsigned int *_uaddr;

void
putsx (s)
     unsigned char *s;
{
    volatile unsigned int *ubase;
    if (((getpsr()>>24) & 0x0f) != 3) ubase = (int *) 0x80000070;
    else ubase = _uaddr;
    while (s[0] != 0)
      {
	  while ((ubase[USR] & 4) == 0);
	  ubase[TXA] = *s;
	  s++;
      }
}


__main ()
{
}

extern int ramsize, etext, freq, bmsg, _stack;
void clean ();
extern int Decode ();
extern char configmsg[];
extern int noinit;
extern int _entry;

main ()
{
    unsigned char *p;
    int paddr, raddr, len, secnum;
    void (*prog) ();
    char pbuf[8192];

    prog = (void *) _entry;
    if (bmsg)
      {
	  putsx ("\n\n\r  MkProm LEON3 boot loader v1.2\n\r");
	  putsx ("  Copyright Gaisler Research - all right reserved\n\n\r");
	  putsx (configmsg);
	  putsx ("\n\r");
      }
    secnum = 0;
    while (sections[secnum].paddr)
      {
	  paddr = sections[secnum].paddr;
	  raddr = sections[secnum].raddr;
	  len = sections[secnum].len;
	  if (sections[secnum].comp)
	    {
		if (bmsg)
		  {
		      putsx ("  decompressing ");
		      putsx (sections[secnum].name);
		      putsx ("\n\r");
		  }
		if (Decode (raddr, paddr))
		  {
		      putsx ("  decompression failed \n\r");
		  }

	    }
	  else
	    {
		if (bmsg)
		  {
		      putsx ("  loading ");
		      putsx (sections[secnum].name);
		      putsx ("\n\r");
		  }
		mmov (raddr, paddr, len);
	    }
	  secnum++;
      }

    *((int *) (sections[0].paddr + 0x7e0)) = freq;
    if (bmsg)
      {
	  putsx ("\n\r  starting ");
	  putsx (filename);
	  putsx ("\n\n\r");
      }
    prog ();
}

void
clean (paddr, len)
     double *paddr;
     int len;
{
    len >>= 3;
    while (len >= 0)
      {
	  paddr[len] = 0;
	  len--;
      }
}

mmov (raddr, paddr, len)
     int *raddr, *paddr;
     int len;
{
    len >>= 2;
    while (len >= 0)
      {
	  paddr[len] = raddr[len];
	  len--;
      }
}
