/* STATIC PCI CONFIGURATION EXAMPLE (AUTOGENERATED FROM A LEON PCI SYSTEM) */

/*** PCI Configuration ***/

#include <stdlib.h>
#define PCI_CFG_STATIC_LIB
#include <pci/cfg.h>

#define PCIRES_EMPTY {0}

/* FORWARD BUS DECLARATIONS */
struct pci_bus pci_hb;
static struct pci_bus bus1;
static struct pci_bus bus2;

/* FORWARD DEVICE DECLARATIONS */
static struct pci_dev dev_0_1_0;
static struct pci_dev dev_0_2_0;
static struct pci_dev dev_0_3_0;
static struct pci_dev dev_0_5_0;
static struct pci_dev dev_1_2_0;
static struct pci_dev dev_2_0_0;
static struct pci_dev dev_0_c_0;
static struct pci_dev dev_0_f_0;


/* PCI BUS 0 - Bridge at [0:0:0] */

struct pci_bus pci_hb = {
        .dev = {
                .resources = {
                        PCIRES_EMPTY,
                        PCIRES_EMPTY,
                        PCIRES_EMPTY,
                        PCIRES_EMPTY,
                        PCIRES_EMPTY,
                        PCIRES_EMPTY,
                        PCIRES_EMPTY,
                },
                .next = NULL,
                .bus = NULL,
                .busdevfun = 0x0000,
                .flags = 0x1,
                .sysirq = 0,
                .command = 0,
        },
        .devs = &dev_0_1_0,
        .flags = 0x3,
        .num = 0,
        .pri = 0,
        .sord = 2,
};


/* PCI DEV at [0:1:0] */
static struct pci_dev dev_0_1_0 = {
        .resources = {
                {
                        .next = NULL,
                        .size = 0x00000100,
                        .boundary = 0x00000100,
                        .flags = 0x9,
                        .bar = 0,
                        .start = 0xff800200,
                        .end = 0xff800300,
                },
                {
                        .next = NULL,
                        .size = 0x00001000,
                        .boundary = 0x00001000,
                        .flags = 0x2,
                        .bar = 1,
                        .start = 0x82043000,
                        .end = 0x82044000,
                },
                PCIRES_EMPTY,
                PCIRES_EMPTY,
                PCIRES_EMPTY,
                PCIRES_EMPTY,
                PCIRES_EMPTY,
        },
        .next = &dev_0_2_0,
        .bus = &pci_hb,
        .busdevfun = 0x0008,
        .flags = 0x0,
        .sysirq = 4,
        .command = 0,
};


/* PCI DEV at [0:2:0] */
static struct pci_dev dev_0_2_0 = {
        .resources = {
                PCIRES_EMPTY,
                PCIRES_EMPTY,
                PCIRES_EMPTY,
                PCIRES_EMPTY,
                PCIRES_EMPTY,
                PCIRES_EMPTY,
                PCIRES_EMPTY,
        },
        .next = &dev_0_3_0,
        .bus = &pci_hb,
        .busdevfun = 0x0010,
        .flags = 0x0,
        .sysirq = 0,
        .command = 0,
};


/* PCI DEV at [0:3:0] */
static struct pci_dev dev_0_3_0 = {
        .resources = {
                {
                        .next = NULL,
                        .size = 0x00001000,
                        .boundary = 0x00001000,
                        .flags = 0x2,
                        .bar = 0,
                        .start = 0x82042000,
                        .end = 0x82043000,
                },
                {
                        .next = NULL,
                        .size = 0x00000100,
                        .boundary = 0x00000100,
                        .flags = 0x1,
                        .bar = 1,
                        .start = 0xff800100,
                        .end = 0xff800200,
                },
                PCIRES_EMPTY,
                PCIRES_EMPTY,
                PCIRES_EMPTY,
                PCIRES_EMPTY,
                PCIRES_EMPTY,
        },
        .next = &dev_0_5_0,
        .bus = &pci_hb,
        .busdevfun = 0x0018,
        .flags = 0x0,
        .sysirq = 12,
        .command = 0,
};


/* PCI DEV at [0:5:0] */
static struct pci_dev dev_0_5_0 = {
        .resources = {
                {
                        .next = NULL,
                        .size = 0x00001000,
                        .boundary = 0x00001000,
                        .flags = 0x2,
                        .bar = 0,
                        .start = 0x82041000,
                        .end = 0x82042000,
                },
                {
                        .next = NULL,
                        .size = 0x00000040,
                        .boundary = 0x00000040,
                        .flags = 0x9,
                        .bar = 1,
                        .start = 0xff800300,
                        .end = 0xff800340,
                },
                {
                        .next = NULL,
                        .size = 0x00020000,
                        .boundary = 0x00020000,
                        .flags = 0x2,
                        .bar = 2,
                        .start = 0x83020000,
                        .end = 0x83040000,
                },
                PCIRES_EMPTY,
                PCIRES_EMPTY,
                PCIRES_EMPTY,
                {
                        .next = NULL,
                        .size = 0x00010000,
                        .boundary = 0x00010000,
                        .flags = 0x2,
                        .bar = 6,
                        .start = 0x82030000,
                        .end = 0x82040000,
                },
        },
        .next = &bus1.dev,
        .bus = &pci_hb,
        .busdevfun = 0x0028,
        .flags = 0x0,
        .sysirq = 4,
        .command = 0,
};


/* PCI BUS 1 - Bridge at [0:9:0] */

static struct pci_bus bus1 = {
        .dev = {
                .resources = {
                        PCIRES_EMPTY,
                        PCIRES_EMPTY,
                        {
                                .next = NULL,
                                .size = 0x00000100,
                                .boundary = 0x00001000,
                                .flags = 0x1,
                                .bar = 2,
                                .start = 0xff800000,
                                .end = 0xff800100,
                        },
                        {
                                .next = NULL,
                                .size = 0x00804100,
                                .boundary = 0x00800000,
                                .flags = 0x2,
                                .bar = 3,
                                .start = 0x82800000,
                                .end = 0x83004100,
                        },
                        {
                                .next = NULL,
                                .size = 0x02030000,
                                .boundary = 0x02000000,
                                .flags = 0x2,
                                .bar = 4,
                                .start = 0x80000000,
                                .end = 0x82030000,
                        },
                        PCIRES_EMPTY,
                        PCIRES_EMPTY,
                },
                .next = &dev_0_c_0,
                .bus = &pci_hb,
                .busdevfun = 0x0048,
                .flags = 0x1,
                .sysirq = 0,
                .command = 0,
        },
        .devs = &dev_1_2_0,
        .flags = 0xf,
        .num = 1,
        .pri = 0,
        .sord = 2,
};


/* PCI DEV at [1:2:0] */
static struct pci_dev dev_1_2_0 = {
        .resources = {
                {
                        .next = NULL,
                        .size = 0x00000100,
                        .boundary = 0x00000100,
                        .flags = 0x9,
                        .bar = 0,
                        .start = 0xff800000,
                        .end = 0xff800100,
                },
                {
                        .next = NULL,
                        .size = 0x00000100,
                        .boundary = 0x00000100,
                        .flags = 0x2,
                        .bar = 1,
                        .start = 0x83004000,
                        .end = 0x83004100,
                },
                PCIRES_EMPTY,
                PCIRES_EMPTY,
                PCIRES_EMPTY,
                PCIRES_EMPTY,
                {
                        .next = NULL,
                        .size = 0x00010000,
                        .boundary = 0x00010000,
                        .flags = 0x3,
                        .bar = 6,
                        .start = 0x82020000,
                        .end = 0x82030000,
                },
        },
        .next = &bus2.dev,
        .bus = &bus1,
        .busdevfun = 0x0110,
        .flags = 0x0,
        .sysirq = 12,
        .command = 0,
};


/* PCI BUS 2 - Bridge at [1:3:0] */

static struct pci_bus bus2 = {
        .dev = {
                .resources = {
                        PCIRES_EMPTY,
                        PCIRES_EMPTY,
                        PCIRES_EMPTY,
                        {
                                .next = NULL,
                                .size = 0x00804000,
                                .boundary = 0x00800000,
                                .flags = 0x2,
                                .bar = 3,
                                .start = 0x82800000,
                                .end = 0x83004000,
                        },
                        {
                                .next = NULL,
                                .size = 0x02020000,
                                .boundary = 0x02000000,
                                .flags = 0x3,
                                .bar = 4,
                                .start = 0x80000000,
                                .end = 0x82020000,
                        },
                        PCIRES_EMPTY,
                        PCIRES_EMPTY,
                },
                .next = NULL,
                .bus = &bus1,
                .busdevfun = 0x0118,
                .flags = 0x1,
                .sysirq = 0,
                .command = 0,
        },
        .devs = &dev_2_0_0,
        .flags = 0xf,
        .num = 2,
        .pri = 1,
        .sord = 2,
};


/* PCI DEV at [2:0:0] */
static struct pci_dev dev_2_0_0 = {
        .resources = {
                {
                        .next = NULL,
                        .size = 0x02000000,
                        .boundary = 0x02000000,
                        .flags = 0x3,
                        .bar = 0,
                        .start = 0x80000000,
                        .end = 0x82000000,
                },
                {
                        .next = NULL,
                        .size = 0x00004000,
                        .boundary = 0x00004000,
                        .flags = 0x2,
                        .bar = 1,
                        .start = 0x83000000,
                        .end = 0x83004000,
                },
                {
                        .next = NULL,
                        .size = 0x00800000,
                        .boundary = 0x00800000,
                        .flags = 0x2,
                        .bar = 2,
                        .start = 0x82800000,
                        .end = 0x83000000,
                },
                PCIRES_EMPTY,
                PCIRES_EMPTY,
                PCIRES_EMPTY,
                {
                        .next = NULL,
                        .size = 0x00020000,
                        .boundary = 0x00020000,
                        .flags = 0x3,
                        .bar = 6,
                        .start = 0x82000000,
                        .end = 0x82020000,
                },
        },
        .next = NULL,
        .bus = &bus2,
        .busdevfun = 0x0200,
        .flags = 0x0,
        .sysirq = 3,
        .command = 0,
};


/* PCI DEV at [0:c:0] */
static struct pci_dev dev_0_c_0 = {
        .resources = {
                PCIRES_EMPTY,
                PCIRES_EMPTY,
                PCIRES_EMPTY,
                PCIRES_EMPTY,
                PCIRES_EMPTY,
                PCIRES_EMPTY,
                PCIRES_EMPTY,
        },
        .next = &dev_0_f_0,
        .bus = &pci_hb,
        .busdevfun = 0x0060,
        .flags = 0x0,
        .sysirq = 0,
        .command = 0,
};


/* PCI DEV at [0:f:0] */
static struct pci_dev dev_0_f_0 = {
        .resources = {
                {
                        .next = NULL,
                        .size = 0x00001000,
                        .boundary = 0x00001000,
                        .flags = 0x2,
                        .bar = 0,
                        .start = 0x82040000,
                        .end = 0x82041000,
                },
                PCIRES_EMPTY,
                PCIRES_EMPTY,
                PCIRES_EMPTY,
                PCIRES_EMPTY,
                PCIRES_EMPTY,
                PCIRES_EMPTY,
        },
        .next = NULL,
        .bus = &pci_hb,
        .busdevfun = 0x0078,
        .flags = 0x0,
        .sysirq = 12,
        .command = 0,
};
