/*  semaphore.h
 *
 *  $Id: semaphore.h,v 1.4 1999/04/26 18:22:08 joel Exp $
 */

#ifndef __POSIX_SEMAPHORE_h
#define __POSIX_SEMAPHORE_h

#ifdef __cplusplus
extern "C" {
#endif

#include <sys/features.h>

#if defined(_POSIX_SEMAPHORES)

#include <sys/time.h>

/*
 *  11.1 Semaphore Characteristics, P1003.1b-1993, p.219
 */

typedef int sem_t;

/*
 *  11.2.1 Initialize an Unnamed Semaphore, P1003.1b-1993, p.219
 */

int sem_init(
  sem_t         *sem,
  int            pshared,
  unsigned int   value
);

/*
 *  11.2.2 Destroy an Unnamed Semaphore, P1003.1b-1993, p.220
 */

int sem_destroy(
  sem_t *sem
);

/*
 *  11.2.3 Initialize/Open a Named Semaphore, P1003.1b-1993, p.221
 *
 *  NOTE: Follows open() calling conventions.
 */

sem_t *sem_open(
  const char *name,
  int         oflag,
  ...
);

/*
 *  11.2.4 Close a Named Semaphore, P1003.1b-1993, p.224
 */

int sem_close(
  sem_t *sem
);

/*
 *  11.2.5 Remove a Named Semaphore, P1003.1b-1993, p.225
 */

int sem_unlink(
  const char *name
);

/*
 *  11.2.6 Lock a Semaphore, P1003.1b-1993, p.226
 *
 *  NOTE: P1003.4b/D8 adds sem_timedwait(), p. 27
 */

int sem_wait(
  sem_t *sem
);

int sem_trywait(
  sem_t *sem
);

#if defined(_POSIX_TIMEOUTS)
int sem_timedwait(
  sem_t                 *sem,
  const struct timespec *timeout
);
#endif

/*
 *  11.2.7 Unlock a Semaphore, P1003.1b-1993, p.227
 */

int sem_post(
  sem_t  *sem
);

/*
 *  11.2.8 Get the Value of a Semaphore, P1003.1b-1993, p.229
 */

int sem_getvalue(
  sem_t  *sem,
  int    *sval
);

#endif   /* _POSIX_SEMAPHORES */

#ifdef __cplusplus
}
#endif

#endif
/* end of include file */
