/** 
 *  @file  rtems/score/address.h
 *
 *  This include file contains the information required to manipulate
 *  physical addresses.
 */

/*
 *  COPYRIGHT (c) 1989-2006.
 *  On-Line Applications Research Corporation (OAR).
 *
 *  The license and distribution terms for this file may be
 *  found in the file LICENSE in this distribution or at
 *  http://www.rtems.com/license/LICENSE.
 *
 *  $Id: address.h,v 1.16 2006/01/16 15:13:58 joel Exp $
 */

#ifndef _RTEMS_SCORE_ADDRESS_H
#define _RTEMS_SCORE_ADDRESS_H

/**
 *  @defgroup ScoreAddress Address Handler
 *
 *  This handler encapsulates functionality which abstracts address
 *  manipulation in a portable manner.
 */
/**@{*/

#ifdef __cplusplus
extern "C" {
#endif

#include <rtems/score/address.inl>

#ifdef __cplusplus
}
#endif

/**@}*/

#endif
/* end of include file */
