CC=sparc-rtems-gcc
CPP=sparc-rtems-c++
LD=sparc-rtems-ld
MKPROM2=mkprom2

#SAMPLES_ROOT=$(abspath $(dir $(lastword $(MAKEFILE_LIST))))
SAMPLES_ROOT=$(dir $(lastword $(MAKEFILE_LIST)))
CONFIG_DEPS=$(SAMPLES_ROOT)config*.c
TOOLCHAIN_DEP=$(wildcard /opt/rtems-4.10/sparc-rtems/leon3/lib/*.a)

CFLAGS=-Wall -g -O2 

INCLUDE=-I$(SAMPLES_ROOT) 
override CFLAGS+=$(INCLUDE)

OUTDIR:=
# Make sure the OUTDIR ends with a /
ifneq ($(strip $(OUTDIR)),)
ifneq ($(strip $(OUTDIR)),$(dir $(strip $(OUTDIR))))
	override OUTDIR:=$(OUTDIR)/
endif
endif

# Defualt AMP configuration
# Shared memory is 0x40000000-0x40001000
MP_SHM_START=0x40000000
MP_SHM_SIZE=0x1000
# Variables MP_TEXT, MP_TEXT, MP_UART should be a list have MP_NODES number of 
# addresses. Each node has 4MB of memory (execpt the first which has 4MB-1k)
MP_NODES=2
MP_TEXT=0x40001000 0x40400000
MP_STACK=0x403fff00 0x407fff00
MP_UART=0x80000100 0x80000600
# Variables MP_MEMC, MP_IRQMP, MP_GPT needs to be set if not located at default
# location, since MP_MKRPROMFLAGS includes the -nopnp flag
MP_MEMC=
MP_IRQMP=
MP_GPT=

# Default MKPROM2 flags
MKPROMFLAGS=-baud 38400 -freq 50 -memcfg1 0x0003c2ff -memcfg2 0x92c46000 -memcfg3 0x001d2000
MP_MKRPROMFLAGS=-mp -mpstack $(MP_NODES) $(MP_STACK) -mpentry $(MP_NODES) $(MP_TEXT) -mpuart $(MP_NODES) $(MP_UART) -nopnp

# Setup hardware flags.
# To set custom hardware flags, set CPU="" and then CPUFLAGS="<flag>..." to 
# replace only the hardware flags or CFLAGS="<flag>...> to replace all the
# flags
CPU=leon3
CPUFLAGS=
ifeq ($(strip $(CPU)),erc32)
	CPUFLAGS=-tsc691
endif
ifeq ($(strip $(CPU)),leon2)
	CPUFLAGS=-msoft-float -qleon2
endif
ifeq ($(strip $(CPU)),leon2fp)
	CPUFLAGS=-qleon2
endif
ifeq ($(strip $(CPU)),leon2v8fp)
	CPUFLAGS=-qleon2 -mcpu=v8
endif
ifeq ($(strip $(CPU)),leon2v8)
	CPUFLAGS=-qleon2 -mcpu=v8 -msoft-float
endif
ifeq ($(strip $(CPU)),leon3)
	CPUFLAGS=-msoft-float
endif
ifeq ($(strip $(CPU)),leon3fp)
	CPUFLAGS=
endif
ifeq ($(strip $(CPU)),leon3v8fp)
	CPUFLAGS=-mcpu=v8
endif
ifeq ($(strip $(CPU)),leon3v8)
	CPUFLAGS=-mcpu=v8 -msoft-float
endif
ifeq ($(strip $(CPU)),ut699)
	MKPROMFLAGS=-baud 38400 -freq 66 -romwidth 32 -romsize 16384 -ramwidth 32 -ramcs 1 -ramsize 4096
	CPUFLAGS=-mcpu=v8 -mtune=ut699
endif
ifeq ($(strip $(CPU)),gr712)
	MP_UART=0x80000100 0x80100100
        MKPROMFLAGS=-baud 38400 -freq 48 -romwidth 8 -romsize 8192 -ramwidth 32 -ramcs 1 -ramsize 8192
	CPUFLAGS=-mcpu=v8
endif
ifeq ($(strip $(CPU)),ngmp)
        MP_MAX_NODES=2
        MP_SHM_START=0x00000000
        MP_SHM_SIZE=0x1000
        MP_TEXT=0x00001000 0x00400000 
        MP_STACK=0x003fff00 0x007fff00
        MP_UART=0xff900000 0xff901000
        MP_MEMC=0xffe00000
	MP_IRQMP=0xff904000
	MP_GPT=0xff908000

        MKPROMFLAGS=-baud 38400 -freq 200 -sparcleon0 -rstaddr 0xc0000000 -romwidth 8 -romsize 8192 -ddrram 2048 -ddrbanks 2 -ddrfreq 400 
	CPUFLAGS=-qngmp -mcpu=v8
endif

# Add target dependent flags
override CFLAGS+=$(CPUFLAGS)
ifneq ($(strip $(MP_MEMC)),)
	MP_MKRPROMFLAGS+=-memc $(MP_MEMC)
endif
ifneq ($(strip $(MP_IRQMP)),)
	MP_MKRPROMFLAGS+=-irqmp $(MP_IRQMP)
endif
ifneq ($(strip $(MP_GPT)),)
	MP_MKRPROMFLAGS+=-gpt $(MP_GPT)
endif

$(OUTDIR):
	mkdir -p $@

# Create PROM images using mkprom2, setup MKPROMFLAGS before use.
%.mkprom: $(OUTDIR)% | $(OUTDIR)
	@echo "### NOTE: Make sure the MKPROMFLAGS are set to flags that correspond to your target system."
	-$(MKPROM2) $(MKPROMFLAGS) -o $@ $<

