/*
 *  ringbuf.h 
 *
 *  This file provides simple ring buffer functionality.
 *
 *  $Id: ringbuf.h,v 1.2 1995/10/30 21:52:37 joel Exp $
 */

#ifndef __RINGBUF_H__
#define __RINGBUF_H__

#ifndef RINGBUF_QUEUE_LENGTH
#define RINGBUF_QUEUE_LENGTH 128
#endif

typedef struct {
  char buffer[RINGBUF_QUEUE_LENGTH];
  volatile int  head;
  volatile int  tail;
} Ring_buffer_t;

#define Ring_buffer_Initialize( _buffer ) \
  do { \
    (_buffer)->head = (_buffer)->tail = 0; \
  } while ( 0 ) 
  
#define Ring_buffer_Is_empty( _buffer ) \
   ( (_buffer)->head == (_buffer)->tail )

#define Ring_buffer_Is_full( _buffer ) \
   ( (_buffer)->head == ((_buffer)->tail + 1) % RINGBUF_QUEUE_LENGTH )

#define Ring_buffer_Add_character( _buffer, _ch ) \
  do { \
    rtems_unsigned32 isrlevel; \
    \
    rtems_interrupt_disable( isrlevel ); \
      (_buffer)->tail = ((_buffer)->tail+1) % RINGBUF_QUEUE_LENGTH; \
      (_buffer)->buffer[ (_buffer)->tail ] = (_ch); \
    rtems_interrupt_enable( isrlevel ); \
  } while ( 0 ) 

#define Ring_buffer_Remove_character( _buffer, _ch ) \
  do { \
    rtems_unsigned32 isrlevel; \
    \
    rtems_interrupt_disable( isrlevel ); \
      (_buffer)->head = ((_buffer)->head+1) % RINGBUF_QUEUE_LENGTH; \
      (_ch) = (_buffer)->buffer[ (_buffer)->head ]; \
    rtems_interrupt_enable( isrlevel ); \
  } while ( 0 ) 

#endif
