#include <rtems.h>

#define CONFIGURE_INIT
#include <bsp.h> /* for device driver prototypes */
rtems_task Init( rtems_task_argument argument);	/* forward declaration needed */
/* configuration information */
#define CONFIGURE_APPLICATION_NEEDS_CONSOLE_DRIVER
#define CONFIGURE_APPLICATION_NEEDS_CLOCK_DRIVER
#define CONFIGURE_MAXIMUM_TASKS             8
#define CONFIGURE_RTEMS_INIT_TASKS_TABLE
#define CONFIGURE_EXTRA_TASK_STACKS         (3 * RTEMS_MINIMUM_STACK_SIZE)
#define CONFIGURE_LIBIO_MAXIMUM_FILE_DESCRIPTORS 5
#define CONFIGURE_INIT_TASK_PRIORITY	100
/* #define CONFIGURE_INIT_TASK_INITIAL_MODES (RTEMS_PREEMPT | \ */
/*                                            RTEMS_TIMESLICE | \ */
/*                                            RTEMS_ASR | \ */
/*                                            RTEMS_INTERRUPT_LEVEL(0)) */

#include <confdefs.h>
#include <stdio.h>

rtems_task task1(rtems_task_argument argument);
rtems_task task2(rtems_task_argument argument);
rtems_id   Task_id[ 3 ];         /* array of task ids */
rtems_name Task_name[ 3 ];       /* array of task names */

/* ========================================================= 
   initialisation */
rtems_task Init(
  rtems_task_argument ignored
)
{
  FILE *f; int fd;
  rtems_status_code status;

  spacewire_register();
  spacewire_setattibutes(0,1,2,2);
  spacewire_setattibutes(1,2,2,1);
  
  Task_name[ 1 ] = rtems_build_name( 'T', 'A', '1', ' ' );
  Task_name[ 2 ] = rtems_build_name( 'T', 'A', '2', ' ' );

  status = rtems_task_create(Task_name[ 1 ], 1, RTEMS_MINIMUM_STACK_SIZE * 2,
			     RTEMS_DEFAULT_MODES, /* RTEMS_PREEMPT|RTEMS_TIMESLICE|RTEMS_ASR|RTEMS_INTERRUPT_LEVEL(0), *//*RTEMS_PREEMPT RTEMS_TIMESLICE */
			     RTEMS_DEFAULT_ATTRIBUTES, &Task_id[ 1 ]
			     );
  status = rtems_task_create(
			     Task_name[ 2 ], 1, RTEMS_MINIMUM_STACK_SIZE * 2,
			     RTEMS_DEFAULT_MODES, /* RTEMS_PREEMPT|RTEMS_TIMESLICE|RTEMS_ASR|RTEMS_INTERRUPT_LEVEL(0), *//*RTEMS_PREEMPT RTEMS_TIMESLICE */
			     RTEMS_DEFAULT_ATTRIBUTES, &Task_id[ 2 ]
			     );

  
  status = rtems_task_start( Task_id[ 1 ], task1, 1 );
  status = rtems_task_start( Task_id[ 2 ], task2, 2 );

  status = rtems_task_delete( RTEMS_SELF );
}

unsigned int init1 = 0,init2 = 0;

/* ========================================================= 
   sender task */
rtems_task task1(
  rtems_task_argument unused
  ) {
  rtems_status_code status;
  FILE *f; int fd;

  printf("task1\n");
  
  if (f = fopen ("/dev/spacewire","r+")) {
    char response[128];
    char **c,*cmds[] = 
      { "get username\n",
	"echo name\n",
	"set remote\n",
	"logout\n",
	0 
      };
    init1 = 1;
    while(!(init1 && init2))
      sched_yield();

    /*while(1)*/ {
      char b[200];
      int c, i;
      for (i=0;i < sizeof(b);i++){
	b[i] = i;
      }
      if((c = fwrite(b,1,sizeof(b),f)) == sizeof(b)) {
	fflush(f);
	printf("fwrite success\n");
      } else {
	printf("fwrite transmitted only %i bytes\n",c);
      }
      fclose(f);
    }
  }else {
    printf("cannot open /dev/spacewire, exiting\n");
    exit(0);
  }
  status = rtems_task_delete( RTEMS_SELF );
}

/* ========================================================= 
   receiver task */
rtems_task task2(
  rtems_task_argument unused
  ) {
  rtems_status_code status;
  FILE *f; int fd;

  printf("task2\n");
  
  if (f = fopen ("/dev/spacewire_b","r+")) {
    char *cmd1,cmd[128];

    init2 = 1;
    while(!(init1 && init2))
      sched_yield();
    
    /*while(1)*/ {
      char b[100];
      int c;
      while(!feof(f)) {
	if((c = fread(b,1,1,f)) == 1) {
	  printf("fread Success\n");
	} else {
	  printf("fread transmitted only %i bytes\n",c);
	}
      }
      fclose(f);
    }
  }else {
    printf("cannot open /dev/spacewire_b, exiting\n");
    exit(0);
  }
  status = rtems_task_delete( RTEMS_SELF );
}

