
/* CPU Node 0 has system console */
#if (NODE_NUMBER == 1)
#define CONFIGURE_APPLICATION_NEEDS_CONSOLE_DRIVER
#endif
#define CONFIGURE_APPLICATION_NEEDS_CLOCK_DRIVER

#define CONFIGURE_MAXIMUM_TASKS             10

/*#define CONFIGURE_INIT_TASK_ATTRIBUTES    RTEMS_GLOBAL*/

/* Give each Init task a unique name */
#define CONFIGURE_INIT_TASK_NAME          rtems_build_name('U', 'I', '0'+NODE_NUMBER, ' ')
#define CONFIGURE_RTEMS_INIT_TASKS_TABLE

#define CONFIGURE_EXTRA_TASK_STACKS         (64 * RTEMS_MINIMUM_STACK_SIZE)

/* MP Config - will be used in future to enable RTEMS multi-processing */
#if 0
#define CONFIGURE_MP_APPLICATION
#define CONFIGURE_MP_NODE_NUMBER NODE_NUMBER
#define CONFIGURE_MP_MAXIMUM_NODES 2
#define CONFIGURE_MP_MAXIMUM_GLOBAL_OBJECTS 32
#define CONFIGURE_MP_MAXIMUM_PROXIES 32
#endif
#define CONFIGURE_MAXIMUM_SEMAPHORES 32

#include <rtems/confdefs.h>

#if defined(RTEMS_DRVMGR_STARTUP) /* if --drvmgr was given to configure */
 /* Add Timer and UART Driver for this example */
 #ifdef CONFIGURE_APPLICATION_NEEDS_CLOCK_DRIVER
  #define CONFIGURE_DRIVER_AMBAPP_GAISLER_GPTIMER
 #endif
 #ifdef CONFIGURE_APPLICATION_NEEDS_CONSOLE_DRIVER
  #define CONFIGURE_DRIVER_AMBAPP_GAISLER_APBUART
 #endif

 #include <drvmgr/ambapp_bus.h>
  /* OPTIONAL FOR GRLIB SYSTEMS WITH GPTIMER AS SYSTEM CLOCK TIMER */

  /* APBUART0 */
  struct drvmgr_key grlib_drv_res_apbuart0[] =
  {
  	{"mode", KEY_TYPE_INT, {(unsigned int)0}},
  /*
   	{"syscon", KEY_TYPE_INT, {(unsigned int)1}}, // Set Interrupt mode
  */
  	KEY_EMPTY
  };
  /* APBUART1 */
  struct drvmgr_key grlib_drv_res_apbuart1[] =
  {
  	{"mode", KEY_TYPE_INT, {(unsigned int)0}},
  /*
  	{"syscon", KEY_TYPE_INT, {(unsigned int)1}}, // Set Interrupt mode
  */
  	KEY_EMPTY
  };

  /* This is where device resources are separated between the AMP nodes.
   * By setting a NULL of a device's driver resources we tell the Driver
   * Manager to ignore a device (AMBA device in this case).
   *
   * It is expected that the CPU nodes shared one GPTIMER core,
   * and are assigned one UART for system console per system
   *
   * Default (when #if 0) is to have SYSTEM[N] using GPTIMER[0],Timer[N] and
   * APBUART[N] as system/debug console.
   */
  struct drvmgr_drv_res grlib_drv_resources[] =
  {
#if (NODE_NUMBER == 1)
  	/* First AMP Node use UART0, GPTIMER[0],Timer[0]] */
  	{DRIVER_AMBAPP_GAISLER_GPTIMER_ID, 1, NULL}, /* Do not use timers on this GPTIMER core */
  	{DRIVER_AMBAPP_GAISLER_GPTIMER_ID, 2, NULL}, /* Do not use timers on this GPTIMER core */
  	{DRIVER_AMBAPP_GAISLER_GPTIMER_ID, 3, NULL}, /* Do not use timers on this GPTIMER core */
  	{DRIVER_AMBAPP_GAISLER_GPTIMER_ID, 4, NULL}, /* Do not use timers on this GPTIMER core */
   	{DRIVER_AMBAPP_GAISLER_APBUART_ID, 0, &grlib_drv_res_apbuart0[0]},
#elif (NODE_NUMBER == 2)
  	/* Second AMP Node use GPTIMER[1],Timer[0] (no UART) */
  	{DRIVER_AMBAPP_GAISLER_GPTIMER_ID, 0, NULL}, /* Do not use timers on this GPTIMER core */
  	{DRIVER_AMBAPP_GAISLER_GPTIMER_ID, 2, NULL}, /* Do not use timers on this GPTIMER core */
  	{DRIVER_AMBAPP_GAISLER_GPTIMER_ID, 3, NULL}, /* Do not use timers on this GPTIMER core */
  	{DRIVER_AMBAPP_GAISLER_GPTIMER_ID, 4, NULL}, /* Do not use timers on this GPTIMER core */
   	{DRIVER_AMBAPP_GAISLER_APBUART_ID, 0, NULL}, /* Let RTEMS[0] use this UART */
   	{DRIVER_AMBAPP_GAISLER_APBUART_ID, 1, NULL}, /* Let RTEMS[0] use this UART */
#elif (NODE_NUMBER == 3)
  	/* Second AMP Node use GPTIMER[2],Timer[0] (no UART) */
  	{DRIVER_AMBAPP_GAISLER_GPTIMER_ID, 0, NULL}, /* Do not use timers on this GPTIMER core */
  	{DRIVER_AMBAPP_GAISLER_GPTIMER_ID, 1, NULL}, /* Do not use timers on this GPTIMER core */
  	{DRIVER_AMBAPP_GAISLER_GPTIMER_ID, 3, NULL}, /* Do not use timers on this GPTIMER core */
  	{DRIVER_AMBAPP_GAISLER_GPTIMER_ID, 4, NULL}, /* Do not use timers on this GPTIMER core */
   	{DRIVER_AMBAPP_GAISLER_APBUART_ID, 0, NULL}, /* Let RTEMS[0] use this UART */
   	{DRIVER_AMBAPP_GAISLER_APBUART_ID, 1, NULL}, /* Let RTEMS[0] use this UART */
#elif (NODE_NUMBER == 4)
  	/* Second AMP Node use GPTIMER[3],Timer[0] (no UART) */
  	{DRIVER_AMBAPP_GAISLER_GPTIMER_ID, 0, NULL}, /* Do not use timers on this GPTIMER core */
  	{DRIVER_AMBAPP_GAISLER_GPTIMER_ID, 1, NULL}, /* Do not use timers on this GPTIMER core */
  	{DRIVER_AMBAPP_GAISLER_GPTIMER_ID, 2, NULL}, /* Do not use timers on this GPTIMER core */
  	{DRIVER_AMBAPP_GAISLER_GPTIMER_ID, 4, NULL}, /* Do not use timers on this GPTIMER core */
   	{DRIVER_AMBAPP_GAISLER_APBUART_ID, 0, NULL}, /* Let RTEMS[0] use this UART */
   	{DRIVER_AMBAPP_GAISLER_APBUART_ID, 1, NULL}, /* Let RTEMS[0] use this UART */
#endif
  	RES_EMPTY
  };

 #include <drvmgr/drvmgr_confdefs.h>
#endif
